import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IothubEnrichmentAConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_enrichment.html#endpoint_names IothubEnrichmentA#endpoint_names}.
     *
     * @stability stable
     */
    readonly endpointNames: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_enrichment.html#iothub_name IothubEnrichmentA#iothub_name}.
     *
     * @stability stable
     */
    readonly iothubName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_enrichment.html#key IothubEnrichmentA#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_enrichment.html#resource_group_name IothubEnrichmentA#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_enrichment.html#value IothubEnrichmentA#value}.
     *
     * @stability stable
     */
    readonly value: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_enrichment.html#timeouts IothubEnrichmentA#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IothubEnrichmentTimeouts;
}
/**
 * @stability stable
 */
export interface IothubEnrichmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_enrichment.html#create IothubEnrichmentA#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_enrichment.html#delete IothubEnrichmentA#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_enrichment.html#read IothubEnrichmentA#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_enrichment.html#update IothubEnrichmentA#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function iothubEnrichmentTimeoutsToTerraform(struct?: IothubEnrichmentTimeoutsOutputReference | IothubEnrichmentTimeouts): any;
/**
 * @stability stable
 */
export declare class IothubEnrichmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IothubEnrichmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IothubEnrichmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_enrichment.html azurerm_iothub_enrichment}.
 *
 * @stability stable
 */
export declare class IothubEnrichmentA extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_enrichment.html azurerm_iothub_enrichment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IothubEnrichmentAConfig);
    private _endpointNames?;
    /**
     * @stability stable
     */
    get endpointNames(): string[];
    /**
     * @stability stable
     */
    set endpointNames(value: string[]);
    /**
     * @stability stable
     */
    get endpointNamesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _iothubName?;
    /**
     * @stability stable
     */
    get iothubName(): string;
    /**
     * @stability stable
     */
    set iothubName(value: string);
    /**
     * @stability stable
     */
    get iothubNameInput(): string | undefined;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): IothubEnrichmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IothubEnrichmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IothubEnrichmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
