import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KeyVaultManagedStorageAccountSasTokenDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html#managed_storage_account_id KeyVaultManagedStorageAccountSasTokenDefinition#managed_storage_account_id}.
     *
     * @stability stable
     */
    readonly managedStorageAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html#name KeyVaultManagedStorageAccountSasTokenDefinition#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html#sas_template_uri KeyVaultManagedStorageAccountSasTokenDefinition#sas_template_uri}.
     *
     * @stability stable
     */
    readonly sasTemplateUri: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html#sas_type KeyVaultManagedStorageAccountSasTokenDefinition#sas_type}.
     *
     * @stability stable
     */
    readonly sasType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html#tags KeyVaultManagedStorageAccountSasTokenDefinition#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html#validity_period KeyVaultManagedStorageAccountSasTokenDefinition#validity_period}.
     *
     * @stability stable
     */
    readonly validityPeriod: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html#timeouts KeyVaultManagedStorageAccountSasTokenDefinition#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KeyVaultManagedStorageAccountSasTokenDefinitionTimeouts;
}
/**
 * @stability stable
 */
export interface KeyVaultManagedStorageAccountSasTokenDefinitionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html#create KeyVaultManagedStorageAccountSasTokenDefinition#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html#delete KeyVaultManagedStorageAccountSasTokenDefinition#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html#read KeyVaultManagedStorageAccountSasTokenDefinition#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html#update KeyVaultManagedStorageAccountSasTokenDefinition#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function keyVaultManagedStorageAccountSasTokenDefinitionTimeoutsToTerraform(struct?: KeyVaultManagedStorageAccountSasTokenDefinitionTimeoutsOutputReference | KeyVaultManagedStorageAccountSasTokenDefinitionTimeouts): any;
/**
 * @stability stable
 */
export declare class KeyVaultManagedStorageAccountSasTokenDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultManagedStorageAccountSasTokenDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultManagedStorageAccountSasTokenDefinitionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html azurerm_key_vault_managed_storage_account_sas_token_definition}.
 *
 * @stability stable
 */
export declare class KeyVaultManagedStorageAccountSasTokenDefinition extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account_sas_token_definition.html azurerm_key_vault_managed_storage_account_sas_token_definition} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KeyVaultManagedStorageAccountSasTokenDefinitionConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _managedStorageAccountId?;
    /**
     * @stability stable
     */
    get managedStorageAccountId(): string;
    /**
     * @stability stable
     */
    set managedStorageAccountId(value: string);
    /**
     * @stability stable
     */
    get managedStorageAccountIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sasTemplateUri?;
    /**
     * @stability stable
     */
    get sasTemplateUri(): string;
    /**
     * @stability stable
     */
    set sasTemplateUri(value: string);
    /**
     * @stability stable
     */
    get sasTemplateUriInput(): string | undefined;
    private _sasType?;
    /**
     * @stability stable
     */
    get sasType(): string;
    /**
     * @stability stable
     */
    set sasType(value: string);
    /**
     * @stability stable
     */
    get sasTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get secretId(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _validityPeriod?;
    /**
     * @stability stable
     */
    get validityPeriod(): string;
    /**
     * @stability stable
     */
    set validityPeriod(value: string);
    /**
     * @stability stable
     */
    get validityPeriodInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KeyVaultManagedStorageAccountSasTokenDefinitionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KeyVaultManagedStorageAccountSasTokenDefinitionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KeyVaultManagedStorageAccountSasTokenDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
