import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbNatRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#backend_port LbNatRule#backend_port}.
     *
     * @stability stable
     */
    readonly backendPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#enable_floating_ip LbNatRule#enable_floating_ip}.
     *
     * @stability stable
     */
    readonly enableFloatingIp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#enable_tcp_reset LbNatRule#enable_tcp_reset}.
     *
     * @stability stable
     */
    readonly enableTcpReset?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#frontend_ip_configuration_name LbNatRule#frontend_ip_configuration_name}.
     *
     * @stability stable
     */
    readonly frontendIpConfigurationName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#frontend_port LbNatRule#frontend_port}.
     *
     * @stability stable
     */
    readonly frontendPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#idle_timeout_in_minutes LbNatRule#idle_timeout_in_minutes}.
     *
     * @stability stable
     */
    readonly idleTimeoutInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#loadbalancer_id LbNatRule#loadbalancer_id}.
     *
     * @stability stable
     */
    readonly loadbalancerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#name LbNatRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#protocol LbNatRule#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#resource_group_name LbNatRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#timeouts LbNatRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LbNatRuleTimeouts;
}
/**
 * @stability stable
 */
export interface LbNatRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#create LbNatRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#delete LbNatRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#read LbNatRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html#update LbNatRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function lbNatRuleTimeoutsToTerraform(struct?: LbNatRuleTimeoutsOutputReference | LbNatRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class LbNatRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LbNatRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LbNatRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html azurerm_lb_nat_rule}.
 *
 * @stability stable
 */
export declare class LbNatRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_rule.html azurerm_lb_nat_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbNatRuleConfig);
    /**
     * @stability stable
     */
    get backendIpConfigurationId(): string;
    private _backendPort?;
    /**
     * @stability stable
     */
    get backendPort(): number;
    /**
     * @stability stable
     */
    set backendPort(value: number);
    /**
     * @stability stable
     */
    get backendPortInput(): number | undefined;
    private _enableFloatingIp?;
    /**
     * @stability stable
     */
    get enableFloatingIp(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableFloatingIp(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableFloatingIp(): void;
    /**
     * @stability stable
     */
    get enableFloatingIpInput(): boolean | cdktf.IResolvable | undefined;
    private _enableTcpReset?;
    /**
     * @stability stable
     */
    get enableTcpReset(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableTcpReset(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableTcpReset(): void;
    /**
     * @stability stable
     */
    get enableTcpResetInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get frontendIpConfigurationId(): string;
    private _frontendIpConfigurationName?;
    /**
     * @stability stable
     */
    get frontendIpConfigurationName(): string;
    /**
     * @stability stable
     */
    set frontendIpConfigurationName(value: string);
    /**
     * @stability stable
     */
    get frontendIpConfigurationNameInput(): string | undefined;
    private _frontendPort?;
    /**
     * @stability stable
     */
    get frontendPort(): number;
    /**
     * @stability stable
     */
    set frontendPort(value: number);
    /**
     * @stability stable
     */
    get frontendPortInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _idleTimeoutInMinutes?;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutes(): number;
    /**
     * @stability stable
     */
    set idleTimeoutInMinutes(value: number);
    /**
     * @stability stable
     */
    resetIdleTimeoutInMinutes(): void;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutesInput(): number | undefined;
    private _loadbalancerId?;
    /**
     * @stability stable
     */
    get loadbalancerId(): string;
    /**
     * @stability stable
     */
    set loadbalancerId(value: string);
    /**
     * @stability stable
     */
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LbNatRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LbNatRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LbNatRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
