import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MediaJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#description MediaJob#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#media_services_account_name MediaJob#media_services_account_name}.
     *
     * @stability stable
     */
    readonly mediaServicesAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#name MediaJob#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#priority MediaJob#priority}.
     *
     * @stability stable
     */
    readonly priority?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#resource_group_name MediaJob#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#transform_name MediaJob#transform_name}.
     *
     * @stability stable
     */
    readonly transformName: string;
    /**
     * input_asset block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#input_asset MediaJob#input_asset}
     *
     * @stability stable
     */
    readonly inputAsset: MediaJobInputAsset;
    /**
     * output_asset block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#output_asset MediaJob#output_asset}
     *
     * @stability stable
     */
    readonly outputAsset: MediaJobOutputAsset[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#timeouts MediaJob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MediaJobTimeouts;
}
/**
 * @stability stable
 */
export interface MediaJobInputAsset {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#label MediaJob#label}.
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#name MediaJob#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function mediaJobInputAssetToTerraform(struct?: MediaJobInputAssetOutputReference | MediaJobInputAsset): any;
/**
 * @stability stable
 */
export declare class MediaJobInputAssetOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaJobInputAsset | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaJobInputAsset | undefined);
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaJobOutputAsset {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#label MediaJob#label}.
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#name MediaJob#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function mediaJobOutputAssetToTerraform(struct?: MediaJobOutputAsset): any;
/**
 * @stability stable
 */
export interface MediaJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#create MediaJob#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#delete MediaJob#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#read MediaJob#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html#update MediaJob#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mediaJobTimeoutsToTerraform(struct?: MediaJobTimeoutsOutputReference | MediaJobTimeouts): any;
/**
 * @stability stable
 */
export declare class MediaJobTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaJobTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaJobTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html azurerm_media_job}.
 *
 * @stability stable
 */
export declare class MediaJob extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_job.html azurerm_media_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MediaJobConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _mediaServicesAccountName?;
    /**
     * @stability stable
     */
    get mediaServicesAccountName(): string;
    /**
     * @stability stable
     */
    set mediaServicesAccountName(value: string);
    /**
     * @stability stable
     */
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): string;
    /**
     * @stability stable
     */
    set priority(value: string);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _transformName?;
    /**
     * @stability stable
     */
    get transformName(): string;
    /**
     * @stability stable
     */
    set transformName(value: string);
    /**
     * @stability stable
     */
    get transformNameInput(): string | undefined;
    private _inputAsset;
    /**
     * @stability stable
     */
    get inputAsset(): MediaJobInputAssetOutputReference;
    /**
     * @stability stable
     */
    putInputAsset(value: MediaJobInputAsset): void;
    /**
     * @stability stable
     */
    get inputAssetInput(): MediaJobInputAsset | undefined;
    private _outputAsset?;
    /**
     * @stability stable
     */
    get outputAsset(): MediaJobOutputAsset[];
    /**
     * @stability stable
     */
    set outputAsset(value: MediaJobOutputAsset[]);
    /**
     * @stability stable
     */
    get outputAssetInput(): MediaJobOutputAsset[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MediaJobTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MediaJobTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MediaJobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
