import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MssqlElasticpoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#license_type MssqlElasticpool#license_type}.
     *
     * @stability stable
     */
    readonly licenseType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#location MssqlElasticpool#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#max_size_bytes MssqlElasticpool#max_size_bytes}.
     *
     * @stability stable
     */
    readonly maxSizeBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#max_size_gb MssqlElasticpool#max_size_gb}.
     *
     * @stability stable
     */
    readonly maxSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#name MssqlElasticpool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#resource_group_name MssqlElasticpool#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#server_name MssqlElasticpool#server_name}.
     *
     * @stability stable
     */
    readonly serverName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#tags MssqlElasticpool#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#zone_redundant MssqlElasticpool#zone_redundant}.
     *
     * @stability stable
     */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
    /**
     * per_database_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#per_database_settings MssqlElasticpool#per_database_settings}
     *
     * @stability stable
     */
    readonly perDatabaseSettings: MssqlElasticpoolPerDatabaseSettings;
    /**
     * sku block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#sku MssqlElasticpool#sku}
     *
     * @stability stable
     */
    readonly sku: MssqlElasticpoolSku;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#timeouts MssqlElasticpool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MssqlElasticpoolTimeouts;
}
/**
 * @stability stable
 */
export interface MssqlElasticpoolPerDatabaseSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#max_capacity MssqlElasticpool#max_capacity}.
     *
     * @stability stable
     */
    readonly maxCapacity: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#min_capacity MssqlElasticpool#min_capacity}.
     *
     * @stability stable
     */
    readonly minCapacity: number;
}
export declare function mssqlElasticpoolPerDatabaseSettingsToTerraform(struct?: MssqlElasticpoolPerDatabaseSettingsOutputReference | MssqlElasticpoolPerDatabaseSettings): any;
/**
 * @stability stable
 */
export declare class MssqlElasticpoolPerDatabaseSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlElasticpoolPerDatabaseSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlElasticpoolPerDatabaseSettings | undefined);
    private _maxCapacity?;
    /**
     * @stability stable
     */
    get maxCapacity(): number;
    /**
     * @stability stable
     */
    set maxCapacity(value: number);
    /**
     * @stability stable
     */
    get maxCapacityInput(): number | undefined;
    private _minCapacity?;
    /**
     * @stability stable
     */
    get minCapacity(): number;
    /**
     * @stability stable
     */
    set minCapacity(value: number);
    /**
     * @stability stable
     */
    get minCapacityInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MssqlElasticpoolSku {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#capacity MssqlElasticpool#capacity}.
     *
     * @stability stable
     */
    readonly capacity: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#family MssqlElasticpool#family}.
     *
     * @stability stable
     */
    readonly family?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#name MssqlElasticpool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#tier MssqlElasticpool#tier}.
     *
     * @stability stable
     */
    readonly tier: string;
}
export declare function mssqlElasticpoolSkuToTerraform(struct?: MssqlElasticpoolSkuOutputReference | MssqlElasticpoolSku): any;
/**
 * @stability stable
 */
export declare class MssqlElasticpoolSkuOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlElasticpoolSku | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlElasticpoolSku | undefined);
    private _capacity?;
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    set capacity(value: number);
    /**
     * @stability stable
     */
    get capacityInput(): number | undefined;
    private _family?;
    /**
     * @stability stable
     */
    get family(): string;
    /**
     * @stability stable
     */
    set family(value: string);
    /**
     * @stability stable
     */
    resetFamily(): void;
    /**
     * @stability stable
     */
    get familyInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MssqlElasticpoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#create MssqlElasticpool#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#delete MssqlElasticpool#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#read MssqlElasticpool#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html#update MssqlElasticpool#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mssqlElasticpoolTimeoutsToTerraform(struct?: MssqlElasticpoolTimeoutsOutputReference | MssqlElasticpoolTimeouts): any;
/**
 * @stability stable
 */
export declare class MssqlElasticpoolTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlElasticpoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlElasticpoolTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html azurerm_mssql_elasticpool}.
 *
 * @stability stable
 */
export declare class MssqlElasticpool extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_elasticpool.html azurerm_mssql_elasticpool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MssqlElasticpoolConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _licenseType?;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    set licenseType(value: string);
    /**
     * @stability stable
     */
    resetLicenseType(): void;
    /**
     * @stability stable
     */
    get licenseTypeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maxSizeBytes?;
    /**
     * @stability stable
     */
    get maxSizeBytes(): number;
    /**
     * @stability stable
     */
    set maxSizeBytes(value: number);
    /**
     * @stability stable
     */
    resetMaxSizeBytes(): void;
    /**
     * @stability stable
     */
    get maxSizeBytesInput(): number | undefined;
    private _maxSizeGb?;
    /**
     * @stability stable
     */
    get maxSizeGb(): number;
    /**
     * @stability stable
     */
    set maxSizeGb(value: number);
    /**
     * @stability stable
     */
    resetMaxSizeGb(): void;
    /**
     * @stability stable
     */
    get maxSizeGbInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _serverName?;
    /**
     * @stability stable
     */
    get serverName(): string;
    /**
     * @stability stable
     */
    set serverName(value: string);
    /**
     * @stability stable
     */
    get serverNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _zoneRedundant?;
    /**
     * @stability stable
     */
    get zoneRedundant(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetZoneRedundant(): void;
    /**
     * @stability stable
     */
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
    private _perDatabaseSettings;
    /**
     * @stability stable
     */
    get perDatabaseSettings(): MssqlElasticpoolPerDatabaseSettingsOutputReference;
    /**
     * @stability stable
     */
    putPerDatabaseSettings(value: MssqlElasticpoolPerDatabaseSettings): void;
    /**
     * @stability stable
     */
    get perDatabaseSettingsInput(): MssqlElasticpoolPerDatabaseSettings | undefined;
    private _sku;
    /**
     * @stability stable
     */
    get sku(): MssqlElasticpoolSkuOutputReference;
    /**
     * @stability stable
     */
    putSku(value: MssqlElasticpoolSku): void;
    /**
     * @stability stable
     */
    get skuInput(): MssqlElasticpoolSku | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MssqlElasticpoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MssqlElasticpoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MssqlElasticpoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
