import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkInterfaceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#dns_servers NetworkInterface#dns_servers}.
     *
     * @stability stable
     */
    readonly dnsServers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#enable_accelerated_networking NetworkInterface#enable_accelerated_networking}.
     *
     * @stability stable
     */
    readonly enableAcceleratedNetworking?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#enable_ip_forwarding NetworkInterface#enable_ip_forwarding}.
     *
     * @stability stable
     */
    readonly enableIpForwarding?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#internal_dns_name_label NetworkInterface#internal_dns_name_label}.
     *
     * @stability stable
     */
    readonly internalDnsNameLabel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#location NetworkInterface#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#name NetworkInterface#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#resource_group_name NetworkInterface#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#tags NetworkInterface#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#ip_configuration NetworkInterface#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration: NetworkInterfaceIpConfiguration[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#timeouts NetworkInterface#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkInterfaceTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkInterfaceIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#gateway_load_balancer_frontend_ip_configuration_id NetworkInterface#gateway_load_balancer_frontend_ip_configuration_id}.
     *
     * @stability stable
     */
    readonly gatewayLoadBalancerFrontendIpConfigurationId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#name NetworkInterface#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#primary NetworkInterface#primary}.
     *
     * @stability stable
     */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#private_ip_address NetworkInterface#private_ip_address}.
     *
     * @stability stable
     */
    readonly privateIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#private_ip_address_allocation NetworkInterface#private_ip_address_allocation}.
     *
     * @stability stable
     */
    readonly privateIpAddressAllocation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#private_ip_address_version NetworkInterface#private_ip_address_version}.
     *
     * @stability stable
     */
    readonly privateIpAddressVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#public_ip_address_id NetworkInterface#public_ip_address_id}.
     *
     * @stability stable
     */
    readonly publicIpAddressId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#subnet_id NetworkInterface#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
}
export declare function networkInterfaceIpConfigurationToTerraform(struct?: NetworkInterfaceIpConfiguration): any;
/**
 * @stability stable
 */
export interface NetworkInterfaceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#create NetworkInterface#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#delete NetworkInterface#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#read NetworkInterface#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html#update NetworkInterface#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function networkInterfaceTimeoutsToTerraform(struct?: NetworkInterfaceTimeoutsOutputReference | NetworkInterfaceTimeouts): any;
/**
 * @stability stable
 */
export declare class NetworkInterfaceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkInterfaceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkInterfaceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html azurerm_network_interface}.
 *
 * @stability stable
 */
export declare class NetworkInterface extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface.html azurerm_network_interface} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkInterfaceConfig);
    /**
     * @stability stable
     */
    get appliedDnsServers(): string[];
    private _dnsServers?;
    /**
     * @stability stable
     */
    get dnsServers(): string[];
    /**
     * @stability stable
     */
    set dnsServers(value: string[]);
    /**
     * @stability stable
     */
    resetDnsServers(): void;
    /**
     * @stability stable
     */
    get dnsServersInput(): string[] | undefined;
    private _enableAcceleratedNetworking?;
    /**
     * @stability stable
     */
    get enableAcceleratedNetworking(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAcceleratedNetworking(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableAcceleratedNetworking(): void;
    /**
     * @stability stable
     */
    get enableAcceleratedNetworkingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableIpForwarding?;
    /**
     * @stability stable
     */
    get enableIpForwarding(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableIpForwarding(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableIpForwarding(): void;
    /**
     * @stability stable
     */
    get enableIpForwardingInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _internalDnsNameLabel?;
    /**
     * @stability stable
     */
    get internalDnsNameLabel(): string;
    /**
     * @stability stable
     */
    set internalDnsNameLabel(value: string);
    /**
     * @stability stable
     */
    resetInternalDnsNameLabel(): void;
    /**
     * @stability stable
     */
    get internalDnsNameLabelInput(): string | undefined;
    /**
     * @stability stable
     */
    get internalDomainNameSuffix(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get macAddress(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    /**
     * @stability stable
     */
    get privateIpAddresses(): string[];
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get virtualMachineId(): string;
    private _ipConfiguration?;
    /**
     * @stability stable
     */
    get ipConfiguration(): NetworkInterfaceIpConfiguration[];
    /**
     * @stability stable
     */
    set ipConfiguration(value: NetworkInterfaceIpConfiguration[]);
    /**
     * @stability stable
     */
    get ipConfigurationInput(): NetworkInterfaceIpConfiguration[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetworkInterfaceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkInterfaceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkInterfaceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
