import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SpringCloudServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#location SpringCloudService#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#name SpringCloudService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#resource_group_name SpringCloudService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#sku_name SpringCloudService#sku_name}.
     *
     * @stability stable
     */
    readonly skuName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#tags SpringCloudService#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * config_server_git_setting block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#config_server_git_setting SpringCloudService#config_server_git_setting}
     *
     * @stability stable
     */
    readonly configServerGitSetting?: SpringCloudServiceConfigServerGitSetting;
    /**
     * network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#network SpringCloudService#network}
     *
     * @stability stable
     */
    readonly network?: SpringCloudServiceNetwork;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#timeouts SpringCloudService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SpringCloudServiceTimeouts;
    /**
     * trace block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#trace SpringCloudService#trace}
     *
     * @stability stable
     */
    readonly trace?: SpringCloudServiceTrace;
}
/**
 * @stability stable
 */
export declare class SpringCloudServiceRequiredNetworkTrafficRules extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get direction(): string;
    /**
     * @stability stable
     */
    get fqdns(): string[];
    /**
     * @stability stable
     */
    get ipAddresses(): string[];
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get protocol(): string;
}
/**
 * @stability stable
 */
export interface SpringCloudServiceConfigServerGitSettingHttpBasicAuth {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#password SpringCloudService#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#username SpringCloudService#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function springCloudServiceConfigServerGitSettingHttpBasicAuthToTerraform(struct?: SpringCloudServiceConfigServerGitSettingHttpBasicAuthOutputReference | SpringCloudServiceConfigServerGitSettingHttpBasicAuth): any;
/**
 * @stability stable
 */
export declare class SpringCloudServiceConfigServerGitSettingHttpBasicAuthOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudServiceConfigServerGitSettingHttpBasicAuth | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudServiceConfigServerGitSettingHttpBasicAuth | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#password SpringCloudService#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#username SpringCloudService#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function springCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthToTerraform(struct?: SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthOutputReference | SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth): any;
/**
 * @stability stable
 */
export declare class SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SpringCloudServiceConfigServerGitSettingRepositorySshAuth {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#host_key SpringCloudService#host_key}.
     *
     * @stability stable
     */
    readonly hostKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#host_key_algorithm SpringCloudService#host_key_algorithm}.
     *
     * @stability stable
     */
    readonly hostKeyAlgorithm?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#private_key SpringCloudService#private_key}.
     *
     * @stability stable
     */
    readonly privateKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#strict_host_key_checking_enabled SpringCloudService#strict_host_key_checking_enabled}.
     *
     * @stability stable
     */
    readonly strictHostKeyCheckingEnabled?: boolean | cdktf.IResolvable;
}
export declare function springCloudServiceConfigServerGitSettingRepositorySshAuthToTerraform(struct?: SpringCloudServiceConfigServerGitSettingRepositorySshAuthOutputReference | SpringCloudServiceConfigServerGitSettingRepositorySshAuth): any;
/**
 * @stability stable
 */
export declare class SpringCloudServiceConfigServerGitSettingRepositorySshAuthOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudServiceConfigServerGitSettingRepositorySshAuth | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudServiceConfigServerGitSettingRepositorySshAuth | undefined);
    private _hostKey?;
    /**
     * @stability stable
     */
    get hostKey(): string;
    /**
     * @stability stable
     */
    set hostKey(value: string);
    /**
     * @stability stable
     */
    resetHostKey(): void;
    /**
     * @stability stable
     */
    get hostKeyInput(): string | undefined;
    private _hostKeyAlgorithm?;
    /**
     * @stability stable
     */
    get hostKeyAlgorithm(): string;
    /**
     * @stability stable
     */
    set hostKeyAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetHostKeyAlgorithm(): void;
    /**
     * @stability stable
     */
    get hostKeyAlgorithmInput(): string | undefined;
    private _privateKey?;
    /**
     * @stability stable
     */
    get privateKey(): string;
    /**
     * @stability stable
     */
    set privateKey(value: string);
    /**
     * @stability stable
     */
    get privateKeyInput(): string | undefined;
    private _strictHostKeyCheckingEnabled?;
    /**
     * @stability stable
     */
    get strictHostKeyCheckingEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set strictHostKeyCheckingEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStrictHostKeyCheckingEnabled(): void;
    /**
     * @stability stable
     */
    get strictHostKeyCheckingEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface SpringCloudServiceConfigServerGitSettingRepository {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#label SpringCloudService#label}.
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#name SpringCloudService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#pattern SpringCloudService#pattern}.
     *
     * @stability stable
     */
    readonly pattern?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#search_paths SpringCloudService#search_paths}.
     *
     * @stability stable
     */
    readonly searchPaths?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#uri SpringCloudService#uri}.
     *
     * @stability stable
     */
    readonly uri: string;
    /**
     * http_basic_auth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#http_basic_auth SpringCloudService#http_basic_auth}
     *
     * @stability stable
     */
    readonly httpBasicAuth?: SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth;
    /**
     * ssh_auth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#ssh_auth SpringCloudService#ssh_auth}
     *
     * @stability stable
     */
    readonly sshAuth?: SpringCloudServiceConfigServerGitSettingRepositorySshAuth;
}
export declare function springCloudServiceConfigServerGitSettingRepositoryToTerraform(struct?: SpringCloudServiceConfigServerGitSettingRepository): any;
/**
 * @stability stable
 */
export interface SpringCloudServiceConfigServerGitSettingSshAuth {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#host_key SpringCloudService#host_key}.
     *
     * @stability stable
     */
    readonly hostKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#host_key_algorithm SpringCloudService#host_key_algorithm}.
     *
     * @stability stable
     */
    readonly hostKeyAlgorithm?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#private_key SpringCloudService#private_key}.
     *
     * @stability stable
     */
    readonly privateKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#strict_host_key_checking_enabled SpringCloudService#strict_host_key_checking_enabled}.
     *
     * @stability stable
     */
    readonly strictHostKeyCheckingEnabled?: boolean | cdktf.IResolvable;
}
export declare function springCloudServiceConfigServerGitSettingSshAuthToTerraform(struct?: SpringCloudServiceConfigServerGitSettingSshAuthOutputReference | SpringCloudServiceConfigServerGitSettingSshAuth): any;
/**
 * @stability stable
 */
export declare class SpringCloudServiceConfigServerGitSettingSshAuthOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudServiceConfigServerGitSettingSshAuth | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudServiceConfigServerGitSettingSshAuth | undefined);
    private _hostKey?;
    /**
     * @stability stable
     */
    get hostKey(): string;
    /**
     * @stability stable
     */
    set hostKey(value: string);
    /**
     * @stability stable
     */
    resetHostKey(): void;
    /**
     * @stability stable
     */
    get hostKeyInput(): string | undefined;
    private _hostKeyAlgorithm?;
    /**
     * @stability stable
     */
    get hostKeyAlgorithm(): string;
    /**
     * @stability stable
     */
    set hostKeyAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetHostKeyAlgorithm(): void;
    /**
     * @stability stable
     */
    get hostKeyAlgorithmInput(): string | undefined;
    private _privateKey?;
    /**
     * @stability stable
     */
    get privateKey(): string;
    /**
     * @stability stable
     */
    set privateKey(value: string);
    /**
     * @stability stable
     */
    get privateKeyInput(): string | undefined;
    private _strictHostKeyCheckingEnabled?;
    /**
     * @stability stable
     */
    get strictHostKeyCheckingEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set strictHostKeyCheckingEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStrictHostKeyCheckingEnabled(): void;
    /**
     * @stability stable
     */
    get strictHostKeyCheckingEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface SpringCloudServiceConfigServerGitSetting {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#label SpringCloudService#label}.
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#search_paths SpringCloudService#search_paths}.
     *
     * @stability stable
     */
    readonly searchPaths?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#uri SpringCloudService#uri}.
     *
     * @stability stable
     */
    readonly uri: string;
    /**
     * http_basic_auth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#http_basic_auth SpringCloudService#http_basic_auth}
     *
     * @stability stable
     */
    readonly httpBasicAuth?: SpringCloudServiceConfigServerGitSettingHttpBasicAuth;
    /**
     * repository block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#repository SpringCloudService#repository}
     *
     * @stability stable
     */
    readonly repository?: SpringCloudServiceConfigServerGitSettingRepository[];
    /**
     * ssh_auth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#ssh_auth SpringCloudService#ssh_auth}
     *
     * @stability stable
     */
    readonly sshAuth?: SpringCloudServiceConfigServerGitSettingSshAuth;
}
export declare function springCloudServiceConfigServerGitSettingToTerraform(struct?: SpringCloudServiceConfigServerGitSettingOutputReference | SpringCloudServiceConfigServerGitSetting): any;
/**
 * @stability stable
 */
export declare class SpringCloudServiceConfigServerGitSettingOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudServiceConfigServerGitSetting | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudServiceConfigServerGitSetting | undefined);
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _searchPaths?;
    /**
     * @stability stable
     */
    get searchPaths(): string[];
    /**
     * @stability stable
     */
    set searchPaths(value: string[]);
    /**
     * @stability stable
     */
    resetSearchPaths(): void;
    /**
     * @stability stable
     */
    get searchPathsInput(): string[] | undefined;
    private _uri?;
    /**
     * @stability stable
     */
    get uri(): string;
    /**
     * @stability stable
     */
    set uri(value: string);
    /**
     * @stability stable
     */
    get uriInput(): string | undefined;
    private _httpBasicAuth;
    /**
     * @stability stable
     */
    get httpBasicAuth(): SpringCloudServiceConfigServerGitSettingHttpBasicAuthOutputReference;
    /**
     * @stability stable
     */
    putHttpBasicAuth(value: SpringCloudServiceConfigServerGitSettingHttpBasicAuth): void;
    /**
     * @stability stable
     */
    resetHttpBasicAuth(): void;
    /**
     * @stability stable
     */
    get httpBasicAuthInput(): SpringCloudServiceConfigServerGitSettingHttpBasicAuth | undefined;
    private _repository?;
    /**
     * @stability stable
     */
    get repository(): SpringCloudServiceConfigServerGitSettingRepository[];
    /**
     * @stability stable
     */
    set repository(value: SpringCloudServiceConfigServerGitSettingRepository[]);
    /**
     * @stability stable
     */
    resetRepository(): void;
    /**
     * @stability stable
     */
    get repositoryInput(): SpringCloudServiceConfigServerGitSettingRepository[] | undefined;
    private _sshAuth;
    /**
     * @stability stable
     */
    get sshAuth(): SpringCloudServiceConfigServerGitSettingSshAuthOutputReference;
    /**
     * @stability stable
     */
    putSshAuth(value: SpringCloudServiceConfigServerGitSettingSshAuth): void;
    /**
     * @stability stable
     */
    resetSshAuth(): void;
    /**
     * @stability stable
     */
    get sshAuthInput(): SpringCloudServiceConfigServerGitSettingSshAuth | undefined;
}
/**
 * @stability stable
 */
export interface SpringCloudServiceNetwork {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#app_network_resource_group SpringCloudService#app_network_resource_group}.
     *
     * @stability stable
     */
    readonly appNetworkResourceGroup?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#app_subnet_id SpringCloudService#app_subnet_id}.
     *
     * @stability stable
     */
    readonly appSubnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#cidr_ranges SpringCloudService#cidr_ranges}.
     *
     * @stability stable
     */
    readonly cidrRanges: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#service_runtime_network_resource_group SpringCloudService#service_runtime_network_resource_group}.
     *
     * @stability stable
     */
    readonly serviceRuntimeNetworkResourceGroup?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#service_runtime_subnet_id SpringCloudService#service_runtime_subnet_id}.
     *
     * @stability stable
     */
    readonly serviceRuntimeSubnetId: string;
}
export declare function springCloudServiceNetworkToTerraform(struct?: SpringCloudServiceNetworkOutputReference | SpringCloudServiceNetwork): any;
/**
 * @stability stable
 */
export declare class SpringCloudServiceNetworkOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudServiceNetwork | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudServiceNetwork | undefined);
    private _appNetworkResourceGroup?;
    /**
     * @stability stable
     */
    get appNetworkResourceGroup(): string;
    /**
     * @stability stable
     */
    set appNetworkResourceGroup(value: string);
    /**
     * @stability stable
     */
    resetAppNetworkResourceGroup(): void;
    /**
     * @stability stable
     */
    get appNetworkResourceGroupInput(): string | undefined;
    private _appSubnetId?;
    /**
     * @stability stable
     */
    get appSubnetId(): string;
    /**
     * @stability stable
     */
    set appSubnetId(value: string);
    /**
     * @stability stable
     */
    get appSubnetIdInput(): string | undefined;
    private _cidrRanges?;
    /**
     * @stability stable
     */
    get cidrRanges(): string[];
    /**
     * @stability stable
     */
    set cidrRanges(value: string[]);
    /**
     * @stability stable
     */
    get cidrRangesInput(): string[] | undefined;
    private _serviceRuntimeNetworkResourceGroup?;
    /**
     * @stability stable
     */
    get serviceRuntimeNetworkResourceGroup(): string;
    /**
     * @stability stable
     */
    set serviceRuntimeNetworkResourceGroup(value: string);
    /**
     * @stability stable
     */
    resetServiceRuntimeNetworkResourceGroup(): void;
    /**
     * @stability stable
     */
    get serviceRuntimeNetworkResourceGroupInput(): string | undefined;
    private _serviceRuntimeSubnetId?;
    /**
     * @stability stable
     */
    get serviceRuntimeSubnetId(): string;
    /**
     * @stability stable
     */
    set serviceRuntimeSubnetId(value: string);
    /**
     * @stability stable
     */
    get serviceRuntimeSubnetIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SpringCloudServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#create SpringCloudService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#delete SpringCloudService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#read SpringCloudService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#update SpringCloudService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function springCloudServiceTimeoutsToTerraform(struct?: SpringCloudServiceTimeoutsOutputReference | SpringCloudServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class SpringCloudServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudServiceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SpringCloudServiceTrace {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#connection_string SpringCloudService#connection_string}.
     *
     * @stability stable
     */
    readonly connectionString?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#instrumentation_key SpringCloudService#instrumentation_key}.
     *
     * @stability stable
     */
    readonly instrumentationKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html#sample_rate SpringCloudService#sample_rate}.
     *
     * @stability stable
     */
    readonly sampleRate?: number;
}
export declare function springCloudServiceTraceToTerraform(struct?: SpringCloudServiceTraceOutputReference | SpringCloudServiceTrace): any;
/**
 * @stability stable
 */
export declare class SpringCloudServiceTraceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudServiceTrace | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudServiceTrace | undefined);
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    set connectionString(value: string);
    /**
     * @stability stable
     */
    resetConnectionString(): void;
    /**
     * @stability stable
     */
    get connectionStringInput(): string | undefined;
    private _instrumentationKey?;
    /**
     * @stability stable
     */
    get instrumentationKey(): string;
    /**
     * @stability stable
     */
    set instrumentationKey(value: string);
    /**
     * @stability stable
     */
    resetInstrumentationKey(): void;
    /**
     * @stability stable
     */
    get instrumentationKeyInput(): string | undefined;
    private _sampleRate?;
    /**
     * @stability stable
     */
    get sampleRate(): number;
    /**
     * @stability stable
     */
    set sampleRate(value: number);
    /**
     * @stability stable
     */
    resetSampleRate(): void;
    /**
     * @stability stable
     */
    get sampleRateInput(): number | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html azurerm_spring_cloud_service}.
 *
 * @stability stable
 */
export declare class SpringCloudService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service.html azurerm_spring_cloud_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SpringCloudServiceConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get outboundPublicIpAddresses(): string[];
    /**
     * @stability stable
     */
    requiredNetworkTrafficRules(index: string): SpringCloudServiceRequiredNetworkTrafficRules;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    resetSkuName(): void;
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _configServerGitSetting;
    /**
     * @stability stable
     */
    get configServerGitSetting(): SpringCloudServiceConfigServerGitSettingOutputReference;
    /**
     * @stability stable
     */
    putConfigServerGitSetting(value: SpringCloudServiceConfigServerGitSetting): void;
    /**
     * @stability stable
     */
    resetConfigServerGitSetting(): void;
    /**
     * @stability stable
     */
    get configServerGitSettingInput(): SpringCloudServiceConfigServerGitSetting | undefined;
    private _network;
    /**
     * @stability stable
     */
    get network(): SpringCloudServiceNetworkOutputReference;
    /**
     * @stability stable
     */
    putNetwork(value: SpringCloudServiceNetwork): void;
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): SpringCloudServiceNetwork | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SpringCloudServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SpringCloudServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SpringCloudServiceTimeouts | undefined;
    private _trace;
    /**
     * @stability stable
     */
    get trace(): SpringCloudServiceTraceOutputReference;
    /**
     * @stability stable
     */
    putTrace(value: SpringCloudServiceTrace): void;
    /**
     * @stability stable
     */
    resetTrace(): void;
    /**
     * @stability stable
     */
    get traceInput(): SpringCloudServiceTrace | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
