import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StreamAnalyticsOutputServicebusQueueConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#name StreamAnalyticsOutputServicebusQueue#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#queue_name StreamAnalyticsOutputServicebusQueue#queue_name}.
     *
     * @stability stable
     */
    readonly queueName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#resource_group_name StreamAnalyticsOutputServicebusQueue#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#servicebus_namespace StreamAnalyticsOutputServicebusQueue#servicebus_namespace}.
     *
     * @stability stable
     */
    readonly servicebusNamespace: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#shared_access_policy_key StreamAnalyticsOutputServicebusQueue#shared_access_policy_key}.
     *
     * @stability stable
     */
    readonly sharedAccessPolicyKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#shared_access_policy_name StreamAnalyticsOutputServicebusQueue#shared_access_policy_name}.
     *
     * @stability stable
     */
    readonly sharedAccessPolicyName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#stream_analytics_job_name StreamAnalyticsOutputServicebusQueue#stream_analytics_job_name}.
     *
     * @stability stable
     */
    readonly streamAnalyticsJobName: string;
    /**
     * serialization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#serialization StreamAnalyticsOutputServicebusQueue#serialization}
     *
     * @stability stable
     */
    readonly serialization: StreamAnalyticsOutputServicebusQueueSerialization;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#timeouts StreamAnalyticsOutputServicebusQueue#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StreamAnalyticsOutputServicebusQueueTimeouts;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsOutputServicebusQueueSerialization {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#encoding StreamAnalyticsOutputServicebusQueue#encoding}.
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#field_delimiter StreamAnalyticsOutputServicebusQueue#field_delimiter}.
     *
     * @stability stable
     */
    readonly fieldDelimiter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#format StreamAnalyticsOutputServicebusQueue#format}.
     *
     * @stability stable
     */
    readonly format?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#type StreamAnalyticsOutputServicebusQueue#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function streamAnalyticsOutputServicebusQueueSerializationToTerraform(struct?: StreamAnalyticsOutputServicebusQueueSerializationOutputReference | StreamAnalyticsOutputServicebusQueueSerialization): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsOutputServicebusQueueSerializationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsOutputServicebusQueueSerialization | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsOutputServicebusQueueSerialization | undefined);
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    /**
     * @stability stable
     */
    get fieldDelimiter(): string;
    /**
     * @stability stable
     */
    set fieldDelimiter(value: string);
    /**
     * @stability stable
     */
    resetFieldDelimiter(): void;
    /**
     * @stability stable
     */
    get fieldDelimiterInput(): string | undefined;
    private _format?;
    /**
     * @stability stable
     */
    get format(): string;
    /**
     * @stability stable
     */
    set format(value: string);
    /**
     * @stability stable
     */
    resetFormat(): void;
    /**
     * @stability stable
     */
    get formatInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsOutputServicebusQueueTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#create StreamAnalyticsOutputServicebusQueue#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#delete StreamAnalyticsOutputServicebusQueue#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#read StreamAnalyticsOutputServicebusQueue#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html#update StreamAnalyticsOutputServicebusQueue#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function streamAnalyticsOutputServicebusQueueTimeoutsToTerraform(struct?: StreamAnalyticsOutputServicebusQueueTimeoutsOutputReference | StreamAnalyticsOutputServicebusQueueTimeouts): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsOutputServicebusQueueTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsOutputServicebusQueueTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsOutputServicebusQueueTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html azurerm_stream_analytics_output_servicebus_queue}.
 *
 * @stability stable
 */
export declare class StreamAnalyticsOutputServicebusQueue extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_servicebus_queue.html azurerm_stream_analytics_output_servicebus_queue} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StreamAnalyticsOutputServicebusQueueConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _queueName?;
    /**
     * @stability stable
     */
    get queueName(): string;
    /**
     * @stability stable
     */
    set queueName(value: string);
    /**
     * @stability stable
     */
    get queueNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _servicebusNamespace?;
    /**
     * @stability stable
     */
    get servicebusNamespace(): string;
    /**
     * @stability stable
     */
    set servicebusNamespace(value: string);
    /**
     * @stability stable
     */
    get servicebusNamespaceInput(): string | undefined;
    private _sharedAccessPolicyKey?;
    /**
     * @stability stable
     */
    get sharedAccessPolicyKey(): string;
    /**
     * @stability stable
     */
    set sharedAccessPolicyKey(value: string);
    /**
     * @stability stable
     */
    get sharedAccessPolicyKeyInput(): string | undefined;
    private _sharedAccessPolicyName?;
    /**
     * @stability stable
     */
    get sharedAccessPolicyName(): string;
    /**
     * @stability stable
     */
    set sharedAccessPolicyName(value: string);
    /**
     * @stability stable
     */
    get sharedAccessPolicyNameInput(): string | undefined;
    private _streamAnalyticsJobName?;
    /**
     * @stability stable
     */
    get streamAnalyticsJobName(): string;
    /**
     * @stability stable
     */
    set streamAnalyticsJobName(value: string);
    /**
     * @stability stable
     */
    get streamAnalyticsJobNameInput(): string | undefined;
    private _serialization;
    /**
     * @stability stable
     */
    get serialization(): StreamAnalyticsOutputServicebusQueueSerializationOutputReference;
    /**
     * @stability stable
     */
    putSerialization(value: StreamAnalyticsOutputServicebusQueueSerialization): void;
    /**
     * @stability stable
     */
    get serializationInput(): StreamAnalyticsOutputServicebusQueueSerialization | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StreamAnalyticsOutputServicebusQueueTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StreamAnalyticsOutputServicebusQueueTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StreamAnalyticsOutputServicebusQueueTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
