import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SubnetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#address_prefix Subnet#address_prefix}.
     *
     * @stability stable
     */
    readonly addressPrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#address_prefixes Subnet#address_prefixes}.
     *
     * @stability stable
     */
    readonly addressPrefixes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#enforce_private_link_endpoint_network_policies Subnet#enforce_private_link_endpoint_network_policies}.
     *
     * @stability stable
     */
    readonly enforcePrivateLinkEndpointNetworkPolicies?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#enforce_private_link_service_network_policies Subnet#enforce_private_link_service_network_policies}.
     *
     * @stability stable
     */
    readonly enforcePrivateLinkServiceNetworkPolicies?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#name Subnet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#resource_group_name Subnet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#service_endpoint_policy_ids Subnet#service_endpoint_policy_ids}.
     *
     * @stability stable
     */
    readonly serviceEndpointPolicyIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#service_endpoints Subnet#service_endpoints}.
     *
     * @stability stable
     */
    readonly serviceEndpoints?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#virtual_network_name Subnet#virtual_network_name}.
     *
     * @stability stable
     */
    readonly virtualNetworkName: string;
    /**
     * delegation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#delegation Subnet#delegation}
     *
     * @stability stable
     */
    readonly delegation?: SubnetDelegation[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#timeouts Subnet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SubnetTimeouts;
}
/**
 * @stability stable
 */
export interface SubnetDelegationServiceDelegation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#actions Subnet#actions}.
     *
     * @stability stable
     */
    readonly actions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#name Subnet#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function subnetDelegationServiceDelegationToTerraform(struct?: SubnetDelegationServiceDelegationOutputReference | SubnetDelegationServiceDelegation): any;
/**
 * @stability stable
 */
export declare class SubnetDelegationServiceDelegationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SubnetDelegationServiceDelegation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SubnetDelegationServiceDelegation | undefined);
    private _actions?;
    /**
     * @stability stable
     */
    get actions(): string[];
    /**
     * @stability stable
     */
    set actions(value: string[]);
    /**
     * @stability stable
     */
    resetActions(): void;
    /**
     * @stability stable
     */
    get actionsInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SubnetDelegation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#name Subnet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * service_delegation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#service_delegation Subnet#service_delegation}
     *
     * @stability stable
     */
    readonly serviceDelegation: SubnetDelegationServiceDelegation;
}
export declare function subnetDelegationToTerraform(struct?: SubnetDelegation): any;
/**
 * @stability stable
 */
export interface SubnetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#create Subnet#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#delete Subnet#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#read Subnet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html#update Subnet#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function subnetTimeoutsToTerraform(struct?: SubnetTimeoutsOutputReference | SubnetTimeouts): any;
/**
 * @stability stable
 */
export declare class SubnetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SubnetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SubnetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html azurerm_subnet}.
 *
 * @stability stable
 */
export declare class Subnet extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/subnet.html azurerm_subnet} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SubnetConfig);
    private _addressPrefix?;
    /**
     * @stability stable
     */
    get addressPrefix(): string;
    /**
     * @stability stable
     */
    set addressPrefix(value: string);
    /**
     * @stability stable
     */
    resetAddressPrefix(): void;
    /**
     * @stability stable
     */
    get addressPrefixInput(): string | undefined;
    private _addressPrefixes?;
    /**
     * @stability stable
     */
    get addressPrefixes(): string[];
    /**
     * @stability stable
     */
    set addressPrefixes(value: string[]);
    /**
     * @stability stable
     */
    resetAddressPrefixes(): void;
    /**
     * @stability stable
     */
    get addressPrefixesInput(): string[] | undefined;
    private _enforcePrivateLinkEndpointNetworkPolicies?;
    /**
     * @stability stable
     */
    get enforcePrivateLinkEndpointNetworkPolicies(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enforcePrivateLinkEndpointNetworkPolicies(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnforcePrivateLinkEndpointNetworkPolicies(): void;
    /**
     * @stability stable
     */
    get enforcePrivateLinkEndpointNetworkPoliciesInput(): boolean | cdktf.IResolvable | undefined;
    private _enforcePrivateLinkServiceNetworkPolicies?;
    /**
     * @stability stable
     */
    get enforcePrivateLinkServiceNetworkPolicies(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enforcePrivateLinkServiceNetworkPolicies(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnforcePrivateLinkServiceNetworkPolicies(): void;
    /**
     * @stability stable
     */
    get enforcePrivateLinkServiceNetworkPoliciesInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _serviceEndpointPolicyIds?;
    /**
     * @stability stable
     */
    get serviceEndpointPolicyIds(): string[];
    /**
     * @stability stable
     */
    set serviceEndpointPolicyIds(value: string[]);
    /**
     * @stability stable
     */
    resetServiceEndpointPolicyIds(): void;
    /**
     * @stability stable
     */
    get serviceEndpointPolicyIdsInput(): string[] | undefined;
    private _serviceEndpoints?;
    /**
     * @stability stable
     */
    get serviceEndpoints(): string[];
    /**
     * @stability stable
     */
    set serviceEndpoints(value: string[]);
    /**
     * @stability stable
     */
    resetServiceEndpoints(): void;
    /**
     * @stability stable
     */
    get serviceEndpointsInput(): string[] | undefined;
    private _virtualNetworkName?;
    /**
     * @stability stable
     */
    get virtualNetworkName(): string;
    /**
     * @stability stable
     */
    set virtualNetworkName(value: string);
    /**
     * @stability stable
     */
    get virtualNetworkNameInput(): string | undefined;
    private _delegation?;
    /**
     * @stability stable
     */
    get delegation(): SubnetDelegation[];
    /**
     * @stability stable
     */
    set delegation(value: SubnetDelegation[]);
    /**
     * @stability stable
     */
    resetDelegation(): void;
    /**
     * @stability stable
     */
    get delegationInput(): SubnetDelegation[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SubnetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SubnetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SubnetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
