import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#availability_set_id VirtualMachine#availability_set_id}.
     *
     * @stability stable
     */
    readonly availabilitySetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#delete_data_disks_on_termination VirtualMachine#delete_data_disks_on_termination}.
     *
     * @stability stable
     */
    readonly deleteDataDisksOnTermination?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#delete_os_disk_on_termination VirtualMachine#delete_os_disk_on_termination}.
     *
     * @stability stable
     */
    readonly deleteOsDiskOnTermination?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#license_type VirtualMachine#license_type}.
     *
     * @stability stable
     */
    readonly licenseType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#location VirtualMachine#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#name VirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#network_interface_ids VirtualMachine#network_interface_ids}.
     *
     * @stability stable
     */
    readonly networkInterfaceIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#primary_network_interface_id VirtualMachine#primary_network_interface_id}.
     *
     * @stability stable
     */
    readonly primaryNetworkInterfaceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#proximity_placement_group_id VirtualMachine#proximity_placement_group_id}.
     *
     * @stability stable
     */
    readonly proximityPlacementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#resource_group_name VirtualMachine#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#tags VirtualMachine#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#vm_size VirtualMachine#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#zones VirtualMachine#zones}.
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * additional_capabilities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#additional_capabilities VirtualMachine#additional_capabilities}
     *
     * @stability stable
     */
    readonly additionalCapabilities?: VirtualMachineAdditionalCapabilities;
    /**
     * boot_diagnostics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#boot_diagnostics VirtualMachine#boot_diagnostics}
     *
     * @stability stable
     */
    readonly bootDiagnostics?: VirtualMachineBootDiagnostics;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#identity VirtualMachine#identity}
     *
     * @stability stable
     */
    readonly identity?: VirtualMachineIdentity;
    /**
     * os_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#os_profile VirtualMachine#os_profile}
     *
     * @stability stable
     */
    readonly osProfile?: VirtualMachineOsProfile;
    /**
     * os_profile_linux_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#os_profile_linux_config VirtualMachine#os_profile_linux_config}
     *
     * @stability stable
     */
    readonly osProfileLinuxConfig?: VirtualMachineOsProfileLinuxConfig;
    /**
     * os_profile_secrets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#os_profile_secrets VirtualMachine#os_profile_secrets}
     *
     * @stability stable
     */
    readonly osProfileSecrets?: VirtualMachineOsProfileSecrets[];
    /**
     * os_profile_windows_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#os_profile_windows_config VirtualMachine#os_profile_windows_config}
     *
     * @stability stable
     */
    readonly osProfileWindowsConfig?: VirtualMachineOsProfileWindowsConfig;
    /**
     * plan block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#plan VirtualMachine#plan}
     *
     * @stability stable
     */
    readonly plan?: VirtualMachinePlan;
    /**
     * storage_data_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#storage_data_disk VirtualMachine#storage_data_disk}
     *
     * @stability stable
     */
    readonly storageDataDisk?: VirtualMachineStorageDataDisk[];
    /**
     * storage_image_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#storage_image_reference VirtualMachine#storage_image_reference}
     *
     * @stability stable
     */
    readonly storageImageReference?: VirtualMachineStorageImageReference;
    /**
     * storage_os_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#storage_os_disk VirtualMachine#storage_os_disk}
     *
     * @stability stable
     */
    readonly storageOsDisk: VirtualMachineStorageOsDisk;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#timeouts VirtualMachine#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualMachineTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualMachineAdditionalCapabilities {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#ultra_ssd_enabled VirtualMachine#ultra_ssd_enabled}.
     *
     * @stability stable
     */
    readonly ultraSsdEnabled: boolean | cdktf.IResolvable;
}
export declare function virtualMachineAdditionalCapabilitiesToTerraform(struct?: VirtualMachineAdditionalCapabilitiesOutputReference | VirtualMachineAdditionalCapabilities): any;
/**
 * @stability stable
 */
export declare class VirtualMachineAdditionalCapabilitiesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineAdditionalCapabilities | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineAdditionalCapabilities | undefined);
    private _ultraSsdEnabled?;
    /**
     * @stability stable
     */
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineBootDiagnostics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#enabled VirtualMachine#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#storage_uri VirtualMachine#storage_uri}.
     *
     * @stability stable
     */
    readonly storageUri: string;
}
export declare function virtualMachineBootDiagnosticsToTerraform(struct?: VirtualMachineBootDiagnosticsOutputReference | VirtualMachineBootDiagnostics): any;
/**
 * @stability stable
 */
export declare class VirtualMachineBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineBootDiagnostics | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineBootDiagnostics | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageUri?;
    /**
     * @stability stable
     */
    get storageUri(): string;
    /**
     * @stability stable
     */
    set storageUri(value: string);
    /**
     * @stability stable
     */
    get storageUriInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#identity_ids VirtualMachine#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#type VirtualMachine#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function virtualMachineIdentityToTerraform(struct?: VirtualMachineIdentityOutputReference | VirtualMachineIdentity): any;
/**
 * @stability stable
 */
export declare class VirtualMachineIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineOsProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#admin_password VirtualMachine#admin_password}.
     *
     * @stability stable
     */
    readonly adminPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#admin_username VirtualMachine#admin_username}.
     *
     * @stability stable
     */
    readonly adminUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#computer_name VirtualMachine#computer_name}.
     *
     * @stability stable
     */
    readonly computerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#custom_data VirtualMachine#custom_data}.
     *
     * @stability stable
     */
    readonly customData?: string;
}
export declare function virtualMachineOsProfileToTerraform(struct?: VirtualMachineOsProfileOutputReference | VirtualMachineOsProfile): any;
/**
 * @stability stable
 */
export declare class VirtualMachineOsProfileOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineOsProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineOsProfile | undefined);
    private _adminPassword?;
    /**
     * @stability stable
     */
    get adminPassword(): string;
    /**
     * @stability stable
     */
    set adminPassword(value: string);
    /**
     * @stability stable
     */
    resetAdminPassword(): void;
    /**
     * @stability stable
     */
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    /**
     * @stability stable
     */
    get adminUsername(): string;
    /**
     * @stability stable
     */
    set adminUsername(value: string);
    /**
     * @stability stable
     */
    get adminUsernameInput(): string | undefined;
    private _computerName?;
    /**
     * @stability stable
     */
    get computerName(): string;
    /**
     * @stability stable
     */
    set computerName(value: string);
    /**
     * @stability stable
     */
    get computerNameInput(): string | undefined;
    private _customData?;
    /**
     * @stability stable
     */
    get customData(): string;
    /**
     * @stability stable
     */
    set customData(value: string);
    /**
     * @stability stable
     */
    resetCustomData(): void;
    /**
     * @stability stable
     */
    get customDataInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineOsProfileLinuxConfigSshKeys {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#key_data VirtualMachine#key_data}.
     *
     * @stability stable
     */
    readonly keyData: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#path VirtualMachine#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function virtualMachineOsProfileLinuxConfigSshKeysToTerraform(struct?: VirtualMachineOsProfileLinuxConfigSshKeys): any;
/**
 * @stability stable
 */
export interface VirtualMachineOsProfileLinuxConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#disable_password_authentication VirtualMachine#disable_password_authentication}.
     *
     * @stability stable
     */
    readonly disablePasswordAuthentication: boolean | cdktf.IResolvable;
    /**
     * ssh_keys block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#ssh_keys VirtualMachine#ssh_keys}
     *
     * @stability stable
     */
    readonly sshKeys?: VirtualMachineOsProfileLinuxConfigSshKeys[];
}
export declare function virtualMachineOsProfileLinuxConfigToTerraform(struct?: VirtualMachineOsProfileLinuxConfigOutputReference | VirtualMachineOsProfileLinuxConfig): any;
/**
 * @stability stable
 */
export declare class VirtualMachineOsProfileLinuxConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineOsProfileLinuxConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineOsProfileLinuxConfig | undefined);
    private _disablePasswordAuthentication?;
    /**
     * @stability stable
     */
    get disablePasswordAuthentication(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disablePasswordAuthentication(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get disablePasswordAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): VirtualMachineOsProfileLinuxConfigSshKeys[];
    /**
     * @stability stable
     */
    set sshKeys(value: VirtualMachineOsProfileLinuxConfigSshKeys[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): VirtualMachineOsProfileLinuxConfigSshKeys[] | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineOsProfileSecretsVaultCertificates {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#certificate_store VirtualMachine#certificate_store}.
     *
     * @stability stable
     */
    readonly certificateStore?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#certificate_url VirtualMachine#certificate_url}.
     *
     * @stability stable
     */
    readonly certificateUrl: string;
}
export declare function virtualMachineOsProfileSecretsVaultCertificatesToTerraform(struct?: VirtualMachineOsProfileSecretsVaultCertificates): any;
/**
 * @stability stable
 */
export interface VirtualMachineOsProfileSecrets {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#source_vault_id VirtualMachine#source_vault_id}.
     *
     * @stability stable
     */
    readonly sourceVaultId: string;
    /**
     * vault_certificates block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#vault_certificates VirtualMachine#vault_certificates}
     *
     * @stability stable
     */
    readonly vaultCertificates?: VirtualMachineOsProfileSecretsVaultCertificates[];
}
export declare function virtualMachineOsProfileSecretsToTerraform(struct?: VirtualMachineOsProfileSecrets): any;
/**
 * @stability stable
 */
export interface VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#component VirtualMachine#component}.
     *
     * @stability stable
     */
    readonly component: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#content VirtualMachine#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#pass VirtualMachine#pass}.
     *
     * @stability stable
     */
    readonly pass: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#setting_name VirtualMachine#setting_name}.
     *
     * @stability stable
     */
    readonly settingName: string;
}
export declare function virtualMachineOsProfileWindowsConfigAdditionalUnattendConfigToTerraform(struct?: VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig): any;
/**
 * @stability stable
 */
export interface VirtualMachineOsProfileWindowsConfigWinrm {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#certificate_url VirtualMachine#certificate_url}.
     *
     * @stability stable
     */
    readonly certificateUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#protocol VirtualMachine#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
}
export declare function virtualMachineOsProfileWindowsConfigWinrmToTerraform(struct?: VirtualMachineOsProfileWindowsConfigWinrm): any;
/**
 * @stability stable
 */
export interface VirtualMachineOsProfileWindowsConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#enable_automatic_upgrades VirtualMachine#enable_automatic_upgrades}.
     *
     * @stability stable
     */
    readonly enableAutomaticUpgrades?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#provision_vm_agent VirtualMachine#provision_vm_agent}.
     *
     * @stability stable
     */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#timezone VirtualMachine#timezone}.
     *
     * @stability stable
     */
    readonly timezone?: string;
    /**
     * additional_unattend_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#additional_unattend_config VirtualMachine#additional_unattend_config}
     *
     * @stability stable
     */
    readonly additionalUnattendConfig?: VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig[];
    /**
     * winrm block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#winrm VirtualMachine#winrm}
     *
     * @stability stable
     */
    readonly winrm?: VirtualMachineOsProfileWindowsConfigWinrm[];
}
export declare function virtualMachineOsProfileWindowsConfigToTerraform(struct?: VirtualMachineOsProfileWindowsConfigOutputReference | VirtualMachineOsProfileWindowsConfig): any;
/**
 * @stability stable
 */
export declare class VirtualMachineOsProfileWindowsConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineOsProfileWindowsConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineOsProfileWindowsConfig | undefined);
    private _enableAutomaticUpgrades?;
    /**
     * @stability stable
     */
    get enableAutomaticUpgrades(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAutomaticUpgrades(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableAutomaticUpgrades(): void;
    /**
     * @stability stable
     */
    get enableAutomaticUpgradesInput(): boolean | cdktf.IResolvable | undefined;
    private _provisionVmAgent?;
    /**
     * @stability stable
     */
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProvisionVmAgent(): void;
    /**
     * @stability stable
     */
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _additionalUnattendConfig?;
    /**
     * @stability stable
     */
    get additionalUnattendConfig(): VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig[];
    /**
     * @stability stable
     */
    set additionalUnattendConfig(value: VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig[]);
    /**
     * @stability stable
     */
    resetAdditionalUnattendConfig(): void;
    /**
     * @stability stable
     */
    get additionalUnattendConfigInput(): VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig[] | undefined;
    private _winrm?;
    /**
     * @stability stable
     */
    get winrm(): VirtualMachineOsProfileWindowsConfigWinrm[];
    /**
     * @stability stable
     */
    set winrm(value: VirtualMachineOsProfileWindowsConfigWinrm[]);
    /**
     * @stability stable
     */
    resetWinrm(): void;
    /**
     * @stability stable
     */
    get winrmInput(): VirtualMachineOsProfileWindowsConfigWinrm[] | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachinePlan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#name VirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#product VirtualMachine#product}.
     *
     * @stability stable
     */
    readonly product: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#publisher VirtualMachine#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
}
export declare function virtualMachinePlanToTerraform(struct?: VirtualMachinePlanOutputReference | VirtualMachinePlan): any;
/**
 * @stability stable
 */
export declare class VirtualMachinePlanOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachinePlan | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachinePlan | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _product?;
    /**
     * @stability stable
     */
    get product(): string;
    /**
     * @stability stable
     */
    set product(value: string);
    /**
     * @stability stable
     */
    get productInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineStorageDataDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#caching VirtualMachine#caching}.
     *
     * @stability stable
     */
    readonly caching?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#create_option VirtualMachine#create_option}.
     *
     * @stability stable
     */
    readonly createOption: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#disk_size_gb VirtualMachine#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#lun VirtualMachine#lun}.
     *
     * @stability stable
     */
    readonly lun: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#managed_disk_id VirtualMachine#managed_disk_id}.
     *
     * @stability stable
     */
    readonly managedDiskId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#managed_disk_type VirtualMachine#managed_disk_type}.
     *
     * @stability stable
     */
    readonly managedDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#name VirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#vhd_uri VirtualMachine#vhd_uri}.
     *
     * @stability stable
     */
    readonly vhdUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#write_accelerator_enabled VirtualMachine#write_accelerator_enabled}.
     *
     * @stability stable
     */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
}
export declare function virtualMachineStorageDataDiskToTerraform(struct?: VirtualMachineStorageDataDisk): any;
/**
 * @stability stable
 */
export interface VirtualMachineStorageImageReference {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#id VirtualMachine#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#offer VirtualMachine#offer}.
     *
     * @stability stable
     */
    readonly offer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#publisher VirtualMachine#publisher}.
     *
     * @stability stable
     */
    readonly publisher?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#sku VirtualMachine#sku}.
     *
     * @stability stable
     */
    readonly sku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#version VirtualMachine#version}.
     *
     * @stability stable
     */
    readonly version?: string;
}
export declare function virtualMachineStorageImageReferenceToTerraform(struct?: VirtualMachineStorageImageReferenceOutputReference | VirtualMachineStorageImageReference): any;
/**
 * @stability stable
 */
export declare class VirtualMachineStorageImageReferenceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineStorageImageReference | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineStorageImageReference | undefined);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _offer?;
    /**
     * @stability stable
     */
    get offer(): string;
    /**
     * @stability stable
     */
    set offer(value: string);
    /**
     * @stability stable
     */
    resetOffer(): void;
    /**
     * @stability stable
     */
    get offerInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    resetPublisher(): void;
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    resetSku(): void;
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineStorageOsDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#caching VirtualMachine#caching}.
     *
     * @stability stable
     */
    readonly caching?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#create_option VirtualMachine#create_option}.
     *
     * @stability stable
     */
    readonly createOption: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#disk_size_gb VirtualMachine#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#image_uri VirtualMachine#image_uri}.
     *
     * @stability stable
     */
    readonly imageUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#managed_disk_id VirtualMachine#managed_disk_id}.
     *
     * @stability stable
     */
    readonly managedDiskId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#managed_disk_type VirtualMachine#managed_disk_type}.
     *
     * @stability stable
     */
    readonly managedDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#name VirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#os_type VirtualMachine#os_type}.
     *
     * @stability stable
     */
    readonly osType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#vhd_uri VirtualMachine#vhd_uri}.
     *
     * @stability stable
     */
    readonly vhdUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#write_accelerator_enabled VirtualMachine#write_accelerator_enabled}.
     *
     * @stability stable
     */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
}
export declare function virtualMachineStorageOsDiskToTerraform(struct?: VirtualMachineStorageOsDiskOutputReference | VirtualMachineStorageOsDisk): any;
/**
 * @stability stable
 */
export declare class VirtualMachineStorageOsDiskOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineStorageOsDisk | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineStorageOsDisk | undefined);
    private _caching?;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    set caching(value: string);
    /**
     * @stability stable
     */
    resetCaching(): void;
    /**
     * @stability stable
     */
    get cachingInput(): string | undefined;
    private _createOption?;
    /**
     * @stability stable
     */
    get createOption(): string;
    /**
     * @stability stable
     */
    set createOption(value: string);
    /**
     * @stability stable
     */
    get createOptionInput(): string | undefined;
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _imageUri?;
    /**
     * @stability stable
     */
    get imageUri(): string;
    /**
     * @stability stable
     */
    set imageUri(value: string);
    /**
     * @stability stable
     */
    resetImageUri(): void;
    /**
     * @stability stable
     */
    get imageUriInput(): string | undefined;
    private _managedDiskId?;
    /**
     * @stability stable
     */
    get managedDiskId(): string;
    /**
     * @stability stable
     */
    set managedDiskId(value: string);
    /**
     * @stability stable
     */
    resetManagedDiskId(): void;
    /**
     * @stability stable
     */
    get managedDiskIdInput(): string | undefined;
    private _managedDiskType?;
    /**
     * @stability stable
     */
    get managedDiskType(): string;
    /**
     * @stability stable
     */
    set managedDiskType(value: string);
    /**
     * @stability stable
     */
    resetManagedDiskType(): void;
    /**
     * @stability stable
     */
    get managedDiskTypeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _osType?;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    set osType(value: string);
    /**
     * @stability stable
     */
    resetOsType(): void;
    /**
     * @stability stable
     */
    get osTypeInput(): string | undefined;
    private _vhdUri?;
    /**
     * @stability stable
     */
    get vhdUri(): string;
    /**
     * @stability stable
     */
    set vhdUri(value: string);
    /**
     * @stability stable
     */
    resetVhdUri(): void;
    /**
     * @stability stable
     */
    get vhdUriInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWriteAcceleratorEnabled(): void;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface VirtualMachineTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#create VirtualMachine#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#delete VirtualMachine#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#read VirtualMachine#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html#update VirtualMachine#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualMachineTimeoutsToTerraform(struct?: VirtualMachineTimeoutsOutputReference | VirtualMachineTimeouts): any;
/**
 * @stability stable
 */
export declare class VirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualMachineTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html azurerm_virtual_machine}.
 *
 * @stability stable
 */
export declare class VirtualMachine extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine.html azurerm_virtual_machine} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualMachineConfig);
    private _availabilitySetId?;
    /**
     * @stability stable
     */
    get availabilitySetId(): string;
    /**
     * @stability stable
     */
    set availabilitySetId(value: string);
    /**
     * @stability stable
     */
    resetAvailabilitySetId(): void;
    /**
     * @stability stable
     */
    get availabilitySetIdInput(): string | undefined;
    private _deleteDataDisksOnTermination?;
    /**
     * @stability stable
     */
    get deleteDataDisksOnTermination(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deleteDataDisksOnTermination(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeleteDataDisksOnTermination(): void;
    /**
     * @stability stable
     */
    get deleteDataDisksOnTerminationInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteOsDiskOnTermination?;
    /**
     * @stability stable
     */
    get deleteOsDiskOnTermination(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deleteOsDiskOnTermination(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeleteOsDiskOnTermination(): void;
    /**
     * @stability stable
     */
    get deleteOsDiskOnTerminationInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _licenseType?;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    set licenseType(value: string);
    /**
     * @stability stable
     */
    resetLicenseType(): void;
    /**
     * @stability stable
     */
    get licenseTypeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkInterfaceIds?;
    /**
     * @stability stable
     */
    get networkInterfaceIds(): string[];
    /**
     * @stability stable
     */
    set networkInterfaceIds(value: string[]);
    /**
     * @stability stable
     */
    get networkInterfaceIdsInput(): string[] | undefined;
    private _primaryNetworkInterfaceId?;
    /**
     * @stability stable
     */
    get primaryNetworkInterfaceId(): string;
    /**
     * @stability stable
     */
    set primaryNetworkInterfaceId(value: string);
    /**
     * @stability stable
     */
    resetPrimaryNetworkInterfaceId(): void;
    /**
     * @stability stable
     */
    get primaryNetworkInterfaceIdInput(): string | undefined;
    private _proximityPlacementGroupId?;
    /**
     * @stability stable
     */
    get proximityPlacementGroupId(): string;
    /**
     * @stability stable
     */
    set proximityPlacementGroupId(value: string);
    /**
     * @stability stable
     */
    resetProximityPlacementGroupId(): void;
    /**
     * @stability stable
     */
    get proximityPlacementGroupIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _additionalCapabilities;
    /**
     * @stability stable
     */
    get additionalCapabilities(): VirtualMachineAdditionalCapabilitiesOutputReference;
    /**
     * @stability stable
     */
    putAdditionalCapabilities(value: VirtualMachineAdditionalCapabilities): void;
    /**
     * @stability stable
     */
    resetAdditionalCapabilities(): void;
    /**
     * @stability stable
     */
    get additionalCapabilitiesInput(): VirtualMachineAdditionalCapabilities | undefined;
    private _bootDiagnostics;
    /**
     * @stability stable
     */
    get bootDiagnostics(): VirtualMachineBootDiagnosticsOutputReference;
    /**
     * @stability stable
     */
    putBootDiagnostics(value: VirtualMachineBootDiagnostics): void;
    /**
     * @stability stable
     */
    resetBootDiagnostics(): void;
    /**
     * @stability stable
     */
    get bootDiagnosticsInput(): VirtualMachineBootDiagnostics | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): VirtualMachineIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: VirtualMachineIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): VirtualMachineIdentity | undefined;
    private _osProfile;
    /**
     * @stability stable
     */
    get osProfile(): VirtualMachineOsProfileOutputReference;
    /**
     * @stability stable
     */
    putOsProfile(value: VirtualMachineOsProfile): void;
    /**
     * @stability stable
     */
    resetOsProfile(): void;
    /**
     * @stability stable
     */
    get osProfileInput(): VirtualMachineOsProfile | undefined;
    private _osProfileLinuxConfig;
    /**
     * @stability stable
     */
    get osProfileLinuxConfig(): VirtualMachineOsProfileLinuxConfigOutputReference;
    /**
     * @stability stable
     */
    putOsProfileLinuxConfig(value: VirtualMachineOsProfileLinuxConfig): void;
    /**
     * @stability stable
     */
    resetOsProfileLinuxConfig(): void;
    /**
     * @stability stable
     */
    get osProfileLinuxConfigInput(): VirtualMachineOsProfileLinuxConfig | undefined;
    private _osProfileSecrets?;
    /**
     * @stability stable
     */
    get osProfileSecrets(): VirtualMachineOsProfileSecrets[];
    /**
     * @stability stable
     */
    set osProfileSecrets(value: VirtualMachineOsProfileSecrets[]);
    /**
     * @stability stable
     */
    resetOsProfileSecrets(): void;
    /**
     * @stability stable
     */
    get osProfileSecretsInput(): VirtualMachineOsProfileSecrets[] | undefined;
    private _osProfileWindowsConfig;
    /**
     * @stability stable
     */
    get osProfileWindowsConfig(): VirtualMachineOsProfileWindowsConfigOutputReference;
    /**
     * @stability stable
     */
    putOsProfileWindowsConfig(value: VirtualMachineOsProfileWindowsConfig): void;
    /**
     * @stability stable
     */
    resetOsProfileWindowsConfig(): void;
    /**
     * @stability stable
     */
    get osProfileWindowsConfigInput(): VirtualMachineOsProfileWindowsConfig | undefined;
    private _plan;
    /**
     * @stability stable
     */
    get plan(): VirtualMachinePlanOutputReference;
    /**
     * @stability stable
     */
    putPlan(value: VirtualMachinePlan): void;
    /**
     * @stability stable
     */
    resetPlan(): void;
    /**
     * @stability stable
     */
    get planInput(): VirtualMachinePlan | undefined;
    private _storageDataDisk?;
    /**
     * @stability stable
     */
    get storageDataDisk(): VirtualMachineStorageDataDisk[];
    /**
     * @stability stable
     */
    set storageDataDisk(value: VirtualMachineStorageDataDisk[]);
    /**
     * @stability stable
     */
    resetStorageDataDisk(): void;
    /**
     * @stability stable
     */
    get storageDataDiskInput(): VirtualMachineStorageDataDisk[] | undefined;
    private _storageImageReference;
    /**
     * @stability stable
     */
    get storageImageReference(): VirtualMachineStorageImageReferenceOutputReference;
    /**
     * @stability stable
     */
    putStorageImageReference(value: VirtualMachineStorageImageReference): void;
    /**
     * @stability stable
     */
    resetStorageImageReference(): void;
    /**
     * @stability stable
     */
    get storageImageReferenceInput(): VirtualMachineStorageImageReference | undefined;
    private _storageOsDisk;
    /**
     * @stability stable
     */
    get storageOsDisk(): VirtualMachineStorageOsDiskOutputReference;
    /**
     * @stability stable
     */
    putStorageOsDisk(value: VirtualMachineStorageOsDisk): void;
    /**
     * @stability stable
     */
    get storageOsDiskInput(): VirtualMachineStorageOsDisk | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualMachineTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualMachineTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
