from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkIOCore
import vtkmodules.vtkRenderingContext2D
import vtkmodules.vtkRenderingCore

class vtkX3D(vtkmodules.vtkCommonCore.namespace):
    class X3DAttribute(int): ...
    class X3DElement(int): ...
    class X3DTypes(int): ...
    AS:'X3DAttribute'
    Anchor:'X3DElement'
    Appearance:'X3DElement'
    Arc2D:'X3DElement'
    ArcClose2D:'X3DElement'
    AudioClip:'X3DElement'
    Background:'X3DElement'
    Billboard:'X3DElement'
    BooleanFilter:'X3DElement'
    BooleanSequencer:'X3DElement'
    BooleanToggle:'X3DElement'
    BooleanTrigger:'X3DElement'
    Box:'X3DElement'
    CADAssembly:'X3DElement'
    CADFace:'X3DElement'
    CADLayer:'X3DElement'
    CADPart:'X3DElement'
    Circle2D:'X3DElement'
    Collision:'X3DElement'
    Color:'X3DElement'
    ColorInterpolator:'X3DElement'
    ColorRGBA:'X3DElement'
    ComposedCubeMapTexture:'X3DElement'
    ComposedShader:'X3DElement'
    ComposedTexture3D:'X3DElement'
    Cone:'X3DElement'
    Contour2D:'X3DElement'
    ContourPolyline2D:'X3DElement'
    Coordinate:'X3DElement'
    CoordinateDouble:'X3DElement'
    CoordinateInterpolator:'X3DElement'
    CoordinateInterpolator2D:'X3DElement'
    Cylinder:'X3DElement'
    CylinderSensor:'X3DElement'
    DEF:'X3DAttribute'
    DirectionalLight:'X3DElement'
    Disk2D:'X3DElement'
    EXPORT:'X3DElement'
    ElevationGrid:'X3DElement'
    EspduTransform:'X3DElement'
    ExternProtoDeclare:'X3DElement'
    Extrusion:'X3DElement'
    FillProperties:'X3DElement'
    FloatVertexAttribute:'X3DElement'
    Fog:'X3DElement'
    FogCoordinate:'X3DElement'
    FontStyle:'X3DElement'
    GeneratedCubeMapTexture:'X3DElement'
    GeoCoordinate:'X3DElement'
    GeoElevationGrid:'X3DElement'
    GeoLOD:'X3DElement'
    GeoLocation:'X3DElement'
    GeoMetadata:'X3DElement'
    GeoOrigin:'X3DElement'
    GeoPositionInterpolator:'X3DElement'
    GeoTouchSensor:'X3DElement'
    GeoViewpoint:'X3DElement'
    Group:'X3DElement'
    HAnimDisplacer:'X3DElement'
    HAnimHumanoid:'X3DElement'
    HAnimJoint:'X3DElement'
    HAnimSegment:'X3DElement'
    HAnimSite:'X3DElement'
    IMPORT:'X3DElement'
    IS:'X3DElement'
    ImageCubeMapTexture:'X3DElement'
    ImageTexture:'X3DElement'
    ImageTexture3D:'X3DElement'
    IndexedFaceSet:'X3DElement'
    IndexedLineSet:'X3DElement'
    IndexedQuadSet:'X3DElement'
    IndexedTriangleFanSet:'X3DElement'
    IndexedTriangleSet:'X3DElement'
    IndexedTriangleStripSet:'X3DElement'
    Inline:'X3DElement'
    InlineDEF:'X3DAttribute'
    IntegerSequencer:'X3DElement'
    IntegerTrigger:'X3DElement'
    KeySensor:'X3DElement'
    LOD:'X3DElement'
    LineProperties:'X3DElement'
    LineSet:'X3DElement'
    LoadSensor:'X3DElement'
    LocalFog:'X3DElement'
    MFCOLOR:'X3DTypes'
    MFINT32:'X3DTypes'
    MFROTATION:'X3DTypes'
    MFSTRING:'X3DTypes'
    MFVEC2F:'X3DTypes'
    MFVEC3F:'X3DTypes'
    Material:'X3DElement'
    Matrix3VertexAttribute:'X3DElement'
    Matrix4VertexAttribute:'X3DElement'
    MetadataDouble:'X3DElement'
    MetadataFloat:'X3DElement'
    MetadataInteger:'X3DElement'
    MetadataSet:'X3DElement'
    MetadataString:'X3DElement'
    MovieTexture:'X3DElement'
    MultiTexture:'X3DElement'
    MultiTextureCoordinate:'X3DElement'
    MultiTextureTransform:'X3DElement'
    NavigationInfo:'X3DElement'
    Normal:'X3DElement'
    NormalInterpolator:'X3DElement'
    NurbsCurve:'X3DElement'
    NurbsCurve2D:'X3DElement'
    NurbsOrientationInterpolator:'X3DElement'
    NurbsPatchSurface:'X3DElement'
    NurbsPositionInterpolator:'X3DElement'
    NurbsSet:'X3DElement'
    NurbsSurfaceInterpolator:'X3DElement'
    NurbsSweptSurface:'X3DElement'
    NurbsSwungSurface:'X3DElement'
    NurbsTextureCoordinate:'X3DElement'
    NurbsTrimmedSurface:'X3DElement'
    OrientationInterpolator:'X3DElement'
    PackagedShader:'X3DElement'
    PixelTexture:'X3DElement'
    PixelTexture3D:'X3DElement'
    PlaneSensor:'X3DElement'
    PointLight:'X3DElement'
    PointSet:'X3DElement'
    Polyline2D:'X3DElement'
    Polypoint2D:'X3DElement'
    PositionInterpolator:'X3DElement'
    PositionInterpolator2D:'X3DElement'
    ProgramShader:'X3DElement'
    ProtoBody:'X3DElement'
    ProtoDeclare:'X3DElement'
    ProtoInstance:'X3DElement'
    ProtoInterface:'X3DElement'
    ProximitySensor:'X3DElement'
    QuadSet:'X3DElement'
    ROUTE:'X3DElement'
    ReceiverPdu:'X3DElement'
    Rectangle2D:'X3DElement'
    SFCOLOR:'X3DTypes'
    SFIMAGE:'X3DTypes'
    SFROTATION:'X3DTypes'
    SFSTRING:'X3DTypes'
    SFVEC2F:'X3DTypes'
    SFVEC3F:'X3DTypes'
    ScalarInterpolator:'X3DElement'
    Scene:'X3DElement'
    Script:'X3DElement'
    ShaderPart:'X3DElement'
    ShaderProgram:'X3DElement'
    Shape:'X3DElement'
    SignalPdu:'X3DElement'
    Sound:'X3DElement'
    Sphere:'X3DElement'
    SphereSensor:'X3DElement'
    SpotLight:'X3DElement'
    StaticGroup:'X3DElement'
    StringSensor:'X3DElement'
    Switch:'X3DElement'
    Text:'X3DElement'
    TextureBackground:'X3DElement'
    TextureCoordinate:'X3DElement'
    TextureCoordinate3D:'X3DElement'
    TextureCoordinate4D:'X3DElement'
    TextureCoordinateGenerator:'X3DElement'
    TextureTransform:'X3DElement'
    TextureTransform3D:'X3DElement'
    TextureTransformMatrix3D:'X3DElement'
    TimeSensor:'X3DElement'
    TimeTrigger:'X3DElement'
    TouchSensor:'X3DElement'
    Transform:'X3DElement'
    TransmitterPdu:'X3DElement'
    TriangleFanSet:'X3DElement'
    TriangleSet:'X3DElement'
    TriangleSet2D:'X3DElement'
    TriangleStripSet:'X3DElement'
    USE:'X3DAttribute'
    Viewpoint:'X3DElement'
    VisibilitySensor:'X3DElement'
    WorldInfo:'X3DElement'
    X3D:'X3DElement'
    _class:'X3DAttribute'
    accessType:'X3DAttribute'
    actionKeyPress:'X3DAttribute'
    actionKeyRelease:'X3DAttribute'
    address:'X3DAttribute'
    alpha:'X3DAttribute'
    altKey:'X3DAttribute'
    ambientIntensity:'X3DAttribute'
    antennaLocation:'X3DAttribute'
    antennaPatternLength:'X3DAttribute'
    antennaPatternType:'X3DAttribute'
    applicationID:'X3DAttribute'
    articulationParameterArray:'X3DAttribute'
    articulationParameterChangeIndicatorArray:'X3DAttribute'
    articulationParameterCount:'X3DAttribute'
    articulationParameterDesignatorArray:'X3DAttribute'
    articulationParameterIdPartAttachedArray:'X3DAttribute'
    articulationParameterTypeArray:'X3DAttribute'
    attenuation:'X3DAttribute'
    autoOffset:'X3DAttribute'
    avatarSize:'X3DAttribute'
    axisOfRotation:'X3DAttribute'
    backUrl:'X3DAttribute'
    bboxCenter:'X3DAttribute'
    bboxSize:'X3DAttribute'
    beamWidth:'X3DAttribute'
    beginCap:'X3DAttribute'
    bindTime:'X3DAttribute'
    bottom:'X3DAttribute'
    bottomRadius:'X3DAttribute'
    bottomUrl:'X3DAttribute'
    ccw:'X3DAttribute'
    center:'X3DAttribute'
    centerOfMass:'X3DAttribute'
    centerOfRotation:'X3DAttribute'
    child1Url:'X3DAttribute'
    child2Url:'X3DAttribute'
    child3Url:'X3DAttribute'
    child4Url:'X3DAttribute'
    closureType:'X3DAttribute'
    collideTime:'X3DAttribute'
    color:'X3DAttribute'
    colorIndex:'X3DAttribute'
    colorPerVertex:'X3DAttribute'
    component:'X3DElement'
    connect:'X3DElement'
    containerField:'X3DAttribute'
    content:'X3DAttribute'
    controlKey:'X3DAttribute'
    controlPoint:'X3DAttribute'
    convex:'X3DAttribute'
    coordIndex:'X3DAttribute'
    coordinateSystem:'X3DAttribute'
    copyright:'X3DAttribute'
    creaseAngle:'X3DAttribute'
    crossSection:'X3DAttribute'
    cryptoKeyID:'X3DAttribute'
    cryptoSystem:'X3DAttribute'
    cutOffAngle:'X3DAttribute'
    cycleInterval:'X3DAttribute'
    cycleTime:'X3DAttribute'
    data:'X3DAttribute'
    dataFormat:'X3DAttribute'
    dataLength:'X3DAttribute'
    dataUrl:'X3DAttribute'
    date:'X3DAttribute'
    deadReckoning:'X3DAttribute'
    deletionAllowed:'X3DAttribute'
    description:'X3DAttribute'
    detonateTime:'X3DAttribute'
    diffuseColor:'X3DAttribute'
    dir:'X3DAttribute'
    directOutput:'X3DAttribute'
    direction:'X3DAttribute'
    diskAngle:'X3DAttribute'
    displacements:'X3DAttribute'
    documentation:'X3DAttribute'
    elapsedTime:'X3DAttribute'
    ellipsoid:'X3DAttribute'
    emissiveColor:'X3DAttribute'
    enabled:'X3DAttribute'
    encodingScheme:'X3DAttribute'
    endAngle:'X3DAttribute'
    endCap:'X3DAttribute'
    enterTime:'X3DAttribute'
    enteredText:'X3DAttribute'
    entityCategory:'X3DAttribute'
    entityCountry:'X3DAttribute'
    entityDomain:'X3DAttribute'
    entityExtra:'X3DAttribute'
    entityID:'X3DAttribute'
    entityKind:'X3DAttribute'
    entitySpecific:'X3DAttribute'
    entitySubCategory:'X3DAttribute'
    exitTime:'X3DAttribute'
    extent:'X3DAttribute'
    family:'X3DAttribute'
    fanCount:'X3DAttribute'
    field:'X3DElement'
    fieldOfView:'X3DAttribute'
    fieldValue:'X3DElement'
    filled:'X3DAttribute'
    finalText:'X3DAttribute'
    fireMissionIndex:'X3DAttribute'
    fired1:'X3DAttribute'
    fired2:'X3DAttribute'
    firedTime:'X3DAttribute'
    firingRange:'X3DAttribute'
    firingRate:'X3DAttribute'
    fogType:'X3DAttribute'
    forceID:'X3DAttribute'
    frequency:'X3DAttribute'
    fromField:'X3DAttribute'
    fromNode:'X3DAttribute'
    frontUrl:'X3DAttribute'
    function:'X3DAttribute'
    fuse:'X3DAttribute'
    geoCoords:'X3DAttribute'
    geoGridOrigin:'X3DAttribute'
    geoSystem:'X3DAttribute'
    groundAngle:'X3DAttribute'
    groundColor:'X3DAttribute'
    hatchColor:'X3DAttribute'
    hatchStyle:'X3DAttribute'
    hatched:'X3DAttribute'
    head:'X3DElement'
    headlight:'X3DAttribute'
    height:'X3DAttribute'
    horizontal:'X3DAttribute'
    horizontalDatum:'X3DAttribute'
    http_equiv:'X3DAttribute'
    humanoidBodyType:'X3DElement'
    image:'X3DAttribute'
    importedDEF:'X3DAttribute'
    index:'X3DAttribute'
    info:'X3DAttribute'
    innerRadius:'X3DAttribute'
    inputFalse:'X3DAttribute'
    inputNegate:'X3DAttribute'
    inputSource:'X3DAttribute'
    inputTrue:'X3DAttribute'
    integerKey:'X3DAttribute'
    intensity:'X3DAttribute'
    jump:'X3DAttribute'
    justify:'X3DAttribute'
    key:'X3DAttribute'
    keyPress:'X3DAttribute'
    keyRelease:'X3DAttribute'
    keyValue:'X3DAttribute'
    knot:'X3DAttribute'
    lang:'X3DAttribute'
    language:'X3DAttribute'
    leftToRight:'X3DAttribute'
    leftUrl:'X3DAttribute'
    length:'X3DAttribute'
    lengthOfModulationParameters:'X3DAttribute'
    level:'X3DAttribute'
    limitOrientation:'X3DAttribute'
    lineSegments:'X3DAttribute'
    linearAcceleration:'X3DAttribute'
    linearVelocity:'X3DAttribute'
    linetype:'X3DAttribute'
    linewidthScaleFactor:'X3DAttribute'
    llimit:'X3DAttribute'
    load:'X3DAttribute'
    loadTime:'X3DAttribute'
    localDEF:'X3DAttribute'
    location:'X3DAttribute'
    loop:'X3DAttribute'
    marking:'X3DAttribute'
    mass:'X3DAttribute'
    maxAngle:'X3DAttribute'
    maxBack:'X3DAttribute'
    maxExtent:'X3DAttribute'
    maxFront:'X3DAttribute'
    maxPosition:'X3DAttribute'
    meta:'X3DElement'
    metadataFormat:'X3DAttribute'
    minAngle:'X3DAttribute'
    minBack:'X3DAttribute'
    minFront:'X3DAttribute'
    minPosition:'X3DAttribute'
    mode:'X3DAttribute'
    modulationTypeDetail:'X3DAttribute'
    modulationTypeMajor:'X3DAttribute'
    modulationTypeSpreadSpectrum:'X3DAttribute'
    modulationTypeSystem:'X3DAttribute'
    momentsOfInertia:'X3DAttribute'
    multicastRelayHost:'X3DAttribute'
    multicastRelayPort:'X3DAttribute'
    munitionApplicationID:'X3DAttribute'
    munitionEndPoint:'X3DAttribute'
    munitionEntityID:'X3DAttribute'
    munitionQuantity:'X3DAttribute'
    munitionSiteID:'X3DAttribute'
    munitionStartPoint:'X3DAttribute'
    mustEvaluate:'X3DAttribute'
    name:'X3DAttribute'
    navType:'X3DAttribute'
    networkMode:'X3DAttribute'
    next:'X3DAttribute'
    nodeField:'X3DAttribute'
    normalIndex:'X3DAttribute'
    normalPerVertex:'X3DAttribute'
    offset:'X3DAttribute'
    on:'X3DAttribute'
    order:'X3DAttribute'
    orientation:'X3DAttribute'
    originator:'X3DAttribute'
    outerRadius:'X3DAttribute'
    parameter:'X3DAttribute'
    pauseTime:'X3DAttribute'
    pitch:'X3DAttribute'
    point:'X3DAttribute'
    points:'X3DAttribute'
    port:'X3DAttribute'
    position:'X3DAttribute'
    power:'X3DAttribute'
    previous:'X3DAttribute'
    priority:'X3DAttribute'
    profile:'X3DAttribute'
    progress:'X3DAttribute'
    protoField:'X3DAttribute'
    radioEntityTypeCategory:'X3DAttribute'
    radioEntityTypeCountry:'X3DAttribute'
    radioEntityTypeDomain:'X3DAttribute'
    radioEntityTypeKind:'X3DAttribute'
    radioEntityTypeNomenclature:'X3DAttribute'
    radioEntityTypeNomenclatureVersion:'X3DAttribute'
    radioID:'X3DAttribute'
    radius:'X3DAttribute'
    range:'X3DAttribute'
    readInterval:'X3DAttribute'
    receivedPower:'X3DAttribute'
    receiverState:'X3DAttribute'
    reference:'X3DAttribute'
    relativeAntennaLocation:'X3DAttribute'
    repeatS:'X3DAttribute'
    repeatT:'X3DAttribute'
    resolution:'X3DAttribute'
    resumeTime:'X3DAttribute'
    rightUrl:'X3DAttribute'
    rootUrl:'X3DAttribute'
    rotateYUp:'X3DAttribute'
    rotation:'X3DAttribute'
    rtpHeaderExpected:'X3DAttribute'
    sampleRate:'X3DAttribute'
    samples:'X3DAttribute'
    scale:'X3DAttribute'
    scaleOrientation:'X3DAttribute'
    shiftKey:'X3DAttribute'
    shininess:'X3DAttribute'
    side:'X3DAttribute'
    siteID:'X3DAttribute'
    size:'X3DAttribute'
    skinCoordIndex:'X3DAttribute'
    skinCoordWeight:'X3DAttribute'
    skyAngle:'X3DAttribute'
    skyColor:'X3DAttribute'
    solid:'X3DAttribute'
    source:'X3DAttribute'
    spacing:'X3DAttribute'
    spatialize:'X3DAttribute'
    specularColor:'X3DAttribute'
    speed:'X3DAttribute'
    speedFactor:'X3DAttribute'
    spine:'X3DAttribute'
    startAngle:'X3DAttribute'
    startTime:'X3DAttribute'
    stiffness:'X3DAttribute'
    stopTime:'X3DAttribute'
    string:'X3DAttribute'
    stripCount:'X3DAttribute'
    style:'X3DAttribute'
    summary:'X3DAttribute'
    tdlType:'X3DAttribute'
    tessellation:'X3DAttribute'
    tessellationScale:'X3DAttribute'
    texCoordIndex:'X3DAttribute'
    time:'X3DAttribute'
    timeOut:'X3DAttribute'
    timestamp:'X3DAttribute'
    title:'X3DAttribute'
    toField:'X3DAttribute'
    toNode:'X3DAttribute'
    toggle:'X3DAttribute'
    top:'X3DAttribute'
    topToBottom:'X3DAttribute'
    topUrl:'X3DAttribute'
    touchTime:'X3DAttribute'
    translation:'X3DAttribute'
    transmitFrequencyBandwidth:'X3DAttribute'
    transmitState:'X3DAttribute'
    transmitterApplicationID:'X3DAttribute'
    transmitterEntityID:'X3DAttribute'
    transmitterRadioID:'X3DAttribute'
    transmitterSiteID:'X3DAttribute'
    transparency:'X3DAttribute'
    transparent:'X3DAttribute'
    triggerTime:'X3DAttribute'
    triggerTrue:'X3DAttribute'
    triggerValue:'X3DAttribute'
    type:'X3DAttribute'
    uDimension:'X3DAttribute'
    uKnot:'X3DAttribute'
    uOrder:'X3DAttribute'
    uTessellation:'X3DAttribute'
    ulimit:'X3DAttribute'
    url:'X3DAttribute'
    vDimension:'X3DAttribute'
    vKnot:'X3DAttribute'
    vOrder:'X3DAttribute'
    vTessellation:'X3DAttribute'
    value:'X3DAttribute'
    vector:'X3DAttribute'
    version:'X3DAttribute'
    vertexCount:'X3DAttribute'
    verticalDatum:'X3DAttribute'
    vertices:'X3DAttribute'
    visibilityLimit:'X3DAttribute'
    visibilityRange:'X3DAttribute'
    warhead:'X3DAttribute'
    weight:'X3DAttribute'
    whichChoice:'X3DAttribute'
    whichGeometry:'X3DAttribute'
    writeInterval:'X3DAttribute'
    xDimension:'X3DAttribute'
    xSpacing:'X3DAttribute'
    yScale:'X3DAttribute'
    zDimension:'X3DAttribute'
    zSpacing:'X3DAttribute'

class vtkExporter(vtkmodules.vtkCommonCore.vtkObject):
    def GetActiveRenderer(self) -> 'vtkRenderer': ...
    def GetInput(self) -> 'vtkRenderWindow': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderWindow(self) -> 'vtkRenderWindow': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExporter': ...
    def SetActiveRenderer(self, __a:'vtkRenderer') -> None: ...
    def SetEndWrite(self, f:Callback) -> None: ...
    def SetInput(self, renWin:'vtkRenderWindow') -> None: ...
    def SetRenderWindow(self, __a:'vtkRenderWindow') -> None: ...
    def SetStartWrite(self, f:Callback) -> None: ...
    def Update(self) -> None: ...
    def Write(self) -> None: ...

class vtkGLTFExporter(vtkExporter):
    def GetFileName(self) -> str: ...
    def GetInlineData(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSaveBatchId(self) -> bool: ...
    def GetSaveNormal(self) -> bool: ...
    def InlineDataOff(self) -> None: ...
    def InlineDataOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGLTFExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGLTFExporter': ...
    def SaveBatchIdOff(self) -> None: ...
    def SaveBatchIdOn(self) -> None: ...
    def SaveNormalOff(self) -> None: ...
    def SaveNormalOn(self) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetInlineData(self, _arg:bool) -> None: ...
    def SetSaveBatchId(self, _arg:bool) -> None: ...
    def SetSaveNormal(self, _arg:bool) -> None: ...
    def WriteToString(self) -> str: ...

class vtkIVExporter(vtkExporter):
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIVExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIVExporter': ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkJSONDataSetWriter(vtkmodules.vtkIOCore.vtkWriter):
    @staticmethod
    def ComputeMD5(content:Sequence[int], size:int, hash:str) -> None: ...
    def GetArchiver(self) -> 'vtkArchiver': ...
    @overload
    def GetInput(self) -> 'vtkDataSet': ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataSet': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetShortType(input:'vtkDataArray', needConversion:bool) -> str: ...
    @staticmethod
    def GetUID(__a:'vtkDataArray', needConversion:bool) -> str: ...
    def GetValidString(self, __a:str) -> str: ...
    def IsA(self, type:str) -> int: ...
    def IsDataSetValid(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkJSONDataSetWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkJSONDataSetWriter': ...
    def SetArchiver(self, __a:'vtkArchiver') -> None: ...
    @overload
    def Write(self, __a:'vtkDataSet') -> None: ...
    @overload
    def Write(self) -> int: ...
    @staticmethod
    def WriteArrayAsRAW(__a:'vtkDataArray', filePath:str) -> bool: ...
    def WriteArrayContents(self, __a:'vtkDataArray', relativeFilePath:str) -> bool: ...

class vtkJSONRenderWindowExporter(vtkExporter):
    def CompactOutputOff(self) -> None: ...
    def CompactOutputOn(self) -> None: ...
    def GetArchiver(self) -> 'vtkArchiver': ...
    def GetCompactOutput(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSerializer(self) -> 'vtkVtkJSSceneGraphSerializer': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkJSONRenderWindowExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkJSONRenderWindowExporter': ...
    def SetArchiver(self, __a:'vtkArchiver') -> None: ...
    def SetCompactOutput(self, _arg:bool) -> None: ...
    def SetSerializer(self, __a:'vtkVtkJSSceneGraphSerializer') -> None: ...
    def WriteData(self) -> None: ...

class vtkJSONSceneExporter(vtkExporter):
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyLODsBaseSize(self) -> int: ...
    def GetPolyLODsBaseUrl(self) -> str: ...
    def GetTextureLODsBaseSize(self) -> int: ...
    def GetTextureLODsBaseUrl(self) -> str: ...
    def GetWritePolyLODs(self) -> bool: ...
    def GetWriteTextureLODs(self) -> bool: ...
    def GetWriteTextures(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkJSONSceneExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkJSONSceneExporter': ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetPolyLODsBaseSize(self, _arg:int) -> None: ...
    def SetPolyLODsBaseUrl(self, _arg:str) -> None: ...
    def SetTextureLODsBaseSize(self, _arg:int) -> None: ...
    def SetTextureLODsBaseUrl(self, _arg:str) -> None: ...
    def SetWritePolyLODs(self, _arg:bool) -> None: ...
    def SetWriteTextureLODs(self, _arg:bool) -> None: ...
    def SetWriteTextures(self, _arg:bool) -> None: ...

class vtkOBJExporter(vtkExporter):
    def GetFilePrefix(self) -> str: ...
    def GetMTLFileComment(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOBJFileComment(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOBJExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOBJExporter': ...
    def SetFilePrefix(self, _arg:str) -> None: ...
    def SetMTLFileComment(self, _arg:str) -> None: ...
    def SetOBJFileComment(self, _arg:str) -> None: ...

class vtkOOGLExporter(vtkExporter):
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOOGLExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOOGLExporter': ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkPOVExporter(vtkExporter):
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPOVExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPOVExporter': ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkRIBExporter(vtkExporter):
    def BackgroundOff(self) -> None: ...
    def BackgroundOn(self) -> None: ...
    def ExportArraysOff(self) -> None: ...
    def ExportArraysOn(self) -> None: ...
    def GetBackground(self) -> int: ...
    def GetExportArrays(self) -> int: ...
    def GetExportArraysMaxValue(self) -> int: ...
    def GetExportArraysMinValue(self) -> int: ...
    def GetFilePrefix(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPixelSamples(self) -> Tuple[int, int]: ...
    def GetSize(self) -> Tuple[int, int]: ...
    def GetTexturePrefix(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRIBExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRIBExporter': ...
    def SetBackground(self, _arg:int) -> None: ...
    def SetExportArrays(self, _arg:int) -> None: ...
    def SetFilePrefix(self, _arg:str) -> None: ...
    @overload
    def SetPixelSamples(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetPixelSamples(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetSize(self, _arg:Sequence[int]) -> None: ...
    def SetTexturePrefix(self, _arg:str) -> None: ...

class vtkRIBLight(vtkmodules.vtkRenderingCore.vtkLight):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShadows(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRIBLight': ...
    def Render(self, ren:'vtkRenderer', index:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRIBLight': ...
    def SetShadows(self, _arg:int) -> None: ...
    def ShadowsOff(self) -> None: ...
    def ShadowsOn(self) -> None: ...

class vtkRIBProperty(vtkmodules.vtkRenderingCore.vtkProperty):
    def AddDisplacementShaderParameter(self, parameter:str, value:str) -> None: ...
    def AddParameter(self, parameter:str, value:str) -> None: ...
    def AddSurfaceShaderParameter(self, parameter:str, value:str) -> None: ...
    def AddVariable(self, variable:str, declaration:str) -> None: ...
    def GetDeclarations(self) -> str: ...
    def GetDisplacementShader(self) -> str: ...
    def GetDisplacementShaderParameters(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParameters(self) -> str: ...
    def GetSurfaceShader(self) -> str: ...
    def GetSurfaceShaderParameters(self) -> str: ...
    def GetSurfaceShaderUsesDefaultParameters(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRIBProperty': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRIBProperty': ...
    def SetDisplacementShader(self, _arg:str) -> None: ...
    def SetDisplacementShaderParameter(self, parameter:str, value:str) -> None: ...
    def SetParameter(self, parameter:str, value:str) -> None: ...
    def SetSurfaceShader(self, _arg:str) -> None: ...
    def SetSurfaceShaderParameter(self, parameter:str, value:str) -> None: ...
    def SetSurfaceShaderUsesDefaultParameters(self, _arg:bool) -> None: ...
    def SetVariable(self, variable:str, declaration:str) -> None: ...
    def SurfaceShaderUsesDefaultParametersOff(self) -> None: ...
    def SurfaceShaderUsesDefaultParametersOn(self) -> None: ...

class vtkSVGContextDevice2D(vtkmodules.vtkRenderingContext2D.vtkContextDevice2D):
    def Begin(self, __a:'vtkViewport') -> None: ...
    def ComputeJustifiedStringBounds(self, string:str, bounds:MutableSequence[float]) -> None: ...
    def ComputeStringBounds(self, string:str, bounds:MutableSequence[float]) -> None: ...
    def DrawColoredPolygon(self, points:MutableSequence[float], numPoints:int, colors:MutableSequence[int]=..., nc_comps:int=0) -> None: ...
    def DrawEllipseWedge(self, x:float, y:float, outRx:float, outRy:float, inRx:float, inRy:float, startAngle:float, stopAngle:float) -> None: ...
    def DrawEllipticArc(self, x:float, y:float, rX:float, rY:float, startAngle:float, stopAngle:float) -> None: ...
    @overload
    def DrawImage(self, p:MutableSequence[float], scale:float, image:'vtkImageData') -> None: ...
    @overload
    def DrawImage(self, pos:'vtkRectf', image:'vtkImageData') -> None: ...
    def DrawLines(self, f:MutableSequence[float], n:int, colors:MutableSequence[int]=..., nc_comps:int=0) -> None: ...
    def DrawMarkers(self, shape:int, highlight:bool, points:MutableSequence[float], n:int, colors:MutableSequence[int]=..., nc_comps:int=0) -> None: ...
    def DrawMathTextString(self, point:MutableSequence[float], str:str) -> None: ...
    def DrawPointSprites(self, sprite:'vtkImageData', points:MutableSequence[float], n:int, colors:MutableSequence[int]=..., nc_comps:int=0) -> None: ...
    def DrawPoints(self, points:MutableSequence[float], n:int, colors:MutableSequence[int]=..., nc_comps:int=0) -> None: ...
    def DrawPoly(self, points:MutableSequence[float], n:int, colors:MutableSequence[int]=..., nc_comps:int=0) -> None: ...
    def DrawPolygon(self, __a:MutableSequence[float], __b:int) -> None: ...
    def DrawQuad(self, __a:MutableSequence[float], __b:int) -> None: ...
    def DrawQuadStrip(self, __a:MutableSequence[float], __b:int) -> None: ...
    def DrawString(self, point:MutableSequence[float], string:str) -> None: ...
    def EmbedFontsOff(self) -> None: ...
    def EmbedFontsOn(self) -> None: ...
    def EnableClipping(self, enable:bool) -> None: ...
    def End(self) -> None: ...
    def GenerateDefinitions(self) -> None: ...
    def GetEmbedFonts(self) -> bool: ...
    def GetMatrix(self, m:'vtkMatrix3x3') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSubdivisionThreshold(self) -> float: ...
    def GetTextAsPath(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MultiplyMatrix(self, m:'vtkMatrix3x3') -> None: ...
    def NewInstance(self) -> 'vtkSVGContextDevice2D': ...
    def PopMatrix(self) -> None: ...
    def PushMatrix(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSVGContextDevice2D': ...
    def SetClipping(self, x:MutableSequence[int]) -> None: ...
    def SetColor4(self, color:MutableSequence[int]) -> None: ...
    def SetEmbedFonts(self, _arg:bool) -> None: ...
    def SetLineType(self, type:int) -> None: ...
    def SetLineWidth(self, width:float) -> None: ...
    def SetMatrix(self, m:'vtkMatrix3x3') -> None: ...
    def SetPointSize(self, size:float) -> None: ...
    def SetSVGContext(self, context:'vtkXMLDataElement', defs:'vtkXMLDataElement') -> None: ...
    def SetSubdivisionThreshold(self, _arg:float) -> None: ...
    def SetTextAsPath(self, _arg:bool) -> None: ...
    def SetTexture(self, image:'vtkImageData', properties:int) -> None: ...
    def TextAsPathOff(self) -> None: ...
    def TextAsPathOn(self) -> None: ...

class vtkSVGExporter(vtkExporter):
    def DrawBackgroundOff(self) -> None: ...
    def DrawBackgroundOn(self) -> None: ...
    def GetDescription(self) -> str: ...
    def GetDrawBackground(self) -> bool: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSubdivisionThreshold(self) -> float: ...
    def GetTextAsPath(self) -> bool: ...
    def GetTitle(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSVGExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSVGExporter': ...
    def SetDescription(self, _arg:str) -> None: ...
    def SetDrawBackground(self, _arg:bool) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetSubdivisionThreshold(self, _arg:float) -> None: ...
    def SetTextAsPath(self, _arg:bool) -> None: ...
    def SetTitle(self, _arg:str) -> None: ...
    def TextAsPathOff(self) -> None: ...
    def TextAsPathOn(self) -> None: ...

class vtkSingleVTPExporter(vtkExporter):
    def GetFilePrefix(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSingleVTPExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSingleVTPExporter': ...
    def SetFileName(self, __a:str) -> None: ...
    def SetFilePrefix(self, _arg:str) -> None: ...

class vtkVRMLExporter(vtkExporter):
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSpeed(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRMLExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRMLExporter': ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetSpeed(self, _arg:float) -> None: ...

class vtkX3DExporter(vtkExporter):
    def BinaryOff(self) -> None: ...
    def BinaryOn(self) -> None: ...
    def FastestOff(self) -> None: ...
    def FastestOn(self) -> None: ...
    def GetBinary(self) -> int: ...
    def GetBinaryMaxValue(self) -> int: ...
    def GetBinaryMinValue(self) -> int: ...
    def GetBinaryOutputString(self) -> Pointer: ...
    def GetFastest(self) -> int: ...
    def GetFastestMaxValue(self) -> int: ...
    def GetFastestMinValue(self) -> int: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputString(self) -> str: ...
    def GetOutputStringLength(self) -> int: ...
    def GetSpeed(self) -> float: ...
    def GetWriteToOutputString(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkX3DExporter': ...
    def RegisterAndGetOutputString(self) -> str: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkX3DExporter': ...
    def SetBinary(self, _arg:int) -> None: ...
    def SetFastest(self, _arg:int) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetSpeed(self, _arg:float) -> None: ...
    def SetWriteToOutputString(self, _arg:int) -> None: ...
    def WriteToOutputStringOff(self) -> None: ...
    def WriteToOutputStringOn(self) -> None: ...

class vtkX3DExporterWriter(vtkmodules.vtkCommonCore.vtkObject):
    def CloseFile(self) -> None: ...
    def EndDocument(self) -> None: ...
    def EndNode(self) -> None: ...
    def Flush(self) -> None: ...
    def GetBinaryOutputString(self) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputString(self) -> str: ...
    def GetOutputStringLength(self) -> int: ...
    def GetWriteToOutputString(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkX3DExporterWriter': ...
    def OpenFile(self, file:str) -> int: ...
    def OpenStream(self) -> int: ...
    def RegisterAndGetOutputString(self) -> str: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkX3DExporterWriter': ...
    @overload
    def SetField(self, attributeID:int, value:str, mfstring:bool=False) -> None: ...
    @overload
    def SetField(self, attributeID:int, __b:int) -> None: ...
    @overload
    def SetField(self, attributeID:int, __b:float) -> None: ...
    @overload
    def SetField(self, attributeID:int, __b:bool) -> None: ...
    @overload
    def SetField(self, attributeID:int, type:int, a:Sequence[float]) -> None: ...
    @overload
    def SetField(self, attributeID:int, type:int, a:'vtkDataArray') -> None: ...
    @overload
    def SetField(self, attributeID:int, values:Sequence[float], size:int) -> None: ...
    @overload
    def SetField(self, attributeID:int, values:Sequence[int], size:int, image:bool=False) -> None: ...
    def SetWriteToOutputString(self, _arg:int) -> None: ...
    def StartDocument(self) -> None: ...
    def StartNode(self, nodeID:int) -> None: ...
    def WriteToOutputStringOff(self) -> None: ...
    def WriteToOutputStringOn(self) -> None: ...

class vtkX3DExporterFIWriter(vtkX3DExporterWriter):
    def CloseFile(self) -> None: ...
    def EndDocument(self) -> None: ...
    def EndNode(self) -> None: ...
    def FastestOff(self) -> None: ...
    def FastestOn(self) -> None: ...
    def Flush(self) -> None: ...
    def GetFastest(self) -> int: ...
    def GetFastestMaxValue(self) -> int: ...
    def GetFastestMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkX3DExporterFIWriter': ...
    def OpenFile(self, file:str) -> int: ...
    def OpenStream(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkX3DExporterFIWriter': ...
    def SetFastest(self, _arg:int) -> None: ...
    @overload
    def SetField(self, attributeID:int, __b:str, mfstring:bool=False) -> None: ...
    @overload
    def SetField(self, attributeID:int, __b:int) -> None: ...
    @overload
    def SetField(self, attributeID:int, __b:float) -> None: ...
    @overload
    def SetField(self, attributeID:int, __b:bool) -> None: ...
    @overload
    def SetField(self, attributeID:int, type:int, a:Sequence[float]) -> None: ...
    @overload
    def SetField(self, attributeID:int, type:int, a:'vtkDataArray') -> None: ...
    @overload
    def SetField(self, attributeID:int, values:Sequence[float], size:int) -> None: ...
    @overload
    def SetField(self, attributeID:int, type:int, a:'vtkCellArray') -> None: ...
    @overload
    def SetField(self, attributeID:int, values:Sequence[int], size:int, image:bool=False) -> None: ...
    def StartDocument(self) -> None: ...
    def StartNode(self, elementID:int) -> None: ...

class vtkX3DExporterXMLWriter(vtkX3DExporterWriter):
    def CloseFile(self) -> None: ...
    def EndDocument(self) -> None: ...
    def EndNode(self) -> None: ...
    def Flush(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkX3DExporterXMLWriter': ...
    def OpenFile(self, file:str) -> int: ...
    def OpenStream(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkX3DExporterXMLWriter': ...
    @overload
    def SetField(self, attributeID:int, __b:str, mfstring:bool=True) -> None: ...
    @overload
    def SetField(self, attributeID:int, __b:int) -> None: ...
    @overload
    def SetField(self, attributeID:int, __b:float) -> None: ...
    @overload
    def SetField(self, attributeID:int, __b:bool) -> None: ...
    @overload
    def SetField(self, attributeID:int, type:int, a:Sequence[float]) -> None: ...
    @overload
    def SetField(self, attributeID:int, type:int, a:'vtkDataArray') -> None: ...
    @overload
    def SetField(self, attributeID:int, values:Sequence[float], size:int) -> None: ...
    @overload
    def SetField(self, attributeID:int, values:Sequence[int], size:int, image:bool=False) -> None: ...
    def StartDocument(self) -> None: ...
    def StartNode(self, elementID:int) -> None: ...

