from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkRenderingCore

class vtkLODActor(vtkmodules.vtkRenderingCore.vtkActor):
    def AddLODMapper(self, mapper:'vtkMapper') -> None: ...
    def GetLODMappers(self) -> 'vtkMapperCollection': ...
    def GetLowResFilter(self) -> 'vtkPolyDataAlgorithm': ...
    def GetMediumResFilter(self) -> 'vtkPolyDataAlgorithm': ...
    def GetNumberOfCloudPoints(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Modified(self) -> None: ...
    def NewInstance(self) -> 'vtkLODActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, __a:'vtkRenderer', __b:'vtkMapper') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLODActor': ...
    def SetLowResFilter(self, __a:'vtkPolyDataAlgorithm') -> None: ...
    def SetMediumResFilter(self, __a:'vtkPolyDataAlgorithm') -> None: ...
    def SetNumberOfCloudPoints(self, _arg:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkQuadricLODActor(vtkmodules.vtkRenderingCore.vtkActor):
    class PropTypeEnum(int): ...
    class DataConfigurationEnum(int): ...
    ACTOR:'PropTypeEnum'
    FOLLOWER:'PropTypeEnum'
    UNKNOWN:'DataConfigurationEnum'
    XLINE:'DataConfigurationEnum'
    XYPLANE:'DataConfigurationEnum'
    XYZVOLUME:'DataConfigurationEnum'
    XZPLANE:'DataConfigurationEnum'
    YLINE:'DataConfigurationEnum'
    YZPLANE:'DataConfigurationEnum'
    ZLINE:'DataConfigurationEnum'
    def DeferLODConstructionOff(self) -> None: ...
    def DeferLODConstructionOn(self) -> None: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetCollapseDimensionRatio(self) -> float: ...
    def GetCollapseDimensionRatioMaxValue(self) -> float: ...
    def GetCollapseDimensionRatioMinValue(self) -> float: ...
    def GetDataConfiguration(self) -> int: ...
    def GetDataConfigurationMaxValue(self) -> int: ...
    def GetDataConfigurationMinValue(self) -> int: ...
    def GetDeferLODConstruction(self) -> int: ...
    def GetLODFilter(self) -> 'vtkQuadricClustering': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPropType(self) -> int: ...
    def GetPropTypeMaxValue(self) -> int: ...
    def GetPropTypeMinValue(self) -> int: ...
    def GetStatic(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadricLODActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, __a:'vtkRenderer', __b:'vtkMapper') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadricLODActor': ...
    def SetCamera(self, __a:'vtkCamera') -> None: ...
    def SetCollapseDimensionRatio(self, _arg:float) -> None: ...
    def SetDataConfiguration(self, _arg:int) -> None: ...
    def SetDataConfigurationToUnknown(self) -> None: ...
    def SetDataConfigurationToXLine(self) -> None: ...
    def SetDataConfigurationToXYPlane(self) -> None: ...
    def SetDataConfigurationToXYZVolume(self) -> None: ...
    def SetDataConfigurationToXZPlane(self) -> None: ...
    def SetDataConfigurationToYLine(self) -> None: ...
    def SetDataConfigurationToYZPlane(self) -> None: ...
    def SetDataConfigurationToZLine(self) -> None: ...
    def SetDeferLODConstruction(self, _arg:int) -> None: ...
    def SetLODFilter(self, lodFilter:'vtkQuadricClustering') -> None: ...
    def SetPropType(self, _arg:int) -> None: ...
    def SetPropTypeToActor(self) -> None: ...
    def SetPropTypeToFollower(self) -> None: ...
    def SetStatic(self, _arg:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def StaticOff(self) -> None: ...
    def StaticOn(self) -> None: ...

