# 🌐 Blue-GEO (`@geo`)

🌐 AI for a Blue Planet.

```bash
pip install blue-geo
```

|   |   |   |
| --- | --- | --- |
| 🧊[`copernicus`](https://github.com/kamangir/blue-geo/tree/main/blue_geo/catalog/copernicus) [![image](https://github.com/kamangir/assets/blob/main/blue-geo/copernicus.jpg?raw=true)](https://github.com/kamangir/blue-geo/tree/main/blue_geo/catalog/copernicus) catalog: [Copernicus Data Space Ecosystem - Europe's eyes on Earth](https://dataspace.copernicus.eu/) | 🌐[`SkyFox`](https://github.com/kamangir/blue-geo/tree/main/blue_geo/catalog/SkyFox) [![image](https://earthdaily.github.io/EDA-Documentation/Images/EarthDailyEDS.png)](https://github.com/kamangir/blue-geo/tree/main/blue_geo/catalog/SkyFox) catalog: [Earth Data Store](https://earthdaily.github.io/EDA-Documentation/). | 🌐[`EarthSearch`](https://github.com/kamangir/blue-geo/blob/main/blue_geo/catalog/EarthSearch) [![image](https://github.com/kamangir/assets/blob/main/blue-geo/viewer-aws-element84-com.png?raw=true)](https://github.com/kamangir/blue-geo/blob/main/blue_geo/catalog/EarthSearch) catalog: [Earth Search by Element 84 (earth-search-aws)](https://stacindex.org/catalogs/earth-search#/). |
| 🌐[`firms-area`](https://github.com/kamangir/blue-geo/tree/main/blue_geo/catalog/firms) [![image](https://raw.githubusercontent.com/kamangir/assets/main/blue-geo/datacube-firms_area.jpg)](https://github.com/kamangir/blue-geo/tree/main/blue_geo/catalog/firms) catalog: Fire Information for Resource Management System ([FIRMS](https://firms.modaps.eosdis.nasa.gov)). | 🇺🇦[`ukraine-timemap`](https://github.com/kamangir/blue-geo/blob/main/blue_geo/catalog/ukraine_timemap) [![image](https://github.com/kamangir/assets/blob/main/nbs/ukraine-timemap/QGIS.png?raw=true)](https://github.com/kamangir/blue-geo/blob/main/blue_geo/catalog/ukraine_timemap) catalog: [Bellingcat](https://www.bellingcat.com/) [Civilian Harm in Ukraine TimeMap](https://github.com/bellingcat/ukraine-timemap) dataset, available through [this UI](https://ukraine.bellingcat.com/) and [this API](https://bellingcat-embeds.ams3.cdn.digitaloceanspaces.com/production/ukr/timemap/api.json). | 🌈[`vancouver-watching`](https://github.com/kamangir/Vancouver-Watching) [![image](https://kamangir-public.s3.ca-central-1.amazonaws.com/2024-01-06-20-39-46-73614/2024-01-06-20-39-46-73614-2X.gif?raw=true)](https://github.com/kamangir/Vancouver-Watching) catalog: Vancouver watching with AI, last build: [🔗](https://kamangir-public.s3.ca-central-1.amazonaws.com/test_vancouver_watching_ingest/animation.gif). |
| 🌐[`geo-watch`](https://github.com/kamangir/blue-geo/blob/main/blue_geo/watch) [![image](https://kamangir-public.s3.ca-central-1.amazonaws.com/geo-watch-2024-09-06-Jasper-a/geo-watch-2024-09-06-Jasper-a-2X.gif)](https://github.com/kamangir/blue-geo/blob/main/blue_geo/watch) watch the planet's story unfold. | 🌐[`catalog`](https://github.com/kamangir/blue-geo/tree/main/blue_geo/catalog) [![image](https://github.com/kamangir/assets/raw/main/blue-plugin/marquee.png?raw=true)](https://github.com/kamangir/blue-geo/tree/main/blue_geo/catalog) generalized STAC Catalogs. | 🧊[`datacube`](https://github.com/kamangir/blue-geo/tree/main/blue_geo/datacube) [![image](https://github.com/kamangir/assets/raw/main/blue-plugin/marquee.png?raw=true)](https://github.com/kamangir/blue-geo/tree/main/blue_geo/datacube) generalized STAC Items. |
| 🌐[`QGIS`](https://github.com/kamangir/blue-geo/blob/main/blue_geo/QGIS/README.md) [![image](https://raw.githubusercontent.com/kamangir/assets/main/blue-geo/QGIS.jpg)](https://github.com/kamangir/blue-geo/blob/main/blue_geo/QGIS/README.md) an AI terraform for [QGIS](https://www.qgis.org/). |  |  |

---

📜 [metadata](./metadata.yaml)

🎁 [wish list and bugs](https://github.com/kamangir/blue-geo/issues/8)

to use on [AWS SageMaker](https://aws.amazon.com/sagemaker/) replace `<plugin-name>` with "blue_geo" and follow [these instructions](https://github.com/kamangir/notebooks-and-scripts/blob/main/SageMaker.md).

[![pylint](https://github.com/kamangir/blue-geo/actions/workflows/pylint.yml/badge.svg)](https://github.com/kamangir/blue-geo/actions/workflows/pylint.yml) [![pytest](https://github.com/kamangir/blue-geo/actions/workflows/pytest.yml/badge.svg)](https://github.com/kamangir/blue-geo/actions/workflows/pytest.yml) [![bashtest](https://github.com/kamangir/blue-geo/actions/workflows/bashtest.yml/badge.svg)](https://github.com/kamangir/blue-geo/actions/workflows/bashtest.yml) [![PyPI version](https://img.shields.io/pypi/v/blue-geo.svg)](https://pypi.org/project/blue-geo/)

built by 🌀 [`blue_options-4.85.1-abcli-current`](https://github.com/kamangir/awesome-bash-cli), based on 🌐 [`blue_geo-4.586.1`](https://github.com/kamangir/blue-geo).
