import datetime
from rupython import __Общие_функции__

Часовой_пояс = datetime.timezone
Временная_метка = datetime.datetime

Формат_даты = '%Д.%М.%Г'
Формат_времени = '%ч:%м:%с'
Формат_даты_и_времени = '%Д.%М.%Г %ч:%м:%с'

Словарь_спецификаторов = {
    '%Г': '%Y',  # год (4 цифры, например 1945)
    '%М': '%m',  # месяц (2 цифры, 01–12)
    '%Д': '%d',  # день (2 цифры, 01–31)
    '%ч': '%H',  # часы (2 цифры, 00–23)
    '%м': '%M',  # минуты (2 цифры, 00–59)
    '%с': '%S',  # секунды (2 цифры, 00–59)
    '%д': '%f'   # дробная часть секунды (в микросекундах) (6 цифр, 000000–999999)
}

Словарь_параметров = {
    'год': 'year', 'месяц': 'month', 'день': 'day',
    'часов': 'hour', 'минут': 'minute', 'секунд': 'second',
    'микросекунд': 'microsecond', 'часовой_пояс': 'tzinfo',
    'добавка_летнего_времени': 'fold'
}

Словарь_параметров_интервала = {
    'дней': 'days', 'секунд': 'seconds',
    'микросекунд': 'microseconds', 'миллисекунд': 'milliseconds',
    'минут': 'minutes', 'часов': 'hours', 'недель': 'weeks'
}

Месяцы_родительный = {
    1: 'января', 2: 'февраля', 3: 'марта', 4: 'апреля',
    5: 'мая', 6: 'июня', 7: 'июля', 8: 'августа',
    9: 'сентября', 10: 'октября', 11: 'ноября', 12: 'декабря'
}

Дни_недели_полные = {
    1: 'понедельник', 2: 'вторник', 3: 'среда', 4: 'четверг',
    5: 'пятница', 6: 'суббота', 7: 'воскресенье'
}

Дни_недели_краткие = {
    1: 'Пн', 2: 'Вт', 3: 'Ср', 4: 'Чт',
    5: 'Пт', 6: 'Сб', 7: 'Вс'
}

def Склонение_после_числительного(число, слова):
	return str(число) + ' ' + \
        (слова[2] if число % 100 >= 5 and число % 100 <= 20 else \
            (слова[0] if число % 10 == 1 else \
                (слова[1] if число % 10 >= 2 and число % 10 <= 4 else слова[2])))

def Перевести_формат(формат):
    for русский, питоновский in Словарь_спецификаторов.items():
        формат = формат.replace(русский, питоновский)
    return формат

class Дата_и_время:
    def __init__(экземпляр, *ПА, **ИА):
        if len(ПА) > 0 and type(ПА[0]) == datetime.datetime: экземпляр._дата_время = ПА[0]
        else:
            ИА = __Общие_функции__.Заменить_ключи_в_словаре(
                ИА, Словарь_параметров
            )
            экземпляр._дата_время = datetime.datetime(*ПА, **ИА)

    @staticmethod
    def Сейчас(часовой_пояс = None):
        return Дата_и_время(datetime.datetime.now(часовой_пояс))

    @staticmethod
    def Из_метки_времени(метка_времени, часовой_пояс = None):
        return Дата_и_время(datetime.datetime.fromtimestamp(метка_времени, часовой_пояс))

    @staticmethod
    def Из_строки(строка):
        return Дата_и_время.Разобрать(строка, Формат_даты_и_времени)

    @staticmethod
    def Разобрать(строка, формат):
        формат = Перевести_формат(формат)
        return Дата_и_время(datetime.datetime.strptime(строка, формат))

    def В_формат(экземпляр, формат):
        формат = Перевести_формат(формат)
        return экземпляр._дата_время.strftime(формат)

    def __str__(экземпляр):
        формат = Перевести_формат(Формат_даты_и_времени)
        return экземпляр._дата_время.strftime(формат)

    def Словами(экземпляр, формат = 'полный'):
        день_недели = экземпляр.Номер_дня_недели()
        if формат == 'полный':
            return f"{Дни_недели_полные[день_недели]}, {экземпляр.День} {Месяцы_родительный[экземпляр.Месяц]} {экземпляр.Год} года, {экземпляр.Часов:02d}:{экземпляр.Минут:02d}"
        elif формат == 'краткий':
            return f"{Дни_недели_краткие[день_недели]}, {экземпляр.День} {Месяцы_родительный[экземпляр.Месяц]} {экземпляр.Год} г."
        elif формат == 'дата':
            return f"{экземпляр.День} {Месяцы_родительный[экземпляр.Месяц]} {экземпляр.Год} года"
        elif формат == 'время':
            return f"{экземпляр.Часов:02d}:{экземпляр.Минут:02d}"
        elif формат == 'день_недели':
            return Дни_недели_полные[день_недели]
        else:
            raise ValueError("Неподдерживаемый формат")

    def В_метку_времени(экземпляр):
        return экземпляр._дата_время.timestamp()

    def День_недели(экземпляр):
        return экземпляр._дата_время.weekday()

    def Номер_дня_недели(экземпляр):
        return экземпляр._дата_время.isoweekday()

    def Добавить(экземпляр, интервал):
        return Дата_и_время(экземпляр._дата_время + интервал._интервал)

    def Вычесть(экземпляр, интервал):
        return Дата_и_время(экземпляр._дата_время - интервал._интервал)

    def __add__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр.Добавить(другой)
        return NotImplemented

    def __radd__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр.Добавить(другой)
        return NotImplemented

    def __sub__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр.Вычесть(другой)
        return NotImplemented

    def __eq__(экземпляр, другой):
        if isinstance(другой, Дата_и_время):
            return экземпляр._дата_время == другой._дата_время
        return NotImplemented

    def __lt__(экземпляр, другой):
        if isinstance(другой, Дата_и_время):
            return экземпляр._дата_время < другой._дата_время
        return NotImplemented

    def __le__(экземпляр, другой):
        if isinstance(другой, Дата_и_время):
            return экземпляр._дата_время <= другой._дата_время
        return NotImplemented

    def __gt__(экземпляр, другой):
        if isinstance(другой, Дата_и_время):
            return экземпляр._дата_время > другой._дата_время
        return NotImplemented

    def __ge__(экземпляр, другой):
        if isinstance(другой, Дата_и_время):
            return экземпляр._дата_время >= другой._дата_время
        return NotImplemented

    def __format__(экземпляр, формат):
        return экземпляр.В_формат(формат)

    @property
    def Год(экземпляр):
        return экземпляр._дата_время.year

    @property
    def Месяц(экземпляр):
        return экземпляр._дата_время.month

    @property
    def День(экземпляр):
        return экземпляр._дата_время.day

    @property
    def Часов(экземпляр):
        return экземпляр._дата_время.hour

    @property
    def Минут(экземпляр):
        return экземпляр._дата_время.minute

    @property
    def Секунд(экземпляр):
        return экземпляр._дата_время.second

    @property
    def Микросекунд(экземпляр):
        return экземпляр._дата_время.microsecond

    @property
    def Часовой_пояс(экземпляр):
        return экземпляр._дата_время.tzinfo

class Дата:
    def __init__(экземпляр, *ПА, **ИА):
        if len(ПА) > 0 and type(ПА[0]) == datetime.date: экземпляр._дата = ПА[0]
        else:
            ИА = __Общие_функции__.Заменить_ключи_в_словаре(
                ИА, Словарь_параметров
            )
            экземпляр._дата = datetime.date(*ПА, **ИА)

    @staticmethod
    def Сегодня():
        return Дата(datetime.date.today())

    @staticmethod
    def От_даты(порядковый_номер):
        return Дата(datetime.date.fromordinal(порядковый_номер))

    def В_формат(экземпляр, формат):
        формат = Перевести_формат(формат)
        return экземпляр._дата.strftime(формат)

    def __str__(экземпляр):
        формат = Перевести_формат(Формат_даты)
        return экземпляр._дата.strftime(формат)

    def Из_строки(строка):
        return Дата(Дата_и_время.Разобрать(строка, Формат_времени)._дата_время.time())

    def День_недели(экземпляр):
        return экземпляр._дата.isoweekday()

    def Добавить(экземпляр, интервал):
        return Дата(экземпляр._дата + интервал._интервал)

    def Вычесть(экземпляр, интервал):
        return Дата(экземпляр._дата - интервал._интервал)

    def __add__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр.Добавить(другой)
        return NotImplemented

    def __radd__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр.Добавить(другой)
        return NotImplemented

    def __sub__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр.Вычесть(другой)
        return NotImplemented

    def __eq__(экземпляр, другой):
        if isinstance(другой, Дата):
            return экземпляр._дата == другой._дата
        return NotImplemented

    def __lt__(экземпляр, другой):
        if isinstance(другой, Дата):
            return экземпляр._дата < другой._дата
        return NotImplemented

    def __le__(экземпляр, другой):
        if isinstance(другой, Дата):
            return экземпляр._дата <= другой._дата
        return NotImplemented

    def __gt__(экземпляр, другой):
        if isinstance(другой, Дата):
            return экземпляр._дата > другой._дата
        return NotImplemented

    def __ge__(экземпляр, другой):
        if isinstance(другой, Дата):
            return экземпляр._дата >= другой._дата
        return NotImplemented

    def __format__(экземпляр, формат):
        return экземпляр.В_формат(формат)

    @property
    def год(экземпляр): return экземпляр._дата.year

    @property
    def месяц(экземпляр): return экземпляр._дата.month

    @property
    def день(экземпляр): return экземпляр._дата.day

class Время:
    def __init__(экземпляр, *ПА, **ИА):
        ИА = __Общие_функции__.Заменить_ключи_в_словаре(
            ИА, Словарь_параметров
        )
        экземпляр._время = datetime.time(*ПА, **ИА)

    @staticmethod
        def Сейчас(часовой_пояс=None):
            return Время(datetime.datetime.now(часовой_пояс).time())

    def В_формат(экземпляр, формат):
        формат = Перевести_формат(формат)
        return экземпляр._время.strftime(формат)

    def __str__(экземпляр):
        формат = Перевести_формат(Формат_времени)
        return экземпляр._время.strftime(формат)

    def Заменить(экземпляр, **ИА):
        ИА = __Общие_функции__.Заменить_ключи_в_словаре(
            ИА, Словарь_параметров
        )
        return Время(экземпляр._время.replace(**ИА))

    def Добавить(экземпляр, интервал):
        базовая_дата = datetime.datetime(1970, 1, 1, экземпляр._время.hour, экземпляр._время.minute, экземпляр._время.second, экземпляр._время.microsecond, экземпляр._время.tzinfo)
        результат = базовая_дата + интервал._интервал
        return Время(результат.hour, результат.minute, результат.second, результат.microsecond, экземпляр._время.tzinfo)

    def Вычесть(экземпляр, интервал):
        базовая_дата = datetime.datetime(1970, 1, 1, экземпляр._время.hour, экземпляр._время.minute, экземпляр._время.second, экземпляр._время.microsecond, экземпляр._время.tzinfo)
        результат = базовая_дата - интервал._интервал
        return Время(результат.hour, результат.minute, результат.second, результат.microsecond, экземпляр._время.tzinfo)

    def __add__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр.Добавить(другой)
        return NotImplemented

    def __radd__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр.Добавить(другой)
        return NotImplemented

    def __sub__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр.Вычесть(другой)
        return NotImplemented

    def __eq__(экземпляр, другой):
        if isinstance(другой, Время):
            return экземпляр._время == другой._время
        return NotImplemented

    def __lt__(экземпляр, другой):
        if isinstance(другой, Время):
            return экземпляр._время < другой._время
        return NotImplemented

    def __le__(экземпляр, другой):
        if isinstance(другой, Время):
            return экземпляр._время <= другой._время
        return NotImplemented

    def __gt__(экземпляр, другой):
        if isinstance(другой, Время):
            return экземпляр._время > другой._время
        return NotImplemented

    def __ge__(экземпляр, другой):
        if isinstance(другой, Время):
            return экземпляр._время >= другой._время
        return NotImplemented

    def __format__(экземпляр, формат):
        return экземпляр.В_формат(формат)

    @property
    def Часов(экземпляр):
        return экземпляр._время.hour

    @property
    def Минут(экземпляр):
        return экземпляр._время.minute

    @property
    def Секунд(экземпляр):
        return экземпляр._время.second

    @property
    def Микросекунд(экземпляр):
        return экземпляр._время.microsecond

    @property
    def Часовой_пояс(экземпляр):
        return экземпляр._время.tzinfo

class Интервал:
    def __init__(экземпляр, *ПА, **ИА):
        if len(ПА) > 0 and type(ПА[0]) == datetime.timedelta: экземпляр._интервал = ПА[0]
        else:
            ИА = __Общие_функции__.Заменить_ключи_в_словаре(
                ИА, Словарь_параметров_интервала
            )
            экземпляр._интервал = datetime.timedelta(*ПА, **ИА)

    def Добавить(экземпляр, другой):
        return Интервал(дней=(экземпляр._интервал + другой._интервал).days, секунд=(экземпляр._интервал + другой._интервал).seconds, микросекунд=(экземпляр._интервал + другой._интервал).microseconds)

    def Вычесть(экземпляр, другой):
        return Интервал(дней=(экземпляр._интервал - другой._интервал).days, секунд=(экземпляр._интервал - другой._интервал).seconds, микросекунд=(экземпляр._интервал - другой._интервал).microseconds)

    def __str__(экземпляр):
        части = []
        if экземпляр.Дней:
            части.append(Склонение_после_числительного(экземпляр.Дней, ['день', 'дня', 'дней']))
        секунд = экземпляр.Секунд
        if секунд >= 3600:
            часов = секунд // 3600
            части.append(Склонение_после_числительного(часов, ['час', 'часа', 'часов']))
            секунд %= 3600
        if секунд >= 60:
            минут = секунд // 60
            части.append(Склонение_после_числительного(минут, ['минута', 'минуты', 'минут']))
            секунд %= 60
        if секунд:
            части.append(Склонение_после_числительного(секунд, ['секунда', 'секунды', 'секунд']))
        return ' '.join(части) or '0 секунд'

    @staticmethod
    def Из_строки(строка):
        части = строка.split()
        ИА = {}
        i = 0
        while i < len(части):
            число = int(части[i])
            единица = части[i + 1]
            if 'день' in единица or 'дня' in единица or 'дней' in единица:
                ИА['дней'] = число
            elif 'час' in единица:
                ИА['часов'] = число
            elif 'минут' in единица:
                ИА['минут'] = число
            elif 'секунд' in единица:
                ИА['секунд'] = число
            i += 2
        return Интервал(**ИА)

    def __add__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр.Добавить(другой)
        return NotImplemented

    def __sub__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр.Вычесть(другой)
        return NotImplemented

    def __eq__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр._интервал == другой._интервал
        return NotImplemented

    def __lt__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр._интервал < другой._интервал
        return NotImplemented

    def __le__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр._интервал <= другой._интервал
        return NotImplemented

    def __gt__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр._интервал > другой._интервал
        return NotImplemented

    def __ge__(экземпляр, другой):
        if isinstance(другой, Интервал):
            return экземпляр._интервал >= другой._интервал
        return NotImplemented

    @property
    def Дней(экземпляр):
        return экземпляр._интервал.days

    @property
    def Секунд(экземпляр):
        return экземпляр._интервал.seconds

    @property
    def Микросекунд(экземпляр):
        return экземпляр._интервал.microseconds

    @property
    def Всего_секунд(экземпляр):
        return экземпляр._интервал.total_seconds()

def Совместить(дата, время):
    return Дата_время(datetime.datetime.combine(дата._дата, время._время))

class ДатаСтСт:
    def __init__(экземпляр, *ПА):
        if len(ПА) == 3:
            экземпляр.год, экземпляр.месяц, экземпляр.день = ПА
            экземпляр._Посчитать_дни()
        else:
            if isinstance(ПА[0], ДатаСтСт):
                экземпляр.в_днях = ПА[0].в_днях
            else:
                экземпляр.в_днях = ПА[0]
            экземпляр._Посчитать_дату()

    def _Посчитать_день_недели_и_года(экземпляр):
        экземпляр.день_недели = (экземпляр.в_днях - 1) % 7
        if экземпляр.день_недели == 0: экземпляр.день_недели = 7
        экземпляр.день_года = (
            (275 * экземпляр.месяц // 9)
            - (((экземпляр.месяц + 9) // 12) * (1 + ((экземпляр.год - 4 * (экземпляр.год // 4) + 2) // 3)))
            + экземпляр.день
            - 31
        )

    def _Посчитать_дни(экземпляр):
        экземпляр.в_днях = (
            367 * экземпляр.год
            - int((7 * (экземпляр.год + 5001 + int((экземпляр.месяц - 9) / 7))) / 4)
            + int((275 * экземпляр.месяц) / 9)
            + экземпляр.день
            + 8353
        )
        экземпляр._Посчитать_день_недели_и_года()

    def _Посчитать_дату(экземпляр):
        a = экземпляр.в_днях + 1890
        b = int((a - 122.1) / 365.25)
        c = int(365.25 * b)
        d = int((a - c) / 30.6001)
        экземпляр.день = a - c - int(30.6001 * d)
        экземпляр.месяц = d - (13 if d > 13 else 1)
        экземпляр.год = b - (3 if экземпляр.месяц < 3 else 4)
        экземпляр._Посчитать_день_недели_и_года()

    def Добавить_дни(экземпляр, количество):
        экземпляр.в_днях += количество
        экземпляр._Посчитать_дату()
        return экземпляр

    def Разница_в_днях(экземпляр, другая_дата):
        return экземпляр.в_днях - другая_дата.в_днях

    def Сравнить(экземпляр, другая_дата):
        if экземпляр.в_днях < другая_дата.в_днях: return -1
        elif экземпляр.в_днях > другая_дата.в_днях: return 1
        else: return 0

    def В_новый_стиль(экземпляр):
        разница = экземпляр.год // 100 - экземпляр.год // 400 - 2
        год_увеличения_разницы = экземпляр.год % 100 == 0 and экземпляр.год % 400 != 0
        if год_увеличения_разницы:
            if экземпляр.день_года < 60: разница -= 1
        if экземпляр.день_года == 59 and год_увеличения_разницы:
            дата = Дата(экземпляр.год, 3, 1) + Интервал(дней = разница)
        else:
            дата = Дата(экземпляр.год, экземпляр.месяц, экземпляр.день)
            дата += Интервал(дней = разница)
        return дата

def Пасха(год, нов_ст = None):
    смещение = (год % 19 * 19 + 15) % 30
    смещение += (год % 4 * 2 + год % 7 * 4 + 6 * смещение + 6) % 7
    нов_ст = True if нов_ст is None and год >= 1918 else нов_ст
    дата = ДатаСтСт(год, 3, 22)
    дата.Добавить_дни(смещение)
    if нов_ст: return дата.В_новый_стиль()
    else: return дата
