import requests

Словарь_параметров_запроса = {
    'параметры': 'params',
    'данные': 'data',
    'данные_json': 'json',
    'заголовки': 'headers',
    'куки': 'cookies',
    'аутентификация': 'auth',
    'таймаут': 'timeout',
    'разрешить_перенаправления': 'allow_redirects',
    'проверить_шифрование': 'verify',
    'поток': 'stream',
    'прокси': 'proxies',
    'кодование_ответа': 'encoding',
    'задержка_соединения': 'connect',
    'задержка_чтения': 'read'
}

Успешно = 200
Создано = 201
Принято = 202
Нет_содержимого = 204
Множественный_выбор = 300
Перенаправление = 301
Найдено = 302
Не_изменено = 304
Неверный_запрос = 400
Не_авторизован = 401
Запрещено = 403
Не_найдено = 404
Метод_не_разрешен = 405
Конфликт = 409
Ошибка_сервера = 500
Не_реализовано = 501
Служба_недоступна = 503

class Ответ:
    def __init__(экземпляр, исходный_ответ: requests.Response):
        экземпляр._ответ = исходный_ответ

    @property
    def код_статуса(экземпляр): return экземпляр._ответ.status_code

    @property
    def текст(экземпляр): return экземпляр._ответ.text

    @property
    def json(экземпляр):
        try: return экземпляр._ответ.json()
        except requests.exceptions.JSONDecodeError: return None

    @property
    def заголовки(экземпляр): return экземпляр._ответ.headers

    @property
    def байты(экземпляр): return экземпляр._ответ.content

    @property
    def успешно(экземпляр): return экземпляр._ответ.ok

    @property
    def кодование(экземпляр): return экземпляр._ответ.encoding

    @кодование.setter
    def кодование(экземпляр, новое_кодование):
        экземпляр._ответ.encoding = новое_кодование

    def Выдать_ошибку(экземпляр): экземпляр._ответ.raise_for_status()

    def __str__(экземпляр):
        return f"Ответ (статус: {экземпляр.код_статуса}, ссылка: {экземпляр._ответ.ссылка})"

    def __repr__(экземпляр):
        return f"<Ответ - статус: {экземпляр.код_статуса}, ссылка: {экземпляр._ответ.ссылка}>"

class Запросы:
    def __init__(экземпляр):
        экземпляр._сессия = requests.Session()

    def _Перевести_параметры(экземпляр, **ИА):
        новые_ИА = {}
        for ключ, значение in ИА.items():
            if isinstance(ключ, tuple) and ключ[0] == 'таймаут':
                connect_timeout = ИА.get(('таймаут', 'задержка_соединения'), None)
                read_timeout = ИА.get(('таймаут', 'задержка_чтения'), None)
                if connect_timeout is not None or read_timeout is not None:
                    новые_ИА['timeout'] = (connect_timeout, read_timeout)
            else:
                if ключ in Словарь_параметров_запроса:
                    новые_ИА[Словарь_параметров_запроса[ключ]] = значение
                else:
                    новые_ИА[ключ] = значение
        return новые_ИА

    def Получить(экземпляр, ссылка, **ИА):
        переведенные_параметры = экземпляр._Перевести_параметры(**ИА)
        ответ = экземпляр._сессия.get(ссылка, **переведенные_параметры)
        return Ответ_HTTP(ответ)

    def Отправить(экземпляр, ссылка, **ИА):
        переведенные_параметры = экземпляр._Перевести_параметры(**ИА)
        ответ = экземпляр._сессия.post(ссылка, **переведенные_параметры)
        return Ответ_HTTP(ответ)

    def Положить(экземпляр, ссылка, **ИА):
        переведенные_параметры = экземпляр._Перевести_параметры(**ИА)
        ответ = экземпляр._сессия.put(ссылка, **переведенные_параметры)
        return Ответ_HTTP(ответ)

    def Удалить(экземпляр, ссылка, **ИА):
        переведенные_параметры = экземпляр._Перевести_параметры(**ИА)
        ответ = экземпляр._сессия.delete(ссылка, **переведенные_параметры)
        return Ответ_HTTP(ответ)

    def Заголовки(экземпляр, ссылка, **ИА):
        переведенные_параметры = экземпляр._Перевести_параметры(**ИА)
        ответ = экземпляр._сессия.head(ссылка, **переведенные_параметры)
        return Ответ_HTTP(ответ)

    def Опции(экземпляр, ссылка, **ИА):
        переведенные_параметры = экземпляр._Перевести_параметры(**ИА)
        ответ = экземпляр._сессия.options(ссылка, **переведенные_параметры)
        return Ответ_HTTP(ответ)

    def Изменить(экземпляр, ссылка, **ИА):
        переведенные_параметры = экземпляр._Перевести_параметры(**ИА)
        ответ = экземпляр._сессия.patch(ссылка, **переведенные_параметры)
        return Ответ_HTTP(ответ)

    def Закрыть_сессию(экземпляр):
        экземпляр._сессия.close()

Запросы_по_умолчанию = Запросы()
def Получить(ссылка, **ИА): return Запросы_по_умолчанию.Получить(ссылка, **ИА)
def Отправить(ссылка, **ИА): return Запросы_по_умолчанию.Отправить(ссылка, **ИА)
def Положить(ссылка, **ИА): return Запросы_по_умолчанию.Положить(ссылка, **ИА)
def Удалить(ссылка, **ИА): return Запросы_по_умолчанию.Удалить(ссылка, **ИА)
def Заголовки(ссылка, **ИА): return Запросы_по_умолчанию.Заголовки(ссылка, **ИА)
def Опции(ссылка, **ИА): return Запросы_по_умолчанию.Опции(ссылка, **ИА)
def Изменить(ссылка, **ИА): return Запросы_по_умолчанию.Изменить(ссылка, **ИА)
