import queue
from rupython import __Общие_функции__

Очередь_пуста = queue.Empty
Очередь_полна = queue.Full

Словарь_параметров = {
    'максимальный_размер': 'maxsize',
    'элемент': 'item',
    'блоковать': 'block',
    'таймаут': 'timeout',
    'приоритет': 'priority'
}

Словарь_склонений = {
    'элемент': ['элемент', 'элемента', 'элементов'],
    'задача': ['задача', 'задачи', 'задач']
}

class Очередь:
    def __init__(экземпляр, максимальный_размер = 0):
        kwargs = {'maxsize': максимальный_размер}
        экземпляр._queue = queue.Queue(**kwargs)

    def Добавить(экземпляр, элемент, блоковать = True, таймаут = None):
        kwargs = {'item': элемент, 'block': блоковать}
        if таймаут is not None:
            kwargs['timeout'] = таймаут
        экземпляр._queue.put(**kwargs)

    def Добавить_без_блокования(экземпляр, элемент):
        экземпляр._queue.put_nowait(элемент)

    def Получить(экземпляр, блоковать = True, таймаут = None):
        kwargs = {'block': блоковать}
        if таймаут is not None:
            kwargs['timeout'] = таймаут
        return экземпляр._queue.get(**kwargs)

    def Получить_без_блокования(экземпляр):
        return экземпляр._queue.get_nowait()

    def Задача_выполнена(экземпляр):
        экземпляр._queue.task_done()

    def Ждать_завершения(экземпляр):
        экземпляр._queue.join()

    def Пустая(экземпляр):
        return экземпляр._queue.empty()

    def Полная(экземпляр):
        return экземпляр._queue.full()

    def Размер(экземпляр):
        return экземпляр._queue.qsize()

    def __len__(экземпляр):
        return экземпляр._queue.qsize()

    def __str__(экземпляр):
        размер = экземпляр.Размер()
        return f"Очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['элемент'])}"

    def В_строку_с_задачами(экземпляр):
        размер = экземпляр.Размер()
        return f"Очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['задача'])}"

class Стековая_очередь:
    def __init__(экземпляр, максимальный_размер = 0):
        kwargs = {'maxsize': максимальный_размер}
        экземпляр._queue = queue.LifoQueue(**kwargs)

    def Добавить(экземпляр, элемент, блоковать = True, таймаут = None):
        kwargs = {'item': элемент, 'block': блоковать}
        if таймаут is not None:
            kwargs['timeout'] = таймаут
        экземпляр._queue.put(**kwargs)

    def Добавить_без_блокования(экземпляр, элемент):
        экземпляр._queue.put_nowait(элемент)

    def Получить(экземпляр, блоковать = True, таймаут = None):
        kwargs = {'block': блоковать}
        if таймаут is not None:
            kwargs['timeout'] = таймаут
        return экземпляр._queue.get(**kwargs)

    def Получить_без_блокования(экземпляр):
        return экземпляр._queue.get_nowait()

    def Задача_выполнена(экземпляр):
        экземпляр._queue.task_done()

    def Ждать_завершения(экземпляр):
        экземпляр._queue.join()

    def Пустая(экземпляр):
        return экземпляр._queue.empty()

    def Полная(экземпляр):
        return экземпляр._queue.full()

    def Размер(экземпляр):
        return экземпляр._queue.qsize()

    def __len__(экземпляр):
        return экземпляр._queue.qsize()

    def __str__(экземпляр):
        размер = экземпляр.Размер()
        return f"Стековая_очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['элемент'])}"

    def В_строку_с_задачами(экземпляр):
        размер = экземпляр.Размер()
        return f"Стековая_очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['задача'])}"

class Приоритетная_очередь:
    def __init__(экземпляр, максимальный_размер = 0):
        kwargs = {'maxsize': максимальный_размер}
        экземпляр._queue = queue.PriorityQueue(**kwargs)

    def Добавить(экземпляр, элемент, приоритет, блоковать = True, таймаут = None):
        kwargs = {'item': (приоритет, элемент), 'block': блоковать}
        if таймаут is not None:
            kwargs['timeout'] = таймаут
        экземпляр._queue.put(**kwargs)

    def Добавить_без_блокования(экземпляр, элемент, приоритет):
        экземпляр._queue.put_nowait((приоритет, элемент))

    def Получить(экземпляр, блоковать = True, таймаут = None):
        kwargs = {'block': блоковать}
        if таймаут is not None:
            kwargs['timeout'] = таймаут
        приоритет, элемент = экземпляр._queue.get(**kwargs)
        return элемент

    def Получить_с_приоритетом(экземпляр, блоковать = True, таймаут = None):
        kwargs = {'block': блоковать}
        if таймаут is not None:
            kwargs['timeout'] = таймаут
        return экземпляр._queue.get(**kwargs)

    def Получить_без_блокования(экземпляр):
        приоритет, элемент = экземпляр._queue.get_nowait()
        return элемент

    def Получить_без_блокования_с_приоритетом(экземпляр):
        """Возвращает кортеж (приоритет, элемент)."""
        return экземпляр._queue.get_nowait()

    def Задача_выполнена(экземпляр):
        экземпляр._queue.task_done()

    def Ждать_завершения(экземпляр):
        экземпляр._queue.join()

    def Пустая(экземпляр):
        return экземпляр._queue.empty()

    def Полная(экземпляр):
        return экземпляр._queue.full()

    def Размер(экземпляр):
        return экземпляр._queue.qsize()

    def __len__(экземпляр):
        return экземпляр._queue.qsize()

    def __str__(экземпляр):
        размер = экземпляр.Размер()
        return f"Приоритетная_очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['элемент'])}"

    def В_строку_с_задачами(экземпляр):
        размер = экземпляр.Размер()
        return f"Приоритетная_очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['задача'])}"
