import threading
from rupython import __Общие_функции__

Ошибка_потока = threading.ThreadError

Словарь_параметров = {
    'цель': 'target',
    'имя': 'name',
    'аргументы': 'args',
    'именовАргументы': 'kwargs',
    'после_окончания': 'daemon',
    'время_ожидания': 'timeout',
    'количество': 'count',
    'действие': 'action',
    'блоковать': 'block',
    'обратный_вызов': 'callback',
    'аргументыОбрВыз': 'callback_args',
    'именовАргументыОбрВыз': 'callback_kwargs',
    'интервал': 'interval'
}

Словарь_склонений = {
    'поток': ['поток', 'потока', 'потоков'],
    'ресурс': ['ресурс', 'ресурса', 'ресурсов'],
    'участник': ['участник', 'участника', 'участников']
}

class Поток:
    def __init__(экземпляр, цель = None, имя = None, аргументы = (), именовАргументы = None, после_окончания = None):
        ИА = {}
        if цель is not None:
            ИА['target'] = цель
        if имя is not None:
            ИА['name'] = имя
        if аргументы:
            ИА['args'] = аргументы
        if именовАргументы is not None:
            ИА['kwargs'] = именовАргументы
        if после_окончания is not None:
            ИА['daemon'] = после_окончания
        экземпляр._thread = threading.Thread(**ИА)

    def Начать(экземпляр):
        экземпляр._thread.start()

    def Ждать(экземпляр, время_ожидания = None):
        ИА = {}
        if время_ожидания is not None:
            ИА['timeout'] = время_ожидания
        экземпляр._thread.join(**kwargs)

    def Живой(экземпляр):
        return экземпляр._thread.is_alive()

    def Получить_имя(экземпляр):
        return экземпляр._thread.getName()

    def Установить_имя(экземпляр, имя):
        экземпляр._thread.setName(имя)

    def Получить_идентификатор(экземпляр):
        return экземпляр._thread.ident

    def После_окончания(экземпляр):
        return экземпляр._thread.daemon

    def Установить_после_окончания(экземпляр, после_окончания):
        экземпляр._thread.daemon = после_окончания

    def __str__(экземпляр):
        return f"Поток(имя={экземпляр.Получить_имя()}, живой={экземпляр.Живой()})"

class Блокование:
    def __init__(экземпляр):
        экземпляр._lock = threading.Lock()

    def Захватить(экземпляр, блоковать = True, время_ожидания = None):
        ИА = {'block': блоковать}
        if время_ожидания is not None:
            ИА['timeout'] = время_ожидания
        return экземпляр._lock.acquire(**ИА)

    def Освободить(экземпляр):
        экземпляр._lock.release()

    def Захвачено(экземпляр):
        return экземпляр._lock.locked()

    def __enter__(экземпляр):
        экземпляр.Захватить()
        return экземпляр

    def __exit__(экземпляр, тип_исключения, значение_исключения, трассировка):
        экземпляр.Освободить()

    def __str__(экземпляр):
        return f"Блокование(захвачено={экземпляр.Захвачено()})"

class Повторное_блокование:
    def __init__(экземпляр):
        экземпляр._rlock = threading.RLock()

    def Захватить(экземпляр, блоковать = True, время_ожидания = None):
        ИА = {'block': блоковать}
        if время_ожидания is not None:
            ИА['timeout'] = время_ожидания
        return экземпляр._rlock.acquire(**ИА)

    def Освободить(экземпляр):
        экземпляр._rlock.release()

    def __enter__(экземпляр):
        экземпляр.Захватить()
        return экземпляр

    def __exit__(экземпляр, тип_исключения, значение_исключения, трассировка):
        экземпляр.Освободить()

    def __str__(экземпляр):
        return f"Повторное_блокование(владелец={экземпляр._rlock._owner}, счётчик={экземпляр._rlock._count})"

class Семафор:
    def __init__(экземпляр, количество = 1):
        ИА = {'value': количество}
        экземпляр._semaphore = threading.Semaphore(**ИА)

    def Захватить(экземпляр, блоковать = True, время_ожидания = None):
        ИА = {'block': блоковать}
        if время_ожидания is not None:
            ИА['timeout'] = время_ожидания
        return экземпляр._semaphore.acquire(**ИА)

    def Освободить(экземпляр):
        экземпляр._semaphore.release()

    def __enter__(экземпляр):
        экземпляр.Захватить()
        return экземпляр

    def __exit__(экземпляр, тип_исключения, значение_исключения, трассировка):
        экземпляр.Освободить()

    def __str__(экземпляр):
        return f"Семафор(ресурсов={экземпляр._semaphore._value})"

class Ограниченный_семафор(Семафор):
    def __init__(экземпляр, количество = 1):
        ИА = {'value': количество}
        экземпляр._semaphore = threading.BoundedSemaphore(**ИА)

class Событие:
    def __init__(экземпляр):
        экземпляр._event = threading.Event()

    def Установить(экземпляр):
        экземпляр._event.set()

    def Сбросить(экземпляр):
        экземпляр._event.clear()

    def Активно(экземпляр):
        return экземпляр._event.is_set()

    def Ждать(экземпляр, время_ожидания = None):
        ИА = {}
        if время_ожидания is not None:
            ИА['timeout'] = время_ожидания
        return экземпляр._event.wait(**ИА)

    def __str__(экземпляр):
        return f"Событие(активно={экземпляр.Активно()})"

class Условие:
    def __init__(экземпляр, блокование = None):
        ИА = {}
        if блокование is not None:
            ИА['lock'] = блокование._lock if isinstance(блокование, (Блокование, Повторное_блокование)) else блокование
        экземпляр._condition = threading.Condition(**ИА)

    def Захватить(экземпляр):
        return экземпляр._condition.acquire()

    def Освободить(экземпляр):
        экземпляр._condition.release()

    def Ждать(экземпляр, время_ожидания = None):
        ИА = {}
        if время_ожидания is not None:
            ИА['timeout'] = время_ожидания
        return экземпляр._condition.wait(**ИА)

    def Уведомить(экземпляр, количество = 1):
        ИА = {'n': количество}
        экземпляр._condition.notify(**ИА)

    def Уведомить_все(экземпляр):
        экземпляр._condition.notify_all()

    def __enter__(экземпляр):
        экземпляр.Захватить()
        return экземпляр

    def __exit__(экземпляр, тип_исключения, значение_исключения, трассировка):
        экземпляр.Освободить()

    def __str__(экземпляр):
        return f"Условие(захвачено={экземпляр._condition._is_owned()})"

class Барьер:
    def __init__(экземпляр, количество, действие = None, время_ожидания = None):
        ИА = {'parties': количество}
        if действие is not None:
            ИА['action'] = действие
        if время_ожидания is not None:
            ИА['timeout'] = время_ожидания
        экземпляр._barrier = threading.Barrier(**ИА)

    def Ждать(экземпляр, время_ожидания = None):
        ИА = {}
        if время_ожидания is not None:
            ИА['timeout'] = время_ожидания
        return экземпляр._barrier.wait(**ИА)

    def Сбросить(экземпляр):
        экземпляр._barrier.reset()

    def Прервать(экземпляр):
        экземпляр._barrier.abort()

    def Количество_участников(экземпляр):
        return экземпляр._barrier.parties

    def Количество_ожидающих(экземпляр):
        return экземпляр._barrier.n_waiting

    def Сломан(экземпляр):
        return экземпляр._barrier.broken

    def __str__(экземпляр):
        return f"Барьер({__Общие_функции__.Склонение_после_числительного(экземпляр.Количество_ожидающих(), Словарь_склонений['участник'])} из {экземпляр.Количество_участников()})"

class Таймер(Поток):
    def __init__(экземпляр, интервал, цель, аргументы = (), именовАргументы = None, обратный_вызов = None, аргументыОбрВыз = (), именовАргументыОбрВыз = None):
        ИА = {'interval': интервал, 'function': цель}
        if аргументы:
            ИА['args'] = аргументы
        if именовАргументы is not None:
            ИА['kwargs'] = именовАргументы
        экземпляр._timer = threading.Timer(**ИА)
        экземпляр._callback = обратный_вызов
        экземпляр._callback_args = аргументыОбрВыз
        экземпляр._callback_kwargs = именовАргументыОбрВыз or {}

    def Отменить(экземпляр):
        экземпляр._timer.cancel()

    def Завершён(экземпляр):
        return экземпляр._timer.finished.is_set()

    def __str__(экземпляр):
        return f"Таймер(интервал={экземпляр._timer.interval}, завершён={экземпляр.Завершён()})"

def Текущий_поток():
    return Поток(цель = lambda: None, имя = threading.current_thread().getName())

def Количество_активных_потоков():
    return threading.active_count()

def Перечислить_потоки():
    return [Поток(цель = lambda: None, имя = поток.getName()) for поток in threading.enumerate()]

def Получить_основной_поток():
    return Поток(цель = lambda: None, имя = threading.main_thread().getName())
