"""Add mtime and size columns to Entity for sync optimization

Revision ID: 9d9c1cb7d8f5
Revises: a1b2c3d4e5f6
Create Date: 2025-10-20 05:07:55.173849

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "9d9c1cb7d8f5"
down_revision: Union[str, None] = "a1b2c3d4e5f6"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("entity", schema=None) as batch_op:
        batch_op.add_column(sa.Column("mtime", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("size", sa.Integer(), nullable=True))
        batch_op.drop_constraint(batch_op.f("fk_entity_project_id"), type_="foreignkey")
        batch_op.create_foreign_key(
            batch_op.f("fk_entity_project_id"), "project", ["project_id"], ["id"]
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("entity", schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f("fk_entity_project_id"), type_="foreignkey")
        batch_op.create_foreign_key(
            batch_op.f("fk_entity_project_id"),
            "project",
            ["project_id"],
            ["id"],
            ondelete="CASCADE",
        )
        batch_op.drop_column("size")
        batch_op.drop_column("mtime")

    # ### end Alembic commands ###
