'''
 =======================================================================
 ····Y88b···d88P················888b·····d888·d8b·······················
 ·····Y88b·d88P·················8888b···d8888·Y8P·······················
 ······Y88o88P··················88888b·d88888···························
 ·······Y888P··8888b···88888b···888Y88888P888·888·88888b·····d88b·······
 ········888······"88b·888·"88b·888·Y888P·888·888·888·"88b·d88P"88b·····
 ········888···d888888·888··888·888··Y8P··888·888·888··888·888··888·····
 ········888··888··888·888··888·888···"···888·888·888··888·Y88b·888·····
 ········888··"Y888888·888··888·888·······888·888·888··888··"Y88888·····
 ·······························································888·····
 ··························································Y8b·d88P·····
 ···························································"Y88P"······
 =======================================================================

 -----------------------------------------------------------------------
Author       : 焱铭
Date         : 2025-04-21 20:03:52 +0800
LastEditTime : 2025-04-21 23:46:53 +0800
Github       : https://github.com/YanMing-lxb/
FilePath     : /EGWaterProps/src/data.py
Description  : 
 -----------------------------------------------------------------------
'''

# --------------------------------- 数据来源 ---------------------------------
# Dow Chemical USA. 2001b. Engineering manual for DOWTHERM SR-1and DOWTHERM 
# 4000 inhibited ethylene glycol heat transfer fluids.Midland, MI.
# 行对应温度                    列对应体积浓度
# 温度范围: -35--125°C step 5  体积浓度范围: 0.1%--0.9% step 0.1,
# --------------------------------------------------------------------------
# 乙二醇水溶液的密度 (kg/m3)
eg_rho = [
    [None    , None    , None    , None    , 1089.94 , 1104.60 , 1118.61 , 1132.11 , None   ],
    [None    , None    , None    , None    , 1089.04 , 1103.54 , 1117.38 , 1130.72 , None   ],
    [None    , None    , None    , None    , 1088.01 , 1102.36 , 1116.04 , 1129.21 , 1141.87],
    [None    , None    , None    , 1071.98 , 1086.87 , 1101.06 , 1114.58 , 1127.57 , 1140.07],
    [None    , None    , None    , 1070.87 , 1085.61 , 1099.64 , 1112.99 , 1125.82 , 1138.14],
    [None    , None    , 1054.31 , 1069.63 , 1084.22 , 1098.09 , 1111.28 , 1123.94 , 1136.09],
    [None    , 1036.85 , 1053.11 , 1068.28 , 1082.71 , 1096.43 , 1109.45 , 1121.94 , 1133.91],
    [1018.73 , 1035.67 , 1051.78 , 1066.80 , 1081.08 , 1094.64 , 1107.50 , 1119.82 , 1131.62],
    [1017.57 , 1034.36 , 1050.33 , 1065.21 , 1079.33 , 1092.73 , 1105.43 , 1117.58 , 1129.20],
    [1016.28 , 1032.94 , 1048.76 , 1063.49 , 1077.46 , 1090.70 , 1103.23 , 1115.22 , 1126.67],
    [1014.87 , 1031.39 , 1047.07 , 1061.65 , 1075.46 , 1088.54 , 1100.92 , 1112.73 , 1124.01],
    [1013.34 , 1029.72 , 1045.25 , 1059.68 , 1073.35 , 1086.27 , 1098.48 , 1110.13 , 1121.23],
    [1011.69 , 1027.93 , 1043.32 , 1057.60 , 1071.11 , 1083.87 , 1095.92 , 1107.40 , 1118.32],
    [1009.92 , 1026.02 , 1041.26 , 1055.39 , 1068.75 , 1081.35 , 1093.24 , 1104.55 , 1115.30],
    [1008.02 , 1023.99 , 1039.08 , 1053.07 , 1066.27 , 1078.71 , 1090.43 , 1101.58 , 1112.15],
    [1006.01 , 1021.83 , 1036.78 , 1050.62 , 1063.66 , 1075.95 , 1087.51 , 1098.48 , 1108.89],
    [1003.87 , 1019.55 , 1034.36 , 1048.05 , 1060.94 , 1073.07 , 1084.46 , 1095.27 , 1105.50],
    [1001.61 , 1017.16 , 1031.81 , 1045.35 , 1058.09 , 1070.06 , 1081.30 , 1091.93 , 1101.99],
    [999.23  , 1014.64 , 1029.15 , 1042.54 , 1055.13 , 1066.94 , 1078.01 , 1088.48 , 1098.36],
    [996.72  , 1011.99 , 1026.36 , 1039.61 , 1052.04 , 1063.69 , 1074.60 , 1084.90 , 1094.60],
    [994.10  , 1009.23 , 1023.45 , 1036.55 , 1048.83 , 1060.32 , 1071.06 , 1081.20 , 1090.73],
    [991.35  , 1006.35 , 1020.42 , 1033.37 , 1045.49 , 1056.83 , 1067.41 , 1077.37 , 1086.73],
    [988.49  , 1003.34 , 1017.27 , 1030.07 , 1042.04 , 1053.22 , 1063.64 , 1073.43 , 1082.61],
    [985.50  , 1000.21 , 1014.00 , 1026.65 , 1038.46 , 1049.48 , 1059.74 , 1069.36 , 1078.37],
    [982.39  , 996.96  , 1010.60 , 1023.10 , 1034.77 , 1045.63 , 1055.72 , 1065.18 , 1074.01],
    [979.15  , 993.59  , 1007.09 , 1019.44 , 1030.95 , 1041.65 , 1051.58 , 1060.87 , 1069.53],
    [975.80  , 990.10  , 1003.45 , 1015.65 , 1027.01 , 1037.55 , 1047.32 , 1056.44 , 1064.92],
    [972.32  , 986.48  , 999.69  , 1011.74 , 1022.95 , 1033.33 , 1042.93 , 1051.88 , 1060.20],
    [968.73  , 982.75  , 995.81  , 1007.71 , 1018.76 , 1028.99 , 1038.43 , 1047.21 , 1055.35],
    [965.01  , 978.89  , 991.81  , 1003.56 , 1014.46 , 1024.52 , 1033.80 , 1042.41 , 1050.38],
    [961.17  , 974.91  , 987.68  , 999.29  , 1010.03 , 1019.94 , 1029.05 , 1037.50 , 1045.29],
    [957.21  , 970.81  , 983.43  , 994.90  , 1005.48 , 1015.23 , 1024.18 , 1032.46 , 1040.08],
    [953.12  , 966.59  , 979.07  , 990.38  , 1000.81 , 1010.40 , 1019.19 , 1027.30 , 1034.74],
]

# 乙二醇水溶液的比热 (J/kg.K)
eg_cp = [
    [None , None , None , None , 3068 , 2844 , 2612 , 2370 , None],
    [None , None , None , None , 3088 , 2866 , 2636 , 2397 , None],
    [None , None , None , None , 3107 , 2888 , 2660 , 2423 , 2177],
    [None , None , None , 3334 , 3126 , 2909 , 2685 , 2450 , 2206],
    [None , None , None , 3351 , 3145 , 2931 , 2709 , 2477 , 2235],
    [None , None , 3560 , 3367 , 3165 , 2953 , 2733 , 2503 , 2264],
    [None , 3757 , 3574 , 3384 , 3184 , 2975 , 2757 , 2530 , 2293],
    [3937 , 3769 , 3589 , 3401 , 3203 , 2997 , 2782 , 2556 , 2322],
    [3946 , 3780 , 3603 , 3418 , 3223 , 3018 , 2806 , 2583 , 2351],
    [3954 , 3792 , 3617 , 3435 , 3242 , 3040 , 2830 , 2610 , 2380],
    [3963 , 3803 , 3631 , 3451 , 3261 , 3062 , 2854 , 2636 , 2409],
    [3972 , 3815 , 3645 , 3468 , 3281 , 3084 , 2878 , 2663 , 2438],
    [3981 , 3826 , 3660 , 3485 , 3300 , 3106 , 2903 , 2690 , 2467],
    [3989 , 3838 , 3674 , 3502 , 3319 , 3127 , 2927 , 2716 , 2496],
    [3998 , 3849 , 3688 , 3518 , 3339 , 3149 , 2951 , 2743 , 2525],
    [4007 , 3861 , 3702 , 3535 , 3358 , 3171 , 2975 , 2770 , 2554],
    [4015 , 3872 , 3716 , 3552 , 3377 , 3193 , 3000 , 2796 , 2583],
    [4024 , 3884 , 3730 , 3569 , 3396 , 3215 , 3024 , 2823 , 2612],
    [4033 , 3895 , 3745 , 3585 , 3416 , 3236 , 3048 , 2850 , 2641],
    [4042 , 3907 , 3759 , 3602 , 3435 , 3258 , 3072 , 2876 , 2670],
    [4050 , 3918 , 3773 , 3619 , 3454 , 3280 , 3097 , 2903 , 2699],
    [4059 , 3930 , 3787 , 3636 , 3474 , 3302 , 3121 , 2929 , 2728],
    [4068 , 3941 , 3801 , 3653 , 3493 , 3324 , 3145 , 2956 , 2757],
    [4077 , 3953 , 3816 , 3669 , 3512 , 3345 , 3169 , 2983 , 2786],
    [4085 , 3964 , 3830 , 3686 , 3532 , 3367 , 3193 , 3009 , 2815],
    [4094 , 3976 , 3844 , 3703 , 3551 , 3389 , 3218 , 3036 , 2844],
    [4103 , 3987 , 3858 , 3720 , 3570 , 3411 , 3242 , 3063 , 2873],
    [4112 , 3999 , 3872 , 3736 , 3590 , 3433 , 3266 , 3089 , 2902],
    [4120 , 4010 , 3886 , 3753 , 3609 , 3454 , 3290 , 3116 , 2931],
    [4129 , 4022 , 3901 , 3770 , 3628 , 3476 , 3315 , 3143 , 2960],
    [4138 , 4033 , 3915 , 3787 , 3647 , 3498 , 3339 , 3169 , 2989],
    [4147 , 4045 , 3929 , 3804 , 3667 , 3520 , 3363 , 3196 , 3018],
    [4155 , 4056 , 3943 , 3820 , 3686 , 3542 , 3387 , 3223 , 3047],
]

# 乙二醇水溶液导热系数 (W/m.K)
eg_k = [
    [None  , None  , None  , None  , 0.300 , 0.279 , 0.262 , None  , None ],
    [None  , None  , None  , None  , 0.328 , 0.303 , 0.282 , 0.264 , None ],
    [None  , None  , None  , None  , 0.332 , 0.306 , 0.284 , 0.266 , 0.252],
    [None  , None  , None  , 0.366 , 0.336 , 0.310 , 0.287 , 0.268 , 0.253],
    [None  , None  , None  , 0.371 , 0.340 , 0.313 , 0.289 , 0.270 , 0.255],
    [None  , None  , 0.411 , 0.376 , 0.344 , 0.316 , 0.292 , 0.271 , 0.256],
    [None  , 0.458 , 0.417 , 0.381 , 0.348 , 0.319 , 0.294 , 0.273 , 0.257],
    [0.512 , 0.466 , 0.423 , 0.386 , 0.352 , 0.322 , 0.297 , 0.275 , 0.259],
    [0.520 , 0.472 , 0.429 , 0.391 , 0.356 , 0.325 , 0.299 , 0.277 , 0.260],
    [0.528 , 0.479 , 0.435 , 0.395 , 0.360 , 0.328 , 0.301 , 0.278 , 0.261],
    [0.535 , 0.486 , 0.440 , 0.400 , 0.363 , 0.331 , 0.303 , 0.280 , 0.262],
    [0.543 , 0.492 , 0.445 , 0.404 , 0.366 , 0.334 , 0.305 , 0.281 , 0.263],
    [0.550 , 0.498 , 0.450 , 0.408 , 0.370 , 0.336 , 0.307 , 0.283 , 0.264],
    [0.556 , 0.503 , 0.455 , 0.412 , 0.373 , 0.338 , 0.309 , 0.284 , 0.265],
    [0.563 , 0.509 , 0.459 , 0.415 , 0.376 , 0.341 , 0.311 , 0.285 , 0.266],
    [0.569 , 0.514 , 0.463 , 0.419 , 0.378 , 0.343 , 0.312 , 0.286 , 0.267],
    [0.574 , 0.518 , 0.467 , 0.422 , 0.381 , 0.345 , 0.314 , 0.288 , 0.268],
    [0.579 , 0.523 , 0.471 , 0.425 , 0.383 , 0.347 , 0.315 , 0.289 , 0.268],
    [0.584 , 0.527 , 0.474 , 0.427 , 0.385 , 0.348 , 0.316 , 0.289 , 0.269],
    [0.588 , 0.530 , 0.477 , 0.430 , 0.387 , 0.350 , 0.317 , 0.290 , 0.270],
    [0.592 , 0.534 , 0.480 , 0.432 , 0.389 , 0.351 , 0.318 , 0.291 , 0.270],
    [0.596 , 0.537 , 0.483 , 0.434 , 0.391 , 0.352 , 0.319 , 0.292 , 0.271],
    [0.599 , 0.540 , 0.485 , 0.436 , 0.392 , 0.354 , 0.320 , 0.292 , 0.271],
    [0.602 , 0.542 , 0.487 , 0.438 , 0.394 , 0.355 , 0.321 , 0.293 , 0.271],
    [0.605 , 0.544 , 0.489 , 0.439 , 0.395 , 0.355 , 0.322 , 0.293 , 0.272],
    [0.607 , 0.546 , 0.490 , 0.440 , 0.396 , 0.356 , 0.322 , 0.294 , 0.272],
    [0.609 , 0.548 , 0.491 , 0.441 , 0.396 , 0.357 , 0.322 , 0.294 , 0.272],
    [0.610 , 0.549 , 0.493 , 0.442 , 0.397 , 0.357 , 0.323 , 0.294 , 0.272],
    [0.612 , 0.550 , 0.493 , 0.443 , 0.398 , 0.358 , 0.323 , 0.294 , 0.272],
    [0.613 , 0.551 , 0.494 , 0.443 , 0.398 , 0.358 , 0.323 , 0.294 , 0.272],
    [0.614 , 0.552 , 0.495 , 0.444 , 0.398 , 0.358 , 0.323 , 0.294 , 0.272],
    [0.614 , 0.552 , 0.495 , 0.444 , 0.398 , 0.358 , 0.323 , 0.294 , 0.272],
    [0.615 , 0.552 , 0.495 , 0.444 , 0.398 , 0.358 , 0.323 , 0.294 , 0.271],
]

# 乙二醇水溶液动力粘度 (mPa/s)
eg_mu = [
    [None   , None   , None   , None   , 66.93  , 93.44  , 133.53 , 191.09   , None],
    [None   , None   , None   , None   , 43.98  , 65.25  , 96.57  , 141.02   , None],
    [None   , None   , None   , None   , 30.50  , 46.75  , 70.38  , 102.21 , 196.87],
    [None   , None   , None   , 15.75  , 22.07  , 34.28  , 51.94  , 74.53  , 128.43],
    [None   , None   , None   , 11.74  , 16.53  , 25.69  , 38.88  , 55.09  , 87.52 ],
    [None   , None   , 6.19   , 9.06   , 12.74  , 19.62  , 29.53  , 41.36  , 61.85 ],
    [None   , 3.65   , 5.03   , 7.18   , 10.05  , 15.25  , 22.76  , 31.56  , 45.08 ],
    [2.08   , 3.02   , 4.15   , 5.83   , 8.09   , 12.05  , 17.79  , 24.44  , 33.74 ],
    [1.79   , 2.54   , 3.48   , 4.82   , 6.63   , 9.66   , 14.09  , 19.20  , 25.84 ],
    [1.56   , 2.18   , 2.95   , 4.04   , 5.50   , 7.85   , 11.31  , 15.29  , 20.18 ],
    [1.37   , 1.89   , 2.53   , 3.44   , 4.63   , 6.46   , 9.18   , 12.33  , 16.04 ],
    [1.21   , 1.65   , 2.20   , 2.96   , 3.94   , 5.38   , 7.53   , 10.05  , 12.95 ],
    [1.08   , 1.46   , 1.92   , 2.57   , 3.39   , 4.52   , 6.24   , 8.29   , 10.59 ],
    [0.97   , 1.30   , 1.69   , 2.26   , 2.94   , 3.84   , 5.23   , 6.90   , 8.77  ],
    [0.88   , 1.17   , 1.50   , 1.99   , 2.56   , 3.29   , 4.42   , 5.79   , 7.34  ],
    [0.80   , 1.06   , 1.34   , 1.77   , 2.26   , 2.84   , 3.76   , 4.91   , 6.21  ],
    [0.73   , 0.96   , 1.21   , 1.59   , 2.00   , 2.47   , 3.23   , 4.19   , 5.30  ],
    [0.67   , 0.88   , 1.09   , 1.43   , 1.78   , 2.16   , 2.80   , 3.61   , 4.56  ],
    [0.62   , 0.81   , 0.99   , 1.29   , 1.59   , 1.91   , 2.43   , 3.12   , 3.95  ],
    [0.57   , 0.74   , 0.90   , 1.17   , 1.43   , 1.69   , 2.13   , 2.72   , 3.45  ],
    [0.53   , 0.69   , 0.83   , 1.06   , 1.29   , 1.51   , 1.88   , 2.39   , 3.03  ],
    [0.50   , 0.64   , 0.76   , 0.97   , 1.17   , 1.35   , 1.67   , 2.11   , 2.67  ],
    [0.47   , 0.59   , 0.70   , 0.89   , 1.07   , 1.22   , 1.49   , 1.87   , 2.37  ],
    [0.44   , 0.55   , 0.65   , 0.82   , 0.98   , 1.10   , 1.33   , 1.66   , 2.12  ],
    [0.41   , 0.52   , 0.60   , 0.76   , 0.89   , 1.00   , 1.20   , 1.49   , 1.90  ],
    [0.39   , 0.49   , 0.56   , 0.70   , 0.82   , 0.92   , 1.09   , 1.34   , 1.71  ],
    [0.37   , 0.46   , 0.52   , 0.65   , 0.76   , 0.84   , 0.99   , 1.21   , 1.54  ],
    [0.35   , 0.43   , 0.49   , 0.60   , 0.70   , 0.77   , 0.90   , 1.10   , 1.40  ],
    [0.33   , 0.40   , 0.46   , 0.56   , 0.65   , 0.71   , 0.82   , 1.00   , 1.27  ],
    [0.32   , 0.38   , 0.43   , 0.53   , 0.60   , 0.66   , 0.76   , 0.91   , 1.16  ],
    [0.30   , 0.36   , 0.41   , 0.49   , 0.56   , 0.61   , 0.70   , 0.83   , 1.07  ],
    [0.29   , 0.34   , 0.38   , 0.46   , 0.53   , 0.57   , 0.64   , 0.77   , 0.98  ],
    [0.28   , 0.33   , 0.36   , 0.43   , 0.49   , 0.53   , 0.60   , 0.71   , 0.90  ],

]

# 乙二醇水溶液的冰点沸点(℃) 100.7KPa freezing and boiling points
# 质量浓度 体积浓度  冰点℃    沸点℃
eg_fb = [
    [0.0 , 0.0 ,  0.0 , 100.0],
    [5.0 , 4.4 , -1.4 , 100.6],
    [10.0, 8.9 , -3.2 , 101.1],
    [15.0, 13.6, -5.4 , 101.7],
    [20.0, 18.1, -7.8 , 102.2],
    [21.0, 19.2, -8.4 , 102.2],
    [22.0, 20.1, -8.9 , 102.2],
    [23.0, 21.0, -9.5 , 102.8],
    [24.0, 22.0, -10.2, 102.8],
    [25.0, 22.9, -10.7, 103.3],
    [26.0, 23.9, -11.4, 103.3],
    [27.0, 24.8, -12.0, 103.3],
    [28.0, 25.8, -12.7, 103.9],
    [29.0, 26.7, -13.3, 103.9],
    [30.0, 27.7, -14.1, 104.4],
    [31.0, 28.7, -14.8, 104.4],
    [32.0, 29.6, -15.4, 104.4],
    [33.0, 30.6, -16.2, 104.4],
    [34.0, 31.6, -17.0, 104.4],
    [35.0, 32.6, -17.9, 105.0],
    [36.0, 33.5, -18.6, 105.0],
    [37.0, 34.5, -19.4, 105.0],
    [38.0, 35.5, -20.3, 105.0],
    [39.0, 36.5, -21.3, 105.0],
    [40.0, 37.5, -22.3, 105.6],
    [41.0, 38.5, -23.2, 105.6],
    [42.0, 39.5, -24.3, 105.6],
    [43.0, 40.5, -25.3, 106.1],
    [44.0, 41.5, -26.4, 106.1],
    [45.0, 42.5, -27.5, 106.7],
    [46.0, 43.5, -28.8, 106.7],
    [47.0, 44.5, -29.8, 106.7],
    [48.0, 45.5, -31.1, 106.7],
    [49.0, 46.6, -32.6, 106.7],
    [50.0, 47.6, -33.8, 107.2],
    [51.0, 48.6, -35.1, 107.2],
    [52.0, 49.6, -36.4, 107.2],
    [53.0, 50.6, -37.9, 107.8],
    [54.0, 51.6, -39.3, 107.8],
    [55.0, 52.7, -41.1, 108.3],
    [56.0, 53.7, -42.6, 108.3],
    [57.0, 54.7, -44.2, 108.9],
    [58.0, 55.7, -45.6, 108.9],
    [59.0, 56.8, -47.1, 109.4],
    [60.0, 57.8, -48.3, 110.0],
    [65.0, 62.8,  None, 112.8],
    [70.0, 68.3,  None, 116.7],
    [75.0, 73.6,  None, 120.0],
    [80.0, 78.9, -46.8, 123.9],
    [85.0, 84.3, -36.9, 133.9],
    [90.0, 89.7, -29.8, 140.6],
    [95.0, 95.0, -19.4, 158.3]
]

EGP = {
    'rho': eg_rho,
    'cp': eg_cp,
    'k': eg_k,
    'mu': eg_mu,
    'fb': eg_fb
}