# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 7.17.2697
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_account.models.calculation_info import CalculationInfo
from typing import Optional, Set
from typing_extensions import Self

class AuditActionStatistics(BaseModel):
    """
    Detail process statistics. 
    """ # noqa: E501
    request_points_count: Optional[Annotated[int, Field(le=100000000, strict=True, ge=0)]] = Field(default=None, description="Non-unique points per request.")
    result_elements_count: Optional[Annotated[int, Field(le=100000000, strict=True, ge=0)]] = Field(default=None, description="The number of planned elements in the response.")
    calculation_info: CalculationInfo
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["request_points_count", "result_elements_count", "calculation_info"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuditActionStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of calculation_info
        if self.calculation_info:
            _dict['calculation_info'] = self.calculation_info.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if request_points_count (nullable) is None
        # and model_fields_set contains the field
        if self.request_points_count is None and "request_points_count" in self.model_fields_set:
            _dict['request_points_count'] = None

        # set to None if result_elements_count (nullable) is None
        # and model_fields_set contains the field
        if self.result_elements_count is None and "result_elements_count" in self.model_fields_set:
            _dict['result_elements_count'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuditActionStatistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "request_points_count": obj.get("request_points_count"),
            "result_elements_count": obj.get("result_elements_count"),
            "calculation_info": CalculationInfo.from_dict(obj["calculation_info"]) if obj.get("calculation_info") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


