"""
    OneSignal

    A powerful way to send personalized messages at scale and build effective customer engagement strategies. Learn more at onesignal.com  # noqa: E501

    The version of the OpenAPI document: 1.2.2
    Contact: devrel@onesignal.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from onesignal.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from onesignal.exceptions import ApiAttributeError


def lazy_import():
    from onesignal.model.basic_notification import BasicNotification
    from onesignal.model.basic_notification_all_of_android_background_layout import BasicNotificationAllOfAndroidBackgroundLayout
    from onesignal.model.button import Button
    from onesignal.model.delivery_data import DeliveryData
    from onesignal.model.filter import Filter
    from onesignal.model.notification_with_meta_all_of import NotificationWithMetaAllOf
    from onesignal.model.outcome_data import OutcomeData
    from onesignal.model.outcomes_data import OutcomesData
    from onesignal.model.platform_delivery_data import PlatformDeliveryData
    from onesignal.model.player_notification_target_include_aliases import PlayerNotificationTargetIncludeAliases
    from onesignal.model.string_map import StringMap
    globals()['BasicNotification'] = BasicNotification
    globals()['BasicNotificationAllOfAndroidBackgroundLayout'] = BasicNotificationAllOfAndroidBackgroundLayout
    globals()['Button'] = Button
    globals()['DeliveryData'] = DeliveryData
    globals()['Filter'] = Filter
    globals()['NotificationWithMetaAllOf'] = NotificationWithMetaAllOf
    globals()['OutcomeData'] = OutcomeData
    globals()['OutcomesData'] = OutcomesData
    globals()['PlatformDeliveryData'] = PlatformDeliveryData
    globals()['PlayerNotificationTargetIncludeAliases'] = PlayerNotificationTargetIncludeAliases
    globals()['StringMap'] = StringMap


class NotificationWithMeta(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('target_channel',): {
            'PUSH': "push",
            'EMAIL': "email",
            'SMS': "sms",
        },
        ('aggregation',): {
            'SUM': "sum",
            'COUNT': "count",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'app_id': (str,),  # noqa: E501
            'included_segments': ([str],),  # noqa: E501
            'excluded_segments': ([str],),  # noqa: E501
            'include_player_ids': ([str], none_type,),  # noqa: E501
            'include_external_user_ids': ([str], none_type,),  # noqa: E501
            'include_email_tokens': ([str],),  # noqa: E501
            'include_phone_numbers': ([str],),  # noqa: E501
            'include_ios_tokens': ([str],),  # noqa: E501
            'include_wp_wns_uris': ([str],),  # noqa: E501
            'include_amazon_reg_ids': ([str],),  # noqa: E501
            'include_chrome_reg_ids': ([str],),  # noqa: E501
            'include_chrome_web_reg_ids': ([str],),  # noqa: E501
            'include_android_reg_ids': ([str],),  # noqa: E501
            'include_aliases': (PlayerNotificationTargetIncludeAliases,),  # noqa: E501
            'target_channel': (str,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'value': (int,),  # noqa: E501
            'name': (str, none_type,),  # noqa: E501
            'aggregation': (str,),  # noqa: E501
            'is_ios': (bool, none_type,),  # noqa: E501
            'is_android': (bool, none_type,),  # noqa: E501
            'is_huawei': (bool, none_type,),  # noqa: E501
            'is_any_web': (bool, none_type,),  # noqa: E501
            'is_chrome_web': (bool, none_type,),  # noqa: E501
            'is_firefox': (bool, none_type,),  # noqa: E501
            'is_safari': (bool, none_type,),  # noqa: E501
            'is_wp_wns': (bool, none_type,),  # noqa: E501
            'is_adm': (bool, none_type,),  # noqa: E501
            'is_chrome': (bool, none_type,),  # noqa: E501
            'channel_for_external_user_ids': (str,),  # noqa: E501
            'external_id': (str, none_type,),  # noqa: E501
            'contents': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'headings': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'subtitle': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'data': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type,),  # noqa: E501
            'huawei_msg_type': (str, none_type,),  # noqa: E501
            'url': (str, none_type,),  # noqa: E501
            'web_url': (str, none_type,),  # noqa: E501
            'app_url': (str, none_type,),  # noqa: E501
            'ios_attachments': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type,),  # noqa: E501
            'template_id': (str, none_type,),  # noqa: E501
            'content_available': (bool, none_type,),  # noqa: E501
            'mutable_content': (bool,),  # noqa: E501
            'target_content_identifier': (str, none_type,),  # noqa: E501
            'big_picture': (str, none_type,),  # noqa: E501
            'huawei_big_picture': (str, none_type,),  # noqa: E501
            'adm_big_picture': (str, none_type,),  # noqa: E501
            'chrome_big_picture': (str, none_type,),  # noqa: E501
            'chrome_web_image': (str, none_type,),  # noqa: E501
            'buttons': ([Button], none_type,),  # noqa: E501
            'web_buttons': ([Button], none_type,),  # noqa: E501
            'ios_category': (str, none_type,),  # noqa: E501
            'android_channel_id': (str,),  # noqa: E501
            'huawei_channel_id': (str, none_type,),  # noqa: E501
            'existing_android_channel_id': (str,),  # noqa: E501
            'huawei_existing_channel_id': (str, none_type,),  # noqa: E501
            'android_background_layout': (BasicNotificationAllOfAndroidBackgroundLayout,),  # noqa: E501
            'small_icon': (str, none_type,),  # noqa: E501
            'huawei_small_icon': (str, none_type,),  # noqa: E501
            'large_icon': (str, none_type,),  # noqa: E501
            'huawei_large_icon': (str, none_type,),  # noqa: E501
            'adm_small_icon': (str, none_type,),  # noqa: E501
            'adm_large_icon': (str, none_type,),  # noqa: E501
            'chrome_web_icon': (str, none_type,),  # noqa: E501
            'chrome_web_badge': (str, none_type,),  # noqa: E501
            'firefox_icon': (str, none_type,),  # noqa: E501
            'chrome_icon': (str, none_type,),  # noqa: E501
            'ios_sound': (str, none_type,),  # noqa: E501
            'android_sound': (str, none_type,),  # noqa: E501
            'huawei_sound': (str, none_type,),  # noqa: E501
            'adm_sound': (str, none_type,),  # noqa: E501
            'wp_wns_sound': (str, none_type,),  # noqa: E501
            'android_led_color': (str, none_type,),  # noqa: E501
            'huawei_led_color': (str, none_type,),  # noqa: E501
            'android_accent_color': (str, none_type,),  # noqa: E501
            'huawei_accent_color': (str, none_type,),  # noqa: E501
            'android_visibility': (int, none_type,),  # noqa: E501
            'huawei_visibility': (int, none_type,),  # noqa: E501
            'ios_badge_type': (str, none_type,),  # noqa: E501
            'ios_badge_count': (int, none_type,),  # noqa: E501
            'collapse_id': (str,),  # noqa: E501
            'web_push_topic': (str, none_type,),  # noqa: E501
            'apns_alert': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type,),  # noqa: E501
            'delayed_option': (str, none_type,),  # noqa: E501
            'delivery_time_of_day': (str, none_type,),  # noqa: E501
            'ttl': (int, none_type,),  # noqa: E501
            'priority': (int, none_type,),  # noqa: E501
            'apns_push_type_override': (str,),  # noqa: E501
            'throttle_rate_per_minute': (int, none_type,),  # noqa: E501
            'android_group': (str, none_type,),  # noqa: E501
            'android_group_message': (str, none_type,),  # noqa: E501
            'adm_group': (str, none_type,),  # noqa: E501
            'adm_group_message': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type,),  # noqa: E501
            'thread_id': (str, none_type,),  # noqa: E501
            'summary_arg': (str,),  # noqa: E501
            'summary_arg_count': (int,),  # noqa: E501
            'email_subject': (str, none_type,),  # noqa: E501
            'email_body': (str,),  # noqa: E501
            'email_from_name': (str, none_type,),  # noqa: E501
            'email_from_address': (str, none_type,),  # noqa: E501
            'email_preheader': (str, none_type,),  # noqa: E501
            'include_unsubscribed': (bool,),  # noqa: E501
            'sms_from': (str, none_type,),  # noqa: E501
            'sms_media_urls': ([str], none_type,),  # noqa: E501
            'filters': ([Filter], none_type,),  # noqa: E501
            'custom_data': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type,),  # noqa: E501
            'successful': (int,),  # noqa: E501
            'failed': (int,),  # noqa: E501
            'errored': (int,),  # noqa: E501
            'converted': (int,),  # noqa: E501
            'received': (int, none_type,),  # noqa: E501
            'outcomes': ([OutcomeData],),  # noqa: E501
            'remaining': (int,),  # noqa: E501
            'queued_at': (int,),  # noqa: E501
            'send_after': (int, none_type,),  # noqa: E501
            'completed_at': (int, none_type,),  # noqa: E501
            'platform_delivery_stats': (PlatformDeliveryData,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'app_id': 'app_id',  # noqa: E501
        'included_segments': 'included_segments',  # noqa: E501
        'excluded_segments': 'excluded_segments',  # noqa: E501
        'include_player_ids': 'include_player_ids',  # noqa: E501
        'include_external_user_ids': 'include_external_user_ids',  # noqa: E501
        'include_email_tokens': 'include_email_tokens',  # noqa: E501
        'include_phone_numbers': 'include_phone_numbers',  # noqa: E501
        'include_ios_tokens': 'include_ios_tokens',  # noqa: E501
        'include_wp_wns_uris': 'include_wp_wns_uris',  # noqa: E501
        'include_amazon_reg_ids': 'include_amazon_reg_ids',  # noqa: E501
        'include_chrome_reg_ids': 'include_chrome_reg_ids',  # noqa: E501
        'include_chrome_web_reg_ids': 'include_chrome_web_reg_ids',  # noqa: E501
        'include_android_reg_ids': 'include_android_reg_ids',  # noqa: E501
        'include_aliases': 'include_aliases',  # noqa: E501
        'target_channel': 'target_channel',  # noqa: E501
        'id': 'id',  # noqa: E501
        'value': 'value',  # noqa: E501
        'name': 'name',  # noqa: E501
        'aggregation': 'aggregation',  # noqa: E501
        'is_ios': 'isIos',  # noqa: E501
        'is_android': 'isAndroid',  # noqa: E501
        'is_huawei': 'isHuawei',  # noqa: E501
        'is_any_web': 'isAnyWeb',  # noqa: E501
        'is_chrome_web': 'isChromeWeb',  # noqa: E501
        'is_firefox': 'isFirefox',  # noqa: E501
        'is_safari': 'isSafari',  # noqa: E501
        'is_wp_wns': 'isWP_WNS',  # noqa: E501
        'is_adm': 'isAdm',  # noqa: E501
        'is_chrome': 'isChrome',  # noqa: E501
        'channel_for_external_user_ids': 'channel_for_external_user_ids',  # noqa: E501
        'external_id': 'external_id',  # noqa: E501
        'contents': 'contents',  # noqa: E501
        'headings': 'headings',  # noqa: E501
        'subtitle': 'subtitle',  # noqa: E501
        'data': 'data',  # noqa: E501
        'huawei_msg_type': 'huawei_msg_type',  # noqa: E501
        'url': 'url',  # noqa: E501
        'web_url': 'web_url',  # noqa: E501
        'app_url': 'app_url',  # noqa: E501
        'ios_attachments': 'ios_attachments',  # noqa: E501
        'template_id': 'template_id',  # noqa: E501
        'content_available': 'content_available',  # noqa: E501
        'mutable_content': 'mutable_content',  # noqa: E501
        'target_content_identifier': 'target_content_identifier',  # noqa: E501
        'big_picture': 'big_picture',  # noqa: E501
        'huawei_big_picture': 'huawei_big_picture',  # noqa: E501
        'adm_big_picture': 'adm_big_picture',  # noqa: E501
        'chrome_big_picture': 'chrome_big_picture',  # noqa: E501
        'chrome_web_image': 'chrome_web_image',  # noqa: E501
        'buttons': 'buttons',  # noqa: E501
        'web_buttons': 'web_buttons',  # noqa: E501
        'ios_category': 'ios_category',  # noqa: E501
        'android_channel_id': 'android_channel_id',  # noqa: E501
        'huawei_channel_id': 'huawei_channel_id',  # noqa: E501
        'existing_android_channel_id': 'existing_android_channel_id',  # noqa: E501
        'huawei_existing_channel_id': 'huawei_existing_channel_id',  # noqa: E501
        'android_background_layout': 'android_background_layout',  # noqa: E501
        'small_icon': 'small_icon',  # noqa: E501
        'huawei_small_icon': 'huawei_small_icon',  # noqa: E501
        'large_icon': 'large_icon',  # noqa: E501
        'huawei_large_icon': 'huawei_large_icon',  # noqa: E501
        'adm_small_icon': 'adm_small_icon',  # noqa: E501
        'adm_large_icon': 'adm_large_icon',  # noqa: E501
        'chrome_web_icon': 'chrome_web_icon',  # noqa: E501
        'chrome_web_badge': 'chrome_web_badge',  # noqa: E501
        'firefox_icon': 'firefox_icon',  # noqa: E501
        'chrome_icon': 'chrome_icon',  # noqa: E501
        'ios_sound': 'ios_sound',  # noqa: E501
        'android_sound': 'android_sound',  # noqa: E501
        'huawei_sound': 'huawei_sound',  # noqa: E501
        'adm_sound': 'adm_sound',  # noqa: E501
        'wp_wns_sound': 'wp_wns_sound',  # noqa: E501
        'android_led_color': 'android_led_color',  # noqa: E501
        'huawei_led_color': 'huawei_led_color',  # noqa: E501
        'android_accent_color': 'android_accent_color',  # noqa: E501
        'huawei_accent_color': 'huawei_accent_color',  # noqa: E501
        'android_visibility': 'android_visibility',  # noqa: E501
        'huawei_visibility': 'huawei_visibility',  # noqa: E501
        'ios_badge_type': 'ios_badgeType',  # noqa: E501
        'ios_badge_count': 'ios_badgeCount',  # noqa: E501
        'collapse_id': 'collapse_id',  # noqa: E501
        'web_push_topic': 'web_push_topic',  # noqa: E501
        'apns_alert': 'apns_alert',  # noqa: E501
        'delayed_option': 'delayed_option',  # noqa: E501
        'delivery_time_of_day': 'delivery_time_of_day',  # noqa: E501
        'ttl': 'ttl',  # noqa: E501
        'priority': 'priority',  # noqa: E501
        'apns_push_type_override': 'apns_push_type_override',  # noqa: E501
        'throttle_rate_per_minute': 'throttle_rate_per_minute',  # noqa: E501
        'android_group': 'android_group',  # noqa: E501
        'android_group_message': 'android_group_message',  # noqa: E501
        'adm_group': 'adm_group',  # noqa: E501
        'adm_group_message': 'adm_group_message',  # noqa: E501
        'thread_id': 'thread_id',  # noqa: E501
        'summary_arg': 'summary_arg',  # noqa: E501
        'summary_arg_count': 'summary_arg_count',  # noqa: E501
        'email_subject': 'email_subject',  # noqa: E501
        'email_body': 'email_body',  # noqa: E501
        'email_from_name': 'email_from_name',  # noqa: E501
        'email_from_address': 'email_from_address',  # noqa: E501
        'email_preheader': 'email_preheader',  # noqa: E501
        'include_unsubscribed': 'include_unsubscribed',  # noqa: E501
        'sms_from': 'sms_from',  # noqa: E501
        'sms_media_urls': 'sms_media_urls',  # noqa: E501
        'filters': 'filters',  # noqa: E501
        'custom_data': 'custom_data',  # noqa: E501
        'successful': 'successful',  # noqa: E501
        'failed': 'failed',  # noqa: E501
        'errored': 'errored',  # noqa: E501
        'converted': 'converted',  # noqa: E501
        'received': 'received',  # noqa: E501
        'outcomes': 'outcomes',  # noqa: E501
        'remaining': 'remaining',  # noqa: E501
        'queued_at': 'queued_at',  # noqa: E501
        'send_after': 'send_after',  # noqa: E501
        'completed_at': 'completed_at',  # noqa: E501
        'platform_delivery_stats': 'platform_delivery_stats',  # noqa: E501
    }

    read_only_vars = {
        'value',  # noqa: E501
        'aggregation',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """NotificationWithMeta - a model defined in OpenAPI

        Keyword Args:
            app_id (str): Required: Your OneSignal Application ID, which can be found in Keys & IDs. It is a UUID and looks similar to 8250eaf6-1a58-489e-b136-7c74a864b434. 
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            included_segments ([str]): The segment names you want to target. Users in these segments will receive a notification. This targeting parameter is only compatible with excluded_segments. Example: [\"Active Users\", \"Inactive Users\"] . [optional]  # noqa: E501
            excluded_segments ([str]): Segment that will be excluded when sending. Users in these segments will not receive a notification, even if they were included in included_segments. This targeting parameter is only compatible with included_segments. Example: [\"Active Users\", \"Inactive Users\"] . [optional]  # noqa: E501
            include_player_ids ([str], none_type): Specific playerids to send your notification to. _Does not require API Auth Key. Do not combine with other targeting parameters. Not compatible with any other targeting parameters. Example: [\"1dd608f2-c6a1-11e3-851d-000c2940e62c\"] Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_external_user_ids ([str], none_type): Target specific devices by custom user IDs assigned via API. Not compatible with any other targeting parameters Example: [\"custom-id-assigned-by-api\"] REQUIRED: REST API Key Authentication Limit of 2,000 entries per REST API call. Note: If targeting push, email, or sms subscribers with same ids, use with channel_for_external_user_ids to indicate you are sending a push or email or sms. . [optional]  # noqa: E501
            include_email_tokens ([str]): Recommended for Sending Emails - Target specific email addresses. If an email does not correspond to an existing user, a new user will be created. Example: nick@catfac.ts Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_phone_numbers ([str]): Recommended for Sending SMS - Target specific phone numbers. The phone number should be in the E.164 format. Phone number should be an existing subscriber on OneSignal. Refer our docs to learn how to add phone numbers to OneSignal. Example phone number: +1999999999 Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_ios_tokens ([str]): Not Recommended: Please consider using include_player_ids or include_external_user_ids instead. Target using iOS device tokens. Warning: Only works with Production tokens. All non-alphanumeric characters must be removed from each token. If a token does not correspond to an existing user, a new user will be created. Example: ce777617da7f548fe7a9ab6febb56cf39fba6d38203... Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_wp_wns_uris ([str]): Not Recommended: Please consider using include_player_ids or include_external_user_ids instead. Target using Windows URIs. If a token does not correspond to an existing user, a new user will be created. Example: http://s.notify.live.net/u/1/bn1/HmQAAACPaLDr-... Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_amazon_reg_ids ([str]): Not Recommended: Please consider using include_player_ids or include_external_user_ids instead. Target using Amazon ADM registration IDs. If a token does not correspond to an existing user, a new user will be created. Example: amzn1.adm-registration.v1.XpvSSUk0Rc3hTVVV... Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_chrome_reg_ids ([str]): Not Recommended: Please consider using include_player_ids or include_external_user_ids instead. Target using Chrome App registration IDs. If a token does not correspond to an existing user, a new user will be created. Example: APA91bEeiUeSukAAUdnw3O2RB45FWlSpgJ7Ji_... Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_chrome_web_reg_ids ([str]): Not Recommended: Please consider using include_player_ids or include_external_user_ids instead. Target using Chrome Web Push registration IDs. If a token does not correspond to an existing user, a new user will be created. Example: APA91bEeiUeSukAAUdnw3O2RB45FWlSpgJ7Ji_... Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_android_reg_ids ([str]): Not Recommended: Please consider using include_player_ids or include_external_user_ids instead. Target using Android device registration IDs. If a token does not correspond to an existing user, a new user will be created. Example: APA91bEeiUeSukAAUdnw3O2RB45FWlSpgJ7Ji_... Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_aliases (PlayerNotificationTargetIncludeAliases): [optional]  # noqa: E501
            target_channel (str): [optional]  # noqa: E501
            id (str): [optional]  # noqa: E501
            value (int): [optional]  # noqa: E501
            name (str, none_type): Required for SMS Messages. An identifier for tracking message within the OneSignal dashboard or export analytics. Not shown to end user.. [optional]  # noqa: E501
            aggregation (str): [optional]  # noqa: E501
            is_ios (bool, none_type): Indicates whether to send to all devices registered under your app's Apple iOS platform.. [optional]  # noqa: E501
            is_android (bool, none_type): Indicates whether to send to all devices registered under your app's Google Android platform.. [optional]  # noqa: E501
            is_huawei (bool, none_type): Indicates whether to send to all devices registered under your app's Huawei Android platform.. [optional]  # noqa: E501
            is_any_web (bool, none_type): Indicates whether to send to all subscribed web browser users, including Chrome, Firefox, and Safari. You may use this instead as a combined flag instead of separately enabling isChromeWeb, isFirefox, and isSafari, though the three options are equivalent to this one. . [optional]  # noqa: E501
            is_chrome_web (bool, none_type): Indicates whether to send to all Google Chrome, Chrome on Android, and Mozilla Firefox users registered under your Chrome & Firefox web push platform.. [optional]  # noqa: E501
            is_firefox (bool, none_type): Indicates whether to send to all Mozilla Firefox desktop users registered under your Firefox web push platform.. [optional]  # noqa: E501
            is_safari (bool, none_type): Does not support iOS Safari. Indicates whether to send to all Apple's Safari desktop users registered under your Safari web push platform. Read more iOS Safari. [optional]  # noqa: E501
            is_wp_wns (bool, none_type): Indicates whether to send to all devices registered under your app's Windows platform.. [optional]  # noqa: E501
            is_adm (bool, none_type): Indicates whether to send to all devices registered under your app's Amazon Fire platform.. [optional]  # noqa: E501
            is_chrome (bool, none_type): This flag is not used for web push Please see isChromeWeb for sending to web push users. This flag only applies to Google Chrome Apps & Extensions. Indicates whether to send to all devices registered under your app's Google Chrome Apps & Extension platform. . [optional]  # noqa: E501
            channel_for_external_user_ids (str): Indicates if the message type when targeting with include_external_user_ids for cases where an email, sms, and/or push subscribers have the same external user id. Example: Use the string \"push\" to indicate you are sending a push notification or the string \"email\"for sending emails or \"sms\"for sending SMS. . [optional]  # noqa: E501
            external_id (str, none_type): Correlation and idempotency key. A request received with this parameter will first look for another notification with the same external_id. If one exists, a notification will not be sent, and result of the previous operation will instead be returned. Therefore, if you plan on using this feature, it's important to use a good source of randomness to generate the UUID passed here. This key is only idempotent for 30 days. After 30 days, the notification could be removed from our system and a notification with the same external_id will be sent again.   See Idempotent Notification Requests for more details writeOnly: true . [optional]  # noqa: E501
            contents (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            headings (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            subtitle (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            data ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Channel: Push Notifications Platform: Huawei A custom map of data that is passed back to your app. Same as using Additional Data within the dashboard. Can use up to 2048 bytes of data. Example: {\"abc\": 123, \"foo\": \"bar\", \"event_performed\": true, \"amount\": 12.1} . [optional]  # noqa: E501
            huawei_msg_type (str, none_type): Channel: Push Notifications Platform: Huawei Use \"data\" or \"message\" depending on the type of notification you are sending. More details in Data & Background Notifications. . [optional]  # noqa: E501
            url (str, none_type): Channel: Push Notifications Platform: All The URL to open in the browser when a user clicks on the notification. Note: iOS needs https or updated NSAppTransportSecurity in plist This field supports inline substitutions. Omit if including web_url or app_url Example: https://onesignal.com . [optional]  # noqa: E501
            web_url (str, none_type): Channel: Push Notifications Platform: All Browsers Same as url but only sent to web push platforms. Including Chrome, Firefox, Safari, Opera, etc. Example: https://onesignal.com . [optional]  # noqa: E501
            app_url (str, none_type): Channel: Push Notifications Platform: All Browsers Same as url but only sent to web push platforms. Including iOS, Android, macOS, Windows, ChromeApps, etc. Example: https://onesignal.com . [optional]  # noqa: E501
            ios_attachments ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Channel: Push Notifications Platform: iOS 10+ Adds media attachments to notifications. Set as JSON object, key as a media id of your choice and the value as a valid local filename or URL. User must press and hold on the notification to view. Do not set mutable_content to download attachments. The OneSignal SDK does this automatically Example: {\"id1\": \"https://domain.com/image.jpg\"} . [optional]  # noqa: E501
            template_id (str, none_type): Channel: Push Notifications Platform: All Use a template you setup on our dashboard. The template_id is the UUID found in the URL when viewing a template on our dashboard. Example: be4a8044-bbd6-11e4-a581-000c2940e62c . [optional]  # noqa: E501
            content_available (bool, none_type): Channel: Push Notifications Platform: iOS Sending true wakes your app from background to run custom native code (Apple interprets this as content-available=1). Note: Not applicable if the app is in the \"force-quit\" state (i.e app was swiped away). Omit the contents field to prevent displaying a visible notification. . [optional]  # noqa: E501
            mutable_content (bool): Channel: Push Notifications Platform: iOS 10+ Always defaults to true and cannot be turned off. Allows tracking of notification receives and changing of the notification content in your app before it is displayed. Triggers didReceive(_:withContentHandler:) on your UNNotificationServiceExtension. . [optional]  # noqa: E501
            target_content_identifier (str, none_type): Channel: Push Notifications Platform: iOS 13+ Use to target a specific experience in your App Clip, or to target your notification to a specific window in a multi-scene App. . [optional]  # noqa: E501
            big_picture (str, none_type): Channel: Push Notifications Platform: Android Picture to display in the expanded view. Can be a drawable resource name or a URL. . [optional]  # noqa: E501
            huawei_big_picture (str, none_type): Channel: Push Notifications Platform: Huawei Picture to display in the expanded view. Can be a drawable resource name or a URL. . [optional]  # noqa: E501
            adm_big_picture (str, none_type): Channel: Push Notifications Platform: Amazon Picture to display in the expanded view. Can be a drawable resource name or a URL. . [optional]  # noqa: E501
            chrome_big_picture (str, none_type): Channel: Push Notifications Platform: ChromeApp Large picture to display below the notification text. Must be a local URL. . [optional]  # noqa: E501
            chrome_web_image (str, none_type): Channel: Push Notifications Platform: Chrome 56+ Sets the web push notification's large image to be shown below the notification's title and text. Please see Web Push Notification Icons. . [optional]  # noqa: E501
            buttons ([Button], none_type): Channel: Push Notifications Platform: iOS 8.0+, Android 4.1+, and derivatives like Amazon Buttons to add to the notification. Icon only works for Android. Buttons show in reverse order of array position i.e. Last item in array shows as first button on device. Example: [{\"id\": \"id2\", \"text\": \"second button\", \"icon\": \"ic_menu_share\"}, {\"id\": \"id1\", \"text\": \"first button\", \"icon\": \"ic_menu_send\"}] . [optional]  # noqa: E501
            web_buttons ([Button], none_type): Channel: Push Notifications Platform: Chrome 48+ Add action buttons to the notification. The id field is required. Example: [{\"id\": \"like-button\", \"text\": \"Like\", \"icon\": \"http://i.imgur.com/N8SN8ZS.png\", \"url\": \"https://yoursite.com\"}, {\"id\": \"read-more-button\", \"text\": \"Read more\", \"icon\": \"http://i.imgur.com/MIxJp1L.png\", \"url\": \"https://yoursite.com\"}] . [optional]  # noqa: E501
            ios_category (str, none_type): Channel: Push Notifications Platform: iOS Category APS payload, use with registerUserNotificationSettings:categories in your Objective-C / Swift code. Example: calendar category which contains actions like accept and decline iOS 10+ This will trigger your UNNotificationContentExtension whose ID matches this category. . [optional]  # noqa: E501
            android_channel_id (str): Channel: Push Notifications Platform: Android The Android Oreo Notification Category to send the notification under. See the Category documentation on creating one and getting it's id. . [optional]  # noqa: E501
            huawei_channel_id (str, none_type): Channel: Push Notifications Platform: Huawei The Android Oreo Notification Category to send the notification under. See the Category documentation on creating one and getting it's id. . [optional]  # noqa: E501
            existing_android_channel_id (str): Channel: Push Notifications Platform: Android Use this if you have client side Android Oreo Channels you have already defined in your app with code. . [optional]  # noqa: E501
            huawei_existing_channel_id (str, none_type): Channel: Push Notifications Platform: Huawei Use this if you have client side Android Oreo Channels you have already defined in your app with code. . [optional]  # noqa: E501
            android_background_layout (BasicNotificationAllOfAndroidBackgroundLayout): [optional]  # noqa: E501
            small_icon (str, none_type): Channel: Push Notifications Platform: Android Icon shown in the status bar and on the top left of the notification. If not set a bell icon will be used or ic_stat_onesignal_default if you have set this resource name. See: How to create small icons . [optional]  # noqa: E501
            huawei_small_icon (str, none_type): Channel: Push Notifications Platform: Huawei Icon shown in the status bar and on the top left of the notification. Use an Android resource path (E.g. /drawable/small_icon). Defaults to your app icon if not set. . [optional]  # noqa: E501
            large_icon (str, none_type): Channel: Push Notifications Platform: Android Can be a drawable resource name or a URL. See: How to create large icons . [optional]  # noqa: E501
            huawei_large_icon (str, none_type): Channel: Push Notifications Platform: Huawei Can be a drawable resource name or a URL. See: How to create large icons . [optional]  # noqa: E501
            adm_small_icon (str, none_type): Channel: Push Notifications Platform: Amazon If not set a bell icon will be used or ic_stat_onesignal_default if you have set this resource name. See: How to create small icons . [optional]  # noqa: E501
            adm_large_icon (str, none_type): Channel: Push Notifications Platform: Amazon If blank the small_icon is used. Can be a drawable resource name or a URL. See: How to create large icons . [optional]  # noqa: E501
            chrome_web_icon (str, none_type): Channel: Push Notifications Platform: Chrome Sets the web push notification's icon. An image URL linking to a valid image. Common image types are supported; GIF will not animate. We recommend 256x256 (at least 80x80) to display well on high DPI devices. Firefox will also use this icon, unless you specify firefox_icon. . [optional]  # noqa: E501
            chrome_web_badge (str, none_type): Channel: Push Notifications Platform: Chrome Sets the web push notification icon for Android devices in the notification shade. Please see Web Push Notification Badge. . [optional]  # noqa: E501
            firefox_icon (str, none_type): Channel: Push Notifications Platform: Firefox Not recommended Few people need to set Firefox-specific icons. We recommend setting chrome_web_icon instead, which Firefox will also use. Sets the web push notification's icon for Firefox. An image URL linking to a valid image. Common image types are supported; GIF will not animate. We recommend 256x256 (at least 80x80) to display well on high DPI devices. . [optional]  # noqa: E501
            chrome_icon (str, none_type): Channel: Push Notifications Platform: ChromeApp This flag is not used for web push For web push, please see chrome_web_icon instead. The local URL to an icon to use. If blank, the app icon will be used. . [optional]  # noqa: E501
            ios_sound (str, none_type): Channel: Push Notifications Platform: iOS Sound file that is included in your app to play instead of the default device notification sound. Pass nil to disable vibration and sound for the notification. Example: \"notification.wav\" . [optional]  # noqa: E501
            android_sound (str, none_type): Channel: Push Notifications Platform: Android &#9888;&#65039;Deprecated, this field doesn't work on Android 8 (Oreo) and newer devices! Please use Notification Categories / Channels noted above instead to support ALL versions of Android. Sound file that is included in your app to play instead of the default device notification sound. Pass nil to disable sound for the notification. NOTE: Leave off file extension for Android. Example: \"notification\" . [optional]  # noqa: E501
            huawei_sound (str, none_type): Channel: Push Notifications Platform: Huawei &#9888;&#65039;Deprecated, this field ONLY works on EMUI 5 (Android 7 based) and older devices. Please also set Notification Categories / Channels noted above to support EMUI 8 (Android 8 based) devices. Sound file that is included in your app to play instead of the default device notification sound. NOTE: Leave off file extension for and include the full path.  Example: \"/res/raw/notification\" . [optional]  # noqa: E501
            adm_sound (str, none_type): Channel: Push Notifications Platform: Amazon &#9888;&#65039;Deprecated, this field doesn't work on Android 8 (Oreo) and newer devices! Please use Notification Categories / Channels noted above instead to support ALL versions of Android. Sound file that is included in your app to play instead of the default device notification sound. Pass nil to disable sound for the notification. NOTE: Leave off file extension for Android. Example: \"notification\" . [optional]  # noqa: E501
            wp_wns_sound (str, none_type): Channel: Push Notifications Platform: Windows Sound file that is included in your app to play instead of the default device notification sound. Example: \"notification.wav\" . [optional]  # noqa: E501
            android_led_color (str, none_type): Channel: Push Notifications Platform: Android &#9888;&#65039;Deprecated, this field doesn't work on Android 8 (Oreo) and newer devices! Please use Notification Categories / Channels noted above instead to support ALL versions of Android. Sets the devices LED notification light if the device has one. ARGB Hex format. Example(Blue): \"FF0000FF\" . [optional]  # noqa: E501
            huawei_led_color (str, none_type): Channel: Push Notifications Platform: Huawei &#9888;&#65039;Deprecated, this field ONLY works on EMUI 5 (Android 7 based) and older devices. Please also set Notification Categories / Channels noted above to support EMUI 8 (Android 8 based) devices. Sets the devices LED notification light if the device has one. RGB Hex format. Example(Blue): \"0000FF\" . [optional]  # noqa: E501
            android_accent_color (str, none_type): Channel: Push Notifications Platform: Android Sets the background color of the notification circle to the left of the notification text. Only applies to apps targeting Android API level 21+ on Android 5.0+ devices. Example(Red): \"FFFF0000\" . [optional]  # noqa: E501
            huawei_accent_color (str, none_type): Channel: Push Notifications Platform: Huawei Accent Color used on Action Buttons and Group overflow count. Uses RGB Hex value (E.g. #9900FF). Defaults to device's theme color if not set. . [optional]  # noqa: E501
            android_visibility (int, none_type): Channel: Push Notifications Platform: Android 5.0_ &#9888;&#65039;Deprecated, this field doesn't work on Android 8 (Oreo) and newer devices! Please use Notification Categories / Channels noted above instead to support ALL versions of Android. 1 = Public (default) (Shows the full message on the lock screen unless the user has disabled all notifications from showing on the lock screen. Please consider the user and mark private if the contents are.) 0 = Private (Hides message contents on lock screen if the user set \"Hide sensitive notification content\" in the system settings) -1 = Secret (Notification does not show on the lock screen at all) . [optional]  # noqa: E501
            huawei_visibility (int, none_type): Channel: Push Notifications Platform: Huawei &#9888;&#65039;Deprecated, this field ONLY works on EMUI 5 (Android 7 based) and older devices. Please also set Notification Categories / Channels noted above to support EMUI 8 (Android 8 based) devices. 1 = Public (default) (Shows the full message on the lock screen unless the user has disabled all notifications from showing on the lock screen. Please consider the user and mark private if the contents are.) 0 = Private (Hides message contents on lock screen if the user set \"Hide sensitive notification content\" in the system settings) -1 = Secret (Notification does not show on the lock screen at all) . [optional]  # noqa: E501
            ios_badge_type (str, none_type): Channel: Push Notifications Platform: iOS Describes whether to set or increase/decrease your app's iOS badge count by the ios_badgeCount specified count. Can specify None, SetTo, or Increase. `None` leaves the count unaffected. `SetTo` directly sets the badge count to the number specified in ios_badgeCount. `Increase` adds the number specified in ios_badgeCount to the total. Use a negative number to decrease the badge count. . [optional]  # noqa: E501
            ios_badge_count (int, none_type): Channel: Push Notifications Platform: iOS Used with ios_badgeType, describes the value to set or amount to increase/decrease your app's iOS badge count by. You can use a negative number to decrease the badge count when used with an ios_badgeType of Increase. . [optional]  # noqa: E501
            collapse_id (str): Channel: Push Notifications Platform: iOS 10+, Android Only one notification with the same id will be shown on the device. Use the same id to update an existing notification instead of showing a new one. Limit of 64 characters. . [optional]  # noqa: E501
            web_push_topic (str, none_type): Channel: Push Notifications Platform: All Browsers Display multiple notifications at once with different topics. . [optional]  # noqa: E501
            apns_alert ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Channel: Push Notifications Platform: iOS 10+ iOS can localize push notification messages on the client using special parameters such as loc-key. When using the Create Notification endpoint, you must include these parameters inside of a field called apns_alert. Please see Apple's guide on localizing push notifications to learn more. . [optional]  # noqa: E501
            delayed_option (str, none_type): Channel: All Possible values are: timezone (Deliver at a specific time-of-day in each users own timezone) last-active Same as Intelligent Delivery . (Deliver at the same time of day as each user last used your app). If send_after is used, this takes effect after the send_after time has elapsed. . [optional]  # noqa: E501
            delivery_time_of_day (str, none_type): Channel: All Use with delayed_option=timezone. Examples: \"9:00AM\" \"21:45\" \"9:45:30\" . [optional]  # noqa: E501
            ttl (int, none_type): Channel: Push Notifications Platform: iOS, Android, Chrome, Firefox, Safari, ChromeWeb Time To Live - In seconds. The notification will be expired if the device does not come back online within this time. The default is 259,200 seconds (3 days). Max value to set is 2419200 seconds (28 days). . [optional]  # noqa: E501
            priority (int, none_type): Channel: Push Notifications Platform: Android, Chrome, ChromeWeb Delivery priority through the push server (example GCM/FCM). Pass 10 for high priority or any other integer for normal priority. Defaults to normal priority for Android and high for iOS. For Android 6.0+ devices setting priority to high will wake the device out of doze mode. . [optional]  # noqa: E501
            apns_push_type_override (str): Channel: Push Notifications Platform: iOS valid values: voip Set the value to voip for sending VoIP Notifications This field maps to the APNS header apns-push-type. Note: alert and background are automatically set by OneSignal . [optional]  # noqa: E501
            throttle_rate_per_minute (int, none_type): number of push notifications sent per minute. Paid Feature Only. If throttling is not enabled for the app or the notification, and for free accounts, null is returned. Refer to Throttling for more details.. [optional]  # noqa: E501
            android_group (str, none_type): Channel: Push Notifications Platform: Android Notifications with the same group will be stacked together using Android's Notification Grouping feature. . [optional]  # noqa: E501
            android_group_message (str, none_type): Channel: Push Notifications Platform: Android Note: This only works for Android 6 and older. Android 7+ allows full expansion of all message. Summary message to display when 2+ notifications are stacked together. Default is \"# new messages\". Include $[notif_count] in your message and it will be replaced with the current number. Languages - The value of each key is the message that will be sent to users for that language. \"en\" (English) is required. The key of each hash is either a a 2 character language code or one of zh-Hans/zh-Hant for Simplified or Traditional Chinese. Read more: supported languages. Example: {\"en\": \"You have $[notif_count] new messages\"} . [optional]  # noqa: E501
            adm_group (str, none_type): Channel: Push Notifications Platform: Amazon Notifications with the same group will be stacked together using Android's Notification Grouping feature. . [optional]  # noqa: E501
            adm_group_message ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Channel: Push Notifications Platform: Amazon Summary message to display when 2+ notifications are stacked together. Default is \"# new messages\". Include $[notif_count] in your message and it will be replaced with the current number. \"en\" (English) is required. The key of each hash is either a a 2 character language code or one of zh-Hans/zh-Hant for Simplified or Traditional Chinese. The value of each key is the message that will be sent to users for that language. Example: {\"en\": \"You have $[notif_count] new messages\"} . [optional]  # noqa: E501
            thread_id (str, none_type): Channel: Push Notifications Platform: iOS 12+ This parameter is supported in iOS 12 and above. It allows you to group related notifications together. If two notifications have the same thread-id, they will both be added to the same group. . [optional]  # noqa: E501
            summary_arg (str): Channel: Push Notifications Platform: iOS 12+ When using thread_id to create grouped notifications in iOS 12+, you can also control the summary. For example, a grouped notification can say \"12 more notifications from John Doe\". The summary_arg lets you set the name of the person/thing the notifications are coming from, and will show up as \"X more notifications from summary_arg\" . [optional]  # noqa: E501
            summary_arg_count (int): Channel: Push Notifications Platform: iOS 12+ When using thread_id, you can also control the count of the number of notifications in the group. For example, if the group already has 12 notifications, and you send a new notification with summary_arg_count = 2, the new total will be 14 and the summary will be \"14 more notifications from summary_arg\" . [optional]  # noqa: E501
            email_subject (str, none_type): Channel: Email Required.  The subject of the email. . [optional]  # noqa: E501
            email_body (str): Channel: Email Required unless template_id is set. HTML suported The body of the email you wish to send. Typically, customers include their own HTML templates here. Must include [unsubscribe_url] in an <a> tag somewhere in the email. Note: any malformed HTML content will be sent to users. Please double-check your HTML is valid. . [optional]  # noqa: E501
            email_from_name (str, none_type): Channel: Email The name the email is from. If not specified, will default to \"from name\" set in the OneSignal Dashboard Email Settings. . [optional]  # noqa: E501
            email_from_address (str, none_type): Channel: Email The email address the email is from. If not specified, will default to \"from email\" set in the OneSignal Dashboard Email Settings. . [optional]  # noqa: E501
            email_preheader (str, none_type): Channel: Email The preheader text of the email. Preheader is the preview text displayed immediately after an email subject that provides additional context about the email content. If not specified, will default to null. . [optional]  # noqa: E501
            include_unsubscribed (bool): Channel: Email Default is `false`. This field is used to send transactional notifications. If set to `true`, this notification will also be sent to unsubscribed emails. If a `template_id` is provided, the `include_unsubscribed` value from the template will be inherited. If you are using a third-party ESP, this field requires the ESP's list of unsubscribed emails to be cleared.. [optional]  # noqa: E501
            sms_from (str, none_type): Channel: SMS Phone Number used to send SMS. Should be a registered Twilio phone number in E.164 format. . [optional]  # noqa: E501
            sms_media_urls ([str], none_type): Channel: SMS URLs for the media files to be attached to the SMS content. Limit: 10 media urls with a total max. size of 5MBs. . [optional]  # noqa: E501
            filters ([Filter], none_type): [optional]  # noqa: E501
            custom_data ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Channel: All JSON object that can be used as a source of message personalization data for fields that support tag variable substitution. Push, SMS: Can accept up to 2048 bytes of valid JSON. Email: Can accept up to 10000 bytes of valid JSON. Example: {\"order_id\": 123, \"currency\": \"USD\", \"amount\": 25} . [optional]  # noqa: E501
            successful (int): Number of notifications that were successfully delivered.. [optional]  # noqa: E501
            failed (int): Number of notifications that could not be delivered due to those devices being unsubscribed.. [optional]  # noqa: E501
            errored (int): Number of notifications that could not be delivered due to an error. You can find more information by viewing the notification in the dashboard.. [optional]  # noqa: E501
            converted (int): Number of users who have clicked / tapped on your notification.. [optional]  # noqa: E501
            received (int, none_type): Confirmed Deliveries number of devices that received the push notification. Paid Feature Only. Free accounts will see 0.. [optional]  # noqa: E501
            outcomes ([OutcomeData]): [optional]  # noqa: E501
            remaining (int): Number of notifications that have not been sent out yet. This can mean either our system is still processing the notification or you have delayed options set.. [optional]  # noqa: E501
            queued_at (int): Unix timestamp indicating when the notification was created.. [optional]  # noqa: E501
            send_after (int, none_type): Unix timestamp indicating when notification delivery should begin.. [optional]  # noqa: E501
            completed_at (int, none_type): Unix timestamp indicating when notification delivery completed. The delivery duration from start to finish can be calculated with completed_at - send_after.. [optional]  # noqa: E501
            platform_delivery_stats (PlatformDeliveryData): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """NotificationWithMeta - a model defined in OpenAPI

        Keyword Args:
            app_id (str): Required: Your OneSignal Application ID, which can be found in Keys & IDs. It is a UUID and looks similar to 8250eaf6-1a58-489e-b136-7c74a864b434. 
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            included_segments ([str]): The segment names you want to target. Users in these segments will receive a notification. This targeting parameter is only compatible with excluded_segments. Example: [\"Active Users\", \"Inactive Users\"] . [optional]  # noqa: E501
            excluded_segments ([str]): Segment that will be excluded when sending. Users in these segments will not receive a notification, even if they were included in included_segments. This targeting parameter is only compatible with included_segments. Example: [\"Active Users\", \"Inactive Users\"] . [optional]  # noqa: E501
            include_player_ids ([str], none_type): Specific playerids to send your notification to. _Does not require API Auth Key. Do not combine with other targeting parameters. Not compatible with any other targeting parameters. Example: [\"1dd608f2-c6a1-11e3-851d-000c2940e62c\"] Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_external_user_ids ([str], none_type): Target specific devices by custom user IDs assigned via API. Not compatible with any other targeting parameters Example: [\"custom-id-assigned-by-api\"] REQUIRED: REST API Key Authentication Limit of 2,000 entries per REST API call. Note: If targeting push, email, or sms subscribers with same ids, use with channel_for_external_user_ids to indicate you are sending a push or email or sms. . [optional]  # noqa: E501
            include_email_tokens ([str]): Recommended for Sending Emails - Target specific email addresses. If an email does not correspond to an existing user, a new user will be created. Example: nick@catfac.ts Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_phone_numbers ([str]): Recommended for Sending SMS - Target specific phone numbers. The phone number should be in the E.164 format. Phone number should be an existing subscriber on OneSignal. Refer our docs to learn how to add phone numbers to OneSignal. Example phone number: +1999999999 Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_ios_tokens ([str]): Not Recommended: Please consider using include_player_ids or include_external_user_ids instead. Target using iOS device tokens. Warning: Only works with Production tokens. All non-alphanumeric characters must be removed from each token. If a token does not correspond to an existing user, a new user will be created. Example: ce777617da7f548fe7a9ab6febb56cf39fba6d38203... Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_wp_wns_uris ([str]): Not Recommended: Please consider using include_player_ids or include_external_user_ids instead. Target using Windows URIs. If a token does not correspond to an existing user, a new user will be created. Example: http://s.notify.live.net/u/1/bn1/HmQAAACPaLDr-... Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_amazon_reg_ids ([str]): Not Recommended: Please consider using include_player_ids or include_external_user_ids instead. Target using Amazon ADM registration IDs. If a token does not correspond to an existing user, a new user will be created. Example: amzn1.adm-registration.v1.XpvSSUk0Rc3hTVVV... Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_chrome_reg_ids ([str]): Not Recommended: Please consider using include_player_ids or include_external_user_ids instead. Target using Chrome App registration IDs. If a token does not correspond to an existing user, a new user will be created. Example: APA91bEeiUeSukAAUdnw3O2RB45FWlSpgJ7Ji_... Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_chrome_web_reg_ids ([str]): Not Recommended: Please consider using include_player_ids or include_external_user_ids instead. Target using Chrome Web Push registration IDs. If a token does not correspond to an existing user, a new user will be created. Example: APA91bEeiUeSukAAUdnw3O2RB45FWlSpgJ7Ji_... Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_android_reg_ids ([str]): Not Recommended: Please consider using include_player_ids or include_external_user_ids instead. Target using Android device registration IDs. If a token does not correspond to an existing user, a new user will be created. Example: APA91bEeiUeSukAAUdnw3O2RB45FWlSpgJ7Ji_... Limit of 2,000 entries per REST API call . [optional]  # noqa: E501
            include_aliases (PlayerNotificationTargetIncludeAliases): [optional]  # noqa: E501
            target_channel (str): [optional]  # noqa: E501
            id (str): [optional]  # noqa: E501
            value (int): [optional]  # noqa: E501
            name (str, none_type): Required for SMS Messages. An identifier for tracking message within the OneSignal dashboard or export analytics. Not shown to end user.. [optional]  # noqa: E501
            aggregation (str): [optional]  # noqa: E501
            is_ios (bool, none_type): Indicates whether to send to all devices registered under your app's Apple iOS platform.. [optional]  # noqa: E501
            is_android (bool, none_type): Indicates whether to send to all devices registered under your app's Google Android platform.. [optional]  # noqa: E501
            is_huawei (bool, none_type): Indicates whether to send to all devices registered under your app's Huawei Android platform.. [optional]  # noqa: E501
            is_any_web (bool, none_type): Indicates whether to send to all subscribed web browser users, including Chrome, Firefox, and Safari. You may use this instead as a combined flag instead of separately enabling isChromeWeb, isFirefox, and isSafari, though the three options are equivalent to this one. . [optional]  # noqa: E501
            is_chrome_web (bool, none_type): Indicates whether to send to all Google Chrome, Chrome on Android, and Mozilla Firefox users registered under your Chrome & Firefox web push platform.. [optional]  # noqa: E501
            is_firefox (bool, none_type): Indicates whether to send to all Mozilla Firefox desktop users registered under your Firefox web push platform.. [optional]  # noqa: E501
            is_safari (bool, none_type): Does not support iOS Safari. Indicates whether to send to all Apple's Safari desktop users registered under your Safari web push platform. Read more iOS Safari. [optional]  # noqa: E501
            is_wp_wns (bool, none_type): Indicates whether to send to all devices registered under your app's Windows platform.. [optional]  # noqa: E501
            is_adm (bool, none_type): Indicates whether to send to all devices registered under your app's Amazon Fire platform.. [optional]  # noqa: E501
            is_chrome (bool, none_type): This flag is not used for web push Please see isChromeWeb for sending to web push users. This flag only applies to Google Chrome Apps & Extensions. Indicates whether to send to all devices registered under your app's Google Chrome Apps & Extension platform. . [optional]  # noqa: E501
            channel_for_external_user_ids (str): Indicates if the message type when targeting with include_external_user_ids for cases where an email, sms, and/or push subscribers have the same external user id. Example: Use the string \"push\" to indicate you are sending a push notification or the string \"email\"for sending emails or \"sms\"for sending SMS. . [optional]  # noqa: E501
            external_id (str, none_type): Correlation and idempotency key. A request received with this parameter will first look for another notification with the same external_id. If one exists, a notification will not be sent, and result of the previous operation will instead be returned. Therefore, if you plan on using this feature, it's important to use a good source of randomness to generate the UUID passed here. This key is only idempotent for 30 days. After 30 days, the notification could be removed from our system and a notification with the same external_id will be sent again.   See Idempotent Notification Requests for more details writeOnly: true . [optional]  # noqa: E501
            contents (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            headings (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            subtitle (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            data ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Channel: Push Notifications Platform: Huawei A custom map of data that is passed back to your app. Same as using Additional Data within the dashboard. Can use up to 2048 bytes of data. Example: {\"abc\": 123, \"foo\": \"bar\", \"event_performed\": true, \"amount\": 12.1} . [optional]  # noqa: E501
            huawei_msg_type (str, none_type): Channel: Push Notifications Platform: Huawei Use \"data\" or \"message\" depending on the type of notification you are sending. More details in Data & Background Notifications. . [optional]  # noqa: E501
            url (str, none_type): Channel: Push Notifications Platform: All The URL to open in the browser when a user clicks on the notification. Note: iOS needs https or updated NSAppTransportSecurity in plist This field supports inline substitutions. Omit if including web_url or app_url Example: https://onesignal.com . [optional]  # noqa: E501
            web_url (str, none_type): Channel: Push Notifications Platform: All Browsers Same as url but only sent to web push platforms. Including Chrome, Firefox, Safari, Opera, etc. Example: https://onesignal.com . [optional]  # noqa: E501
            app_url (str, none_type): Channel: Push Notifications Platform: All Browsers Same as url but only sent to web push platforms. Including iOS, Android, macOS, Windows, ChromeApps, etc. Example: https://onesignal.com . [optional]  # noqa: E501
            ios_attachments ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Channel: Push Notifications Platform: iOS 10+ Adds media attachments to notifications. Set as JSON object, key as a media id of your choice and the value as a valid local filename or URL. User must press and hold on the notification to view. Do not set mutable_content to download attachments. The OneSignal SDK does this automatically Example: {\"id1\": \"https://domain.com/image.jpg\"} . [optional]  # noqa: E501
            template_id (str, none_type): Channel: Push Notifications Platform: All Use a template you setup on our dashboard. The template_id is the UUID found in the URL when viewing a template on our dashboard. Example: be4a8044-bbd6-11e4-a581-000c2940e62c . [optional]  # noqa: E501
            content_available (bool, none_type): Channel: Push Notifications Platform: iOS Sending true wakes your app from background to run custom native code (Apple interprets this as content-available=1). Note: Not applicable if the app is in the \"force-quit\" state (i.e app was swiped away). Omit the contents field to prevent displaying a visible notification. . [optional]  # noqa: E501
            mutable_content (bool): Channel: Push Notifications Platform: iOS 10+ Always defaults to true and cannot be turned off. Allows tracking of notification receives and changing of the notification content in your app before it is displayed. Triggers didReceive(_:withContentHandler:) on your UNNotificationServiceExtension. . [optional]  # noqa: E501
            target_content_identifier (str, none_type): Channel: Push Notifications Platform: iOS 13+ Use to target a specific experience in your App Clip, or to target your notification to a specific window in a multi-scene App. . [optional]  # noqa: E501
            big_picture (str, none_type): Channel: Push Notifications Platform: Android Picture to display in the expanded view. Can be a drawable resource name or a URL. . [optional]  # noqa: E501
            huawei_big_picture (str, none_type): Channel: Push Notifications Platform: Huawei Picture to display in the expanded view. Can be a drawable resource name or a URL. . [optional]  # noqa: E501
            adm_big_picture (str, none_type): Channel: Push Notifications Platform: Amazon Picture to display in the expanded view. Can be a drawable resource name or a URL. . [optional]  # noqa: E501
            chrome_big_picture (str, none_type): Channel: Push Notifications Platform: ChromeApp Large picture to display below the notification text. Must be a local URL. . [optional]  # noqa: E501
            chrome_web_image (str, none_type): Channel: Push Notifications Platform: Chrome 56+ Sets the web push notification's large image to be shown below the notification's title and text. Please see Web Push Notification Icons. . [optional]  # noqa: E501
            buttons ([Button], none_type): Channel: Push Notifications Platform: iOS 8.0+, Android 4.1+, and derivatives like Amazon Buttons to add to the notification. Icon only works for Android. Buttons show in reverse order of array position i.e. Last item in array shows as first button on device. Example: [{\"id\": \"id2\", \"text\": \"second button\", \"icon\": \"ic_menu_share\"}, {\"id\": \"id1\", \"text\": \"first button\", \"icon\": \"ic_menu_send\"}] . [optional]  # noqa: E501
            web_buttons ([Button], none_type): Channel: Push Notifications Platform: Chrome 48+ Add action buttons to the notification. The id field is required. Example: [{\"id\": \"like-button\", \"text\": \"Like\", \"icon\": \"http://i.imgur.com/N8SN8ZS.png\", \"url\": \"https://yoursite.com\"}, {\"id\": \"read-more-button\", \"text\": \"Read more\", \"icon\": \"http://i.imgur.com/MIxJp1L.png\", \"url\": \"https://yoursite.com\"}] . [optional]  # noqa: E501
            ios_category (str, none_type): Channel: Push Notifications Platform: iOS Category APS payload, use with registerUserNotificationSettings:categories in your Objective-C / Swift code. Example: calendar category which contains actions like accept and decline iOS 10+ This will trigger your UNNotificationContentExtension whose ID matches this category. . [optional]  # noqa: E501
            android_channel_id (str): Channel: Push Notifications Platform: Android The Android Oreo Notification Category to send the notification under. See the Category documentation on creating one and getting it's id. . [optional]  # noqa: E501
            huawei_channel_id (str, none_type): Channel: Push Notifications Platform: Huawei The Android Oreo Notification Category to send the notification under. See the Category documentation on creating one and getting it's id. . [optional]  # noqa: E501
            existing_android_channel_id (str): Channel: Push Notifications Platform: Android Use this if you have client side Android Oreo Channels you have already defined in your app with code. . [optional]  # noqa: E501
            huawei_existing_channel_id (str, none_type): Channel: Push Notifications Platform: Huawei Use this if you have client side Android Oreo Channels you have already defined in your app with code. . [optional]  # noqa: E501
            android_background_layout (BasicNotificationAllOfAndroidBackgroundLayout): [optional]  # noqa: E501
            small_icon (str, none_type): Channel: Push Notifications Platform: Android Icon shown in the status bar and on the top left of the notification. If not set a bell icon will be used or ic_stat_onesignal_default if you have set this resource name. See: How to create small icons . [optional]  # noqa: E501
            huawei_small_icon (str, none_type): Channel: Push Notifications Platform: Huawei Icon shown in the status bar and on the top left of the notification. Use an Android resource path (E.g. /drawable/small_icon). Defaults to your app icon if not set. . [optional]  # noqa: E501
            large_icon (str, none_type): Channel: Push Notifications Platform: Android Can be a drawable resource name or a URL. See: How to create large icons . [optional]  # noqa: E501
            huawei_large_icon (str, none_type): Channel: Push Notifications Platform: Huawei Can be a drawable resource name or a URL. See: How to create large icons . [optional]  # noqa: E501
            adm_small_icon (str, none_type): Channel: Push Notifications Platform: Amazon If not set a bell icon will be used or ic_stat_onesignal_default if you have set this resource name. See: How to create small icons . [optional]  # noqa: E501
            adm_large_icon (str, none_type): Channel: Push Notifications Platform: Amazon If blank the small_icon is used. Can be a drawable resource name or a URL. See: How to create large icons . [optional]  # noqa: E501
            chrome_web_icon (str, none_type): Channel: Push Notifications Platform: Chrome Sets the web push notification's icon. An image URL linking to a valid image. Common image types are supported; GIF will not animate. We recommend 256x256 (at least 80x80) to display well on high DPI devices. Firefox will also use this icon, unless you specify firefox_icon. . [optional]  # noqa: E501
            chrome_web_badge (str, none_type): Channel: Push Notifications Platform: Chrome Sets the web push notification icon for Android devices in the notification shade. Please see Web Push Notification Badge. . [optional]  # noqa: E501
            firefox_icon (str, none_type): Channel: Push Notifications Platform: Firefox Not recommended Few people need to set Firefox-specific icons. We recommend setting chrome_web_icon instead, which Firefox will also use. Sets the web push notification's icon for Firefox. An image URL linking to a valid image. Common image types are supported; GIF will not animate. We recommend 256x256 (at least 80x80) to display well on high DPI devices. . [optional]  # noqa: E501
            chrome_icon (str, none_type): Channel: Push Notifications Platform: ChromeApp This flag is not used for web push For web push, please see chrome_web_icon instead. The local URL to an icon to use. If blank, the app icon will be used. . [optional]  # noqa: E501
            ios_sound (str, none_type): Channel: Push Notifications Platform: iOS Sound file that is included in your app to play instead of the default device notification sound. Pass nil to disable vibration and sound for the notification. Example: \"notification.wav\" . [optional]  # noqa: E501
            android_sound (str, none_type): Channel: Push Notifications Platform: Android &#9888;&#65039;Deprecated, this field doesn't work on Android 8 (Oreo) and newer devices! Please use Notification Categories / Channels noted above instead to support ALL versions of Android. Sound file that is included in your app to play instead of the default device notification sound. Pass nil to disable sound for the notification. NOTE: Leave off file extension for Android. Example: \"notification\" . [optional]  # noqa: E501
            huawei_sound (str, none_type): Channel: Push Notifications Platform: Huawei &#9888;&#65039;Deprecated, this field ONLY works on EMUI 5 (Android 7 based) and older devices. Please also set Notification Categories / Channels noted above to support EMUI 8 (Android 8 based) devices. Sound file that is included in your app to play instead of the default device notification sound. NOTE: Leave off file extension for and include the full path.  Example: \"/res/raw/notification\" . [optional]  # noqa: E501
            adm_sound (str, none_type): Channel: Push Notifications Platform: Amazon &#9888;&#65039;Deprecated, this field doesn't work on Android 8 (Oreo) and newer devices! Please use Notification Categories / Channels noted above instead to support ALL versions of Android. Sound file that is included in your app to play instead of the default device notification sound. Pass nil to disable sound for the notification. NOTE: Leave off file extension for Android. Example: \"notification\" . [optional]  # noqa: E501
            wp_wns_sound (str, none_type): Channel: Push Notifications Platform: Windows Sound file that is included in your app to play instead of the default device notification sound. Example: \"notification.wav\" . [optional]  # noqa: E501
            android_led_color (str, none_type): Channel: Push Notifications Platform: Android &#9888;&#65039;Deprecated, this field doesn't work on Android 8 (Oreo) and newer devices! Please use Notification Categories / Channels noted above instead to support ALL versions of Android. Sets the devices LED notification light if the device has one. ARGB Hex format. Example(Blue): \"FF0000FF\" . [optional]  # noqa: E501
            huawei_led_color (str, none_type): Channel: Push Notifications Platform: Huawei &#9888;&#65039;Deprecated, this field ONLY works on EMUI 5 (Android 7 based) and older devices. Please also set Notification Categories / Channels noted above to support EMUI 8 (Android 8 based) devices. Sets the devices LED notification light if the device has one. RGB Hex format. Example(Blue): \"0000FF\" . [optional]  # noqa: E501
            android_accent_color (str, none_type): Channel: Push Notifications Platform: Android Sets the background color of the notification circle to the left of the notification text. Only applies to apps targeting Android API level 21+ on Android 5.0+ devices. Example(Red): \"FFFF0000\" . [optional]  # noqa: E501
            huawei_accent_color (str, none_type): Channel: Push Notifications Platform: Huawei Accent Color used on Action Buttons and Group overflow count. Uses RGB Hex value (E.g. #9900FF). Defaults to device's theme color if not set. . [optional]  # noqa: E501
            android_visibility (int, none_type): Channel: Push Notifications Platform: Android 5.0_ &#9888;&#65039;Deprecated, this field doesn't work on Android 8 (Oreo) and newer devices! Please use Notification Categories / Channels noted above instead to support ALL versions of Android. 1 = Public (default) (Shows the full message on the lock screen unless the user has disabled all notifications from showing on the lock screen. Please consider the user and mark private if the contents are.) 0 = Private (Hides message contents on lock screen if the user set \"Hide sensitive notification content\" in the system settings) -1 = Secret (Notification does not show on the lock screen at all) . [optional]  # noqa: E501
            huawei_visibility (int, none_type): Channel: Push Notifications Platform: Huawei &#9888;&#65039;Deprecated, this field ONLY works on EMUI 5 (Android 7 based) and older devices. Please also set Notification Categories / Channels noted above to support EMUI 8 (Android 8 based) devices. 1 = Public (default) (Shows the full message on the lock screen unless the user has disabled all notifications from showing on the lock screen. Please consider the user and mark private if the contents are.) 0 = Private (Hides message contents on lock screen if the user set \"Hide sensitive notification content\" in the system settings) -1 = Secret (Notification does not show on the lock screen at all) . [optional]  # noqa: E501
            ios_badge_type (str, none_type): Channel: Push Notifications Platform: iOS Describes whether to set or increase/decrease your app's iOS badge count by the ios_badgeCount specified count. Can specify None, SetTo, or Increase. `None` leaves the count unaffected. `SetTo` directly sets the badge count to the number specified in ios_badgeCount. `Increase` adds the number specified in ios_badgeCount to the total. Use a negative number to decrease the badge count. . [optional]  # noqa: E501
            ios_badge_count (int, none_type): Channel: Push Notifications Platform: iOS Used with ios_badgeType, describes the value to set or amount to increase/decrease your app's iOS badge count by. You can use a negative number to decrease the badge count when used with an ios_badgeType of Increase. . [optional]  # noqa: E501
            collapse_id (str): Channel: Push Notifications Platform: iOS 10+, Android Only one notification with the same id will be shown on the device. Use the same id to update an existing notification instead of showing a new one. Limit of 64 characters. . [optional]  # noqa: E501
            web_push_topic (str, none_type): Channel: Push Notifications Platform: All Browsers Display multiple notifications at once with different topics. . [optional]  # noqa: E501
            apns_alert ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Channel: Push Notifications Platform: iOS 10+ iOS can localize push notification messages on the client using special parameters such as loc-key. When using the Create Notification endpoint, you must include these parameters inside of a field called apns_alert. Please see Apple's guide on localizing push notifications to learn more. . [optional]  # noqa: E501
            delayed_option (str, none_type): Channel: All Possible values are: timezone (Deliver at a specific time-of-day in each users own timezone) last-active Same as Intelligent Delivery . (Deliver at the same time of day as each user last used your app). If send_after is used, this takes effect after the send_after time has elapsed. . [optional]  # noqa: E501
            delivery_time_of_day (str, none_type): Channel: All Use with delayed_option=timezone. Examples: \"9:00AM\" \"21:45\" \"9:45:30\" . [optional]  # noqa: E501
            ttl (int, none_type): Channel: Push Notifications Platform: iOS, Android, Chrome, Firefox, Safari, ChromeWeb Time To Live - In seconds. The notification will be expired if the device does not come back online within this time. The default is 259,200 seconds (3 days). Max value to set is 2419200 seconds (28 days). . [optional]  # noqa: E501
            priority (int, none_type): Channel: Push Notifications Platform: Android, Chrome, ChromeWeb Delivery priority through the push server (example GCM/FCM). Pass 10 for high priority or any other integer for normal priority. Defaults to normal priority for Android and high for iOS. For Android 6.0+ devices setting priority to high will wake the device out of doze mode. . [optional]  # noqa: E501
            apns_push_type_override (str): Channel: Push Notifications Platform: iOS valid values: voip Set the value to voip for sending VoIP Notifications This field maps to the APNS header apns-push-type. Note: alert and background are automatically set by OneSignal . [optional]  # noqa: E501
            throttle_rate_per_minute (int, none_type): number of push notifications sent per minute. Paid Feature Only. If throttling is not enabled for the app or the notification, and for free accounts, null is returned. Refer to Throttling for more details.. [optional]  # noqa: E501
            android_group (str, none_type): Channel: Push Notifications Platform: Android Notifications with the same group will be stacked together using Android's Notification Grouping feature. . [optional]  # noqa: E501
            android_group_message (str, none_type): Channel: Push Notifications Platform: Android Note: This only works for Android 6 and older. Android 7+ allows full expansion of all message. Summary message to display when 2+ notifications are stacked together. Default is \"# new messages\". Include $[notif_count] in your message and it will be replaced with the current number. Languages - The value of each key is the message that will be sent to users for that language. \"en\" (English) is required. The key of each hash is either a a 2 character language code or one of zh-Hans/zh-Hant for Simplified or Traditional Chinese. Read more: supported languages. Example: {\"en\": \"You have $[notif_count] new messages\"} . [optional]  # noqa: E501
            adm_group (str, none_type): Channel: Push Notifications Platform: Amazon Notifications with the same group will be stacked together using Android's Notification Grouping feature. . [optional]  # noqa: E501
            adm_group_message ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Channel: Push Notifications Platform: Amazon Summary message to display when 2+ notifications are stacked together. Default is \"# new messages\". Include $[notif_count] in your message and it will be replaced with the current number. \"en\" (English) is required. The key of each hash is either a a 2 character language code or one of zh-Hans/zh-Hant for Simplified or Traditional Chinese. The value of each key is the message that will be sent to users for that language. Example: {\"en\": \"You have $[notif_count] new messages\"} . [optional]  # noqa: E501
            thread_id (str, none_type): Channel: Push Notifications Platform: iOS 12+ This parameter is supported in iOS 12 and above. It allows you to group related notifications together. If two notifications have the same thread-id, they will both be added to the same group. . [optional]  # noqa: E501
            summary_arg (str): Channel: Push Notifications Platform: iOS 12+ When using thread_id to create grouped notifications in iOS 12+, you can also control the summary. For example, a grouped notification can say \"12 more notifications from John Doe\". The summary_arg lets you set the name of the person/thing the notifications are coming from, and will show up as \"X more notifications from summary_arg\" . [optional]  # noqa: E501
            summary_arg_count (int): Channel: Push Notifications Platform: iOS 12+ When using thread_id, you can also control the count of the number of notifications in the group. For example, if the group already has 12 notifications, and you send a new notification with summary_arg_count = 2, the new total will be 14 and the summary will be \"14 more notifications from summary_arg\" . [optional]  # noqa: E501
            email_subject (str, none_type): Channel: Email Required.  The subject of the email. . [optional]  # noqa: E501
            email_body (str): Channel: Email Required unless template_id is set. HTML suported The body of the email you wish to send. Typically, customers include their own HTML templates here. Must include [unsubscribe_url] in an <a> tag somewhere in the email. Note: any malformed HTML content will be sent to users. Please double-check your HTML is valid. . [optional]  # noqa: E501
            email_from_name (str, none_type): Channel: Email The name the email is from. If not specified, will default to \"from name\" set in the OneSignal Dashboard Email Settings. . [optional]  # noqa: E501
            email_from_address (str, none_type): Channel: Email The email address the email is from. If not specified, will default to \"from email\" set in the OneSignal Dashboard Email Settings. . [optional]  # noqa: E501
            email_preheader (str, none_type): Channel: Email The preheader text of the email. Preheader is the preview text displayed immediately after an email subject that provides additional context about the email content. If not specified, will default to null. . [optional]  # noqa: E501
            include_unsubscribed (bool): Channel: Email Default is `false`. This field is used to send transactional notifications. If set to `true`, this notification will also be sent to unsubscribed emails. If a `template_id` is provided, the `include_unsubscribed` value from the template will be inherited. If you are using a third-party ESP, this field requires the ESP's list of unsubscribed emails to be cleared.. [optional]  # noqa: E501
            sms_from (str, none_type): Channel: SMS Phone Number used to send SMS. Should be a registered Twilio phone number in E.164 format. . [optional]  # noqa: E501
            sms_media_urls ([str], none_type): Channel: SMS URLs for the media files to be attached to the SMS content. Limit: 10 media urls with a total max. size of 5MBs. . [optional]  # noqa: E501
            filters ([Filter], none_type): [optional]  # noqa: E501
            custom_data ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Channel: All JSON object that can be used as a source of message personalization data for fields that support tag variable substitution. Push, SMS: Can accept up to 2048 bytes of valid JSON. Email: Can accept up to 10000 bytes of valid JSON. Example: {\"order_id\": 123, \"currency\": \"USD\", \"amount\": 25} . [optional]  # noqa: E501
            successful (int): Number of notifications that were successfully delivered.. [optional]  # noqa: E501
            failed (int): Number of notifications that could not be delivered due to those devices being unsubscribed.. [optional]  # noqa: E501
            errored (int): Number of notifications that could not be delivered due to an error. You can find more information by viewing the notification in the dashboard.. [optional]  # noqa: E501
            converted (int): Number of users who have clicked / tapped on your notification.. [optional]  # noqa: E501
            received (int, none_type): Confirmed Deliveries number of devices that received the push notification. Paid Feature Only. Free accounts will see 0.. [optional]  # noqa: E501
            outcomes ([OutcomeData]): [optional]  # noqa: E501
            remaining (int): Number of notifications that have not been sent out yet. This can mean either our system is still processing the notification or you have delayed options set.. [optional]  # noqa: E501
            queued_at (int): Unix timestamp indicating when the notification was created.. [optional]  # noqa: E501
            send_after (int, none_type): Unix timestamp indicating when notification delivery should begin.. [optional]  # noqa: E501
            completed_at (int, none_type): Unix timestamp indicating when notification delivery completed. The delivery duration from start to finish can be calculated with completed_at - send_after.. [optional]  # noqa: E501
            platform_delivery_stats (PlatformDeliveryData): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              BasicNotification,
              DeliveryData,
              NotificationWithMetaAllOf,
              OutcomesData,
          ],
          'oneOf': [
          ],
        }
