from typing import Dict

FNAT_THRESHOLD: float = 5.0
FNAT_THRESHOLD_PEPTIDE: float = 4.0
INTERFACE_THRESHOLD: float = 10.0
INTERFACE_THRESHOLD_PEPTIDE: float = 8.0
CLASH_THRESHOLD: float = 2.0
BOND_TOLERANCE: float = 0.4

# Taken from "Beatriz Cordero, Verónica Gómez, Ana E. Platero-Prats, Marc Revés,
# Jorge Echeverría, Eduard Cremades, Flavia Barragán and Santiago Alvarez (2008).
# "Covalent radii revisited". Dalton Trans. (21): 2832–2838
COVALENT_RADIUS: Dict = {
    "H": 0.31,
    "HE": 0.28,
    "LI": 1.28,
    "BE": 0.96,
    "B": 0.84,
    "C": 0.76,
    "N": 0.71,
    "O": 0.66,
    "F": 0.57,
    "NE": 0.58,
    "NA": 1.66,
    "MG": 1.41,
    "AL": 1.21,
    "SI": 1.11,
    "P": 1.07,
    "S": 1.05,
    "CL": 1.02,
    "AR": 1.06,
    "K": 2.03,
    "CA": 1.76,
    "SC": 1.7,
    "TI": 1.6,
    "V": 1.53,
    "CR": 1.39,
    "MN": 1.5,
    "FE": 1.42,
    "CO": 1.38,
    "NI": 1.24,
    "CU": 1.32,
    "ZN": 1.22,
    "GA": 1.22,
    "GE": 1.2,
    "AS": 1.19,
    "SE": 1.2,
    "BR": 1.2,
    "KR": 1.16,
    "RB": 2.2,
    "SR": 1.95,
    "Y": 1.9,
    "ZR": 1.75,
    "NB": 1.64,
    "MO": 1.54,
    "TC": 1.47,
    "RU": 1.46,
    "RH": 1.42,
    "PD": 1.39,
    "AG": 1.45,
    "CD": 1.44,
    "IN": 1.42,
    "SN": 1.39,
    "SB": 1.39,
    "TE": 1.38,
    "I": 1.39,
    "XE": 1.4,
    "CS": 2.44,
    "BA": 2.15,
    "LA": 2.07,
    "CE": 2.04,
    "PR": 2.03,
    "ND": 2.01,
    "PM": 1.99,
    "SM": 1.98,
    "EU": 1.98,
    "GD": 1.96,
    "TB": 1.94,
    "DY": 1.92,
    "HO": 1.92,
    "ER": 1.89,
    "TM": 1.9,
    "YB": 1.87,
    "LU": 1.87,
    "HF": 1.75,
    "TA": 1.7,
    "W": 1.62,
    "RE": 1.51,
    "OS": 1.44,
    "IR": 1.41,
    "PT": 1.36,
    "AU": 1.36,
    "HG": 1.32,
    "TL": 1.45,
    "PB": 1.46,
    "BI": 1.48,
    "PO": 1.4,
    "AT": 1.5,
    "RN": 1.5,
    "FR": 2.6,
    "RA": 2.21,
    "AC": 2.15,
    "TH": 2.06,
    "PA": 2.0,
    "U": 1.96,
    "NP": 1.9,
    "PU": 1.87,
    "AM": 1.8,
    "CM": 1.69,
    "BK": 2.0,
    "CF": 2.0,
    "ES": 2.0,
    "FM": 2.0,
    "MD": 2.0,
    "NO": 2.0,
    "LR": 2.0,
    "RF": 2.0,
    "DB": 2.0,
    "SG": 2.0,
    "BH": 2.0,
    "HS": 2.0,
    "MT": 2.0,
    "DS": 2.0,
    "RG": 2.0,
    "CN": 2.0,
    "UUT": 2.0,
    "UUQ": 2.0,
    "UUP": 2.0,
    "UUH": 2.0,
    "UUS": 2.0,
    "UUO": 2.0,
}

BACKBONE_ATOMS = (
    "CA",
    "C",
    "N",
    "O",
    "P",
    "OP1",
    "OP2",
    "O2'",
    "O3'",
    "O4'",
    "O5'",
    "C1'",
    "C2'",
    "C3'",
    "C4'",
    "C5'",
)
