# SPDX-FileCopyrightText: 2024 Heinz-Alexander Fütterer
#
# SPDX-License-Identifier: MIT

"""API resources for python-re3data."""

from re3data._resources.repository import (
    AccessRestrictions,
    AccessTypes,
    AdditionalName,
    AidSystems,
    Api,
    ApiTypes,
    Certificates,
    ContentType,
    ContentTypeScheme,
    ContentTypeText,
    Countries,
    DataAccess,
    DataAccessRestrictions,
    DataAccessTypes,
    DatabaseAccess,
    DatabaseLicense,
    DatabaseLicenseNames,
    DataLicense,
    DataLicenseNames,
    DataUpload,
    DataUploadLicense,
    DataUploadRestrictions,
    Description,
    Institution,
    InstitutionAdditionalName,
    InstitutionName,
    InstitutionTypes,
    Languages,
    MetadataStandard,
    MetadataStandardDccnames,
    MetadataStandardDccurls,
    MetadataStandardName,
    MetadataStandardScheme,
    PidSystems,
    Policy,
    ProviderTypes,
    Re3Data,
    Repository,
    RepositoryName,
    RepositoryTypes,
    ResponsibilityTypes,
    Size,
    Software,
    SoftwareNames,
    Subject,
    SubjectScheme,
    SubjectText,
    Syndication,
    SyndicationTypes,
    Yesno,
    Yesnoun,
)
from re3data._resources.repository_list import (
    Link,
    RepositoryList,
    RepositorySummary,
)

__all__ = [
    "AccessRestrictions",
    "AccessTypes",
    "AdditionalName",
    "AidSystems",
    "Api",
    "ApiTypes",
    "Certificates",
    "ContentType",
    "ContentTypeScheme",
    "ContentTypeText",
    "Countries",
    "DataAccess",
    "DataAccessRestrictions",
    "DataAccessTypes",
    "DataLicense",
    "DataLicenseNames",
    "DataUpload",
    "DataUploadLicense",
    "DataUploadRestrictions",
    "DatabaseAccess",
    "DatabaseLicense",
    "DatabaseLicenseNames",
    "Description",
    "Institution",
    "InstitutionAdditionalName",
    "InstitutionName",
    "InstitutionTypes",
    "Languages",
    "Link",
    "MetadataStandard",
    "MetadataStandardDccnames",
    "MetadataStandardDccurls",
    "MetadataStandardName",
    "MetadataStandardScheme",
    "PidSystems",
    "Policy",
    "ProviderTypes",
    "Re3Data",
    "Repository",
    "RepositoryList",
    "RepositoryName",
    "RepositorySummary",
    "RepositoryTypes",
    "ResponsibilityTypes",
    "Size",
    "Software",
    "SoftwareNames",
    "Subject",
    "SubjectScheme",
    "SubjectText",
    "Syndication",
    "SyndicationTypes",
    "Yesno",
    "Yesnoun",
]
