# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.1.0
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from fattureincloud_python_sdk.models.payment_account import PaymentAccount
from fattureincloud_python_sdk.models.payment_method_details import PaymentMethodDetails
from fattureincloud_python_sdk.models.payment_method_type import PaymentMethodType
from typing import Optional, Set
from typing_extensions import Self


class PaymentMethod(BaseModel):
    """
    PaymentMethod
    """  # noqa: E501

    id: Optional[StrictInt] = Field(default=None, description="Payment method id")
    name: Optional[StrictStr] = Field(default=None, description="Payment method name")
    type: Optional[PaymentMethodType] = None
    is_default: Optional[StrictBool] = Field(
        default=None, description="Payment method is default"
    )
    default_payment_account: Optional[PaymentAccount] = None
    details: Optional[Annotated[List[PaymentMethodDetails], Field(max_length=5)]] = (
        Field(default=None, description="Payment method details")
    )
    bank_iban: Optional[StrictStr] = Field(
        default=None, description="Payment method bank iban"
    )
    bank_name: Optional[StrictStr] = Field(
        default=None, description="Payment method bank name"
    )
    bank_beneficiary: Optional[StrictStr] = Field(
        default=None, description="Payment method bank beneficiary"
    )
    ei_payment_method: Optional[StrictStr] = Field(
        default=None, description="E-invoice payment method"
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "name",
        "type",
        "is_default",
        "default_payment_account",
        "details",
        "bank_iban",
        "bank_name",
        "bank_beneficiary",
        "ei_payment_method",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentMethod from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_payment_account
        if self.default_payment_account:
            _dict["default_payment_account"] = self.default_payment_account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in details (list)
        _items = []
        if self.details:
            for _item in self.details:
                if _item:
                    _items.append(_item.to_dict())
            _dict["details"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentMethod from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "name": obj.get("name"),
                "type": obj.get("type"),
                "is_default": obj.get("is_default"),
                "default_payment_account": (
                    PaymentAccount.from_dict(obj["default_payment_account"])
                    if obj.get("default_payment_account") is not None
                    else None
                ),
                "details": (
                    [PaymentMethodDetails.from_dict(_item) for _item in obj["details"]]
                    if obj.get("details") is not None
                    else None
                ),
                "bank_iban": obj.get("bank_iban"),
                "bank_name": obj.get("bank_name"),
                "bank_beneficiary": obj.get("bank_beneficiary"),
                "ei_payment_method": obj.get("ei_payment_method"),
            }
        )
        return _obj
