
import json

POOLREGISTRY_IMPLEMENTATION = json.loads("""
[
  {
    "inputs": [],
    "stateMutability": "nonpayable",
    "type": "constructor"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "sender",
        "type": "address"
      },
      {
        "internalType": "address",
        "name": "calledContract",
        "type": "address"
      },
      {
        "internalType": "string",
        "name": "methodSignature",
        "type": "string"
      }
    ],
    "name": "Unauthorized",
    "type": "error"
  },
  {
    "inputs": [],
    "name": "ZeroAddressNotAllowed",
    "type": "error"
  },
  {
    "anonymous": false,
    "inputs": [
      {
        "indexed": false,
        "internalType": "uint8",
        "name": "version",
        "type": "uint8"
      }
    ],
    "name": "Initialized",
    "type": "event"
  },
  {
    "anonymous": false,
    "inputs": [
      {
        "indexed": true,
        "internalType": "address",
        "name": "comptroller",
        "type": "address"
      },
      {
        "indexed": true,
        "internalType": "address",
        "name": "vTokenAddress",
        "type": "address"
      }
    ],
    "name": "MarketAdded",
    "type": "event"
  },
  {
    "anonymous": false,
    "inputs": [
      {
        "indexed": false,
        "internalType": "address",
        "name": "oldAccessControlManager",
        "type": "address"
      },
      {
        "indexed": false,
        "internalType": "address",
        "name": "newAccessControlManager",
        "type": "address"
      }
    ],
    "name": "NewAccessControlManager",
    "type": "event"
  },
  {
    "anonymous": false,
    "inputs": [
      {
        "indexed": true,
        "internalType": "address",
        "name": "previousOwner",
        "type": "address"
      },
      {
        "indexed": true,
        "internalType": "address",
        "name": "newOwner",
        "type": "address"
      }
    ],
    "name": "OwnershipTransferStarted",
    "type": "event"
  },
  {
    "anonymous": false,
    "inputs": [
      {
        "indexed": true,
        "internalType": "address",
        "name": "previousOwner",
        "type": "address"
      },
      {
        "indexed": true,
        "internalType": "address",
        "name": "newOwner",
        "type": "address"
      }
    ],
    "name": "OwnershipTransferred",
    "type": "event"
  },
  {
    "anonymous": false,
    "inputs": [
      {
        "indexed": true,
        "internalType": "address",
        "name": "comptroller",
        "type": "address"
      },
      {
        "components": [
          {
            "internalType": "string",
            "name": "category",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "logoURL",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "description",
            "type": "string"
          }
        ],
        "indexed": false,
        "internalType": "struct PoolRegistryInterface.VenusPoolMetaData",
        "name": "oldMetadata",
        "type": "tuple"
      },
      {
        "components": [
          {
            "internalType": "string",
            "name": "category",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "logoURL",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "description",
            "type": "string"
          }
        ],
        "indexed": false,
        "internalType": "struct PoolRegistryInterface.VenusPoolMetaData",
        "name": "newMetadata",
        "type": "tuple"
      }
    ],
    "name": "PoolMetadataUpdated",
    "type": "event"
  },
  {
    "anonymous": false,
    "inputs": [
      {
        "indexed": true,
        "internalType": "address",
        "name": "comptroller",
        "type": "address"
      },
      {
        "indexed": false,
        "internalType": "string",
        "name": "oldName",
        "type": "string"
      },
      {
        "indexed": false,
        "internalType": "string",
        "name": "newName",
        "type": "string"
      }
    ],
    "name": "PoolNameSet",
    "type": "event"
  },
  {
    "anonymous": false,
    "inputs": [
      {
        "indexed": true,
        "internalType": "address",
        "name": "comptroller",
        "type": "address"
      },
      {
        "components": [
          {
            "internalType": "string",
            "name": "name",
            "type": "string"
          },
          {
            "internalType": "address",
            "name": "creator",
            "type": "address"
          },
          {
            "internalType": "address",
            "name": "comptroller",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "blockPosted",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "timestampPosted",
            "type": "uint256"
          }
        ],
        "indexed": false,
        "internalType": "struct PoolRegistryInterface.VenusPool",
        "name": "pool",
        "type": "tuple"
      }
    ],
    "name": "PoolRegistered",
    "type": "event"
  },
  {
    "inputs": [],
    "name": "acceptOwnership",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function"
  },
  {
    "inputs": [],
    "name": "accessControlManager",
    "outputs": [
      {
        "internalType": "contract IAccessControlManagerV8",
        "name": "",
        "type": "address"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "components": [
          {
            "internalType": "contract VToken",
            "name": "vToken",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "collateralFactor",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "liquidationThreshold",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "initialSupply",
            "type": "uint256"
          },
          {
            "internalType": "address",
            "name": "vTokenReceiver",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "supplyCap",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "borrowCap",
            "type": "uint256"
          }
        ],
        "internalType": "struct PoolRegistry.AddMarketInput",
        "name": "input",
        "type": "tuple"
      }
    ],
    "name": "addMarket",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "string",
        "name": "name",
        "type": "string"
      },
      {
        "internalType": "contract Comptroller",
        "name": "comptroller",
        "type": "address"
      },
      {
        "internalType": "uint256",
        "name": "closeFactor",
        "type": "uint256"
      },
      {
        "internalType": "uint256",
        "name": "liquidationIncentive",
        "type": "uint256"
      },
      {
        "internalType": "uint256",
        "name": "minLiquidatableCollateral",
        "type": "uint256"
      }
    ],
    "name": "addPool",
    "outputs": [
      {
        "internalType": "uint256",
        "name": "index",
        "type": "uint256"
      }
    ],
    "stateMutability": "nonpayable",
    "type": "function"
  },
  {
    "inputs": [],
    "name": "getAllPools",
    "outputs": [
      {
        "components": [
          {
            "internalType": "string",
            "name": "name",
            "type": "string"
          },
          {
            "internalType": "address",
            "name": "creator",
            "type": "address"
          },
          {
            "internalType": "address",
            "name": "comptroller",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "blockPosted",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "timestampPosted",
            "type": "uint256"
          }
        ],
        "internalType": "struct PoolRegistryInterface.VenusPool[]",
        "name": "",
        "type": "tuple[]"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "comptroller",
        "type": "address"
      }
    ],
    "name": "getPoolByComptroller",
    "outputs": [
      {
        "components": [
          {
            "internalType": "string",
            "name": "name",
            "type": "string"
          },
          {
            "internalType": "address",
            "name": "creator",
            "type": "address"
          },
          {
            "internalType": "address",
            "name": "comptroller",
            "type": "address"
          },
          {
            "internalType": "uint256",
            "name": "blockPosted",
            "type": "uint256"
          },
          {
            "internalType": "uint256",
            "name": "timestampPosted",
            "type": "uint256"
          }
        ],
        "internalType": "struct PoolRegistryInterface.VenusPool",
        "name": "",
        "type": "tuple"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "asset",
        "type": "address"
      }
    ],
    "name": "getPoolsSupportedByAsset",
    "outputs": [
      {
        "internalType": "address[]",
        "name": "",
        "type": "address[]"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "comptroller",
        "type": "address"
      },
      {
        "internalType": "address",
        "name": "asset",
        "type": "address"
      }
    ],
    "name": "getVTokenForAsset",
    "outputs": [
      {
        "internalType": "address",
        "name": "",
        "type": "address"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "comptroller",
        "type": "address"
      }
    ],
    "name": "getVenusPoolMetadata",
    "outputs": [
      {
        "components": [
          {
            "internalType": "string",
            "name": "category",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "logoURL",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "description",
            "type": "string"
          }
        ],
        "internalType": "struct PoolRegistryInterface.VenusPoolMetaData",
        "name": "",
        "type": "tuple"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "accessControlManager_",
        "type": "address"
      }
    ],
    "name": "initialize",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "",
        "type": "address"
      }
    ],
    "name": "metadata",
    "outputs": [
      {
        "internalType": "string",
        "name": "category",
        "type": "string"
      },
      {
        "internalType": "string",
        "name": "logoURL",
        "type": "string"
      },
      {
        "internalType": "string",
        "name": "description",
        "type": "string"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [],
    "name": "owner",
    "outputs": [
      {
        "internalType": "address",
        "name": "",
        "type": "address"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [],
    "name": "pendingOwner",
    "outputs": [
      {
        "internalType": "address",
        "name": "",
        "type": "address"
      }
    ],
    "stateMutability": "view",
    "type": "function"
  },
  {
    "inputs": [],
    "name": "renounceOwnership",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "accessControlManager_",
        "type": "address"
      }
    ],
    "name": "setAccessControlManager",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "comptroller",
        "type": "address"
      },
      {
        "internalType": "string",
        "name": "name",
        "type": "string"
      }
    ],
    "name": "setPoolName",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "newOwner",
        "type": "address"
      }
    ],
    "name": "transferOwnership",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function"
  },
  {
    "inputs": [
      {
        "internalType": "address",
        "name": "comptroller",
        "type": "address"
      },
      {
        "components": [
          {
            "internalType": "string",
            "name": "category",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "logoURL",
            "type": "string"
          },
          {
            "internalType": "string",
            "name": "description",
            "type": "string"
          }
        ],
        "internalType": "struct PoolRegistryInterface.VenusPoolMetaData",
        "name": "metadata_",
        "type": "tuple"
      }
    ],
    "name": "updatePoolMetadata",
    "outputs": [],
    "stateMutability": "nonpayable",
    "type": "function"
  }
]
""")
        