/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.CallbackClient;
import py4j.Gateway;
import py4j.GatewayConnection;
import py4j.GatewayServerListener;
import py4j.NetworkUtil;
import py4j.Py4JNetworkException;
import py4j.commands.Command;

public class GatewayServer
implements Runnable {
    public static final int DEFAULT_PORT = 25333;
    public static final int DEFAULT_PYTHON_PORT = 25334;
    public static final int DEFAULT_CONNECT_TIMEOUT = 0;
    public static final int DEFAULT_READ_TIMEOUT = 0;
    public static final String GATEWAY_SERVER_ID = "GATEWAY_SERVER";
    private final int port;
    private final int pythonPort;
    private final Gateway gateway;
    private final int connectTimeout;
    private final int readTimeout;
    private final Logger logger = Logger.getLogger(GatewayServer.class.getName());
    private final List<Socket> connections = new ArrayList<Socket>();
    private final CallbackClient cbClient;
    private final List<Class<? extends Command>> customCommands;
    private final List<GatewayServerListener> listeners;
    private ServerSocket sSocket;

    public GatewayServer(Object entryPoint, int port, int connectTimeout, int readTimeout) {
        this(entryPoint, port, 25334, connectTimeout, readTimeout, null);
    }

    public GatewayServer(Object entryPoint, int port, int pythonPort, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands) {
        this.port = port;
        this.pythonPort = pythonPort;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.cbClient = new CallbackClient(pythonPort);
        this.gateway = new Gateway(entryPoint, this.cbClient);
        this.gateway.getBindings().put(GATEWAY_SERVER_ID, this);
        this.customCommands = customCommands;
        this.listeners = new CopyOnWriteArrayList<GatewayServerListener>();
    }

    public GatewayServer(Object entryPoint, int port, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands, CallbackClient cbClient) {
        this.port = port;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.cbClient = cbClient;
        this.pythonPort = cbClient.getPort();
        this.gateway = new Gateway(entryPoint, cbClient);
        this.gateway.getBindings().put(GATEWAY_SERVER_ID, this);
        this.customCommands = customCommands;
        this.listeners = new ArrayList<GatewayServerListener>();
    }

    public GatewayServer(Object entryPoint) {
        this(entryPoint, 25333, 0, 0);
    }

    public GatewayServer(Object entryPoint, int port) {
        this(entryPoint, port, 0, 0);
    }

    protected void startSocket() throws Py4JNetworkException {
        try {
            this.sSocket = new ServerSocket(this.port);
            this.sSocket.setSoTimeout(this.connectTimeout);
            this.sSocket.setReuseAddress(true);
        }
        catch (IOException e) {
            throw new Py4JNetworkException(e);
        }
    }

    @Override
    public void run() {
        try {
            this.gateway.startup();
            this.fireServerStarted();
            while (true) {
                Socket socket = this.sSocket.accept();
                this.processSocket(socket);
            }
        }
        catch (Exception e) {
            this.fireServerError(e);
            this.fireServerStopped();
            return;
        }
    }

    protected Object createConnection(Gateway gateway, Socket socket) throws IOException {
        return new GatewayConnection(gateway, socket, this.customCommands, this.listeners);
    }

    private void processSocket(Socket socket) {
        try {
            this.fireConnectionStarted();
            this.connections.add(socket);
            socket.setSoTimeout(this.readTimeout);
            this.createConnection(this.gateway, socket);
        }
        catch (Exception e) {
            this.fireConnectionError(e);
        }
    }

    public void start(boolean fork) {
        this.startSocket();
        if (fork) {
            Thread t = new Thread(this);
            t.start();
        } else {
            this.run();
        }
    }

    public void start() {
        this.start(true);
    }

    public void shutdown() {
        this.fireServerPreShutdown();
        NetworkUtil.quietlyClose(this.sSocket);
        for (Socket socket : this.connections) {
            NetworkUtil.quietlyClose(socket);
        }
        this.connections.clear();
        this.gateway.shutdown();
        this.cbClient.shutdown();
        this.fireServerPostShutdown();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getPythonPort() {
        return this.pythonPort;
    }

    public int getPort() {
        return this.port;
    }

    public int getListeningPort() {
        int port = -1;
        try {
            if (this.sSocket.isBound()) {
                port = this.sSocket.getLocalPort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    public CallbackClient getCallbackClient() {
        return this.cbClient;
    }

    public void addListener(GatewayServerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(GatewayServerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireServerStarted() {
        this.logger.info("Gateway Server Started");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverStarted();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerStopped() {
        this.logger.info("Gateway Server Stopped");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverStopped();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerError(Exception e) {
        this.logger.log(Level.SEVERE, "Gateway Server Error", e);
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverError(e);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "A listener crashed.", ex);
            }
        }
    }

    protected void fireServerPreShutdown() {
        this.logger.info("Gateway Server Pre Shutdown");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverPreShutdown();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerPostShutdown() {
        this.logger.info("Gateway Server Post Shutdown");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverPostShutdown();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireConnectionStarted() {
        this.logger.info("Connection Started");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.connectionStarted();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireConnectionError(Exception e) {
        this.logger.log(Level.SEVERE, "Connection Server Error", e);
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.connectionError(e);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "A listener crashed.", ex);
            }
        }
    }

    public static void turnLoggingOff() {
        Logger.getLogger("py4j").setLevel(Level.OFF);
    }

    public static void turnLoggingOn() {
        Logger.getLogger("py4j").setLevel(Level.ALL);
    }

    static {
        GatewayServer.turnLoggingOff();
    }
}

