"use strict";
// import { expect, haveResource, haveResourceLike, SynthUtils } from '@aws-cdk/assert';
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const s3 = require("../lib");
class BucketVersioningChecker {
    visit(node) {
        if (node instanceof s3.CfnBucket) {
            if (!node.versioningConfiguration ||
                (!core_1.Tokenization.isResolvable(node.versioningConfiguration) && node.versioningConfiguration.status !== 'Enabled')) {
                node.node.addError('Bucket versioning is not enabled');
            }
        }
    }
}
module.exports = {
    'bucket must have versioning: failure'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        new s3.Bucket(stack, 'MyBucket');
        // WHEN
        stack.node.applyAspect(new BucketVersioningChecker());
        // THEN
        const assembly = assert_1.SynthUtils.synthesize(stack);
        const errorMessage = assembly.messages.find(m => m.entry.data === 'Bucket versioning is not enabled');
        test.ok(errorMessage, 'Error message not reported');
        test.done();
    },
    'bucket must have versioning: success'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        new s3.Bucket(stack, 'MyBucket', {
            versioned: true
        });
        // WHEN
        stack.node.applyAspect(new BucketVersioningChecker());
        // THEN
        const assembly = assert_1.SynthUtils.synthesize(stack);
        test.deepEqual(assembly.messages, []);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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