from evoagent.embeddings.openai_embeddings import OpenAIEmbeddings

def HFEmbeddings(*args, **kwargs):
    try:
        from evoagent.embeddings.sentence_transformers_embeddings import HFEmbeddings as _HFEmbeddings
        return _HFEmbeddings(*args, **kwargs)
    except ImportError:
        raise ImportError(
            "Could not import sentence-transformers. Please install it with: "
            "pip install sentence-transformers"
        )

def GeminiEmbeddings(*args, **kwargs):
    try:
        from evoagent.embeddings.gemini_embeddings import GeminiEmbeddings as _GeminiEmbeddings
        return _GeminiEmbeddings(*args, **kwargs)
    except ImportError:
        raise ImportError(
            "Could not import google-generativeai. Please install it with: "
            "pip install google-generativeai"
        )

__all__ = ["OpenAIEmbeddings", "HFEmbeddings", "GeminiEmbeddings"]
