# gemini_embeddings.py
from google import genai
from google.genai import types
from dotenv import load_dotenv
import os

load_dotenv()

class GeminiEmbeddings:
    def __init__(self, model: str = "text-embedding-004"):
        self.model = model
        self.client = genai.Client(api_key=os.getenv("GEMINI_API_KEY"))
    
    def embed(self, text: str) -> list[float]:
        result = self.client.models.embed_content(
            model=self.model,
            contents=text
        )
        return result.embeddings[0]