# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeAttachmentArgs', 'VolumeAttachment']

@pulumi.input_type
class VolumeAttachmentArgs:
    def __init__(__self__, *,
                 attachment_type: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 volume_id: pulumi.Input[str],
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 device: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encryption_in_transit_type: Optional[pulumi.Input[str]] = None,
                 is_agent_auto_iscsi_login_enabled: Optional[pulumi.Input[bool]] = None,
                 is_pv_encryption_in_transit_enabled: Optional[pulumi.Input[bool]] = None,
                 is_read_only: Optional[pulumi.Input[bool]] = None,
                 is_shareable: Optional[pulumi.Input[bool]] = None,
                 use_chap: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a VolumeAttachment resource.
        :param pulumi.Input[str] attachment_type: The type of volume. The only supported values are "iscsi" and "paravirtualized".
        :param pulumi.Input[str] instance_id: The OCID of the instance.
        :param pulumi.Input[str] volume_id: The OCID of the volume.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] device: The device name. To retrieve a list of devices for a given instance, see [ListInstanceDevices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Device/ListInstanceDevices).
        :param pulumi.Input[str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] encryption_in_transit_type: Refer the top-level definition of encryptionInTransitType. The default value is NONE.
        :param pulumi.Input[bool] is_agent_auto_iscsi_login_enabled: Whether to enable Oracle Cloud Agent to perform the iSCSI login and logout commands after the volume attach or detach operations for non multipath-enabled iSCSI attachments.
        :param pulumi.Input[bool] is_pv_encryption_in_transit_enabled: Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false.
        :param pulumi.Input[bool] is_read_only: Whether the attachment was created in read-only mode.
        :param pulumi.Input[bool] is_shareable: Whether the attachment should be created in shareable mode. If an attachment is created in shareable mode, then other instances can attach the same volume, provided that they also create their attachments in shareable mode. Only certain volume types can be attached in shareable mode. Defaults to false if not specified.
        :param pulumi.Input[bool] use_chap: Whether to use CHAP authentication for the volume attachment. Defaults to false.
        """
        pulumi.set(__self__, "attachment_type", attachment_type)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "volume_id", volume_id)
        if compartment_id is not None:
            warnings.warn("""The 'compartment_id' field has been deprecated and may be removed in a future version. Do not use this field.""", DeprecationWarning)
            pulumi.log.warn("""compartment_id is deprecated: The 'compartment_id' field has been deprecated and may be removed in a future version. Do not use this field.""")
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encryption_in_transit_type is not None:
            pulumi.set(__self__, "encryption_in_transit_type", encryption_in_transit_type)
        if is_agent_auto_iscsi_login_enabled is not None:
            pulumi.set(__self__, "is_agent_auto_iscsi_login_enabled", is_agent_auto_iscsi_login_enabled)
        if is_pv_encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "is_pv_encryption_in_transit_enabled", is_pv_encryption_in_transit_enabled)
        if is_read_only is not None:
            pulumi.set(__self__, "is_read_only", is_read_only)
        if is_shareable is not None:
            pulumi.set(__self__, "is_shareable", is_shareable)
        if use_chap is not None:
            pulumi.set(__self__, "use_chap", use_chap)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Input[str]:
        """
        The type of volume. The only supported values are "iscsi" and "paravirtualized".
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "attachment_type", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The OCID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Input[str]:
        """
        The OCID of the volume.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    @_utilities.deprecated("""The 'compartment_id' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[str]]:
        """
        The device name. To retrieve a list of devices for a given instance, see [ListInstanceDevices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Device/ListInstanceDevices).
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encryptionInTransitType")
    def encryption_in_transit_type(self) -> Optional[pulumi.Input[str]]:
        """
        Refer the top-level definition of encryptionInTransitType. The default value is NONE.
        """
        return pulumi.get(self, "encryption_in_transit_type")

    @encryption_in_transit_type.setter
    def encryption_in_transit_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_in_transit_type", value)

    @property
    @pulumi.getter(name="isAgentAutoIscsiLoginEnabled")
    def is_agent_auto_iscsi_login_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Oracle Cloud Agent to perform the iSCSI login and logout commands after the volume attach or detach operations for non multipath-enabled iSCSI attachments.
        """
        return pulumi.get(self, "is_agent_auto_iscsi_login_enabled")

    @is_agent_auto_iscsi_login_enabled.setter
    def is_agent_auto_iscsi_login_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_agent_auto_iscsi_login_enabled", value)

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @is_pv_encryption_in_transit_enabled.setter
    def is_pv_encryption_in_transit_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_pv_encryption_in_transit_enabled", value)

    @property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the attachment was created in read-only mode.
        """
        return pulumi.get(self, "is_read_only")

    @is_read_only.setter
    def is_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_read_only", value)

    @property
    @pulumi.getter(name="isShareable")
    def is_shareable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the attachment should be created in shareable mode. If an attachment is created in shareable mode, then other instances can attach the same volume, provided that they also create their attachments in shareable mode. Only certain volume types can be attached in shareable mode. Defaults to false if not specified.
        """
        return pulumi.get(self, "is_shareable")

    @is_shareable.setter
    def is_shareable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_shareable", value)

    @property
    @pulumi.getter(name="useChap")
    def use_chap(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use CHAP authentication for the volume attachment. Defaults to false.
        """
        return pulumi.get(self, "use_chap")

    @use_chap.setter
    def use_chap(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_chap", value)


@pulumi.input_type
class _VolumeAttachmentState:
    def __init__(__self__, *,
                 attachment_type: Optional[pulumi.Input[str]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 chap_secret: Optional[pulumi.Input[str]] = None,
                 chap_username: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 device: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encryption_in_transit_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 ipv4: Optional[pulumi.Input[str]] = None,
                 iqn: Optional[pulumi.Input[str]] = None,
                 is_agent_auto_iscsi_login_enabled: Optional[pulumi.Input[bool]] = None,
                 is_multipath: Optional[pulumi.Input[bool]] = None,
                 is_pv_encryption_in_transit_enabled: Optional[pulumi.Input[bool]] = None,
                 is_read_only: Optional[pulumi.Input[bool]] = None,
                 is_shareable: Optional[pulumi.Input[bool]] = None,
                 is_volume_created_during_launch: Optional[pulumi.Input[bool]] = None,
                 iscsi_login_state: Optional[pulumi.Input[str]] = None,
                 multipath_devices: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentMultipathDeviceArgs']]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 use_chap: Optional[pulumi.Input[bool]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VolumeAttachment resources.
        :param pulumi.Input[str] attachment_type: The type of volume. The only supported values are "iscsi" and "paravirtualized".
        :param pulumi.Input[str] availability_domain: The availability domain of an instance.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] chap_secret: The Challenge-Handshake-Authentication-Protocol (CHAP) secret valid for the associated CHAP user name. (Also called the "CHAP password".)
        :param pulumi.Input[str] chap_username: The volume's system-generated Challenge-Handshake-Authentication-Protocol (CHAP) user name. See [RFC 1994](https://tools.ietf.org/html/rfc1994) for more on CHAP.  Example: `ocid1.volume.oc1.phx.<unique_ID>`
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] device: The device name. To retrieve a list of devices for a given instance, see [ListInstanceDevices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Device/ListInstanceDevices).
        :param pulumi.Input[str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] encryption_in_transit_type: Refer the top-level definition of encryptionInTransitType. The default value is NONE.
        :param pulumi.Input[str] instance_id: The OCID of the instance.
        :param pulumi.Input[str] ipv4: The volume's iSCSI IP address.  Example: `169.254.2.2`
        :param pulumi.Input[str] iqn: The target volume's iSCSI Qualified Name in the format defined by [RFC 3720](https://tools.ietf.org/html/rfc3720#page-32).  Example: `iqn.2015-12.com.oracleiaas:40b7ee03-883f-46c6-a951-63d2841d2195`
        :param pulumi.Input[bool] is_agent_auto_iscsi_login_enabled: Whether to enable Oracle Cloud Agent to perform the iSCSI login and logout commands after the volume attach or detach operations for non multipath-enabled iSCSI attachments.
        :param pulumi.Input[bool] is_multipath: Whether the Iscsi or Paravirtualized attachment is multipath or not, it is not applicable to NVMe attachment.
        :param pulumi.Input[bool] is_pv_encryption_in_transit_enabled: Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false.
        :param pulumi.Input[bool] is_read_only: Whether the attachment was created in read-only mode.
        :param pulumi.Input[bool] is_shareable: Whether the attachment should be created in shareable mode. If an attachment is created in shareable mode, then other instances can attach the same volume, provided that they also create their attachments in shareable mode. Only certain volume types can be attached in shareable mode. Defaults to false if not specified.
        :param pulumi.Input[bool] is_volume_created_during_launch: Flag indicating if this volume was created for the customer as part of a simplified launch. Used to determine whether the volume requires deletion on instance termination.
        :param pulumi.Input[str] iscsi_login_state: The iscsi login state of the volume attachment. For a Iscsi volume attachment, all iscsi sessions need to be all logged-in or logged-out to be in logged-in or logged-out state.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentMultipathDeviceArgs']]] multipath_devices: A list of secondary multipath devices
        :param pulumi.Input[int] port: The volume's iSCSI port, usually port 860 or 3260.  Example: `3260`
        :param pulumi.Input[str] state: The current state of the volume attachment.
        :param pulumi.Input[str] time_created: The date and time the volume was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[bool] use_chap: Whether to use CHAP authentication for the volume attachment. Defaults to false.
        :param pulumi.Input[str] volume_id: The OCID of the volume.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if attachment_type is not None:
            pulumi.set(__self__, "attachment_type", attachment_type)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if chap_secret is not None:
            pulumi.set(__self__, "chap_secret", chap_secret)
        if chap_username is not None:
            pulumi.set(__self__, "chap_username", chap_username)
        if compartment_id is not None:
            warnings.warn("""The 'compartment_id' field has been deprecated and may be removed in a future version. Do not use this field.""", DeprecationWarning)
            pulumi.log.warn("""compartment_id is deprecated: The 'compartment_id' field has been deprecated and may be removed in a future version. Do not use this field.""")
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encryption_in_transit_type is not None:
            pulumi.set(__self__, "encryption_in_transit_type", encryption_in_transit_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if ipv4 is not None:
            pulumi.set(__self__, "ipv4", ipv4)
        if iqn is not None:
            pulumi.set(__self__, "iqn", iqn)
        if is_agent_auto_iscsi_login_enabled is not None:
            pulumi.set(__self__, "is_agent_auto_iscsi_login_enabled", is_agent_auto_iscsi_login_enabled)
        if is_multipath is not None:
            pulumi.set(__self__, "is_multipath", is_multipath)
        if is_pv_encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "is_pv_encryption_in_transit_enabled", is_pv_encryption_in_transit_enabled)
        if is_read_only is not None:
            pulumi.set(__self__, "is_read_only", is_read_only)
        if is_shareable is not None:
            pulumi.set(__self__, "is_shareable", is_shareable)
        if is_volume_created_during_launch is not None:
            pulumi.set(__self__, "is_volume_created_during_launch", is_volume_created_during_launch)
        if iscsi_login_state is not None:
            pulumi.set(__self__, "iscsi_login_state", iscsi_login_state)
        if multipath_devices is not None:
            pulumi.set(__self__, "multipath_devices", multipath_devices)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if use_chap is not None:
            pulumi.set(__self__, "use_chap", use_chap)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume. The only supported values are "iscsi" and "paravirtualized".
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attachment_type", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain of an instance.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="chapSecret")
    def chap_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The Challenge-Handshake-Authentication-Protocol (CHAP) secret valid for the associated CHAP user name. (Also called the "CHAP password".)
        """
        return pulumi.get(self, "chap_secret")

    @chap_secret.setter
    def chap_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chap_secret", value)

    @property
    @pulumi.getter(name="chapUsername")
    def chap_username(self) -> Optional[pulumi.Input[str]]:
        """
        The volume's system-generated Challenge-Handshake-Authentication-Protocol (CHAP) user name. See [RFC 1994](https://tools.ietf.org/html/rfc1994) for more on CHAP.  Example: `ocid1.volume.oc1.phx.<unique_ID>`
        """
        return pulumi.get(self, "chap_username")

    @chap_username.setter
    def chap_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chap_username", value)

    @property
    @pulumi.getter(name="compartmentId")
    @_utilities.deprecated("""The 'compartment_id' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[str]]:
        """
        The device name. To retrieve a list of devices for a given instance, see [ListInstanceDevices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Device/ListInstanceDevices).
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encryptionInTransitType")
    def encryption_in_transit_type(self) -> Optional[pulumi.Input[str]]:
        """
        Refer the top-level definition of encryptionInTransitType. The default value is NONE.
        """
        return pulumi.get(self, "encryption_in_transit_type")

    @encryption_in_transit_type.setter
    def encryption_in_transit_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_in_transit_type", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def ipv4(self) -> Optional[pulumi.Input[str]]:
        """
        The volume's iSCSI IP address.  Example: `169.254.2.2`
        """
        return pulumi.get(self, "ipv4")

    @ipv4.setter
    def ipv4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4", value)

    @property
    @pulumi.getter
    def iqn(self) -> Optional[pulumi.Input[str]]:
        """
        The target volume's iSCSI Qualified Name in the format defined by [RFC 3720](https://tools.ietf.org/html/rfc3720#page-32).  Example: `iqn.2015-12.com.oracleiaas:40b7ee03-883f-46c6-a951-63d2841d2195`
        """
        return pulumi.get(self, "iqn")

    @iqn.setter
    def iqn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iqn", value)

    @property
    @pulumi.getter(name="isAgentAutoIscsiLoginEnabled")
    def is_agent_auto_iscsi_login_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Oracle Cloud Agent to perform the iSCSI login and logout commands after the volume attach or detach operations for non multipath-enabled iSCSI attachments.
        """
        return pulumi.get(self, "is_agent_auto_iscsi_login_enabled")

    @is_agent_auto_iscsi_login_enabled.setter
    def is_agent_auto_iscsi_login_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_agent_auto_iscsi_login_enabled", value)

    @property
    @pulumi.getter(name="isMultipath")
    def is_multipath(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the Iscsi or Paravirtualized attachment is multipath or not, it is not applicable to NVMe attachment.
        """
        return pulumi.get(self, "is_multipath")

    @is_multipath.setter
    def is_multipath(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_multipath", value)

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @is_pv_encryption_in_transit_enabled.setter
    def is_pv_encryption_in_transit_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_pv_encryption_in_transit_enabled", value)

    @property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the attachment was created in read-only mode.
        """
        return pulumi.get(self, "is_read_only")

    @is_read_only.setter
    def is_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_read_only", value)

    @property
    @pulumi.getter(name="isShareable")
    def is_shareable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the attachment should be created in shareable mode. If an attachment is created in shareable mode, then other instances can attach the same volume, provided that they also create their attachments in shareable mode. Only certain volume types can be attached in shareable mode. Defaults to false if not specified.
        """
        return pulumi.get(self, "is_shareable")

    @is_shareable.setter
    def is_shareable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_shareable", value)

    @property
    @pulumi.getter(name="isVolumeCreatedDuringLaunch")
    def is_volume_created_during_launch(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag indicating if this volume was created for the customer as part of a simplified launch. Used to determine whether the volume requires deletion on instance termination.
        """
        return pulumi.get(self, "is_volume_created_during_launch")

    @is_volume_created_during_launch.setter
    def is_volume_created_during_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_volume_created_during_launch", value)

    @property
    @pulumi.getter(name="iscsiLoginState")
    def iscsi_login_state(self) -> Optional[pulumi.Input[str]]:
        """
        The iscsi login state of the volume attachment. For a Iscsi volume attachment, all iscsi sessions need to be all logged-in or logged-out to be in logged-in or logged-out state.
        """
        return pulumi.get(self, "iscsi_login_state")

    @iscsi_login_state.setter
    def iscsi_login_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iscsi_login_state", value)

    @property
    @pulumi.getter(name="multipathDevices")
    def multipath_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentMultipathDeviceArgs']]]]:
        """
        A list of secondary multipath devices
        """
        return pulumi.get(self, "multipath_devices")

    @multipath_devices.setter
    def multipath_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentMultipathDeviceArgs']]]]):
        pulumi.set(self, "multipath_devices", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The volume's iSCSI port, usually port 860 or 3260.  Example: `3260`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the volume attachment.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the volume was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="useChap")
    def use_chap(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use CHAP authentication for the volume attachment. Defaults to false.
        """
        return pulumi.get(self, "use_chap")

    @use_chap.setter
    def use_chap(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_chap", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the volume.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_id", value)


class VolumeAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 device: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encryption_in_transit_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 is_agent_auto_iscsi_login_enabled: Optional[pulumi.Input[bool]] = None,
                 is_pv_encryption_in_transit_enabled: Optional[pulumi.Input[bool]] = None,
                 is_read_only: Optional[pulumi.Input[bool]] = None,
                 is_shareable: Optional[pulumi.Input[bool]] = None,
                 use_chap: Optional[pulumi.Input[bool]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Volume Attachment resource in Oracle Cloud Infrastructure Core service.

        Attaches the specified storage volume to the specified instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_volume_attachment = oci.core.VolumeAttachment("test_volume_attachment",
            attachment_type=volume_attachment_attachment_type,
            instance_id=test_instance["id"],
            volume_id=test_volume["id"],
            device=volume_attachment_device,
            display_name=volume_attachment_display_name,
            encryption_in_transit_type=volume_attachment_encryption_in_transit_type,
            is_agent_auto_iscsi_login_enabled=volume_attachment_is_agent_auto_iscsi_login_enabled,
            is_pv_encryption_in_transit_enabled=volume_attachment_is_pv_encryption_in_transit_enabled,
            is_read_only=volume_attachment_is_read_only,
            is_shareable=volume_attachment_is_shareable,
            use_chap=volume_attachment_use_chap)
        ```

        ## Import

        VolumeAttachments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/volumeAttachment:VolumeAttachment test_volume_attachment "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] attachment_type: The type of volume. The only supported values are "iscsi" and "paravirtualized".
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] device: The device name. To retrieve a list of devices for a given instance, see [ListInstanceDevices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Device/ListInstanceDevices).
        :param pulumi.Input[str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] encryption_in_transit_type: Refer the top-level definition of encryptionInTransitType. The default value is NONE.
        :param pulumi.Input[str] instance_id: The OCID of the instance.
        :param pulumi.Input[bool] is_agent_auto_iscsi_login_enabled: Whether to enable Oracle Cloud Agent to perform the iSCSI login and logout commands after the volume attach or detach operations for non multipath-enabled iSCSI attachments.
        :param pulumi.Input[bool] is_pv_encryption_in_transit_enabled: Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false.
        :param pulumi.Input[bool] is_read_only: Whether the attachment was created in read-only mode.
        :param pulumi.Input[bool] is_shareable: Whether the attachment should be created in shareable mode. If an attachment is created in shareable mode, then other instances can attach the same volume, provided that they also create their attachments in shareable mode. Only certain volume types can be attached in shareable mode. Defaults to false if not specified.
        :param pulumi.Input[bool] use_chap: Whether to use CHAP authentication for the volume attachment. Defaults to false.
        :param pulumi.Input[str] volume_id: The OCID of the volume.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Volume Attachment resource in Oracle Cloud Infrastructure Core service.

        Attaches the specified storage volume to the specified instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_volume_attachment = oci.core.VolumeAttachment("test_volume_attachment",
            attachment_type=volume_attachment_attachment_type,
            instance_id=test_instance["id"],
            volume_id=test_volume["id"],
            device=volume_attachment_device,
            display_name=volume_attachment_display_name,
            encryption_in_transit_type=volume_attachment_encryption_in_transit_type,
            is_agent_auto_iscsi_login_enabled=volume_attachment_is_agent_auto_iscsi_login_enabled,
            is_pv_encryption_in_transit_enabled=volume_attachment_is_pv_encryption_in_transit_enabled,
            is_read_only=volume_attachment_is_read_only,
            is_shareable=volume_attachment_is_shareable,
            use_chap=volume_attachment_use_chap)
        ```

        ## Import

        VolumeAttachments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/volumeAttachment:VolumeAttachment test_volume_attachment "id"
        ```

        :param str resource_name: The name of the resource.
        :param VolumeAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 device: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encryption_in_transit_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 is_agent_auto_iscsi_login_enabled: Optional[pulumi.Input[bool]] = None,
                 is_pv_encryption_in_transit_enabled: Optional[pulumi.Input[bool]] = None,
                 is_read_only: Optional[pulumi.Input[bool]] = None,
                 is_shareable: Optional[pulumi.Input[bool]] = None,
                 use_chap: Optional[pulumi.Input[bool]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeAttachmentArgs.__new__(VolumeAttachmentArgs)

            if attachment_type is None and not opts.urn:
                raise TypeError("Missing required property 'attachment_type'")
            __props__.__dict__["attachment_type"] = attachment_type
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["device"] = device
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["encryption_in_transit_type"] = encryption_in_transit_type
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["is_agent_auto_iscsi_login_enabled"] = is_agent_auto_iscsi_login_enabled
            __props__.__dict__["is_pv_encryption_in_transit_enabled"] = is_pv_encryption_in_transit_enabled
            __props__.__dict__["is_read_only"] = is_read_only
            __props__.__dict__["is_shareable"] = is_shareable
            __props__.__dict__["use_chap"] = use_chap
            if volume_id is None and not opts.urn:
                raise TypeError("Missing required property 'volume_id'")
            __props__.__dict__["volume_id"] = volume_id
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["chap_secret"] = None
            __props__.__dict__["chap_username"] = None
            __props__.__dict__["ipv4"] = None
            __props__.__dict__["iqn"] = None
            __props__.__dict__["is_multipath"] = None
            __props__.__dict__["is_volume_created_during_launch"] = None
            __props__.__dict__["iscsi_login_state"] = None
            __props__.__dict__["multipath_devices"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(VolumeAttachment, __self__).__init__(
            'oci:Core/volumeAttachment:VolumeAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachment_type: Optional[pulumi.Input[str]] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            chap_secret: Optional[pulumi.Input[str]] = None,
            chap_username: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            device: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            encryption_in_transit_type: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            ipv4: Optional[pulumi.Input[str]] = None,
            iqn: Optional[pulumi.Input[str]] = None,
            is_agent_auto_iscsi_login_enabled: Optional[pulumi.Input[bool]] = None,
            is_multipath: Optional[pulumi.Input[bool]] = None,
            is_pv_encryption_in_transit_enabled: Optional[pulumi.Input[bool]] = None,
            is_read_only: Optional[pulumi.Input[bool]] = None,
            is_shareable: Optional[pulumi.Input[bool]] = None,
            is_volume_created_during_launch: Optional[pulumi.Input[bool]] = None,
            iscsi_login_state: Optional[pulumi.Input[str]] = None,
            multipath_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeAttachmentMultipathDeviceArgs', 'VolumeAttachmentMultipathDeviceArgsDict']]]]] = None,
            port: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            use_chap: Optional[pulumi.Input[bool]] = None,
            volume_id: Optional[pulumi.Input[str]] = None) -> 'VolumeAttachment':
        """
        Get an existing VolumeAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] attachment_type: The type of volume. The only supported values are "iscsi" and "paravirtualized".
        :param pulumi.Input[str] availability_domain: The availability domain of an instance.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] chap_secret: The Challenge-Handshake-Authentication-Protocol (CHAP) secret valid for the associated CHAP user name. (Also called the "CHAP password".)
        :param pulumi.Input[str] chap_username: The volume's system-generated Challenge-Handshake-Authentication-Protocol (CHAP) user name. See [RFC 1994](https://tools.ietf.org/html/rfc1994) for more on CHAP.  Example: `ocid1.volume.oc1.phx.<unique_ID>`
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] device: The device name. To retrieve a list of devices for a given instance, see [ListInstanceDevices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Device/ListInstanceDevices).
        :param pulumi.Input[str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] encryption_in_transit_type: Refer the top-level definition of encryptionInTransitType. The default value is NONE.
        :param pulumi.Input[str] instance_id: The OCID of the instance.
        :param pulumi.Input[str] ipv4: The volume's iSCSI IP address.  Example: `169.254.2.2`
        :param pulumi.Input[str] iqn: The target volume's iSCSI Qualified Name in the format defined by [RFC 3720](https://tools.ietf.org/html/rfc3720#page-32).  Example: `iqn.2015-12.com.oracleiaas:40b7ee03-883f-46c6-a951-63d2841d2195`
        :param pulumi.Input[bool] is_agent_auto_iscsi_login_enabled: Whether to enable Oracle Cloud Agent to perform the iSCSI login and logout commands after the volume attach or detach operations for non multipath-enabled iSCSI attachments.
        :param pulumi.Input[bool] is_multipath: Whether the Iscsi or Paravirtualized attachment is multipath or not, it is not applicable to NVMe attachment.
        :param pulumi.Input[bool] is_pv_encryption_in_transit_enabled: Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false.
        :param pulumi.Input[bool] is_read_only: Whether the attachment was created in read-only mode.
        :param pulumi.Input[bool] is_shareable: Whether the attachment should be created in shareable mode. If an attachment is created in shareable mode, then other instances can attach the same volume, provided that they also create their attachments in shareable mode. Only certain volume types can be attached in shareable mode. Defaults to false if not specified.
        :param pulumi.Input[bool] is_volume_created_during_launch: Flag indicating if this volume was created for the customer as part of a simplified launch. Used to determine whether the volume requires deletion on instance termination.
        :param pulumi.Input[str] iscsi_login_state: The iscsi login state of the volume attachment. For a Iscsi volume attachment, all iscsi sessions need to be all logged-in or logged-out to be in logged-in or logged-out state.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeAttachmentMultipathDeviceArgs', 'VolumeAttachmentMultipathDeviceArgsDict']]]] multipath_devices: A list of secondary multipath devices
        :param pulumi.Input[int] port: The volume's iSCSI port, usually port 860 or 3260.  Example: `3260`
        :param pulumi.Input[str] state: The current state of the volume attachment.
        :param pulumi.Input[str] time_created: The date and time the volume was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[bool] use_chap: Whether to use CHAP authentication for the volume attachment. Defaults to false.
        :param pulumi.Input[str] volume_id: The OCID of the volume.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeAttachmentState.__new__(_VolumeAttachmentState)

        __props__.__dict__["attachment_type"] = attachment_type
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["chap_secret"] = chap_secret
        __props__.__dict__["chap_username"] = chap_username
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["device"] = device
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["encryption_in_transit_type"] = encryption_in_transit_type
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["ipv4"] = ipv4
        __props__.__dict__["iqn"] = iqn
        __props__.__dict__["is_agent_auto_iscsi_login_enabled"] = is_agent_auto_iscsi_login_enabled
        __props__.__dict__["is_multipath"] = is_multipath
        __props__.__dict__["is_pv_encryption_in_transit_enabled"] = is_pv_encryption_in_transit_enabled
        __props__.__dict__["is_read_only"] = is_read_only
        __props__.__dict__["is_shareable"] = is_shareable
        __props__.__dict__["is_volume_created_during_launch"] = is_volume_created_during_launch
        __props__.__dict__["iscsi_login_state"] = iscsi_login_state
        __props__.__dict__["multipath_devices"] = multipath_devices
        __props__.__dict__["port"] = port
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["use_chap"] = use_chap
        __props__.__dict__["volume_id"] = volume_id
        return VolumeAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Output[str]:
        """
        The type of volume. The only supported values are "iscsi" and "paravirtualized".
        """
        return pulumi.get(self, "attachment_type")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The availability domain of an instance.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="chapSecret")
    def chap_secret(self) -> pulumi.Output[str]:
        """
        The Challenge-Handshake-Authentication-Protocol (CHAP) secret valid for the associated CHAP user name. (Also called the "CHAP password".)
        """
        return pulumi.get(self, "chap_secret")

    @property
    @pulumi.getter(name="chapUsername")
    def chap_username(self) -> pulumi.Output[str]:
        """
        The volume's system-generated Challenge-Handshake-Authentication-Protocol (CHAP) user name. See [RFC 1994](https://tools.ietf.org/html/rfc1994) for more on CHAP.  Example: `ocid1.volume.oc1.phx.<unique_ID>`
        """
        return pulumi.get(self, "chap_username")

    @property
    @pulumi.getter(name="compartmentId")
    @_utilities.deprecated("""The 'compartment_id' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def device(self) -> pulumi.Output[str]:
        """
        The device name. To retrieve a list of devices for a given instance, see [ListInstanceDevices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Device/ListInstanceDevices).
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="encryptionInTransitType")
    def encryption_in_transit_type(self) -> pulumi.Output[str]:
        """
        Refer the top-level definition of encryptionInTransitType. The default value is NONE.
        """
        return pulumi.get(self, "encryption_in_transit_type")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The OCID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def ipv4(self) -> pulumi.Output[str]:
        """
        The volume's iSCSI IP address.  Example: `169.254.2.2`
        """
        return pulumi.get(self, "ipv4")

    @property
    @pulumi.getter
    def iqn(self) -> pulumi.Output[str]:
        """
        The target volume's iSCSI Qualified Name in the format defined by [RFC 3720](https://tools.ietf.org/html/rfc3720#page-32).  Example: `iqn.2015-12.com.oracleiaas:40b7ee03-883f-46c6-a951-63d2841d2195`
        """
        return pulumi.get(self, "iqn")

    @property
    @pulumi.getter(name="isAgentAutoIscsiLoginEnabled")
    def is_agent_auto_iscsi_login_enabled(self) -> pulumi.Output[bool]:
        """
        Whether to enable Oracle Cloud Agent to perform the iSCSI login and logout commands after the volume attach or detach operations for non multipath-enabled iSCSI attachments.
        """
        return pulumi.get(self, "is_agent_auto_iscsi_login_enabled")

    @property
    @pulumi.getter(name="isMultipath")
    def is_multipath(self) -> pulumi.Output[bool]:
        """
        Whether the Iscsi or Paravirtualized attachment is multipath or not, it is not applicable to NVMe attachment.
        """
        return pulumi.get(self, "is_multipath")

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> pulumi.Output[bool]:
        """
        Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> pulumi.Output[bool]:
        """
        Whether the attachment was created in read-only mode.
        """
        return pulumi.get(self, "is_read_only")

    @property
    @pulumi.getter(name="isShareable")
    def is_shareable(self) -> pulumi.Output[bool]:
        """
        Whether the attachment should be created in shareable mode. If an attachment is created in shareable mode, then other instances can attach the same volume, provided that they also create their attachments in shareable mode. Only certain volume types can be attached in shareable mode. Defaults to false if not specified.
        """
        return pulumi.get(self, "is_shareable")

    @property
    @pulumi.getter(name="isVolumeCreatedDuringLaunch")
    def is_volume_created_during_launch(self) -> pulumi.Output[bool]:
        """
        Flag indicating if this volume was created for the customer as part of a simplified launch. Used to determine whether the volume requires deletion on instance termination.
        """
        return pulumi.get(self, "is_volume_created_during_launch")

    @property
    @pulumi.getter(name="iscsiLoginState")
    def iscsi_login_state(self) -> pulumi.Output[str]:
        """
        The iscsi login state of the volume attachment. For a Iscsi volume attachment, all iscsi sessions need to be all logged-in or logged-out to be in logged-in or logged-out state.
        """
        return pulumi.get(self, "iscsi_login_state")

    @property
    @pulumi.getter(name="multipathDevices")
    def multipath_devices(self) -> pulumi.Output[Sequence['outputs.VolumeAttachmentMultipathDevice']]:
        """
        A list of secondary multipath devices
        """
        return pulumi.get(self, "multipath_devices")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The volume's iSCSI port, usually port 860 or 3260.  Example: `3260`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the volume attachment.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the volume was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="useChap")
    def use_chap(self) -> pulumi.Output[bool]:
        """
        Whether to use CHAP authentication for the volume attachment. Defaults to false.
        """
        return pulumi.get(self, "use_chap")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[str]:
        """
        The OCID of the volume.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "volume_id")

