# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsGroupArgs', 'DomainsGroup']

@pulumi.input_type
class DomainsGroupArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 idcs_endpoint: pulumi.Input[str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupMemberArgs']]]] = None,
                 non_unique_display_name: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupTagArgs']]]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensiondynamic_group: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensiongroup_group: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionposix_group: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionrequestable_group: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs']] = None):
        """
        The set of arguments for constructing a DomainsGroup resource.
        :param pulumi.Input[str] display_name: (Updatable) The Group display name.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Display Name
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGroupMemberArgs']]] members: (Updatable) The group members. <b>Important:</b> When requesting group members, a maximum of 10,000 members can be returned in a single request. If the response contains more than 10,000 members, the request will fail. Use 'startIndex' and 'count' to return members in pages instead of in a single response, for example: #attributes=members[startIndex=1%26count=10]. This REST API is SCIM compliant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:User Members, mapsTo:members[User].value, multiValueDelimiter:;]]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * idcsPaginateResponse: true
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] non_unique_display_name: (Updatable) A human readable name for the group as defined by the Service Consumer.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Non-Unique Display Name
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: always
               * type: string
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGroupTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs'] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        :param pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs'] urnietfparamsscimschemasoracleidcsextensiondynamic_group: (Updatable) Dynamic Group
        :param pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs'] urnietfparamsscimschemasoracleidcsextensiongroup_group: (Updatable) Oracle Identity Cloud Service Group
        :param pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs'] urnietfparamsscimschemasoracleidcsextensionposix_group: (Updatable) POSIX Group extension
        :param pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs'] urnietfparamsscimschemasoracleidcsextensionrequestable_group: (Updatable) Requestable Group
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "schemas", schemas)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if non_unique_display_name is not None:
            pulumi.set(__self__, "non_unique_display_name", non_unique_display_name)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)
        if urnietfparamsscimschemasoracleidcsextensiondynamic_group is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensiondynamic_group", urnietfparamsscimschemasoracleidcsextensiondynamic_group)
        if urnietfparamsscimschemasoracleidcsextensiongroup_group is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensiongroup_group", urnietfparamsscimschemasoracleidcsextensiongroup_group)
        if urnietfparamsscimschemasoracleidcsextensionposix_group is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionposix_group", urnietfparamsscimschemasoracleidcsextensionposix_group)
        if urnietfparamsscimschemasoracleidcsextensionrequestable_group is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionrequestable_group", urnietfparamsscimschemasoracleidcsextensionrequestable_group)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The Group display name.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Display Name
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupMemberArgs']]]]:
        """
        (Updatable) The group members. <b>Important:</b> When requesting group members, a maximum of 10,000 members can be returned in a single request. If the response contains more than 10,000 members, the request will fail. Use 'startIndex' and 'count' to return members in pages instead of in a single response, for example: #attributes=members[startIndex=1%26count=10]. This REST API is SCIM compliant.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsCsvAttributeNameMappings: [[columnHeaderName:User Members, mapsTo:members[User].value, multiValueDelimiter:;]]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * idcsPaginateResponse: true
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter(name="nonUniqueDisplayName")
    def non_unique_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A human readable name for the group as defined by the Service Consumer.

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Non-Unique Display Name
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: always
        * type: string
        """
        return pulumi.get(self, "non_unique_display_name")

    @non_unique_display_name.setter
    def non_unique_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "non_unique_display_name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionOciTags")
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self) -> Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Tags.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags")

    @urnietfparamsscimschemasoracleidcsextension_oci_tags.setter
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self, value: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondynamicGroup")
    def urnietfparamsscimschemasoracleidcsextensiondynamic_group(self) -> Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs']]:
        """
        (Updatable) Dynamic Group
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondynamic_group")

    @urnietfparamsscimschemasoracleidcsextensiondynamic_group.setter
    def urnietfparamsscimschemasoracleidcsextensiondynamic_group(self, value: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensiondynamic_group", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiongroupGroup")
    def urnietfparamsscimschemasoracleidcsextensiongroup_group(self) -> Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs']]:
        """
        (Updatable) Oracle Identity Cloud Service Group
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiongroup_group")

    @urnietfparamsscimschemasoracleidcsextensiongroup_group.setter
    def urnietfparamsscimschemasoracleidcsextensiongroup_group(self, value: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensiongroup_group", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionposixGroup")
    def urnietfparamsscimschemasoracleidcsextensionposix_group(self) -> Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs']]:
        """
        (Updatable) POSIX Group extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionposix_group")

    @urnietfparamsscimschemasoracleidcsextensionposix_group.setter
    def urnietfparamsscimschemasoracleidcsextensionposix_group(self, value: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionposix_group", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionrequestableGroup")
    def urnietfparamsscimschemasoracleidcsextensionrequestable_group(self) -> Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs']]:
        """
        (Updatable) Requestable Group
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionrequestable_group")

    @urnietfparamsscimschemasoracleidcsextensionrequestable_group.setter
    def urnietfparamsscimschemasoracleidcsextensionrequestable_group(self, value: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionrequestable_group", value)


@pulumi.input_type
class _DomainsGroupState:
    def __init__(__self__, *,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 compartment_ocid: Optional[pulumi.Input[str]] = None,
                 delete_in_progress: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain_ocid: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupMemberArgs']]]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupMetaArgs']]]] = None,
                 non_unique_display_name: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensiondbcs_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondbcsGroupArgs']]]] = None,
                 urnietfparamsscimschemasoracleidcsextensiondynamic_group: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensiongroup_group: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionposix_group: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionrequestable_group: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs']] = None):
        """
        Input properties used for looking up and filtering DomainsGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] display_name: (Updatable) The Group display name.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Display Name
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGroupIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGroupIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGroupMemberArgs']]] members: (Updatable) The group members. <b>Important:</b> When requesting group members, a maximum of 10,000 members can be returned in a single request. If the response contains more than 10,000 members, the request will fail. Use 'startIndex' and 'count' to return members in pages instead of in a single response, for example: #attributes=members[startIndex=1%26count=10]. This REST API is SCIM compliant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:User Members, mapsTo:members[User].value, multiValueDelimiter:;]]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * idcsPaginateResponse: true
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGroupMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[str] non_unique_display_name: (Updatable) A human readable name for the group as defined by the Service Consumer.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Non-Unique Display Name
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: always
               * type: string
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGroupTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs'] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondbcsGroupArgs']]] urnietfparamsscimschemasoracleidcsextensiondbcs_groups: (Updatable) Schema for Database Service  Resource
        :param pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs'] urnietfparamsscimschemasoracleidcsextensiondynamic_group: (Updatable) Dynamic Group
        :param pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs'] urnietfparamsscimschemasoracleidcsextensiongroup_group: (Updatable) Oracle Identity Cloud Service Group
        :param pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs'] urnietfparamsscimschemasoracleidcsextensionposix_group: (Updatable) POSIX Group extension
        :param pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs'] urnietfparamsscimschemasoracleidcsextensionrequestable_group: (Updatable) Requestable Group
        """
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if non_unique_display_name is not None:
            pulumi.set(__self__, "non_unique_display_name", non_unique_display_name)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)
        if urnietfparamsscimschemasoracleidcsextensiondbcs_groups is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensiondbcs_groups", urnietfparamsscimschemasoracleidcsextensiondbcs_groups)
        if urnietfparamsscimschemasoracleidcsextensiondynamic_group is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensiondynamic_group", urnietfparamsscimschemasoracleidcsextensiondynamic_group)
        if urnietfparamsscimschemasoracleidcsextensiongroup_group is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensiongroup_group", urnietfparamsscimschemasoracleidcsextensiongroup_group)
        if urnietfparamsscimschemasoracleidcsextensionposix_group is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionposix_group", urnietfparamsscimschemasoracleidcsextensionposix_group)
        if urnietfparamsscimschemasoracleidcsextensionrequestable_group is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionrequestable_group", urnietfparamsscimschemasoracleidcsextensionrequestable_group)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Group display name.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Display Name
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupMemberArgs']]]]:
        """
        (Updatable) The group members. <b>Important:</b> When requesting group members, a maximum of 10,000 members can be returned in a single request. If the response contains more than 10,000 members, the request will fail. Use 'startIndex' and 'count' to return members in pages instead of in a single response, for example: #attributes=members[startIndex=1%26count=10]. This REST API is SCIM compliant.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsCsvAttributeNameMappings: [[columnHeaderName:User Members, mapsTo:members[User].value, multiValueDelimiter:;]]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * idcsPaginateResponse: true
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter(name="nonUniqueDisplayName")
    def non_unique_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A human readable name for the group as defined by the Service Consumer.

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Non-Unique Display Name
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: always
        * type: string
        """
        return pulumi.get(self, "non_unique_display_name")

    @non_unique_display_name.setter
    def non_unique_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "non_unique_display_name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionOciTags")
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self) -> Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Tags.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags")

    @urnietfparamsscimschemasoracleidcsextension_oci_tags.setter
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self, value: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondbcsGroups")
    def urnietfparamsscimschemasoracleidcsextensiondbcs_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondbcsGroupArgs']]]]:
        """
        (Updatable) Schema for Database Service  Resource
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondbcs_groups")

    @urnietfparamsscimschemasoracleidcsextensiondbcs_groups.setter
    def urnietfparamsscimschemasoracleidcsextensiondbcs_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondbcsGroupArgs']]]]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensiondbcs_groups", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondynamicGroup")
    def urnietfparamsscimschemasoracleidcsextensiondynamic_group(self) -> Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs']]:
        """
        (Updatable) Dynamic Group
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondynamic_group")

    @urnietfparamsscimschemasoracleidcsextensiondynamic_group.setter
    def urnietfparamsscimschemasoracleidcsextensiondynamic_group(self, value: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensiondynamic_group", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiongroupGroup")
    def urnietfparamsscimschemasoracleidcsextensiongroup_group(self) -> Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs']]:
        """
        (Updatable) Oracle Identity Cloud Service Group
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiongroup_group")

    @urnietfparamsscimschemasoracleidcsextensiongroup_group.setter
    def urnietfparamsscimschemasoracleidcsextensiongroup_group(self, value: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensiongroup_group", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionposixGroup")
    def urnietfparamsscimschemasoracleidcsextensionposix_group(self) -> Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs']]:
        """
        (Updatable) POSIX Group extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionposix_group")

    @urnietfparamsscimschemasoracleidcsextensionposix_group.setter
    def urnietfparamsscimschemasoracleidcsextensionposix_group(self, value: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionposix_group", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionrequestableGroup")
    def urnietfparamsscimschemasoracleidcsextensionrequestable_group(self) -> Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs']]:
        """
        (Updatable) Requestable Group
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionrequestable_group")

    @urnietfparamsscimschemasoracleidcsextensionrequestable_group.setter
    def urnietfparamsscimschemasoracleidcsextensionrequestable_group(self, value: Optional[pulumi.Input['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionrequestable_group", value)


class DomainsGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupMemberArgs', 'DomainsGroupMemberArgsDict']]]]] = None,
                 non_unique_display_name: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupTagArgs', 'DomainsGroupTagArgsDict']]]]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensiondynamic_group: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensiongroup_group: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionposix_group: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionrequestable_group: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Group resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a group.

        ## Import

        Groups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsGroup:DomainsGroup test_group "idcsEndpoint/{idcsEndpoint}/groups/{groupId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] display_name: (Updatable) The Group display name.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Display Name
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupMemberArgs', 'DomainsGroupMemberArgsDict']]]] members: (Updatable) The group members. <b>Important:</b> When requesting group members, a maximum of 10,000 members can be returned in a single request. If the response contains more than 10,000 members, the request will fail. Use 'startIndex' and 'count' to return members in pages instead of in a single response, for example: #attributes=members[startIndex=1%26count=10]. This REST API is SCIM compliant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:User Members, mapsTo:members[User].value, multiValueDelimiter:;]]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * idcsPaginateResponse: true
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] non_unique_display_name: (Updatable) A human readable name for the group as defined by the Service Consumer.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Non-Unique Display Name
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: always
               * type: string
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupTagArgs', 'DomainsGroupTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgsDict']] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        :param pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgsDict']] urnietfparamsscimschemasoracleidcsextensiondynamic_group: (Updatable) Dynamic Group
        :param pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgsDict']] urnietfparamsscimschemasoracleidcsextensiongroup_group: (Updatable) Oracle Identity Cloud Service Group
        :param pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgsDict']] urnietfparamsscimschemasoracleidcsextensionposix_group: (Updatable) POSIX Group extension
        :param pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgsDict']] urnietfparamsscimschemasoracleidcsextensionrequestable_group: (Updatable) Requestable Group
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Group resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a group.

        ## Import

        Groups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsGroup:DomainsGroup test_group "idcsEndpoint/{idcsEndpoint}/groups/{groupId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupMemberArgs', 'DomainsGroupMemberArgsDict']]]]] = None,
                 non_unique_display_name: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupTagArgs', 'DomainsGroupTagArgsDict']]]]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensiondynamic_group: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensiongroup_group: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionposix_group: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionrequestable_group: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsGroupArgs.__new__(DomainsGroupArgs)

            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authorization"] = authorization
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["external_id"] = external_id
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["members"] = members
            __props__.__dict__["non_unique_display_name"] = non_unique_display_name
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["tags"] = tags
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextension_oci_tags"] = urnietfparamsscimschemasoracleidcsextension_oci_tags
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensiondynamic_group"] = urnietfparamsscimschemasoracleidcsextensiondynamic_group
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensiongroup_group"] = urnietfparamsscimschemasoracleidcsextensiongroup_group
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionposix_group"] = urnietfparamsscimschemasoracleidcsextensionposix_group
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionrequestable_group"] = urnietfparamsscimschemasoracleidcsextensionrequestable_group
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensiondbcs_groups"] = None
        super(DomainsGroup, __self__).__init__(
            'oci:Identity/domainsGroup:DomainsGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            attributes: Optional[pulumi.Input[str]] = None,
            authorization: Optional[pulumi.Input[str]] = None,
            compartment_ocid: Optional[pulumi.Input[str]] = None,
            delete_in_progress: Optional[pulumi.Input[bool]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            domain_ocid: Optional[pulumi.Input[str]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupIdcsCreatedByArgs', 'DomainsGroupIdcsCreatedByArgsDict']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupIdcsLastModifiedByArgs', 'DomainsGroupIdcsLastModifiedByArgsDict']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupMemberArgs', 'DomainsGroupMemberArgsDict']]]]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupMetaArgs', 'DomainsGroupMetaArgsDict']]]]] = None,
            non_unique_display_name: Optional[pulumi.Input[str]] = None,
            ocid: Optional[pulumi.Input[str]] = None,
            resource_type_schema_version: Optional[pulumi.Input[str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupTagArgs', 'DomainsGroupTagArgsDict']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[str]] = None,
            urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgsDict']]] = None,
            urnietfparamsscimschemasoracleidcsextensiondbcs_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondbcsGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondbcsGroupArgsDict']]]]] = None,
            urnietfparamsscimschemasoracleidcsextensiondynamic_group: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgsDict']]] = None,
            urnietfparamsscimschemasoracleidcsextensiongroup_group: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgsDict']]] = None,
            urnietfparamsscimschemasoracleidcsextensionposix_group: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgsDict']]] = None,
            urnietfparamsscimschemasoracleidcsextensionrequestable_group: Optional[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgsDict']]] = None) -> 'DomainsGroup':
        """
        Get an existing DomainsGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] display_name: (Updatable) The Group display name.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Display Name
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupIdcsCreatedByArgs', 'DomainsGroupIdcsCreatedByArgsDict']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupIdcsLastModifiedByArgs', 'DomainsGroupIdcsLastModifiedByArgsDict']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupMemberArgs', 'DomainsGroupMemberArgsDict']]]] members: (Updatable) The group members. <b>Important:</b> When requesting group members, a maximum of 10,000 members can be returned in a single request. If the response contains more than 10,000 members, the request will fail. Use 'startIndex' and 'count' to return members in pages instead of in a single response, for example: #attributes=members[startIndex=1%26count=10]. This REST API is SCIM compliant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:User Members, mapsTo:members[User].value, multiValueDelimiter:;]]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * idcsPaginateResponse: true
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupMetaArgs', 'DomainsGroupMetaArgsDict']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[str] non_unique_display_name: (Updatable) A human readable name for the group as defined by the Service Consumer.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Non-Unique Display Name
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: always
               * type: string
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupTagArgs', 'DomainsGroupTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgsDict']] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondbcsGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondbcsGroupArgsDict']]]] urnietfparamsscimschemasoracleidcsextensiondbcs_groups: (Updatable) Schema for Database Service  Resource
        :param pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroupArgsDict']] urnietfparamsscimschemasoracleidcsextensiondynamic_group: (Updatable) Dynamic Group
        :param pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroupArgsDict']] urnietfparamsscimschemasoracleidcsextensiongroup_group: (Updatable) Oracle Identity Cloud Service Group
        :param pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroupArgsDict']] urnietfparamsscimschemasoracleidcsextensionposix_group: (Updatable) POSIX Group extension
        :param pulumi.Input[Union['DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgs', 'DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroupArgsDict']] urnietfparamsscimschemasoracleidcsextensionrequestable_group: (Updatable) Requestable Group
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsGroupState.__new__(_DomainsGroupState)

        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["members"] = members
        __props__.__dict__["metas"] = metas
        __props__.__dict__["non_unique_display_name"] = non_unique_display_name
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextension_oci_tags"] = urnietfparamsscimschemasoracleidcsextension_oci_tags
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensiondbcs_groups"] = urnietfparamsscimschemasoracleidcsextensiondbcs_groups
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensiondynamic_group"] = urnietfparamsscimschemasoracleidcsextensiondynamic_group
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensiongroup_group"] = urnietfparamsscimschemasoracleidcsextensiongroup_group
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionposix_group"] = urnietfparamsscimschemasoracleidcsextensionposix_group
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionrequestable_group"] = urnietfparamsscimschemasoracleidcsextensionrequestable_group
        return DomainsGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The Group display name.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Display Name
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[str]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsGroupIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsGroupIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence['outputs.DomainsGroupMember']]:
        """
        (Updatable) The group members. <b>Important:</b> When requesting group members, a maximum of 10,000 members can be returned in a single request. If the response contains more than 10,000 members, the request will fail. Use 'startIndex' and 'count' to return members in pages instead of in a single response, for example: #attributes=members[startIndex=1%26count=10]. This REST API is SCIM compliant.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsCsvAttributeNameMappings: [[columnHeaderName:User Members, mapsTo:members[User].value, multiValueDelimiter:;]]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * idcsPaginateResponse: true
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsGroupMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter(name="nonUniqueDisplayName")
    def non_unique_display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A human readable name for the group as defined by the Service Consumer.

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Non-Unique Display Name
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: always
        * type: string
        """
        return pulumi.get(self, "non_unique_display_name")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsGroupTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionOciTags")
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self) -> pulumi.Output['outputs.DomainsGroupUrnietfparamsscimschemasoracleidcsextensionOciTags']:
        """
        (Updatable) Oracle Cloud Infrastructure Tags.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondbcsGroups")
    def urnietfparamsscimschemasoracleidcsextensiondbcs_groups(self) -> pulumi.Output[Sequence['outputs.DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondbcsGroup']]:
        """
        (Updatable) Schema for Database Service  Resource
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondbcs_groups")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondynamicGroup")
    def urnietfparamsscimschemasoracleidcsextensiondynamic_group(self) -> pulumi.Output['outputs.DomainsGroupUrnietfparamsscimschemasoracleidcsextensiondynamicGroup']:
        """
        (Updatable) Dynamic Group
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondynamic_group")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiongroupGroup")
    def urnietfparamsscimschemasoracleidcsextensiongroup_group(self) -> pulumi.Output['outputs.DomainsGroupUrnietfparamsscimschemasoracleidcsextensiongroupGroup']:
        """
        (Updatable) Oracle Identity Cloud Service Group
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiongroup_group")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionposixGroup")
    def urnietfparamsscimschemasoracleidcsextensionposix_group(self) -> pulumi.Output['outputs.DomainsGroupUrnietfparamsscimschemasoracleidcsextensionposixGroup']:
        """
        (Updatable) POSIX Group extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionposix_group")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionrequestableGroup")
    def urnietfparamsscimschemasoracleidcsextensionrequestable_group(self) -> pulumi.Output['outputs.DomainsGroupUrnietfparamsscimschemasoracleidcsextensionrequestableGroup']:
        """
        (Updatable) Requestable Group
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionrequestable_group")

