# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetOperationsInsightsPrivateEndpointResult',
    'AwaitableGetOperationsInsightsPrivateEndpointResult',
    'get_operations_insights_private_endpoint',
    'get_operations_insights_private_endpoint_output',
]

@pulumi.output_type
class GetOperationsInsightsPrivateEndpointResult:
    """
    A collection of values returned by getOperationsInsightsPrivateEndpoint.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, is_used_for_rac_dbs=None, lifecycle_details=None, nsg_ids=None, operations_insights_private_endpoint_id=None, private_endpoint_status_details=None, private_ip=None, state=None, subnet_id=None, system_tags=None, time_created=None, vcn_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_used_for_rac_dbs and not isinstance(is_used_for_rac_dbs, bool):
            raise TypeError("Expected argument 'is_used_for_rac_dbs' to be a bool")
        pulumi.set(__self__, "is_used_for_rac_dbs", is_used_for_rac_dbs)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if operations_insights_private_endpoint_id and not isinstance(operations_insights_private_endpoint_id, str):
            raise TypeError("Expected argument 'operations_insights_private_endpoint_id' to be a str")
        pulumi.set(__self__, "operations_insights_private_endpoint_id", operations_insights_private_endpoint_id)
        if private_endpoint_status_details and not isinstance(private_endpoint_status_details, str):
            raise TypeError("Expected argument 'private_endpoint_status_details' to be a str")
        pulumi.set(__self__, "private_endpoint_status_details", private_endpoint_status_details)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment OCID of the Private service accessed database.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the private endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the private endpoint.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the Private service accessed database.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isUsedForRacDbs")
    def is_used_for_rac_dbs(self) -> bool:
        """
        The flag is to identify if private endpoint is used for rac database or not. This flag is deprecated and no longer is used.
        """
        return pulumi.get(self, "is_used_for_rac_dbs")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        The OCIDs of the network security groups that the private endpoint belongs to.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="operationsInsightsPrivateEndpointId")
    def operations_insights_private_endpoint_id(self) -> str:
        return pulumi.get(self, "operations_insights_private_endpoint_id")

    @property
    @pulumi.getter(name="privateEndpointStatusDetails")
    def private_endpoint_status_details(self) -> str:
        """
        A message describing the status of the private endpoint connection of this resource. For example, it can be used to provide actionable information about the validity of the private endpoint connection.
        """
        return pulumi.get(self, "private_endpoint_status_details")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP addresses assigned to the private endpoint. All IP addresses will be concatenated if it is RAC DBs.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the private endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the private endpoint was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The OCID of the VCN.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetOperationsInsightsPrivateEndpointResult(GetOperationsInsightsPrivateEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOperationsInsightsPrivateEndpointResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_used_for_rac_dbs=self.is_used_for_rac_dbs,
            lifecycle_details=self.lifecycle_details,
            nsg_ids=self.nsg_ids,
            operations_insights_private_endpoint_id=self.operations_insights_private_endpoint_id,
            private_endpoint_status_details=self.private_endpoint_status_details,
            private_ip=self.private_ip,
            state=self.state,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            vcn_id=self.vcn_id)


def get_operations_insights_private_endpoint(operations_insights_private_endpoint_id: Optional[str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOperationsInsightsPrivateEndpointResult:
    """
    This data source provides details about a specific Operations Insights Private Endpoint resource in Oracle Cloud Infrastructure Opsi service.

    Gets the details of the specified private endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operations_insights_private_endpoint = oci.Opsi.get_operations_insights_private_endpoint(operations_insights_private_endpoint_id=test_operations_insights_private_endpoint_oci_opsi_operations_insights_private_endpoint["id"])
    ```


    :param str operations_insights_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Operation Insights private endpoint.
    """
    __args__ = dict()
    __args__['operationsInsightsPrivateEndpointId'] = operations_insights_private_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getOperationsInsightsPrivateEndpoint:getOperationsInsightsPrivateEndpoint', __args__, opts=opts, typ=GetOperationsInsightsPrivateEndpointResult).value

    return AwaitableGetOperationsInsightsPrivateEndpointResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_used_for_rac_dbs=pulumi.get(__ret__, 'is_used_for_rac_dbs'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        operations_insights_private_endpoint_id=pulumi.get(__ret__, 'operations_insights_private_endpoint_id'),
        private_endpoint_status_details=pulumi.get(__ret__, 'private_endpoint_status_details'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))


@_utilities.lift_output_func(get_operations_insights_private_endpoint)
def get_operations_insights_private_endpoint_output(operations_insights_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOperationsInsightsPrivateEndpointResult]:
    """
    This data source provides details about a specific Operations Insights Private Endpoint resource in Oracle Cloud Infrastructure Opsi service.

    Gets the details of the specified private endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operations_insights_private_endpoint = oci.Opsi.get_operations_insights_private_endpoint(operations_insights_private_endpoint_id=test_operations_insights_private_endpoint_oci_opsi_operations_insights_private_endpoint["id"])
    ```


    :param str operations_insights_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Operation Insights private endpoint.
    """
    ...
