# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.request_options import RequestOptions
from ..core.unchecked_base_model import construct_type
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from .types.authentication_authenticate_user_response import AuthenticationAuthenticateUserResponse
from .types.authentication_deauthenticate_user_response import AuthenticationDeauthenticateUserResponse
from .types.authentication_generate_auth_token_response import AuthenticationGenerateAuthTokenResponse
from .types.authentication_generate_widget_session_response import AuthenticationGenerateWidgetSessionResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawAuthenticationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def authenticateuser(
        self,
        *,
        resource: str,
        language: typing.Optional[str] = OMIT,
        reference_id: typing.Optional[str] = OMIT,
        auth_success_redirect_url: typing.Optional[str] = OMIT,
        auth_failure_redirect_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[AuthenticationAuthenticateUserResponse]:
        """
        Creates a login link that allows end users to connect their fitness tracking account

        Parameters
        ----------
        resource : str
            Provider resource identifier (e.g., 'FITBIT', 'GARMIN', 'OURA'). See "Get detailed list of integrations" for available providers

        language : typing.Optional[str]

        reference_id : typing.Optional[str]

        auth_success_redirect_url : typing.Optional[str]

        auth_failure_redirect_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AuthenticationAuthenticateUserResponse]
            Returned when authentication link could be successfully generated
        """
        _response = self._client_wrapper.httpx_client.request(
            "auth/authenticateUser",
            method="POST",
            params={
                "resource": resource,
            },
            json={
                "language": language,
                "reference_id": reference_id,
                "auth_success_redirect_url": auth_success_redirect_url,
                "auth_failure_redirect_url": auth_failure_redirect_url,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuthenticationAuthenticateUserResponse,
                    construct_type(
                        type_=AuthenticationAuthenticateUserResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def generatewidgetsession(
        self,
        *,
        providers: typing.Optional[str] = OMIT,
        language: typing.Optional[str] = OMIT,
        reference_id: typing.Optional[str] = OMIT,
        auth_success_redirect_url: typing.Optional[str] = OMIT,
        auth_failure_redirect_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[AuthenticationGenerateWidgetSessionResponse]:
        """
        Generates a link to redirect an end user to for them to select an integration and log in with their fitness data provider

        Parameters
        ----------
        providers : typing.Optional[str]
            Comma separated list of providers to display on the device selection page. This overrides your selected sources on your dashboard

        language : typing.Optional[str]
            Display language of the widget

        reference_id : typing.Optional[str]
            Identifier of the end user on your system, such as a user ID or email associated with them

        auth_success_redirect_url : typing.Optional[str]
            URL the user is redirected to upon successful authentication

        auth_failure_redirect_url : typing.Optional[str]
            URL the user is redirected to upon unsuccessful authentication

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AuthenticationGenerateWidgetSessionResponse]
            Returned when authentication link could be successfully generated
        """
        _response = self._client_wrapper.httpx_client.request(
            "auth/generateWidgetSession",
            method="POST",
            json={
                "providers": providers,
                "language": language,
                "reference_id": reference_id,
                "auth_success_redirect_url": auth_success_redirect_url,
                "auth_failure_redirect_url": auth_failure_redirect_url,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuthenticationGenerateWidgetSessionResponse,
                    construct_type(
                        type_=AuthenticationGenerateWidgetSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def deauthenticateuser(
        self, *, user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[AuthenticationDeauthenticateUserResponse]:
        """
        Deletes all records of the user on Terra's end, revoking Terra's access to their data

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to deauthenticate and remove from Terra system

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AuthenticationDeauthenticateUserResponse]
            Returned when user is successfully deauthenticated and data is deleted
        """
        _response = self._client_wrapper.httpx_client.request(
            "auth/deauthenticateUser",
            method="DELETE",
            params={
                "user_id": user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuthenticationDeauthenticateUserResponse,
                    construct_type(
                        type_=AuthenticationDeauthenticateUserResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def generateauthtoken(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[AuthenticationGenerateAuthTokenResponse]:
        """
        Creates a token to be used with initConnection() functions in the Terra mobile SDKs in order to create a user record for Apple Health or Samsung Health (or equivalent)

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AuthenticationGenerateAuthTokenResponse]
            200
        """
        _response = self._client_wrapper.httpx_client.request(
            "auth/generateAuthToken",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuthenticationGenerateAuthTokenResponse,
                    construct_type(
                        type_=AuthenticationGenerateAuthTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawAuthenticationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def authenticateuser(
        self,
        *,
        resource: str,
        language: typing.Optional[str] = OMIT,
        reference_id: typing.Optional[str] = OMIT,
        auth_success_redirect_url: typing.Optional[str] = OMIT,
        auth_failure_redirect_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[AuthenticationAuthenticateUserResponse]:
        """
        Creates a login link that allows end users to connect their fitness tracking account

        Parameters
        ----------
        resource : str
            Provider resource identifier (e.g., 'FITBIT', 'GARMIN', 'OURA'). See "Get detailed list of integrations" for available providers

        language : typing.Optional[str]

        reference_id : typing.Optional[str]

        auth_success_redirect_url : typing.Optional[str]

        auth_failure_redirect_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AuthenticationAuthenticateUserResponse]
            Returned when authentication link could be successfully generated
        """
        _response = await self._client_wrapper.httpx_client.request(
            "auth/authenticateUser",
            method="POST",
            params={
                "resource": resource,
            },
            json={
                "language": language,
                "reference_id": reference_id,
                "auth_success_redirect_url": auth_success_redirect_url,
                "auth_failure_redirect_url": auth_failure_redirect_url,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuthenticationAuthenticateUserResponse,
                    construct_type(
                        type_=AuthenticationAuthenticateUserResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def generatewidgetsession(
        self,
        *,
        providers: typing.Optional[str] = OMIT,
        language: typing.Optional[str] = OMIT,
        reference_id: typing.Optional[str] = OMIT,
        auth_success_redirect_url: typing.Optional[str] = OMIT,
        auth_failure_redirect_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[AuthenticationGenerateWidgetSessionResponse]:
        """
        Generates a link to redirect an end user to for them to select an integration and log in with their fitness data provider

        Parameters
        ----------
        providers : typing.Optional[str]
            Comma separated list of providers to display on the device selection page. This overrides your selected sources on your dashboard

        language : typing.Optional[str]
            Display language of the widget

        reference_id : typing.Optional[str]
            Identifier of the end user on your system, such as a user ID or email associated with them

        auth_success_redirect_url : typing.Optional[str]
            URL the user is redirected to upon successful authentication

        auth_failure_redirect_url : typing.Optional[str]
            URL the user is redirected to upon unsuccessful authentication

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AuthenticationGenerateWidgetSessionResponse]
            Returned when authentication link could be successfully generated
        """
        _response = await self._client_wrapper.httpx_client.request(
            "auth/generateWidgetSession",
            method="POST",
            json={
                "providers": providers,
                "language": language,
                "reference_id": reference_id,
                "auth_success_redirect_url": auth_success_redirect_url,
                "auth_failure_redirect_url": auth_failure_redirect_url,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuthenticationGenerateWidgetSessionResponse,
                    construct_type(
                        type_=AuthenticationGenerateWidgetSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def deauthenticateuser(
        self, *, user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[AuthenticationDeauthenticateUserResponse]:
        """
        Deletes all records of the user on Terra's end, revoking Terra's access to their data

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to deauthenticate and remove from Terra system

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AuthenticationDeauthenticateUserResponse]
            Returned when user is successfully deauthenticated and data is deleted
        """
        _response = await self._client_wrapper.httpx_client.request(
            "auth/deauthenticateUser",
            method="DELETE",
            params={
                "user_id": user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuthenticationDeauthenticateUserResponse,
                    construct_type(
                        type_=AuthenticationDeauthenticateUserResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def generateauthtoken(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[AuthenticationGenerateAuthTokenResponse]:
        """
        Creates a token to be used with initConnection() functions in the Terra mobile SDKs in order to create a user record for Apple Health or Samsung Health (or equivalent)

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AuthenticationGenerateAuthTokenResponse]
            200
        """
        _response = await self._client_wrapper.httpx_client.request(
            "auth/generateAuthToken",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuthenticationGenerateAuthTokenResponse,
                    construct_type(
                        type_=AuthenticationGenerateAuthTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
