# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.integrations_response import IntegrationsResponse
from .raw_client import AsyncRawIntegrationsClient, RawIntegrationsClient
from .types.integrations_fetch_response import IntegrationsFetchResponse


class IntegrationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawIntegrationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawIntegrationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawIntegrationsClient
        """
        return self._raw_client

    def fetch(self, *, request_options: typing.Optional[RequestOptions] = None) -> IntegrationsFetchResponse:
        """
        Retrieve a list of all available provider integrations on the API.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IntegrationsFetchResponse
            Returns list of all available integrations on the API

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.integrations.fetch()
        """
        _response = self._raw_client.fetch(request_options=request_options)
        return _response.data

    def detailedfetch(
        self, *, sdk: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> IntegrationsResponse:
        """
        Retrieve a detailed list of supported integrations, optionally filtered by the developer's enabled integrations and the requirement for SDK usage.

        Parameters
        ----------
        sdk : typing.Optional[bool]
            If `true`, allows SDK integrations to be included in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IntegrationsResponse
            Successful response containing a list of integrations.

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.integrations.detailedfetch()
        """
        _response = self._raw_client.detailedfetch(sdk=sdk, request_options=request_options)
        return _response.data


class AsyncIntegrationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawIntegrationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawIntegrationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawIntegrationsClient
        """
        return self._raw_client

    async def fetch(self, *, request_options: typing.Optional[RequestOptions] = None) -> IntegrationsFetchResponse:
        """
        Retrieve a list of all available provider integrations on the API.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IntegrationsFetchResponse
            Returns list of all available integrations on the API

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.integrations.fetch()


        asyncio.run(main())
        """
        _response = await self._raw_client.fetch(request_options=request_options)
        return _response.data

    async def detailedfetch(
        self, *, sdk: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> IntegrationsResponse:
        """
        Retrieve a detailed list of supported integrations, optionally filtered by the developer's enabled integrations and the requirement for SDK usage.

        Parameters
        ----------
        sdk : typing.Optional[bool]
            If `true`, allows SDK integrations to be included in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IntegrationsResponse
            Successful response containing a list of integrations.

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.integrations.detailedfetch()


        asyncio.run(main())
        """
        _response = await self._raw_client.detailedfetch(sdk=sdk, request_options=request_options)
        return _response.data
