# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .device_data import DeviceData


class Athlete(UncheckedBaseModel):
    age: typing.Optional[int] = pydantic.Field(default=None)
    """
    User's age.
    """

    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's country of residence.
    """

    bio: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's bio - a short description they display on their profile.
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's state of residence.
    """

    last_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's last name.
    """

    sex: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's sex.
    """

    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's city of residence.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's email.
    """

    date_of_birth: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's date of birth, in ISO8601 format.
    """

    first_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's first name.
    """

    gender: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's gender.
    """

    joined_provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's account creation date.
    """

    devices: typing.Optional[typing.List[DeviceData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
