# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel


class MeasurementDataSample(UncheckedBaseModel):
    measurement_time: typing.Optional[str] = pydantic.Field(default=None)
    """
    Time with which the record is associated, in ISO8601 format with microsecond precision. TimeZone info will be provided whenever possible. If absent, the time corresponds to the user's local time.
    """

    bmi: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="BMI")] = pydantic.Field(default=None)
    """
    User's Body Mass Index (BMI).
    """

    bmr: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="BMR")] = pydantic.Field(default=None)
    """
    User's Basal Metabolic Rate - minimum amount of calories that a person's body needs to perform necessary functions.
    """

    rmr: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="RMR")] = pydantic.Field(default=None)
    """
    User's Resting Metabolic Rate - amount of energy that a person's body needs to function while at rest. RMR accounts for additional low-effort daily activities on top of basic body functions.
    """

    estimated_fitness_age: typing.Optional[str] = pydantic.Field(default=None)
    """
    Estimate of how fit the user is compared to their actual age, as measured by the device.
    """

    skin_fold_mm: typing.Optional[float] = pydantic.Field(default=None)
    """
    User's skin fold measurement.
    """

    bodyfat_percentage: typing.Optional[float] = pydantic.Field(default=None)
    """
    User's body fat percentage.
    """

    weight_kg: typing.Optional[float] = pydantic.Field(default=None)
    """
    User's body weight.
    """

    height_cm: typing.Optional[float] = pydantic.Field(default=None)
    """
    User's height.
    """

    bone_mass_g: typing.Optional[float] = pydantic.Field(default=None)
    """
    User's total bone mass.
    """

    muscle_mass_g: typing.Optional[float] = pydantic.Field(default=None)
    """
    User's total muscle mass (i.e. skeletal muscle mass).
    """

    lean_mass_g: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total lean mass of the user - calculated as the difference between total body weight and body fat weight.
    """

    water_percentage: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total amount of fluid in the user's body.
    """

    insulin_units: typing.Optional[float] = pydantic.Field(default=None)
    """
    Quantity of insulin administered to the user.
    """

    insulin_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Type of insulin administered to the user.
    """

    urine_color: typing.Optional[str] = pydantic.Field(default=None)
    """
    Color of the user's urine.
    """

    user_notes: typing.Optional[str] = pydantic.Field(default=None)
    """
    User notes associated with the measurement.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
