# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .planned_workout_step_durations import PlannedWorkoutStepDurations
from .planned_workout_step_intensity import PlannedWorkoutStepIntensity
from .planned_workout_step_targets import PlannedWorkoutStepTargets


class PlannedWorkoutStep(UncheckedBaseModel):
    targets: typing.Optional[typing.List[PlannedWorkoutStepTargets]] = pydantic.Field(default=None)
    """
    List of targets for the workout
    """

    intensity: typing.Optional[PlannedWorkoutStepIntensity] = pydantic.Field(default=None)
    """
    Planned intensity for the workout step
    """

    order: typing.Optional[int] = pydantic.Field(default=None)
    """
    Position of the workout step in the overall workout
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of workout step
    """

    durations: typing.Optional[typing.List[PlannedWorkoutStepDurations]] = pydantic.Field(default=None)
    """
    List of conditions to be fulfilled for the workout step to be completed - all of the conditions must be completed
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of workout step
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
