# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .position_sample import PositionSample


class PositionData(UncheckedBaseModel):
    center_pos_lat_lng_deg: typing.Optional[typing.List[float]] = pydantic.Field(default=None)
    """
    Position of the user at the midway point of the workout, represented by a 2-value array of latitude, longitude, wherein each of the two numbers can be nullable.
    """

    end_pos_lat_lng_deg: typing.Optional[typing.List[float]] = pydantic.Field(default=None)
    """
    Position of the user at the end of the workout, represented by a 2-value array of latitude, longitude, wherein each of the two numbers can be nullable.
    """

    position_samples: typing.Optional[typing.List[PositionSample]] = pydantic.Field(default=None)
    """
    Array of datapoints of the position of the user, sampled throughout the workout.
    """

    start_pos_lat_lng_deg: typing.Optional[typing.List[float]] = pydantic.Field(default=None)
    """
    Position of the user at the start of the workout, represented by a 2-value array of latitude, longitude, wherein each of the two numbers can be nullable.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
