# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .terra_user import TerraUser


class RateLimitHitEvent(UncheckedBaseModel):
    """
    Rate limit hit event
    """

    type: typing.Literal["rate_limit_hit"] = "rate_limit_hit"
    user: TerraUser = pydantic.Field()
    """
    User whose request hit rate limits
    """

    start_date: str = pydantic.Field()
    """
    Start date of the requested data range
    """

    end_date: str = pydantic.Field()
    """
    End date of the requested data range
    """

    retrying_at: str = pydantic.Field()
    """
    When the request will be retried
    """

    message: str = pydantic.Field()
    """
    Information about the rate limit
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
