# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .asleep_durations import AsleepDurations
from .awake_durations import AwakeDurations
from .other_sleep_durations import OtherSleepDurations
from .sleep_hypnogram_sample import SleepHypnogramSample


class SleepDurationsData(UncheckedBaseModel):
    asleep: typing.Optional[AsleepDurations] = pydantic.Field(default=None)
    """
    Object containing information on the duration the user spent asleep during the sleep recording session.
    """

    awake: typing.Optional[AwakeDurations] = pydantic.Field(default=None)
    """
    Object containing information on the duration the user spent awake during the sleep recording session.
    """

    hypnogram_samples: typing.Optional[typing.List[SleepHypnogramSample]] = pydantic.Field(default=None)
    """
    List of sleep stage (Hypnogram) samples recorded during the user's sleep session.
    """

    other: typing.Optional[OtherSleepDurations] = pydantic.Field(default=None)
    """
    Object containing information on the miscellaneous duration data for the sleep recording session.
    """

    sleep_efficiency: typing.Optional[float] = pydantic.Field(default=None)
    """
    Sleep efficiency of the user given as a percentage, measured as time spent asleep divided by time spent in bed.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
