/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammars.persistency;

import com.siemens.ct.exi.core.context.GrammarContext;
import com.siemens.ct.exi.core.context.GrammarUriContext;
import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.datatype.Datatype;
import com.siemens.ct.exi.core.datatype.DatetimeDatatype;
import com.siemens.ct.exi.core.datatype.EnumerationDatatype;
import com.siemens.ct.exi.core.datatype.ListDatatype;
import com.siemens.ct.exi.core.datatype.NBitUnsignedIntegerDatatype;
import com.siemens.ct.exi.core.datatype.RestrictedCharacterSetDatatype;
import com.siemens.ct.exi.core.datatype.charset.RestrictedCharacterSet;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.grammars.SchemaInformedGrammars;
import com.siemens.ct.exi.core.grammars.event.Attribute;
import com.siemens.ct.exi.core.grammars.event.AttributeNS;
import com.siemens.ct.exi.core.grammars.event.Characters;
import com.siemens.ct.exi.core.grammars.event.DatatypeEvent;
import com.siemens.ct.exi.core.grammars.event.Event;
import com.siemens.ct.exi.core.grammars.event.EventType;
import com.siemens.ct.exi.core.grammars.event.StartElement;
import com.siemens.ct.exi.core.grammars.event.StartElementNS;
import com.siemens.ct.exi.core.grammars.grammar.DocEnd;
import com.siemens.ct.exi.core.grammars.grammar.Document;
import com.siemens.ct.exi.core.grammars.grammar.Fragment;
import com.siemens.ct.exi.core.grammars.grammar.Grammar;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedDocContent;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedElement;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedFragmentContent;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedGrammar;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedStartTagGrammar;
import com.siemens.ct.exi.core.grammars.production.Production;
import com.siemens.ct.exi.core.types.BuiltIn;
import com.siemens.ct.exi.core.types.BuiltInType;
import com.siemens.ct.exi.core.values.IntegerValue;
import com.siemens.ct.exi.core.values.Value;
import com.siemens.ct.exi.grammars.XSDGrammarsBuilder;
import com.siemens.ct.exi.grammars.persistency.GrammarsPreperation;
import com.siemens.ct.exi.grammars.util.PrintfUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class Grammars2JSON {
    public static final PrintStream ps = System.out;
    public static final boolean STATS_ON = true;
    protected int statsCountTransitions = 0;
    protected int statsCountStates = 0;
    GrammarsPreperation gpreps = new GrammarsPreperation();

    protected void clear() {
        this.gpreps.clear();
    }

    public void toGrammarsJSON(SchemaInformedGrammars grammars, OutputStream os) throws IOException, EXIException {
        this.clear();
        this.gpreps.prepareGrammars(grammars);
        GrammarContext grammarContext = grammars.getGrammarContext();
        OutputStreamWriter w = new OutputStreamWriter(os);
        ArrayList<Datatype> listOfDatatypes = new ArrayList<Datatype>();
        int i = 0;
        while (i < this.gpreps.getNumberOfGrammars()) {
            Grammar r = this.gpreps.getGrammar(i);
            int k = 0;
            while (k < r.getNumberOfEvents()) {
                Production p = r.getProduction(k);
                Event e = p.getEvent();
                if (e instanceof DatatypeEvent) {
                    Datatype base;
                    DatatypeEvent de = (DatatypeEvent)e;
                    if (!listOfDatatypes.contains(de.getDatatype()) && de.getDatatype() != BuiltIn.getDefaultDatatype()) {
                        listOfDatatypes.add(de.getDatatype());
                    }
                    if ((base = de.getDatatype().getBaseDatatype()) != null && !listOfDatatypes.contains(base)) {
                        listOfDatatypes.add(base);
                    }
                }
                ++k;
            }
            ++i;
        }
        int ind = 0;
        PrintfUtils.printfIndLn(w, ind, "{", new Object[0]);
        PrintfUtils.printfIndLn(w, ++ind, "\"%s\" : { ", "qnames");
        PrintfUtils.printfIndLn(w, ++ind, "\"%s\" : [", "namespaceContext", grammarContext.getNumberOfGrammarQNameContexts());
        ++ind;
        int i2 = 0;
        while (i2 < grammarContext.getNumberOfGrammarUriContexts()) {
            PrintfUtils.printfIndLn(w, ind, "{", new Object[0]);
            GrammarUriContext guc = grammarContext.getGrammarUriContext(i2);
            PrintfUtils.printfIndLn(w, ++ind, "\"%s\" : %d ,", "uriID", guc.getNamespaceUriID());
            PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\", ", "uri", guc.getNamespaceUri());
            PrintfUtils.printfIndLn(w, ind, "\"%s\" : [", "qnameContext");
            ++ind;
            int k = 0;
            while (k < guc.getNumberOfQNames()) {
                QNameContext qnc = guc.getQNameContext(k);
                PrintfUtils.printfIndLn(w, ind, "{", new Object[0]);
                PrintfUtils.printfIndLn(w, ++ind, "\"%s\" : %d ,", "uriID", qnc.getNamespaceUriID());
                PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d ,", "localNameID", qnc.getLocalNameID());
                PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\"", "localName", qnc.getLocalName());
                if (qnc.getTypeGrammar() != null) {
                    PrintfUtils.printfIndLn(w, ind, ",", new Object[0]);
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : %s ", "globalTypeGrammarID", this.gpreps.getGrammarID(qnc.getTypeGrammar()));
                }
                if (qnc.getGlobalStartElement() != null) {
                    StartElement se = qnc.getGlobalStartElement();
                    PrintfUtils.printfIndLn(w, ind, ",", new Object[0]);
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : %s ", "globalElementGrammarID", this.gpreps.getGrammarID(se.getGrammar()));
                }
                if (qnc.getGlobalAttribute() != null) {
                    Attribute at = qnc.getGlobalAttribute();
                    PrintfUtils.printfIndLn(w, ind, ",", new Object[0]);
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : %s ", "globalAttributeDatatypeID", listOfDatatypes.indexOf(at.getDatatype()));
                }
                PrintfUtils.printfIndLn(w, --ind, "}", new Object[0]);
                if (k < guc.getNumberOfQNames() - 1) {
                    PrintfUtils.printfIndLn(w, ind, ", ", new Object[0]);
                }
                ++k;
            }
            PrintfUtils.printfIndLn(w, --ind, "]", new Object[0]);
            PrintfUtils.printfIndLn(w, --ind, "}", new Object[0]);
            if (i2 < grammarContext.getNumberOfGrammarUriContexts() - 1) {
                PrintfUtils.printfIndLn(w, ind, ", ", new Object[0]);
            }
            ++i2;
        }
        PrintfUtils.printfIndLn(w, --ind, "]", new Object[0]);
        PrintfUtils.printfIndLn(w, --ind, "}", new Object[0]);
        PrintfUtils.printfIndLn(w, ind, ",", new Object[0]);
        PrintfUtils.printfIndLn(w, ind, "\"%s\" : [ ", "simpleDatatypes");
        ++ind;
        i2 = 0;
        while (i2 < listOfDatatypes.size()) {
            Datatype dt = (Datatype)listOfDatatypes.get(i2);
            PrintfUtils.printfIndLn(w, ind, "{", new Object[0]);
            PrintfUtils.printfIndLn(w, ++ind, "\"%s\" : %d,", "simpleDatatypeID", i2);
            this.printBuiltInDatatype(w, ind, dt);
            dt.getSchemaType();
            PrintfUtils.printfIndLn(w, --ind, "}", new Object[0]);
            if (i2 < listOfDatatypes.size() - 1) {
                PrintfUtils.printfIndLn(w, ind, ", ", new Object[0]);
            }
            ++i2;
        }
        PrintfUtils.printfIndLn(w, --ind, "]", new Object[0]);
        PrintfUtils.printfIndLn(w, ind, ", ", new Object[0]);
        PrintfUtils.printfIndLn(w, ind, "\"grs\" : {", new Object[0]);
        PrintfUtils.printfIndLn(w, ++ind, "\"%s\" : %d ,", "documentGrammarID", this.gpreps.getGrammarID(grammars.getDocumentGrammar()));
        PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d ,", "fragmentGrammarID", this.gpreps.getGrammarID(grammars.getFragmentGrammar()));
        PrintfUtils.printfIndLn(w, ind, "\"%s\" : [", "grammar", this.gpreps.getGrammarID(grammars.getDocumentGrammar()));
        ++ind;
        i2 = 0;
        while (i2 < this.gpreps.getNumberOfGrammars()) {
            Grammar r = this.gpreps.getGrammar(i2);
            this.printGrammar(w, ind, (SchemaInformedGrammar)r, listOfDatatypes);
            if (i2 < this.gpreps.getNumberOfGrammars() - 1) {
                PrintfUtils.printfIndLn(w, ind, ", ", new Object[0]);
            }
            ++i2;
        }
        PrintfUtils.printfIndLn(w, --ind, "]", new Object[0]);
        PrintfUtils.printfIndLn(w, --ind, "}", new Object[0]);
        PrintfUtils.printfIndLn(w, 0, "}", new Object[0]);
        ((Writer)w).flush();
    }

    protected void printGrammar(Writer w, int ind, SchemaInformedGrammar sir, List<Datatype> listOfDatatypes) throws IOException {
        PrintfUtils.printfIndLn(w, ind, "{", new Object[0]);
        PrintfUtils.printfIndLn(w, ++ind, "\"%s\" : \"%d\" ,", "grammarID", this.gpreps.getGrammarID(sir));
        if (sir instanceof SchemaInformedFirstStartTagGrammar) {
            SchemaInformedFirstStartTagGrammar fst = (SchemaInformedFirstStartTagGrammar)sir;
            PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "type", "firstStartTagContent");
            PrintfUtils.printfIndLn(w, ind, "\"%s\" : %s ,", "isTypeCastable", fst.isTypeCastable());
            PrintfUtils.printfIndLn(w, ind, "\"%s\" : %s ,", "isNillable", fst.isNillable());
        } else if (sir instanceof SchemaInformedStartTagGrammar) {
            PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "type", "startTagContent");
        } else if (sir instanceof SchemaInformedElement) {
            PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "type", "elementContent");
        } else if (sir instanceof Document) {
            PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "type", "document");
        } else if (sir instanceof SchemaInformedDocContent) {
            PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "type", "docContent");
        } else if (sir instanceof DocEnd) {
            PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "type", "docEnd");
        } else if (sir instanceof Fragment) {
            PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "type", "fragment");
        } else if (sir instanceof SchemaInformedFragmentContent) {
            PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "type", "fragmentContent");
        } else {
            throw new RuntimeException("Unkown Rule type: " + sir);
        }
        ++this.statsCountStates;
        PrintfUtils.printfIndLn(w, ind, "\"%s\" : [ ", "production");
        this.printGrammarProduction(w, ++ind, sir, listOfDatatypes);
        PrintfUtils.printfIndLn(w, --ind, "]", new Object[0]);
        PrintfUtils.printfIndLn(w, --ind, "}", new Object[0]);
    }

    protected void printGrammarProduction(Writer w, int ind, SchemaInformedGrammar sir, List<Datatype> listOfDatatypes) throws IOException {
        int i = 0;
        while (i < sir.getNumberOfEvents()) {
            ++this.statsCountTransitions;
            PrintfUtils.printfIndLn(w, ind, "{", new Object[0]);
            ++ind;
            Production ei = sir.getProduction(i);
            Event event = ei.getEvent();
            EventType eventType = event.getEventType();
            switch (eventType) {
                case START_DOCUMENT: {
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "event", "startDocument");
                    break;
                }
                case END_DOCUMENT: {
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "event", "endDocument");
                    break;
                }
                case START_ELEMENT: {
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "event", "startElement");
                    StartElement se = (StartElement)event;
                    QNameContext eqname = se.getQNameContext();
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d ,", "startElementNamespaceID", eqname.getNamespaceUriID());
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d ,", "startElementLocalNameID", eqname.getLocalNameID());
                    Grammar seRule = se.getGrammar();
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d ,", "startElementGrammarID", this.gpreps.getGrammarID(seRule));
                    break;
                }
                case START_ELEMENT_NS: {
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "event", "startElementNS");
                    StartElementNS seNS = (StartElementNS)event;
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d ,", "startElementNamespaceID", seNS.getNamespaceUriID());
                    break;
                }
                case END_ELEMENT: {
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "event", "endElement");
                    break;
                }
                case ATTRIBUTE: {
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "event", "attribute");
                    Attribute at = (Attribute)event;
                    QNameContext eqname = at.getQNameContext();
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d ,", "attributeNamespaceID", eqname.getNamespaceUriID());
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d ,", "attributeLocalNameID", eqname.getLocalNameID());
                    Datatype dt = at.getDatatype();
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d ,", "attributeDatatypeID", listOfDatatypes.indexOf(dt));
                    break;
                }
                case ATTRIBUTE_NS: {
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "event", "attributeNS");
                    AttributeNS atNS = (AttributeNS)event;
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d ,", "attributeNamespaceID", atNS.getNamespaceUriID());
                    break;
                }
                case CHARACTERS: {
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "event", "characters");
                    Characters ch = (Characters)event;
                    Datatype dt = ch.getDatatype();
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d ,", "charactersDatatypeID", listOfDatatypes.indexOf(dt));
                    break;
                }
                case START_ELEMENT_GENERIC: {
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "event", "startElementGeneric");
                    break;
                }
                case ATTRIBUTE_GENERIC: {
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "event", "attributeGeneric");
                    break;
                }
                case CHARACTERS_GENERIC: {
                    PrintfUtils.printfIndLn(w, ind, "\"%s\" : \"%s\" ,", "event", "charactersGeneric");
                    break;
                }
                default: {
                    System.err.println("Unknown Event " + ei.getEvent());
                }
            }
            Grammar nextRule = ei.getNextGrammar();
            if (nextRule.getNumberOfEvents() > 0) {
                PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d", "nextGrammarID", this.gpreps.getGrammarID(nextRule));
            } else {
                PrintfUtils.printfIndLn(w, ind, "\"%s\" : %d", "nextGrammarID", -1);
            }
            PrintfUtils.printfIndLn(w, --ind, "}", new Object[0]);
            if (i < sir.getNumberOfEvents() - 1) {
                PrintfUtils.printfIndLn(w, ind, ", ", new Object[0]);
            }
            ++i;
        }
    }

    protected void printBuiltInDatatype(Writer w, int ind, Datatype dt) throws IOException {
        this.printBuiltInDatatype(w, ind, dt, "type");
    }

    protected void printBuiltInDatatype(Writer w, int ind, Datatype dt, String typeID) throws IOException {
        BuiltInType bit = dt.getBuiltInType();
        PrintfUtils.printfInd(w, ind, "\"%s\": \"%s\"", new Object[]{typeID, bit});
        switch (bit) {
            case NBIT_UNSIGNED_INTEGER: {
                PrintfUtils.printfLn(w, ",", new Object[]{bit});
                NBitUnsignedIntegerDatatype nbdt = (NBitUnsignedIntegerDatatype)dt;
                IntegerValue ivLower = nbdt.getLowerBound();
                PrintfUtils.printfIndLn(w, ind, "\"%s\": %s,", "lowerBound", ivLower.toString());
                IntegerValue ivUpper = nbdt.getUpperBound();
                PrintfUtils.printfIndLn(w, ind, "\"%s\": %s", "upperBound", ivUpper.toString());
                break;
            }
            case LIST: {
                PrintfUtils.printfLn(w, ",", new Object[]{bit});
                ListDatatype ldt = (ListDatatype)dt;
                this.printBuiltInDatatype(w, ind, ldt.getListDatatype(), "listType");
                break;
            }
            case ENUMERATION: {
                PrintfUtils.printfLn(w, ",", new Object[]{bit});
                EnumerationDatatype edt = (EnumerationDatatype)dt;
                PrintfUtils.printfInd(w, ind, "\"%s\": [", "enumValues");
                int i = 0;
                while (i < edt.getEnumerationSize()) {
                    Value enumVal = edt.getEnumValue(i);
                    PrintfUtils.printf(w, "\"%s\"", enumVal.toString());
                    if (i + 1 < edt.getEnumerationSize()) {
                        PrintfUtils.printf(w, ", ", new Object[0]);
                    }
                    ++i;
                }
                PrintfUtils.printfLn(w, "]", new Object[0]);
                break;
            }
            case DATETIME: {
                PrintfUtils.printfLn(w, ",", new Object[]{bit});
                DatetimeDatatype ddt = (DatetimeDatatype)dt;
                PrintfUtils.printfIndLn(w, ind, "\"%s\": \"%s\"", "datetimeType", ddt.getDatetimeType().toString());
                break;
            }
            case RCS_STRING: {
                PrintfUtils.printfLn(w, ",", new Object[]{bit});
                RestrictedCharacterSetDatatype rcsdt = (RestrictedCharacterSetDatatype)dt;
                RestrictedCharacterSet rcs = rcsdt.getRestrictedCharacterSet();
                PrintfUtils.printfInd(w, ind, "\"%s\": [", "codePoints");
                int i = 0;
                while (i < rcs.size()) {
                    PrintfUtils.printf(w, "%d", rcs.getCodePoint(i));
                    if (i + 1 < rcs.size()) {
                        PrintfUtils.printf(w, ", ", new Object[0]);
                    }
                    ++i;
                }
                PrintfUtils.printfLn(w, "]", new Object[0]);
                break;
            }
            case BOOLEAN_FACET: {
                PrintfUtils.printfLn(w, ",", new Object[]{bit});
                PrintfUtils.printfIndLn(w, ind, "\"%s\": \"%s\"", "facet", "true");
                break;
            }
            default: {
                PrintfUtils.printfLn(w, "", new Object[]{bit});
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ps.println("#########################################################################");
        ps.println("###   EXIficient - Grammars2JSON                                     ###");
        ps.println("###   Command-Shell Options                                          ###");
        ps.println("#########################################################################");
        ps.println(" <xsd-input-file>");
        String grsOut = null;
        String xsd = "./src/main/resources/schemas_ISO_15118_20/V2G_CI_CommonMessages.xsd";
        grsOut = String.valueOf(xsd) + ".grs";
        XSDGrammarsBuilder grammarBuilder = XSDGrammarsBuilder.newInstance();
        grammarBuilder.loadGrammars(xsd);
        SchemaInformedGrammars grammarIn = grammarBuilder.toGrammars();
        Grammars2JSON g2j = new Grammars2JSON();
        FileOutputStream fos = new FileOutputStream(grsOut);
        g2j.toGrammarsJSON(grammarIn, fos);
        fos.close();
        System.out.println("Transitions: " + g2j.statsCountTransitions);
        System.out.println("States: " + g2j.statsCountStates);
    }
}

