/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammars.persistency;

import com.siemens.ct.exi.core.context.GrammarContext;
import com.siemens.ct.exi.core.context.GrammarUriContext;
import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.datatype.Datatype;
import com.siemens.ct.exi.core.datatype.DatetimeDatatype;
import com.siemens.ct.exi.core.datatype.EnumerationDatatype;
import com.siemens.ct.exi.core.datatype.ListDatatype;
import com.siemens.ct.exi.core.datatype.NBitUnsignedIntegerDatatype;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.grammars.SchemaInformedGrammars;
import com.siemens.ct.exi.core.grammars.event.Attribute;
import com.siemens.ct.exi.core.grammars.event.AttributeGeneric;
import com.siemens.ct.exi.core.grammars.event.Characters;
import com.siemens.ct.exi.core.grammars.event.CharactersGeneric;
import com.siemens.ct.exi.core.grammars.event.EndDocument;
import com.siemens.ct.exi.core.grammars.event.EndElement;
import com.siemens.ct.exi.core.grammars.event.StartDocument;
import com.siemens.ct.exi.core.grammars.event.StartElement;
import com.siemens.ct.exi.core.grammars.event.StartElementGeneric;
import com.siemens.ct.exi.core.grammars.event.StartElementNS;
import com.siemens.ct.exi.core.grammars.grammar.Grammar;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedFirstStartTag;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedStartTag;
import com.siemens.ct.exi.core.grammars.production.Production;
import com.siemens.ct.exi.core.types.BuiltIn;
import com.siemens.ct.exi.core.types.BuiltInType;
import com.siemens.ct.exi.core.values.IntegerValue;
import com.siemens.ct.exi.core.values.StringValue;
import com.siemens.ct.exi.core.values.Value;
import com.siemens.ct.exi.grammars.XSDGrammarsBuilder;
import com.siemens.ct.exi.grammars.persistency.GrammarsPreperation;
import com.siemens.ct.exi.grammars.util.PrintfUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class Grammars2JavaSourceCode {
    protected static final String TOKEN_GRAMMAR_CONTEXT_BEGIN = "/* BEGIN GrammarContext ----- */";
    protected static final String TOKEN_GRAMMAR_CONTEXT_END = "/* END GrammarContext ----- */";
    protected static final String TOKEN_GRAMMARS_BEGIN = "/* BEGIN Grammars ----- */";
    protected static final String TOKEN_GRAMMARS_END = "/* END Grammars ----- */";
    protected static final String TOKEN_GRAMMARS_WITH_ELEMENT_CONTENT_BEGIN = "/* BEGIN Grammars with element content ----- */";
    protected static final String TOKEN_GRAMMARS_WITH_ELEMENT_CONTENT_END = "/* END Grammars with element content ----- */";
    protected static final String TOKEN_GRAMMAR_EVENTS_BEGIN = "/* BEGIN Grammar Events ----- */";
    protected static final String TOKEN_GRAMMAR_EVENTS_END = "/* END Grammar Events ----- */";
    protected static final String TOKEN_GLOBALS_BEGIN = "/* BEGIN Globals ----- */";
    protected static final String TOKEN_GLOBALS_END = "/* END Globals ----- */";
    protected static final String TOKEN_SCHEMA_ID_BEGIN = "/* BEGIN SchemaId ----- */";
    protected static final String TOKEN_SCHEMA_ID_END = "/* END SchemaId ----- */";
    protected static final String TOKEN_GLOBAL_ELEMENTS_BEGIN = "/* BEGIN GlobalElements ----- */";
    protected static final String TOKEN_GLOBAL_ELEMENTS_END = "/* END GlobalElements ----- */";
    protected static final String TOKEN_GLOBAL_ATTRIBUTES_BEGIN = "/* BEGIN GlobalAttributes ----- */";
    protected static final String TOKEN_GLOBAL_ATTRIBUTES_END = "/* END GlobalAttributes ----- */";
    protected static final String TOKEN_TYPE_GRAMMAR_BEGIN = "/* BEGIN TypeGrammar ----- */";
    protected static final String TOKEN_TYPE_GRAMMAR_END = "/* END TypeGrammar ----- */";
    protected static final String TOKEN_FIRST_STARTTAG_GRAMMAR_BEGIN = "/* BEGIN FirstStartGrammar ----- */";
    protected static final String TOKEN_FIRST_STARTTAG_GRAMMAR_END = "/* END FirstStartGrammar ----- */";
    protected static final String TOKEN_DOCUMENT_GRAMMAR_BEGIN = "/* BEGIN Document Grammar ----- */";
    protected static final String TOKEN_DOCUMENT_GRAMMAR_END = "/* END Document Grammar ----- */";
    protected static final String TOKEN_FRAGMENT_GRAMMAR_BEGIN = "/* BEGIN Fragment Grammar ----- */";
    protected static final String TOKEN_FRAGMENT_GRAMMAR_END = "/* END Fragment Grammar ----- */";
    protected static final String TOKEN_SCHEMA_INFORMED_GRAMMARS_BEGIN = "/* BEGIN SchemaInformedGrammars ----- */";
    protected static final String TOKEN_SCHEMA_INFORMED_GRAMMARS_END = "/* END SchemaInformedGrammars ----- */";
    protected static final String TOKEN_PACKAGE = Grammars2JavaSourceCode.class.getPackage().toString();
    protected static final String TOKEN_CLASS_SUFFIX = "Template";
    protected static final String TOKEN_CLASS = "public class " + Grammars2JavaSourceCode.class.getSimpleName() + "Template";
    protected static final String TOKEN_CLASS_CONSTRUCTOR = "public " + Grammars2JavaSourceCode.class.getSimpleName() + "Template";
    static final String STATIC_SAMPLE_GRAMMAR = "com/siemens/ct/exi/grammars/persistency/Grammars2JavaSourceCodeTemplate.java";
    GrammarsPreperation gpreps = new GrammarsPreperation();
    StringWriter swGC;
    StringWriter swGlobals;
    StringWriter swGlobalElements;
    StringWriter swGlobalAttributes;
    StringWriter swTypeGrammar;
    StringWriter swFirstStartGrammar;
    StringWriter swGrammars;
    StringWriter swGrammarsWithElementContent;
    StringWriter swEvents;
    int documentGrammarID;
    int fragmentGrammarID;
    String schemaId;
    SchemaInformedGrammars grammars;

    public Grammars2JavaSourceCode(SchemaInformedGrammars grammars) {
        this.grammars = grammars;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    protected int getQNameID(QNameContext qnc) {
        GrammarContext gc = this.grammars.getGrammarContext();
        int qnameID = 0;
        int i = 0;
        while (i < gc.getNumberOfGrammarUriContexts()) {
            GrammarUriContext guc = gc.getGrammarUriContext(i);
            int k = 0;
            while (k < guc.getNumberOfQNames()) {
                QNameContext qnX = guc.getQNameContext(k);
                if (qnc.equals(qnX)) {
                    return qnameID;
                }
                ++qnameID;
                ++k;
            }
            ++i;
        }
        return -1;
    }

    public void generateCode() throws IOException {
        this.gpreps.prepareGrammars(this.grammars);
        this.documentGrammarID = -1;
        this.fragmentGrammarID = -1;
        this.swGlobals = new StringWriter();
        this.swGlobalElements = new StringWriter();
        this.swGlobalAttributes = new StringWriter();
        this.swTypeGrammar = new StringWriter();
        this.swFirstStartGrammar = new StringWriter();
        PrintfUtils.printfIndLn(this.swGlobalElements, 1, "%s", TOKEN_GLOBAL_ELEMENTS_BEGIN);
        PrintfUtils.printfIndLn(this.swGlobalAttributes, 1, "%s", TOKEN_GLOBAL_ATTRIBUTES_BEGIN);
        PrintfUtils.printfIndLn(this.swTypeGrammar, 1, "%s", TOKEN_TYPE_GRAMMAR_BEGIN);
        PrintfUtils.printfIndLn(this.swFirstStartGrammar, 1, "%s", TOKEN_FIRST_STARTTAG_GRAMMAR_BEGIN);
        this.swGC = new StringWriter();
        PrintfUtils.printfIndLn(this.swGC, 1, "%s", TOKEN_GRAMMAR_CONTEXT_BEGIN);
        GrammarContext gc = this.grammars.getGrammarContext();
        StringBuilder sbUriContexts = new StringBuilder();
        int qnameID = 0;
        int i = 0;
        while (i < gc.getNumberOfGrammarUriContexts()) {
            GrammarUriContext guc = gc.getGrammarUriContext(i);
            PrintfUtils.printfIndLn(this.swGC, 1, "final String ns%d = \"%s\";", i, guc.getNamespaceUri());
            StringBuilder sbQnames = new StringBuilder();
            int k = 0;
            while (k < guc.getNumberOfQNames()) {
                QNameContext qnc = guc.getQNameContext(k);
                PrintfUtils.printfIndLn(this.swGC, 1, "final QNameContext qnc%d = new QNameContext(%d, %d, new QName(ns%d, \"%s\"));", qnameID, qnc.getNamespaceUriID(), qnc.getLocalNameID(), i, qnc.getLocalName());
                sbQnames.append("qnc");
                sbQnames.append(qnameID);
                if (k != guc.getNumberOfQNames() - 1) {
                    sbQnames.append(", ");
                }
                assert (qnameID == this.getQNameID(qnc));
                if (qnc.getGlobalStartElement() != null) {
                    StartElement g = qnc.getGlobalStartElement();
                    int globalIdID = this.gpreps.getGrammarID(g.getGrammar());
                    PrintfUtils.printfIndLn(this.swGlobals, 1, String.valueOf(StartElement.class.getName()) + " globalSE%d = new " + StartElement.class.getName() + "(qnc" + qnameID + ", g" + globalIdID + ");", qnameID);
                    PrintfUtils.printfIndLn(this.swGlobalElements, 1, "qnc%d.setGlobalStartElement(globalSE%d);", qnameID, qnameID);
                }
                if (qnc.getGlobalAttribute() != null) {
                    Attribute a = qnc.getGlobalAttribute();
                    PrintfUtils.printfIndLn(this.swGlobals, 1, String.valueOf(Attribute.class.getName()) + " globalAT%d = new " + Attribute.class.getName() + "(qnc" + qnameID + ", " + this.getDatatypeConstructor(a.getDatatype()) + ");", qnameID);
                    PrintfUtils.printfIndLn(this.swGlobalAttributes, 1, "qnc%d.setGlobalAttribute(globalAT%d);", qnameID, qnameID);
                }
                if (qnc.getTypeGrammar() != null) {
                    SchemaInformedFirstStartTagGrammar sifstg = qnc.getTypeGrammar();
                    int grID = this.gpreps.getGrammarID(sifstg);
                    PrintfUtils.printfIndLn(this.swTypeGrammar, 1, "qnc%d.setTypeGrammar(g%d);", qnameID, grID);
                }
                ++qnameID;
                ++k;
            }
            PrintfUtils.printfIndLn(this.swGC, 1, "final QNameContext[] grammarQNames%d = {%s};", i, sbQnames);
            StringBuilder sbPrefixes = new StringBuilder();
            int k2 = 0;
            while (k2 < guc.getNumberOfPrefixes()) {
                sbPrefixes.append("\"");
                sbPrefixes.append(guc.getPrefix(k2));
                sbPrefixes.append("\"");
                if (k2 != guc.getNumberOfPrefixes() - 1) {
                    sbPrefixes.append(", ");
                }
                ++k2;
            }
            PrintfUtils.printfIndLn(this.swGC, 1, "final String[] grammarPrefixes%d = {%s};", i, sbPrefixes);
            PrintfUtils.printfIndLn(this.swGC, 1, "final GrammarUriContext guc%d = new GrammarUriContext(%d, ns%d, grammarQNames%d, grammarPrefixes%d);", i, i, i, i, i);
            sbUriContexts.append("guc");
            sbUriContexts.append(i);
            if (i != gc.getNumberOfGrammarUriContexts() - 1) {
                sbUriContexts.append(", ");
            }
            PrintfUtils.printfIndLn(this.swGC, 1, "", new Object[0]);
            ++i;
        }
        PrintfUtils.printfIndLn(this.swGC, 1, "final GrammarUriContext[] grammarUriContexts = {%s};", sbUriContexts);
        PrintfUtils.printfIndLn(this.swGC, 1, "final GrammarContext gc = new GrammarContext(grammarUriContexts, %d);", gc.getNumberOfGrammarQNameContexts());
        PrintfUtils.printfIndLn(this.swGC, 1, "%s", TOKEN_GRAMMAR_CONTEXT_END);
        PrintfUtils.printfIndLn(this.swGlobalElements, 1, "%s", TOKEN_GLOBAL_ELEMENTS_END);
        PrintfUtils.printfIndLn(this.swGlobalAttributes, 1, "%s", TOKEN_GLOBAL_ATTRIBUTES_END);
        PrintfUtils.printfIndLn(this.swTypeGrammar, 1, "%s", TOKEN_TYPE_GRAMMAR_END);
        this.swGrammars = new StringWriter();
        this.swGrammarsWithElementContent = new StringWriter();
        this.swEvents = new StringWriter();
        PrintfUtils.printfIndLn(this.swGrammars, 1, "%s", TOKEN_GRAMMARS_BEGIN);
        PrintfUtils.printfIndLn(this.swGrammarsWithElementContent, 1, "%s", TOKEN_GRAMMARS_WITH_ELEMENT_CONTENT_BEGIN);
        PrintfUtils.printfIndLn(this.swEvents, 1, "%s", TOKEN_GRAMMAR_EVENTS_BEGIN);
        i = 0;
        while (i < this.gpreps.getNumberOfGrammars()) {
            Grammar r = this.gpreps.getGrammar(i);
            int currentID = this.gpreps.getGrammarID(r);
            int numberOfEvents = r.getNumberOfEvents();
            String sConstructor = "null";
            switch (r.getGrammarType()) {
                case DOCUMENT: {
                    this.documentGrammarID = currentID;
                    PrintfUtils.printfIndLn(this.swGrammars, 1, "%s g%d = new %s();", r.getClass().getName(), currentID, r.getClass().getName());
                    break;
                }
                case FRAGMENT: {
                    this.fragmentGrammarID = currentID;
                    PrintfUtils.printfIndLn(this.swGrammars, 1, "%s g%d = new %s();", r.getClass().getName(), currentID, r.getClass().getName());
                    break;
                }
                case DOC_END: 
                case SCHEMA_INFORMED_DOC_CONTENT: 
                case SCHEMA_INFORMED_FRAGMENT_CONTENT: 
                case SCHEMA_INFORMED_ELEMENT_CONTENT: {
                    PrintfUtils.printfIndLn(this.swGrammars, 1, "%s g%d = new %s();", r.getClass().getName(), currentID, r.getClass().getName());
                    break;
                }
                case SCHEMA_INFORMED_FIRST_START_TAG_CONTENT: {
                    SchemaInformedFirstStartTag sifst = (SchemaInformedFirstStartTag)r;
                    Grammar elementContentGrammar = sifst.getElementContentGrammar();
                    int elementContentGrammarID = this.gpreps.getGrammarID(elementContentGrammar);
                    PrintfUtils.printfIndLn(this.swGrammarsWithElementContent, 1, "%s g%d = new %s(g%d);", r.getClass().getName(), currentID, r.getClass().getName(), elementContentGrammarID);
                    PrintfUtils.printfIndLn(this.swFirstStartGrammar, 1, "g%d.setElementContentGrammar(%s);", currentID, "g" + this.gpreps.getGrammarID(sifst.getElementContentGrammar()));
                    if (sifst.isTypeCastable()) {
                        PrintfUtils.printfIndLn(this.swFirstStartGrammar, 1, "g%d.setTypeCastable(%s);", currentID, sifst.isTypeCastable());
                    }
                    if (!sifst.isNillable()) break;
                    PrintfUtils.printfIndLn(this.swFirstStartGrammar, 1, "g%d.setNillable(%s);", currentID, sifst.isNillable());
                    break;
                }
                case SCHEMA_INFORMED_START_TAG_CONTENT: {
                    SchemaInformedStartTag sist = (SchemaInformedStartTag)r;
                    Grammar elementContentGrammar = sist.getElementContentGrammar();
                    if (elementContentGrammar instanceof SchemaInformedStartTag) {
                        System.err.println("Error for " + sist + " and " + elementContentGrammar);
                    }
                    int elementContentGrammarID = this.gpreps.getGrammarID(elementContentGrammar);
                    PrintfUtils.printfIndLn(this.swGrammarsWithElementContent, 1, "%s g%d = new %s(g%d);", r.getClass().getName(), currentID, r.getClass().getName(), elementContentGrammarID);
                    break;
                }
                case BUILT_IN_DOC_CONTENT: 
                case BUILT_IN_FRAGMENT_CONTENT: 
                case BUILT_IN_START_TAG_CONTENT: 
                case BUILT_IN_ELEMENT_CONTENT: {
                    throw new RuntimeException("Unsupported GrammarType " + (Object)((Object)r.getGrammarType()));
                }
            }
            int eventCode = 0;
            while (eventCode < numberOfEvents) {
                Production ei = r.getProduction(eventCode);
                int nextID = this.gpreps.getGrammarID(ei.getNextGrammar());
                switch (ei.getEvent().getEventType()) {
                    case START_DOCUMENT: {
                        sConstructor = "new " + StartDocument.class.getName() + "()";
                        break;
                    }
                    case END_DOCUMENT: {
                        sConstructor = "new " + EndDocument.class.getName() + "()";
                        break;
                    }
                    case START_ELEMENT: {
                        StartElement se = (StartElement)ei.getEvent();
                        if (se.getQNameContext().getGlobalStartElement() == se) {
                            sConstructor = "globalSE" + this.getQNameID(se.getQNameContext());
                            break;
                        }
                        sConstructor = "new " + StartElement.class.getName() + "(qnc" + this.getQNameID(se.getQNameContext()) + ", g" + this.gpreps.getGrammarID(se.getGrammar()) + ")";
                        break;
                    }
                    case START_ELEMENT_NS: {
                        StartElementNS seNS = (StartElementNS)ei.getEvent();
                        sConstructor = "new " + StartElementNS.class.getName() + "(" + seNS.getNamespaceUriID() + ", \"" + seNS.getNamespaceURI() + "\")";
                        break;
                    }
                    case START_ELEMENT_GENERIC: {
                        StartElementGeneric seGen = (StartElementGeneric)ei.getEvent();
                        sConstructor = "new " + StartElementGeneric.class.getName() + "()";
                        break;
                    }
                    case END_ELEMENT: {
                        sConstructor = "new " + EndElement.class.getName() + "()";
                        break;
                    }
                    case CHARACTERS: {
                        Characters ch = (Characters)ei.getEvent();
                        sConstructor = "new " + Characters.class.getName() + "(" + this.getDatatypeConstructor(ch.getDatatype()) + ")";
                        break;
                    }
                    case CHARACTERS_GENERIC: {
                        sConstructor = "new " + CharactersGeneric.class.getName() + "()";
                        break;
                    }
                    case ATTRIBUTE: {
                        Attribute at = (Attribute)ei.getEvent();
                        if (at.getQNameContext().getGlobalAttribute() == at) {
                            sConstructor = "globalAT" + this.getQNameID(at.getQNameContext());
                            break;
                        }
                        sConstructor = "new " + Attribute.class.getName() + "(qnc" + this.getQNameID(at.getQNameContext()) + ", " + this.getDatatypeConstructor(at.getDatatype()) + ")";
                        break;
                    }
                    case ATTRIBUTE_GENERIC: {
                        sConstructor = "new " + AttributeGeneric.class.getName() + "()";
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported Event = " + ei.getEvent());
                    }
                }
                PrintfUtils.printfIndLn(this.swEvents, 1, "g%d.addProduction(%s, g%d);", currentID, sConstructor, nextID);
                ++eventCode;
            }
            ++i;
        }
        PrintfUtils.printfIndLn(this.swEvents, 1, "%s", TOKEN_GRAMMAR_EVENTS_END);
        PrintfUtils.printfIndLn(this.swGrammars, 1, "%s", TOKEN_GRAMMARS_END);
        PrintfUtils.printfIndLn(this.swFirstStartGrammar, 1, "%s", TOKEN_FIRST_STARTTAG_GRAMMAR_END);
    }

    public static String readFileToString(File file) throws IOException {
        int c;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringWriter sFile = new StringWriter();
        while ((c = reader.read()) != -1) {
            sFile.append((char)c);
        }
        reader.close();
        return sFile.toString();
    }

    public String getGrammars(String packageName, String className) throws IOException {
        if ((packageName = packageName.trim()).length() > 0 && !packageName.startsWith("package ")) {
            packageName = "package " + packageName;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResource(STATIC_SAMPLE_GRAMMAR).openStream();
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            buf.write((byte)result);
            result = bis.read();
        }
        StringBuilder sStaticSimpleGrammar = new StringBuilder(buf.toString("UTF-8"));
        this.replace(sStaticSimpleGrammar, TOKEN_GRAMMAR_CONTEXT_BEGIN, TOKEN_GRAMMAR_CONTEXT_END, this.swGC.toString());
        this.replace(sStaticSimpleGrammar, TOKEN_GRAMMARS_BEGIN, TOKEN_GRAMMARS_END, this.swGrammars.toString());
        this.replace(sStaticSimpleGrammar, TOKEN_GRAMMARS_WITH_ELEMENT_CONTENT_BEGIN, TOKEN_GRAMMARS_WITH_ELEMENT_CONTENT_END, this.swGrammarsWithElementContent.toString());
        this.replace(sStaticSimpleGrammar, TOKEN_GLOBALS_BEGIN, TOKEN_GLOBALS_END, this.swGlobals.toString());
        if (this.schemaId != null) {
            this.replace(sStaticSimpleGrammar, TOKEN_SCHEMA_ID_BEGIN, TOKEN_SCHEMA_ID_END, "protected String schemaId = \"" + this.schemaId + "\";");
        }
        this.replace(sStaticSimpleGrammar, TOKEN_GLOBAL_ELEMENTS_BEGIN, TOKEN_GLOBAL_ELEMENTS_END, this.swGlobalElements.toString());
        this.replace(sStaticSimpleGrammar, TOKEN_GLOBAL_ATTRIBUTES_BEGIN, TOKEN_GLOBAL_ATTRIBUTES_END, this.swGlobalAttributes.toString());
        this.replace(sStaticSimpleGrammar, TOKEN_TYPE_GRAMMAR_BEGIN, TOKEN_TYPE_GRAMMAR_END, this.swTypeGrammar.toString());
        this.replace(sStaticSimpleGrammar, TOKEN_GRAMMAR_EVENTS_BEGIN, TOKEN_GRAMMAR_EVENTS_END, this.swEvents.toString());
        this.replace(sStaticSimpleGrammar, TOKEN_FIRST_STARTTAG_GRAMMAR_BEGIN, TOKEN_FIRST_STARTTAG_GRAMMAR_END, this.swFirstStartGrammar.toString());
        assert (this.documentGrammarID != -1);
        this.replace(sStaticSimpleGrammar, TOKEN_DOCUMENT_GRAMMAR_BEGIN, TOKEN_DOCUMENT_GRAMMAR_END, "return g" + this.documentGrammarID + ";");
        assert (this.fragmentGrammarID != -1);
        this.replace(sStaticSimpleGrammar, TOKEN_FRAGMENT_GRAMMAR_BEGIN, TOKEN_FRAGMENT_GRAMMAR_END, "return g" + this.fragmentGrammarID + ";");
        this.replace(sStaticSimpleGrammar, TOKEN_PACKAGE, TOKEN_PACKAGE, packageName);
        this.replace(sStaticSimpleGrammar, TOKEN_CLASS, TOKEN_CLASS, "public class " + className);
        this.replace(sStaticSimpleGrammar, TOKEN_CLASS_CONSTRUCTOR, TOKEN_CLASS_CONSTRUCTOR, "public " + className);
        int siefGrammarID = this.gpreps.getGrammarID(this.grammars.getSchemaInformedElementFragmentGrammar());
        this.replace(sStaticSimpleGrammar, TOKEN_SCHEMA_INFORMED_GRAMMARS_BEGIN, TOKEN_SCHEMA_INFORMED_GRAMMARS_END, "SchemaInformedGrammars grammars = new SchemaInformedGrammars(gc, g" + this.documentGrammarID + ", g" + this.fragmentGrammarID + ", g" + siefGrammarID + ");");
        return sStaticSimpleGrammar.toString();
    }

    void replace(StringBuilder sb, String tokenBegin, String tokenEnd, String newToken) {
        int ib = sb.indexOf(tokenBegin);
        int iE = sb.indexOf(tokenEnd);
        if (ib == -1 || iE == -1 || ib > iE) {
            throw new RuntimeException("Could not find the token BEGIN/END");
        }
        sb.replace(ib, iE += tokenEnd.length(), newToken);
    }

    private String getDatatypeConstructor(Datatype dt) {
        String addP = "";
        if (dt.getBuiltInType() == BuiltInType.DATETIME) {
            DatetimeDatatype dtt = (DatetimeDatatype)dt;
            addP = String.valueOf(((Object)((Object)dtt.getDatetimeType())).getClass().getName()) + "." + dtt.getDatetimeType().name() + ", ";
        } else if (dt.getBuiltInType() == BuiltInType.NBIT_UNSIGNED_INTEGER) {
            NBitUnsignedIntegerDatatype nbDT = (NBitUnsignedIntegerDatatype)dt;
            IntegerValue lb = nbDT.getLowerBound();
            IntegerValue ub = nbDT.getUpperBound();
            addP = String.valueOf(this.getIntegerValue(lb)) + ", " + this.getIntegerValue(ub) + ", ";
        } else if (dt.getBuiltInType() == BuiltInType.LIST) {
            ListDatatype ldt = (ListDatatype)dt;
            addP = String.valueOf(this.getDatatypeConstructor(ldt.getListDatatype())) + ", ";
        } else if (dt.getBuiltInType() == BuiltInType.ENUMERATION) {
            EnumerationDatatype edt = (EnumerationDatatype)dt;
            StringBuilder sv = new StringBuilder("new " + Value.class.getName() + "[] {");
            int i = 0;
            while (i < edt.getEnumerationSize()) {
                Value v = edt.getEnumValue(i);
                sv.append("new " + v.getClass().getName() + "(");
                if (v instanceof StringValue) {
                    sv.append("\"" + v.toString() + "\"");
                }
                sv.append(")");
                if (i < edt.getEnumerationSize() - 1) {
                    sv.append(", ");
                }
                ++i;
            }
            sv.append("}");
            String sdt = this.getDatatypeConstructor(edt.getEnumValueDatatype());
            addP = sv + ", " + sdt + ", ";
        }
        int qnameID = this.getQNameID(dt.getSchemaType());
        String s = qnameID < 0 ? String.valueOf(BuiltIn.class.getName()) + ".getDefaultDatatype()" : "new " + dt.getClass().getName() + "(" + addP + "qnc" + qnameID + ")";
        return s;
    }

    private String getIntegerValue(IntegerValue iv) {
        String s;
        switch (iv.getIntegerValueType()) {
            case INT: {
                s = String.valueOf(IntegerValue.class.getName()) + ".valueOf(" + iv.intValue() + ")";
                break;
            }
            case LONG: {
                s = String.valueOf(IntegerValue.class.getName()) + ".valueOf(" + iv.longValue() + "l)";
                break;
            }
            case BIG: {
                s = String.valueOf(IntegerValue.class.getName()) + ".valueOf(new " + BigInteger.class.getName() + "(" + iv.bigIntegerValue() + "))";
                break;
            }
            default: {
                throw new RuntimeException("Unsupported IntegerType " + iv);
            }
        }
        return s;
    }

    public static void main(String[] args) throws EXIException, IOException {
        String className = "GrammarsForGrammars";
        String xsd = "./src/main/resources/schemas_ISO_15118_20/V2G_CI_CommonMessages.xsd";
        XSDGrammarsBuilder grammarBuilder = XSDGrammarsBuilder.newInstance();
        grammarBuilder.loadGrammars(xsd);
        SchemaInformedGrammars grammarIn = grammarBuilder.toGrammars();
        Grammars2JavaSourceCode grammar2Java = new Grammars2JavaSourceCode(grammarIn);
        grammar2Java.setSchemaId("http://www.ct.siemens.com/exi/2017/SchemaForGrammars");
        grammar2Java.generateCode();
        String sf = grammar2Java.getGrammars(Grammars2JavaSourceCode.class.getPackage().toString(), className);
        System.out.println(sf);
        File f = File.createTempFile(className, ".java");
        Files.copy(f.toPath(), new File(String.valueOf(xsd) + ".java").toPath(), StandardCopyOption.REPLACE_EXISTING);
        FileOutputStream fos = new FileOutputStream(f);
        fos.write(sf.getBytes());
        fos.close();
        System.out.println("Written to file: " + f);
    }
}

