/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.conformhelpers.decode;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.siemens.ct.exi.main.conformhelpers.decode.ServiceDiscoveryRes;
import com.siemens.ct.exi.main.conformhelpers.decode.ServiceParameterList;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

public class ServiceDiscoveryResDecodeDeserializer
extends StdDeserializer<ServiceDiscoveryRes> {
    public ServiceDiscoveryResDecodeDeserializer() {
        this((Class<?>)null);
    }

    protected ServiceDiscoveryResDecodeDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public ServiceDiscoveryRes deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        String code = node.get("ResponseCode").asText();
        JsonNode paymentOptionList = node.get("PaymentOptionList");
        JsonNode modifiedpaymentOptionList = this.getModifiedPaymentOptionList(paymentOptionList);
        JsonNode chargeService = node.get("ChargeService");
        ServiceParameterList paramList = new ServiceParameterList();
        paramList.getAdditionalProperties().put("PaymentOptionList", modifiedpaymentOptionList);
        paramList.getAdditionalProperties().put("ChargeService", this.getModifiedChargeServiceList(chargeService));
        if (node.has("ServiceList")) {
            paramList.getAdditionalProperties().put("ServiceList", this.getModifiedServiceListList(node));
        }
        new ServiceDiscoveryRes(code, paramList);
        return new ServiceDiscoveryRes(code, paramList);
    }

    private JsonNode getModifiedPaymentOptionList(JsonNode paymentOptionList) throws JsonMappingException, JsonProcessingException {
        JSONArray paymentOptionsArray = new JSONArray();
        JSONArray allValues = new JSONObject(paymentOptionList.toString()).getJSONArray("PaymentOption");
        for (Object value : allValues) {
            JSONObject paymentOptions = new JSONObject();
            paymentOptions = paymentOptions.put("PaymentOption", value);
            paymentOptionsArray = paymentOptionsArray.put(paymentOptions);
        }
        return new ObjectMapper().readTree(paymentOptionsArray.toString());
    }

    private JsonNode getModifiedChargeServiceList(JsonNode chargeService) throws JsonMappingException, JsonProcessingException {
        JSONArray energyTransferModes = new JSONArray();
        JSONObject supportEnergyTransferNode = new JSONObject(chargeService.toString()).getJSONObject("SupportedEnergyTransferMode");
        JSONArray allTransferModes = supportEnergyTransferNode.getJSONArray("EnergyTransferMode");
        for (Object mode : allTransferModes) {
            JSONObject energyTransferMode = new JSONObject();
            energyTransferMode = energyTransferMode.put("EnergyTransferMode", mode);
            energyTransferModes = energyTransferModes.put(energyTransferMode);
        }
        chargeService = ((ObjectNode)chargeService).set("SupportedEnergyTransferMode", new ObjectMapper().readTree(energyTransferModes.toString()));
        return chargeService;
    }

    private JsonNode getModifiedServiceListList(JsonNode rootObject) throws JsonMappingException, JsonProcessingException {
        return this.getModifiedServiceList(rootObject.get("ServiceList"));
    }

    private JsonNode getModifiedServiceList(JsonNode serviceList) throws JsonMappingException, JsonProcessingException {
        JSONArray serviceListNode = new JSONArray();
        JSONArray allServiceNodes = new JSONObject(serviceList.toString()).getJSONArray("Service");
        for (Object node : allServiceNodes) {
            JSONObject serviceNode = new JSONObject();
            serviceNode.put("Service", node);
            serviceListNode.put(serviceNode);
        }
        return new ObjectMapper().readTree(serviceListNode.toString());
    }
}

