/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.conformhelpers.encode;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.siemens.ct.exi.main.conformhelpers.encode.ServiceDiscoveryRes;
import com.siemens.ct.exi.main.conformhelpers.encode.ServiceParameterList;
import java.io.IOException;
import java.util.List;
import org.json.JSONObject;

public class ServiceDiscoveryResEncodeDeserializer
extends StdDeserializer<ServiceDiscoveryRes> {
    public ServiceDiscoveryResEncodeDeserializer() {
        this((Class<?>)null);
    }

    protected ServiceDiscoveryResEncodeDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public ServiceDiscoveryRes deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        String code = node.get("ResponseCode").asText();
        JsonNode paymentOptionList = node.get("PaymentOptionList");
        JsonNode modifiedpaymentOptionList = this.getModifiedPaymentOptionList(paymentOptionList);
        JsonNode chargeService = node.get("ChargeService");
        ServiceParameterList paramList = new ServiceParameterList();
        paramList.setAdditionalProperty("PaymentOptionList", modifiedpaymentOptionList);
        paramList.setAdditionalProperty("ChargeService", this.getModifiedChargeServiceList(chargeService));
        if (node.has("ServiceList")) {
            paramList.setAdditionalProperty("ServiceList", this.getModifiedServiceListList(node));
        }
        return new ServiceDiscoveryRes(code, null, paramList);
    }

    private JsonNode getModifiedPaymentOptionList(JsonNode paymentOptionList) throws JsonMappingException, JsonProcessingException {
        JSONObject paymentOptions = new JSONObject();
        List<String> allValues = paymentOptionList.findValuesAsText("PaymentOption");
        for (String value : allValues) {
            paymentOptions = paymentOptions.accumulate("PaymentOption", value);
        }
        return new ObjectMapper().readTree(paymentOptions.toString());
    }

    private JsonNode getModifiedChargeServiceList(JsonNode chargeService) throws JsonMappingException, JsonProcessingException {
        chargeService = ((ObjectNode)chargeService).set("SupportedEnergyTransferMode", this.getModifiedEnergyTransferModeList(chargeService.get("SupportedEnergyTransferMode")));
        return chargeService;
    }

    private JsonNode getModifiedEnergyTransferModeList(JsonNode supportedEnergyTransferModeList) throws JsonMappingException, JsonProcessingException {
        JSONObject paymentOptions = new JSONObject();
        List<String> allValues = supportedEnergyTransferModeList.findValuesAsText("EnergyTransferMode");
        for (String value : allValues) {
            paymentOptions = paymentOptions.accumulate("EnergyTransferMode", value);
        }
        return new ObjectMapper().readTree(paymentOptions.toString());
    }

    private JsonNode getModifiedServiceListList(JsonNode rootObject) throws JsonMappingException, JsonProcessingException {
        return this.getModifiedServiceList(rootObject.get("ServiceList"));
    }

    private JsonNode getModifiedServiceList(JsonNode serviceList) throws JsonMappingException, JsonProcessingException {
        List<JsonNode> allServiceNodes = serviceList.findValues("Service");
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode on = mapper.createObjectNode();
        ArrayNode services = on.putArray("Service");
        services.addAll(allServiceNodes);
        return mapper.readTree(on.toString());
    }
}

