/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammars.regex;

import com.siemens.ct.exi.grammars.regex.Match;
import com.siemens.ct.exi.grammars.regex.ParseException;
import com.siemens.ct.exi.grammars.regex.RegularExpression;
import java.text.CharacterIterator;

public final class REUtil {
    static final int CACHESIZE = 20;
    static final RegularExpression[] regexCache = new RegularExpression[20];

    private REUtil() {
    }

    static final int composeFromSurrogates(int high, int low) {
        return 65536 + (high - 55296 << 10) + low - 56320;
    }

    static final boolean isLowSurrogate(int ch) {
        return (ch & 0xFC00) == 56320;
    }

    static final boolean isHighSurrogate(int ch) {
        return (ch & 0xFC00) == 55296;
    }

    static final String decomposeToSurrogates(int ch) {
        char[] chs = new char[]{(char)(((ch -= 65536) >> 10) + 55296), (char)((ch & 0x3FF) + 56320)};
        return new String(chs);
    }

    static final String substring(CharacterIterator iterator, int begin, int end) {
        char[] src = new char[end - begin];
        int i = 0;
        while (i < src.length) {
            src[i] = iterator.setIndex(i + begin);
            ++i;
        }
        return new String(src);
    }

    static final int getOptionValue(int ch) {
        int ret = 0;
        switch (ch) {
            case 105: {
                ret = 2;
                break;
            }
            case 109: {
                ret = 8;
                break;
            }
            case 115: {
                ret = 4;
                break;
            }
            case 120: {
                ret = 16;
                break;
            }
            case 117: {
                ret = 32;
                break;
            }
            case 119: {
                ret = 64;
                break;
            }
            case 70: {
                ret = 256;
                break;
            }
            case 72: {
                ret = 128;
                break;
            }
            case 88: {
                ret = 512;
                break;
            }
            case 44: {
                ret = 1024;
            }
        }
        return ret;
    }

    static final int parseOptions(String opts) throws ParseException {
        if (opts == null) {
            return 0;
        }
        int options = 0;
        int i = 0;
        while (i < opts.length()) {
            int v = REUtil.getOptionValue(opts.charAt(i));
            if (v == 0) {
                throw new ParseException("Unknown Option: " + opts.substring(i), -1);
            }
            options |= v;
            ++i;
        }
        return options;
    }

    static final String createOptionString(int options) {
        StringBuffer sb = new StringBuffer(9);
        if ((options & 0x100) != 0) {
            sb.append('F');
        }
        if ((options & 0x80) != 0) {
            sb.append('H');
        }
        if ((options & 0x200) != 0) {
            sb.append('X');
        }
        if ((options & 2) != 0) {
            sb.append('i');
        }
        if ((options & 8) != 0) {
            sb.append('m');
        }
        if ((options & 4) != 0) {
            sb.append('s');
        }
        if ((options & 0x20) != 0) {
            sb.append('u');
        }
        if ((options & 0x40) != 0) {
            sb.append('w');
        }
        if ((options & 0x10) != 0) {
            sb.append('x');
        }
        if ((options & 0x400) != 0) {
            sb.append(',');
        }
        return sb.toString().intern();
    }

    static String stripExtendedComment(String regex) {
        int len = regex.length();
        StringBuffer buffer = new StringBuffer(len);
        int offset = 0;
        int charClass = 0;
        block0: while (offset < len) {
            char next;
            char ch;
            if ((ch = regex.charAt(offset++)) == '\t' || ch == '\n' || ch == '\f' || ch == '\r' || ch == ' ') {
                if (charClass <= 0) continue;
                buffer.append(ch);
                continue;
            }
            if (ch == '#') {
                while (offset < len) {
                    if ((ch = regex.charAt(offset++)) == '\r' || ch == '\n') continue block0;
                }
                continue;
            }
            if (ch == '\\' && offset < len) {
                next = regex.charAt(offset);
                if (next == '#' || next == '\t' || next == '\n' || next == '\f' || next == '\r' || next == ' ') {
                    buffer.append(next);
                    ++offset;
                    continue;
                }
                buffer.append('\\');
                buffer.append(next);
                ++offset;
                continue;
            }
            if (ch == '[') {
                ++charClass;
                buffer.append(ch);
                if (offset >= len) continue;
                next = regex.charAt(offset);
                if (next == '[' || next == ']') {
                    buffer.append(next);
                    ++offset;
                    continue;
                }
                if (next != '^' || offset + 1 >= len || (next = regex.charAt(offset + 1)) != '[' && next != ']') continue;
                buffer.append('^');
                buffer.append(next);
                offset += 2;
                continue;
            }
            if (charClass > 0 && ch == ']') {
                --charClass;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] argv) {
        pattern = null;
        try {
            options = "";
            target = null;
            if (argv.length == 0) {
                System.out.println("Error:Usage: java REUtil -i|-m|-s|-u|-w|-X regularExpression String");
                System.exit(0);
            }
            i = 0;
            while (i < argv.length) {
                if (argv[i].length() == 0 || argv[i].charAt(0) != '-') {
                    if (pattern == null) {
                        pattern = argv[i];
                    } else if (target == null) {
                        target = argv[i];
                    } else {
                        System.err.println("Unnecessary: " + argv[i]);
                    }
                } else if (argv[i].equals("-i")) {
                    options = String.valueOf(options) + "i";
                } else if (argv[i].equals("-m")) {
                    options = String.valueOf(options) + "m";
                } else if (argv[i].equals("-s")) {
                    options = String.valueOf(options) + "s";
                } else if (argv[i].equals("-u")) {
                    options = String.valueOf(options) + "u";
                } else if (argv[i].equals("-w")) {
                    options = String.valueOf(options) + "w";
                } else if (argv[i].equals("-X")) {
                    options = String.valueOf(options) + "X";
                } else {
                    System.err.println("Unknown option: " + argv[i]);
                }
                ++i;
            }
            reg = new RegularExpression(pattern, options);
            System.out.println("RegularExpression: " + reg);
            match = new Match();
            reg.matches(target, match);
            i = 0;
            while (i < match.getNumberOfGroups()) {
                if (i == 0) {
                    System.out.print("Matched range for the whole pattern: ");
                } else {
                    System.out.print("[" + i + "]: ");
                }
                if (match.getBeginning(i) < 0) {
                    System.out.println("-1");
                } else {
                    System.out.print(String.valueOf(match.getBeginning(i)) + ", " + match.getEnd(i) + ", ");
                    System.out.println("\"" + match.getCapturedText(i) + "\"");
                }
                ++i;
            }
            return;
        }
        catch (ParseException pe) {
            if (pattern == null) {
                pe.printStackTrace();
                return;
            }
            System.err.println("org.apache.xerces.utils.regex.ParseException: " + pe.getMessage());
            indent = "        ";
            System.err.println(String.valueOf(indent) + pattern);
            loc = pe.getLocation();
            if (loc < 0) return;
            System.err.print(indent);
            i = 0;
            ** while (i < loc)
        }
lbl-1000:
        // 1 sources

        {
            System.err.print("-");
            ++i;
            continue;
        }
lbl74:
        // 1 sources

        System.err.println("^");
        return;
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegularExpression createRegex(String pattern, String options) throws ParseException {
        RegularExpression re = null;
        int intOptions = REUtil.parseOptions(options);
        RegularExpression[] regularExpressionArray = regexCache;
        synchronized (regexCache) {
            int i = 0;
            while (i < 20) {
                RegularExpression cached = regexCache[i];
                if (cached == null) {
                    i = -1;
                    break;
                }
                if (cached.equals(pattern, intOptions)) {
                    re = cached;
                    break;
                }
                ++i;
            }
            if (re != null) {
                if (i != 0) {
                    System.arraycopy(regexCache, 0, regexCache, 1, i);
                    REUtil.regexCache[0] = re;
                }
            } else {
                re = new RegularExpression(pattern, options);
                System.arraycopy(regexCache, 0, regexCache, 1, 19);
                REUtil.regexCache[0] = re;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return re;
        }
    }

    public static boolean matches(String regex, String target) throws ParseException {
        return REUtil.createRegex(regex, null).matches(target);
    }

    public static boolean matches(String regex, String options, String target) throws ParseException {
        return REUtil.createRegex(regex, options).matches(target);
    }

    public static String quoteMeta(String literal) {
        int len = literal.length();
        StringBuffer buffer = null;
        int i = 0;
        while (i < len) {
            char ch = literal.charAt(i);
            if (".*+?{[()|\\^$".indexOf(ch) >= 0) {
                if (buffer == null) {
                    buffer = new StringBuffer(i + (len - i) * 2);
                    if (i > 0) {
                        buffer.append(literal.substring(0, i));
                    }
                }
                buffer.append('\\');
                buffer.append(ch);
            } else if (buffer != null) {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer != null ? buffer.toString() : literal;
    }

    static void dumpString(String v) {
        int i = 0;
        while (i < v.length()) {
            System.out.print(Integer.toHexString(v.charAt(i)));
            System.out.print(" ");
            ++i;
        }
        System.out.println();
    }
}

