/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.cmd;

import com.siemens.ct.exi.main.cmd.EXICodec;
import com.siemens.ct.exi.main.cmd.MessageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class EXICodecQuickTest {
    private static EXICodec exi_codec = new EXICodec();
    private static boolean fullDebug = false;
    private static Map<MessageInfo, String> iso15118_2_messageMappings;
    private static Map<MessageInfo, String> iso15118_2_messageMappings_fragmentGrammar;
    private static Map<MessageInfo, String> iso15118_20_messageMappings;
    private static Map<MessageInfo, String> iso15118_20_messageMappings_fragmentGrammar;
    private static Map<MessageInfo, String> dinSpec_70121_messageMappings;
    private static String AppProtocolNS;
    private static String MsgDefNS;
    private static String CommonMessagesNS;
    private static String ACNS;
    private static String DCNS;
    private static String WPTNS;
    private static String ACDPNS;
    private static String XMLDSigNS;
    private static String DINSpec_70121;

    static {
        AppProtocolNS = "urn:iso:15118:2:2010:AppProtocol";
        MsgDefNS = "urn:iso:15118:2:2013:MsgDef";
        CommonMessagesNS = "urn:iso:std:iso:15118:-20:CommonMessages";
        ACNS = "urn:iso:std:iso:15118:-20:AC";
        DCNS = "urn:iso:std:iso:15118:-20:DC";
        WPTNS = "urn:iso:std:iso:15118:-20:WPT";
        ACDPNS = "urn:iso:std:iso:15118:-20:ACDP";
        XMLDSigNS = "http://www.w3.org/2000/09/xmldsig#";
        DINSpec_70121 = "urn:din:70121:2012:MsgDef";
    }

    public static void runFullEncodeDecodeTests() {
        EXICodec exi_codec = new EXICodec();
        System.out.println("Version:" + exi_codec.get_version());
        System.out.println("===== DINSPEC Tests=====");
        EXICodecQuickTest.runTests(EXICodecQuickTest.getDINSPEC_70121_MessageMapping());
        System.out.println("===== ISO15118-2 Tests=====");
        EXICodecQuickTest.runTests(EXICodecQuickTest.getISO15118_2_MessageMapping_Modded());
        System.out.println("\n===FRAGMENT GRAMMAR (ISO15118-2) ===");
        EXICodecQuickTest.runTests(EXICodecQuickTest.getISO15118_2_MessageMapping_FragmentGrammar());
        System.out.println("\n===== ISO15118-20 Tests=====");
        EXICodecQuickTest.runTests(EXICodecQuickTest.getISO15118_20_MessageMapping_Modded());
        System.out.println("\n===FRAGMENT GRAMMAR (ISO15118-20) ===");
        EXICodecQuickTest.runTests(EXICodecQuickTest.getISO15118_20_MessageMapping_FragmentGrammar_Modded());
    }

    public static void runSingleJSONEncodeDecodeTest(String json, String namespace) {
        System.out.println("Incoming JSON: \n" + json);
        byte[] encoded_message = null;
        long startTime = System.nanoTime();
        encoded_message = exi_codec.encode(json, namespace);
        long endTime = System.nanoTime();
        if (fullDebug) {
            System.out.println("Time taken(encode): " + (endTime - startTime) / 1000000L);
        }
        if (encoded_message == null) {
            System.out.println(exi_codec.get_last_encoding_error());
        } else {
            System.out.println("Encoded message: " + EXICodecQuickTest.print(encoded_message));
        }
        String decoded_json = "";
        if (encoded_message != null) {
            startTime = System.nanoTime();
            decoded_json = exi_codec.decode(encoded_message, namespace);
            endTime = System.nanoTime();
            if (fullDebug) {
                System.out.println("Time taken(decode): " + (endTime - startTime) / 1000000L);
            }
            if (decoded_json != null) {
                System.out.println("Decoded Message:\n" + decoded_json);
            } else {
                System.out.println("Error decoding stream: " + exi_codec.get_last_decoding_error());
            }
        }
        System.out.println(exi_codec.compareEncodedAndDecodedJSONFiles(json, decoded_json) ? "OK" : "NEEDS CHECKING");
    }

    static void runTests(Map<MessageInfo, String> messageMappings) {
        ArrayList<MessageInfo> keySet = new ArrayList<MessageInfo>(messageMappings.keySet());
        int i = 0;
        while (i < keySet.size()) {
            MessageInfo mi = (MessageInfo)keySet.get(i);
            String json = messageMappings.get(mi);
            if (fullDebug) {
                System.out.println("Incoming JSON: \n" + json);
            }
            long startTime = System.nanoTime();
            byte[] encoded_message = exi_codec.encode(json, mi.namespace);
            long endTime = System.nanoTime();
            if (fullDebug) {
                System.out.println("Time taken(encode): " + (endTime - startTime) / 1000000L);
            }
            if (encoded_message == null) {
                System.out.println(exi_codec.get_last_encoding_error());
            } else if (fullDebug) {
                System.out.println("Encoded message: " + EXICodecQuickTest.print(encoded_message));
            }
            if (!mi.fragmentMode) {
                String decoded_json = "";
                if (encoded_message != null) {
                    startTime = System.nanoTime();
                    decoded_json = exi_codec.decode(encoded_message, ((MessageInfo)keySet.get((int)i)).namespace);
                    endTime = System.nanoTime();
                    if (fullDebug) {
                        System.out.println("Time taken(decode): " + (endTime - startTime) / 1000000L);
                    }
                    if (decoded_json != null) {
                        if (fullDebug) {
                            System.out.println("Decoded Message:\n" + decoded_json);
                        }
                    } else {
                        System.out.println("Error decoding stream: " + exi_codec.get_last_decoding_error());
                    }
                }
                System.out.println(String.format("%-40s : %s", ((MessageInfo)keySet.get((int)i)).messageType.toString(), exi_codec.compareEncodedAndDecodedJSONFiles(json, decoded_json) ? "OK" : "NEEDS CHECKING"));
            } else {
                System.out.println(String.format("%-40s : %s", ((MessageInfo)keySet.get((int)i)).messageType.toString(), encoded_message != null ? "OK (Needs validating.)" : "NEEDS CHECKING"));
            }
            ++i;
        }
    }

    static Map<MessageInfo, String> getISO15118_20_MessageMapping_Modded() {
        if (iso15118_20_messageMappings == null) {
            iso15118_20_messageMappings = Collections.synchronizedMap(new LinkedHashMap());
            iso15118_20_messageMappings.put(new MessageInfo("SupportedAppProtocolReq", AppProtocolNS), "{\"supportedAppProtocolReq\": {\"AppProtocol\": [{\"ProtocolNamespace\": \"urn:iso:std:iso:15118:-20:AC\", \"VersionNumberMajor\": 1, \"VersionNumberMinor\": 0, \"SchemaID\": 1, \"Priority\": 1}, {\"ProtocolNamespace\": \"urn:iso:15118:2:2013:MsgDef\", \"VersionNumberMajor\": 2, \"VersionNumberMinor\": 0, \"SchemaID\": 2, \"Priority\": 2}]}}");
            iso15118_20_messageMappings.put(new MessageInfo("SupportedAppProtocolRes", AppProtocolNS), "{\"supportedAppProtocolRes\": {\"ResponseCode\": \"OK_SuccessfulNegotiation\", \"SchemaID\": 1}}");
            iso15118_20_messageMappings.put(new MessageInfo("SessionSetupReq", CommonMessagesNS), "{\"SessionSetupReq\": {\"Header\": {\"SessionID\": \"00\", \"TimeStamp\": 1635706899}, \"EVCCID\": \"WMIV1234567890ABCDEX\"}}");
            iso15118_20_messageMappings.put(new MessageInfo("SessionSetupRes", CommonMessagesNS), "{\"SessionSetupRes\": {\"Header\": {\"SessionID\": \"834BA2D14D305318\", \"TimeStamp\": 1635965564}, \"ResponseCode\": \"OK_NewSessionEstablished\", \"EVSEID\": \"UK123E1234\"}}");
            iso15118_20_messageMappings.put(new MessageInfo("AuthorizationSetupReq", CommonMessagesNS), "{\"AuthorizationSetupReq\": {\"Header\": {\"SessionID\": \"834BA2D14D305318\", \"TimeStamp\": 1635965564}}}");
            iso15118_20_messageMappings.put(new MessageInfo("AuthorizationSetupRes", CommonMessagesNS), "{\"AuthorizationSetupRes\":{\"Header\":{\"SessionID\":\"834BA2D14D305318\",\"TimeStamp\":1635965565},\"ResponseCode\":\"OK\",\"AuthorizationServices\":[\"EIM\",\"PnC\"],\"CertificateInstallationService\":true,\"PnC_ASResAuthorizationMode\":{\"GenChallenge\":\"Zm5UeykzrO8sm7LFB8lVxA==\"}}}");
            iso15118_20_messageMappings.put(new MessageInfo("CertificateInstallationReq", CommonMessagesNS), "{\"CertificateInstallationReq\":{\"Header\":{\"SessionID\":\"5DC94BF6003C58BA\",\"Signature\":{\"SignatureValue\":{\"value\":\"MEQCIHyunb6CKRr8c+IWgAMhHaaK8YJvAOYd9GoPBTAbsNCSAiBpdyUFagKJTZgPdxwNvPrOQNkC8bbYJX69EL4Sz2aHWA==\"},\"SignedInfo\":{\"CanonicalizationMethod\":{\"Algorithm\":\"http://www.w3.org/TR/canonical-exi/\"},\"Reference\":[{\"DigestMethod\":{\"Algorithm\":\"http://www.w3.org/2001/04/xmlenc#sha256\"},\"DigestValue\":\"aGYZjLIwFCgpNhml1UH5UpIotSE5FpUDcmN+0cgXg6E=\",\"Transforms\":{\"Transform\":[{\"Algorithm\":\"http://www.w3.org/TR/canonical-exi/\"}]},\"URI\":\"#id1\"}],\"SignatureMethod\":{\"Algorithm\":\"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256\"}}},\"TimeStamp\":1636461326},\"ListOfRootCertificateIDs\":{\"RootCertificateID\":[{\"X509IssuerName\":\"<Name(CN=V2GRootCA,O=Switch,C=UK,DC=V2G)>\",\"X509SerialNumber\":12345}]},\"MaximumContractCertificateChains\":3,\"OEMProvisioningCertificateChain\":{\"Certificate\":\"MIIBwDCCAWWgAwIBAgICMEAwCgYIKoZIzj0EAwIwRzESMBAGA1UEAwwJT0VNU3ViQ0EyMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMB4XDTIxMTEwODE3NTY1MVoXDTI1MTEwNzE3NTY1MVowSTEUMBIGA1UEAwwLT0VNUHJvdkNlcnQxDzANBgNVBAoMBlN3aXRjaDELMAkGA1UEBhMCVUsxEzARBgoJkiaJk/IsZAEZFgNPRU0wWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAQh28fTnaQ+OlxojuQZT/pjJaKu4N8CB4Uz8dND0sIlfu3HkNBb4mOk2b3zgA7cub7OAAVlb1x4hO7fJlEu3/pToz8wPTAMBgNVHRMBAf8EAjAAMA4GA1UdDwEB/wQEAwIDiDAdBgNVHQ4EFgQUniuzBygTPlYGcE3UXiyPdBqtkHAwCgYIKoZIzj0EAwIDSQAwRgIhAIkxKc+8WQHqvoYO+4n9LbIc/QJeAogFwqLKS4Pt0t2BAiEAwWjk4oqLA/BVaWgnN/cSlSom/P0YN+Isf4JHvoBzOzo=\",\"Id\":\"id1\",\"SubCertificates\":{\"Certificate\":[\"MIIBwzCCAWmgAwIBAgICMD8wCgYIKoZIzj0EAwIwRzESMBAGA1UEAwwJT0VNU3ViQ0ExMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMB4XDTIxMTEwODE3NTY1MVoXDTI1MTEwNzE3NTY1MVowRzESMBAGA1UEAwwJT0VNU3ViQ0EyMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE/IU2sUXeATj5/HcB5k5L1k2Lg10rvjHPEz3J5VF3GUsvEu40vWpOuirxFxE8j2X1pEN+/WA0J0+YsSXP0KzH4KNFMEMwEgYDVR0TAQH/BAgwBgEB/wIBADAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFCNE2aWcqZ5nrQC8qiNLWNeR1nJpMAoGCCqGSM49BAMCA0gAMEUCIAsEEbMnEjUuZ64Patbzz9B7ouugeavjBdR7jdlqv6DFAiEAjyhqzEGtijXNpCnA/pJcAW4EaR3SmBJ6rVIdYQxCVk8=\",\"MIIBwzCCAWmgAwIBAgICMD4wCgYIKoZIzj0EAwIwRzESMBAGA1UEAwwJT0VNUm9vdENBMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMB4XDTIxMTEwODE3NTY1MVoXDTI1MTEwNzE3NTY1MVowRzESMBAGA1UEAwwJT0VNU3ViQ0ExMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEKuwJGkmrog2b+h2p11GV9cM3cZn92QFoyuvkBAxl4iSW90HGKkfVuXVRojkzBWOMPzXoElVMEcEpB7hugleNOKNFMEMwEgYDVR0TAQH/BAgwBgEB/wIBATAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFAX0j4MPNB9jVG5RmXRkS3EeI4V1MAoGCCqGSM49BAMCA0gAMEUCIHqLCS8cjb9DY/HXdlCMvKH2pBK2K74TbSkXUlHoMZMIAiEApcmmAO33E+oJGX1N+sV8plQtKU5sja8VZxlHf8X1o+c=\"]}}}}");
            iso15118_20_messageMappings.put(new MessageInfo("CertificateInstallationRes", CommonMessagesNS), "{\"CertificateInstallationRes\":{\"RemainingContractCertificateChains\":0,\"EVSEProcessing\":\"Finished\",\"ResponseCode\":\"FAILED_SequenceError\",\"CPSCertificateChain\":{\"Certificate\":\"\"},\"Header\":{\"SessionID\":\"00\",\"TimeStamp\":1},\"SignedInstallationData\":{\"ECDHCurve\":\"X448\",\"X448_EncryptedPrivateKey\":\"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA\",\"DHPublicKey\":\"\",\"ContractCertificateChain\":{\"SubCertificates\":{\"Certificate\":[\"\"]},\"Certificate\":\"\"},\"Id\":\"\"}}}");
            iso15118_20_messageMappings.put(new MessageInfo("AuthorizationReq", CommonMessagesNS), "{\"AuthorizationReq\":{\"Header\":{\"SessionID\":\"70935E65512500C1\",\"TimeStamp\":1639832808,\"Signature\":{\"SignedInfo\":{\"CanonicalizationMethod\":{\"Algorithm\":\"http://www.w3.org/TR/canonical-exi/\"},\"SignatureMethod\":{\"Algorithm\":\"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256\"},\"Reference\":[{\"Transforms\":{\"Transform\":[{\"Algorithm\":\"http://www.w3.org/TR/canonical-exi/\"}]},\"DigestMethod\":{\"Algorithm\":\"http://www.w3.org/2001/04/xmlenc#sha256\"},\"DigestValue\":\"P6U8ChkeAUxbQWdsOZriEpMThk4uUltqqqJVmorg++M=\",\"URI\":\"#id1\"}]},\"SignatureValue\":{\"value\":\"MEUCIQD1Xg56OX6ZeedOAkInAH+e8BQsjz6X+f66D1/rM7J7kAIgdRMcEqyf8GretUjgpdU3EOXGz8An+LYui4rGGD8YL8Q=\"}}},\"SelectedAuthorizationService\":\"PnC\",\"PnC_AReqAuthorizationMode\":{\"Id\":\"id1\",\"GenChallenge\":\"ZLGnObuVpxTwIw2FpfoGJQ==\",\"ContractCertificateChain\":{\"Certificate\":\"MIIBwTCCAWagAwIBAgICMEQwCgYIKoZIzj0EAwIwRTERMA8GA1UEAwwITU9TdWJDQTIxDzANBgNVBAoMBlN3aXRjaDELMAkGA1UEBhMCVUsxEjAQBgoJkiaJk/IsZAEZFgJNTzAeFw0yMTEyMTMxNzUyMzFaFw0yMzEyMTMxNzUyMzFaMEwxGDAWBgNVBAMMD1VLU1dJMTIzNDU2Nzg5QTEPMA0GA1UECgwGU3dpdGNoMQswCQYDVQQGEwJVSzESMBAGCgmSJomT8ixkARkWAk1PMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEprEx34ScKqlhmDnxWpVr2gvGpkeYWYIcNhsB6bzRHv2q2GOAny3ZIKnGA7w6bAoFtUGcdv28zPEHdwDnPLD05KM/MD0wDAYDVR0TAQH/BAIwADAOBgNVHQ8BAf8EBAMCA+gwHQYDVR0OBBYEFPsqauDurRehZO07aEE400vi38Q/MAoGCCqGSM49BAMCA0kAMEYCIQC0GZIDJFPhl1T3+iv45eaqI1yU+VJQzRNXkJIhVvbGcQIhANe5U5DGrdpY/iQGzBaSoNYTaIaAubA2su6FlEh6jXqx\",\"SubCertificates\":{\"Certificate\":[\"MIIBvjCCAWWgAwIBAgICMEMwCgYIKoZIzj0EAwIwRTERMA8GA1UEAwwITU9TdWJDQTExDzANBgNVBAoMBlN3aXRjaDELMAkGA1UEBhMCVUsxEjAQBgoJkiaJk/IsZAEZFgJNTzAeFw0yMTEyMTMxNzUyMzFaFw0yNTEyMTIxNzUyMzFaMEUxETAPBgNVBAMMCE1PU3ViQ0EyMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRIwEAYKCZImiZPyLGQBGRYCTU8wWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAQTxYYRxcZCjuVyPdmdBDOIN4XAIhLAEqU18nytJv9gKqK8qjAY9ZcJVt7luvVhFBqGmKV4q9+67z8teZiSU9aLo0UwQzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB/wQEAwIBxjAdBgNVHQ4EFgQUdIJK+LExa2RWMMgaSogHspahESAwCgYIKoZIzj0EAwIDRwAwRAIgY2ELqUsiMijWn3rsbDzfTYtsRq5iF+m2gxN6axtNLsoCIGnRymAFGPxc09rJ1uCcFywddwfY3Hv3qv0KrbskN0rs\",\"MIIBvjCCAWWgAwIBAgICMEIwCgYIKoZIzj0EAwIwRTERMA8GA1UEAwwITU9Sb290Q0ExDzANBgNVBAoMBlN3aXRjaDELMAkGA1UEBhMCVUsxEjAQBgoJkiaJk/IsZAEZFgJNTzAeFw0yMTEyMTMxNzUyMzFaFw0yNTEyMTIxNzUyMzFaMEUxETAPBgNVBAMMCE1PU3ViQ0ExMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRIwEAYKCZImiZPyLGQBGRYCTU8wWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAS3mnLj5pBH5uikDz069wdLVJu3nPQDag3go//W34EfXJxrrAGhom+28ENfJ3OnlpQoRXczWixmV1BP68fpld/eo0UwQzASBgNVHRMBAf8ECDAGAQH/AgEBMA4GA1UdDwEB/wQEAwIBBjAdBgNVHQ4EFgQUHmF60L1Yj4tOnL5EAp68IZuzIB4wCgYIKoZIzj0EAwIDRwAwRAIgaMEAvbdVh/+sgIVcvKOSGxfIVIUycWpnguaOEIQBG+MCIEJPkZLdBJeW7r3rhLv7fvdM16FRHAlh2fxEGgm1f9EP\"]}}}}}");
            iso15118_20_messageMappings.put(new MessageInfo("AuthorizationRes", CommonMessagesNS), "{\"AuthorizationRes\": {\"Header\": {\"SessionID\": \"CD421BBAA4FBB6B8\", \"TimeStamp\": 1641305832}, \"ResponseCode\": \"OK\", \"EVSEProcessing\": \"Finished\"}}");
            iso15118_20_messageMappings.put(new MessageInfo("ServiceDiscoveryReq", CommonMessagesNS), "{\"ServiceDiscoveryReq\": {\"Header\": {\"SessionID\": \"CD421BBAA4FBB6B8\", \"TimeStamp\": 1641305832}}}");
            iso15118_20_messageMappings.put(new MessageInfo("ServiceDiscoveryRes", CommonMessagesNS), "{\"ServiceDiscoveryRes\": {\"Header\": {\"SessionID\": \"CD421BBAA4FBB6B8\", \"TimeStamp\": 1641305832}, \"ResponseCode\": \"OK\", \"ServiceRenegotiationSupported\": false, \"EnergyTransferServiceList\": {\"Service\": [{\"ServiceID\": 2, \"FreeService\": false}]}}}");
            iso15118_20_messageMappings.put(new MessageInfo("ServiceDetailReq", CommonMessagesNS), "{\"ServiceDetailReq\": {\"Header\": {\"SessionID\": \"CD421BBAA4FBB6B8\", \"TimeStamp\": 1641305832}, \"ServiceID\": 2}} ");
            iso15118_20_messageMappings.put(new MessageInfo("ServiceDetailRes", CommonMessagesNS), "{\"ServiceDetailRes\": {\"Header\": {\"SessionID\": \"CD421BBAA4FBB6B8\", \"TimeStamp\": 1641305833}, \"ResponseCode\": \"OK\", \"ServiceID\": 2, \"ServiceParameterList\": {\"ParameterSet\": [{\"ParameterSetID\": 1, \"Parameter\": [{\"Name\": \"Connector\", \"intValue\": 2}, {\"Name\": \"ControlMode\", \"intValue\": 2}, {\"Name\": \"MobilityNeedsMode\", \"intValue\": 1}, {\"Name\": \"Pricing\", \"intValue\": 0}]}]}}}");
            iso15118_20_messageMappings.put(new MessageInfo("ServiceSelectionReq", CommonMessagesNS), "{\"ServiceSelectionReq\": {\"Header\": {\"SessionID\": \"CD421BBAA4FBB6B8\", \"TimeStamp\": 1641305833}, \"SelectedEnergyTransferService\": {\"ServiceID\": 2, \"ParameterSetID\": 1}}}");
            iso15118_20_messageMappings.put(new MessageInfo("ServiceSelectionRes", CommonMessagesNS), "{\"ServiceSelectionRes\": {\"Header\": {\"SessionID\": \"CD421BBAA4FBB6B8\", \"TimeStamp\": 1641305833}, \"ResponseCode\": \"OK\"}}");
            iso15118_20_messageMappings.put(new MessageInfo("DC_ChargeParameterDiscoveryReq", DCNS), "{\"DC_ChargeParameterDiscoveryReq\": {\"Header\": {\"SessionID\": \"CD421BBAA4FBB6B8\", \"TimeStamp\": 1641305833}, \"DC_CPDReqEnergyTransferMode\": {\"EVMaximumChargePower\": {\"Exponent\": 3, \"Value\": 300}, \"EVMinimumChargePower\": {\"Exponent\": 0, \"Value\": 100}, \"EVMaximumChargeCurrent\": {\"Exponent\": 0, \"Value\": 300}, \"EVMinimumChargeCurrent\": {\"Exponent\": 0, \"Value\": 10}, \"EVMaximumVoltage\": {\"Exponent\": 0, \"Value\": 1000}, \"EVMinimumVoltage\": {\"Exponent\": 0, \"Value\": 10}}}}");
            iso15118_20_messageMappings.put(new MessageInfo("DC_ChargeParameterDiscoveryRes", DCNS), "{\"DC_ChargeParameterDiscoveryRes\": {\"Header\": {\"SessionID\": \"CD421BBAA4FBB6B8\", \"TimeStamp\": 1641305833}, \"ResponseCode\": \"OK\", \"DC_CPDResEnergyTransferMode\": {\"EVSEMaximumChargePower\": {\"Exponent\": 3, \"Value\": 300}, \"EVSEMinimumChargePower\": {\"Exponent\": 0, \"Value\": 100}, \"EVSEMaximumChargeCurrent\": {\"Exponent\": 0, \"Value\": 300}, \"EVSEMinimumChargeCurrent\": {\"Exponent\": 0, \"Value\": 10}, \"EVSEMaximumVoltage\": {\"Exponent\": 0, \"Value\": 1000}, \"EVSEMinimumVoltage\": {\"Exponent\": 0, \"Value\": 10}}}}");
            iso15118_20_messageMappings.put(new MessageInfo("ScheduleExchangeReq", CommonMessagesNS), "{\"ScheduleExchangeReq\": {\"Header\": {\"SessionID\": \"39DD08590BC1A1BD\", \"TimeStamp\": 1641369235}, \"MaximumSupportingPoints\": 1024, \"Dynamic_SEReqControlMode\": {\"DepartureTime\": 7200, \"MinimumSOC\": 30, \"TargetSOC\": 80, \"EVTargetEnergyRequest\": {\"Exponent\": 3, \"Value\": 40}, \"EVMaximumEnergyRequest\": {\"Exponent\": 1, \"Value\": 6000}, \"EVMinimumEnergyRequest\": {\"Exponent\": 0, \"Value\": 20000}, \"EVMaximumV2XEnergyRequest\": {\"Exponent\": 0, \"Value\": 5000}, \"EVMinimumV2XEnergyRequest\": {\"Exponent\": 0, \"Value\": 0}}}}");
            iso15118_20_messageMappings.put(new MessageInfo("ScheduleExchangeRes", CommonMessagesNS), "{\"ScheduleExchangeRes\": {\"Header\": {\"SessionID\": \"39DD08590BC1A1BD\", \"TimeStamp\": 1641369235}, \"ResponseCode\": \"OK\", \"EVSEProcessing\": \"Ongoing\"}}");
            iso15118_20_messageMappings.put(new MessageInfo("PowerDeliveryReq", CommonMessagesNS), "{\"PowerDeliveryReq\": {\"Header\": {\"SessionID\": \"4369A43B4CBFA987\", \"TimeStamp\": 1642397485}, \"EVProcessing\": \"Finished\", \"ChargeProgress\": \"Stop\"}}");
            iso15118_20_messageMappings.put(new MessageInfo("PowerDeliveryRes", CommonMessagesNS), "{\"PowerDeliveryRes\": {\"Header\": {\"SessionID\": \"4369A43B4CBFA987\", \"TimeStamp\": 1642397485}, \"ResponseCode\": \"OK\"}}");
            iso15118_20_messageMappings.put(new MessageInfo("AC_ChargeLoopReq", ACNS), "{\"AC_ChargeLoopReq\": {\"Header\": {\"SessionID\": \"4369A43B4CBFA987\", \"TimeStamp\": 1642397485}, \"MeterInfoRequested\": false, \"BPT_Dynamic_AC_CLReqControlMode\": {\"EVTargetEnergyRequest\": {\"Exponent\": 3, \"Value\": 40}, \"EVMaximumEnergyRequest\": {\"Exponent\": 3, \"Value\": 60}, \"EVMinimumEnergyRequest\": {\"Exponent\": 3, \"Value\": 20}, \"EVMaximumChargePower\": {\"Exponent\": 3, \"Value\": 300}, \"EVMinimumChargePower\": {\"Exponent\": 0, \"Value\": 100}, \"EVPresentActivePower\": {\"Exponent\": 3, \"Value\": 200}, \"EVPresentReactivePower\": {\"Exponent\": 3, \"Value\": 20}, \"EVMaximumDischargePower\": {\"Exponent\": 3, \"Value\": 11}, \"EVMinimumDischargePower\": {\"Exponent\": 3, \"Value\": 1}}}}");
            iso15118_20_messageMappings.put(new MessageInfo("AC_ChargeLoopRes", ACNS), "{\"AC_ChargeLoopRes\": {\"Header\": {\"SessionID\": \"4369A43B4CBFA987\", \"TimeStamp\": 1642397485}, \"ResponseCode\": \"OK\", \"BPT_Dynamic_AC_CLResControlMode\": {\"EVSETargetActivePower\": {\"Exponent\": 3, \"Value\": 3}, \"EVSETargetActivePower_L2\": {\"Exponent\": 3, \"Value\": 3}, \"EVSETargetActivePower_L3\": {\"Exponent\": 3, \"Value\": 3}}}}");
            iso15118_20_messageMappings.put(new MessageInfo("SessionStopReq", CommonMessagesNS), "{\"SessionStopReq\": {\"Header\": {\"SessionID\": \"4369A43B4CBFA987\", \"TimeStamp\": 1642397485}, \"ChargingSession\": \"Terminate\"}}");
            iso15118_20_messageMappings.put(new MessageInfo("SessionStopRes", CommonMessagesNS), "{\"SessionStopRes\": {\"Header\": {\"SessionID\": \"4369A43B4CBFA987\", \"TimeStamp\": 1642397486}, \"ResponseCode\": \"OK\"}}");
        }
        return iso15118_20_messageMappings;
    }

    static Map<MessageInfo, String> getISO15118_2_MessageMapping_Modded() {
        if (iso15118_2_messageMappings == null) {
            iso15118_2_messageMappings = Collections.synchronizedMap(new LinkedHashMap());
            iso15118_2_messageMappings.put(new MessageInfo("SupportedAppProtocolReq", AppProtocolNS), "{\"supportedAppProtocolReq\": {\"AppProtocol\": [{\"ProtocolNamespace\": \"urn:iso:15118:2:2013:MsgDef\", \"VersionNumberMajor\": 2, \"VersionNumberMinor\": 0, \"SchemaID\": 10, \"Priority\": 1}, {\"ProtocolNamespace\": \"urn:iso:std:iso:15118:-20:AC\", \"VersionNumberMajor\": 1, \"VersionNumberMinor\": 0, \"SchemaID\": 20, \"Priority\": 2}]}}");
            iso15118_2_messageMappings.put(new MessageInfo("SupportedAppProtocolRes", AppProtocolNS), "{\"supportedAppProtocolRes\": {\"ResponseCode\": \"OK_SuccessfulNegotiation\", \"SchemaID\": 10}}");
            iso15118_2_messageMappings.put(new MessageInfo("SessionSetupReq", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"00\"}, \"Body\": {\"SessionSetupReq\": {\"EVCCID\": \"8C859028BFC5\"}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("SessionSetupRes", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"C08CDF36985A7190\"}, \"Body\": {\"SessionSetupRes\": {\"ResponseCode\": \"OK_NewSessionEstablished\", \"EVSEID\": \"UK123E1234\", \"EVSETimeStamp\": 1632218029}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("ServiceDiscoveryReq", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"C08CDF36985A7190\"}, \"Body\": {\"ServiceDiscoveryReq\": {}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("SessionDiscoveryRes", MsgDefNS), "{\"V2G_Message\":{\"Header\":{\"SessionID\":\"9E3EA6105AE723C5\"},\"Body\":{\"ServiceDiscoveryRes\":{\"ResponseCode\":\"OK\",\"ServiceList\":{\"Service\":[{\"ServiceCategory\":\"ContractCertificate\",\"ServiceName\":\"Certificate\",\"FreeService\":true,\"ServiceID\":2}]},\"PaymentOptionList\":{\"PaymentOption\":[\"ExternalPayment\",\"Contract\"]},\"ChargeService\":{\"ServiceCategory\":\"EVCharging\",\"ServiceName\":\"AC_DC_Charging\",\"SupportedEnergyTransferMode\":{\"EnergyTransferMode\":[\"AC_single_phase_core\",\"AC_three_phase_core\"]},\"FreeService\":false,\"ServiceID\":1}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("ServiceDetailReq", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"A53EF57A8CA57A4C\"}, \"Body\": {\"ServiceDetailReq\": {\"ServiceID\": 2}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("ServiceDetailRes", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"A53EF57A8CA57A4C\"}, \"Body\": {\"ServiceDetailRes\": {\"ResponseCode\": \"OK\", \"ServiceID\": 2, \"ServiceParameterList\": {\"ParameterSet\": [{\"ParameterSetID\": 1, \"Parameter\": [{\"Name\": \"Service\", \"stringValue\": \"Installation\"}]}]}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("PaymentServiceSelectionReq", MsgDefNS), "{\"V2G_Message\":{\"Header\":{\"SessionID\":\"B3FBC37458069DBA\"},\"Body\":{\"PaymentServiceSelectionReq\":{\"SelectedPaymentOption\":\"Contract\",\"SelectedServiceList\":{\"SelectedService\":[{\"ServiceID\":1},{\"ServiceID\":2}]}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("PaymentServiceSelectionRes", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"C08CDF36985A7190\"}, \"Body\": {\"PaymentServiceSelectionRes\": {\"ResponseCode\": \"OK\"}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("AuthorisationReq", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"C08CDF36985A7190\"}, \"Body\": {\"AuthorizationReq\": {}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("AuthorizationRes", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"C08CDF36985A7190\"}, \"Body\": {\"AuthorizationRes\": {\"ResponseCode\": \"OK\", \"EVSEProcessing\": \"Finished\"}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("ChargeParameterDiscoveryReq", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"403CEFED6003428C\"}, \"Body\": {\"ChargeParameterDiscoveryReq\": {\"RequestedEnergyTransferMode\": \"AC_three_phase_core\", \"AC_EVChargeParameter\": {\"DepartureTime\": 0, \"EAmount\": {\"Multiplier\": 0, \"Value\": 60, \"Unit\": \"Wh\"}, \"EVMaxVoltage\": {\"Multiplier\": 0, \"Value\": 400, \"Unit\": \"V\"}, \"EVMaxCurrent\": {\"Multiplier\": 0, \"Value\": 16, \"Unit\": \"A\"}, \"EVMinCurrent\": {\"Multiplier\": 0, \"Value\": 10, \"Unit\": \"A\"}}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("ChargeParameterDiscoveryRes", MsgDefNS), "{\"V2G_Message\":{\"Header\":{\"Signature\":{\"SignatureValue\":{\"value\":\"MEUCICSta1OLLMIo3/H59qg4Dareuy/+UDr6p6fb/9TRPlFRAiEAx09IkrD7wL1f220dNKwH83WxRY6Yngx1BjAj3vMTDHw=\"},\"SignedInfo\":{\"Reference\":[{\"Transforms\":{\"Transform\":[{\"Algorithm\":\"http://www.w3.org/TR/canonical-exi/\"}]},\"DigestMethod\":{\"Algorithm\":\"http://www.w3.org/2001/04/xmlenc#sha256\"},\"DigestValue\":\"FOPYeuJCS2wwX9XxiiT+Ly9ofNZY1Zu+UafOP1zwhvA=\",\"URI\":\"#id1\"}],\"CanonicalizationMethod\":{\"Algorithm\":\"http://www.w3.org/TR/canonical-exi/\"},\"SignatureMethod\":{\"Algorithm\":\"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256\"}}},\"SessionID\":\"225FFA52C1BDAE2F\"},\"Body\":{\"ChargeParameterDiscoveryRes\":{\"ResponseCode\":\"OK\",\"EVSEProcessing\":\"Finished\",\"AC_EVSEChargeParameter\":{\"EVSEMaxCurrent\":{\"Multiplier\":0,\"Value\":32,\"Unit\":\"A\"},\"AC_EVSEStatus\":{\"RCD\":false,\"NotificationMaxDelay\":0,\"EVSENotification\":\"None\"},\"EVSENominalVoltage\":{\"Multiplier\":0,\"Value\":400,\"Unit\":\"V\"}},\"SAScheduleList\":{\"SAScheduleTuple\":[{\"PMaxSchedule\":{\"PMaxScheduleEntry\":[{\"PMax\":{\"Multiplier\":0,\"Value\":11000,\"Unit\":\"W\"},\"RelativeTimeInterval\":{\"duration\":3600,\"start\":0}}]},\"SAScheduleTupleID\":1,\"SalesTariff\":{\"SalesTariffID\":10,\"NumEPriceLevels\":2,\"SalesTariffEntry\":[{\"RelativeTimeInterval\":{\"start\":0},\"EPriceLevel\":1},{\"RelativeTimeInterval\":{\"duration\":1799,\"start\":1801},\"EPriceLevel\":2}],\"Id\":\"id1\"}}]}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("PowerDeliveryReq", MsgDefNS), "{\"V2G_Message\":{\"Header\":{\"SessionID\":\"363AD40B7302E70B\"},\"Body\":{\"PowerDeliveryReq\":{\"ChargeProgress\":\"Start\",\"ChargingProfile\":{\"ProfileEntry\":[{\"ChargingProfileEntryMaxPower\":{\"Multiplier\":0,\"Value\":11000,\"Unit\":\"W\"},\"ChargingProfileEntryStart\":0},{\"ChargingProfileEntryMaxPower\":{\"Multiplier\":0,\"Value\":0,\"Unit\":\"W\"},\"ChargingProfileEntryStart\":3600}]},\"SAScheduleTupleID\":1}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("PowerDeliveryRes", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"DE47DF7E4C07981D\"}, \"Body\": {\"PowerDeliveryRes\": {\"ResponseCode\": \"OK\", \"AC_EVSEStatus\": {\"NotificationMaxDelay\": 0, \"EVSENotification\": \"None\", \"RCD\": false}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("ChargingStatusReq", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"602BB3E84737BE58\"}, \"Body\": {\"ChargingStatusReq\": {}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("ChargingStatusRes", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"602BB3E84737BE58\"}, \"Body\": {\"ChargingStatusRes\": {\"ResponseCode\": \"OK\", \"EVSEID\": \"UK123E1234\", \"SAScheduleTupleID\": 1, \"ReceiptRequired\": false, \"AC_EVSEStatus\": {\"NotificationMaxDelay\": 0, \"EVSENotification\": \"None\", \"RCD\": false}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("CableCheckReq", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"A566BAC6855096C0\"}, \"Body\": {\"CableCheckReq\": {\"DC_EVStatus\": {\"EVReady\": true, \"EVErrorCode\": \"NO_ERROR\", \"EVRESSSOC\": 10}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("CableCheckRes", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"A566BAC6855096C0\"}, \"Body\": {\"CableCheckRes\": {\"ResponseCode\": \"OK\", \"DC_EVSEStatus\": {\"NotificationMaxDelay\": 0, \"EVSENotification\": \"None\", \"EVSEIsolationStatus\": \"Valid\", \"EVSEStatusCode\": \"EVSE_Ready\"}, \"EVSEProcessing\": \"Finished\"}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("PreChargeReq", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"A566BAC6855096C0\"}, \"Body\": {\"PreChargeReq\": {\"DC_EVStatus\": {\"EVReady\": true, \"EVErrorCode\": \"NO_ERROR\", \"EVRESSSOC\": 10}, \"EVTargetVoltage\": {\"Value\": 450, \"Multiplier\": 0, \"Unit\": \"V\"}, \"EVTargetCurrent\": {\"Value\": 10, \"Multiplier\": 0, \"Unit\": \"A\"}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("PreChargeRes", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"A566BAC6855096C0\"}, \"Body\": {\"PreChargeRes\": {\"ResponseCode\": \"OK\", \"DC_EVSEStatus\": {\"NotificationMaxDelay\": 0, \"EVSENotification\": \"None\", \"EVSEIsolationStatus\": \"Valid\", \"EVSEStatusCode\": \"EVSE_Ready\"}, \"EVSEPresentVoltage\": {\"Value\": 230, \"Multiplier\": 0, \"Unit\": \"V\"}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("WeldingDetectionReq", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"A566BAC6855096C0\"}, \"Body\": {\"WeldingDetectionReq\": {\"DC_EVStatus\": {\"EVReady\": true, \"EVErrorCode\": \"NO_ERROR\", \"EVRESSSOC\": 10}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("WeldingDetectionRes", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"A566BAC6855096C0\"}, \"Body\": {\"WeldingDetectionRes\": {\"ResponseCode\": \"OK\", \"DC_EVSEStatus\": {\"NotificationMaxDelay\": 0, \"EVSENotification\": \"None\", \"EVSEIsolationStatus\": \"Valid\", \"EVSEStatusCode\": \"EVSE_Ready\"}, \"EVSEPresentVoltage\": {\"Value\": 230, \"Multiplier\": 0, \"Unit\": \"V\"}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("CurrentDemandReq", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"A566BAC6855096C0\"}, \"Body\": {\"CurrentDemandReq\": {\"DC_EVStatus\": {\"EVReady\": true, \"EVErrorCode\": \"NO_ERROR\", \"EVRESSSOC\": 10}, \"EVTargetCurrent\": {\"Value\": 10, \"Multiplier\": 0, \"Unit\": \"A\"}, \"EVMaximumCurrentLimit\": {\"Value\": 300, \"Multiplier\": 0, \"Unit\": \"A\"}, \"EVMaximumPowerLimit\": {\"Value\": 10000, \"Multiplier\": 1, \"Unit\": \"W\"}, \"BulkChargingComplete\": false, \"ChargingComplete\": false, \"RemainingTimeToFullSoC\": {\"Value\": 100, \"Multiplier\": 0, \"Unit\": \"s\"}, \"RemainingTimeToBulkSoC\": {\"Value\": 80, \"Multiplier\": 0, \"Unit\": \"s\"}, \"EVTargetVoltage\": {\"Value\": 450, \"Multiplier\": 0, \"Unit\": \"V\"}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("CurrentDemandRes", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"A566BAC6855096C0\"}, \"Body\": {\"CurrentDemandRes\": {\"ResponseCode\": \"OK\", \"DC_EVSEStatus\": {\"NotificationMaxDelay\": 0, \"EVSENotification\": \"None\", \"EVSEIsolationStatus\": \"Valid\", \"EVSEStatusCode\": \"EVSE_Ready\"}, \"EVSEPresentVoltage\": {\"Value\": 230, \"Multiplier\": 0, \"Unit\": \"V\"}, \"EVSEPresentCurrent\": {\"Value\": 10, \"Multiplier\": 0, \"Unit\": \"A\"}, \"EVSECurrentLimitAchieved\": false, \"EVSEVoltageLimitAchieved\": false, \"EVSEPowerLimitAchieved\": false, \"EVSEMaximumVoltageLimit\": {\"Value\": 600, \"Multiplier\": 0, \"Unit\": \"V\"}, \"EVSEMaximumCurrentLimit\": {\"Value\": 300, \"Multiplier\": 0, \"Unit\": \"A\"}, \"EVSEMaximumPowerLimit\": {\"Value\": 1000, \"Multiplier\": 1, \"Unit\": \"W\"}, \"EVSEID\": \"UK123E1234\", \"SAScheduleTupleID\": 1, \"ReceiptRequired\": false}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("SessionStopReq", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"772E089BF54E58BB\"}, \"Body\": {\"SessionStopReq\": {\"ChargingSession\": \"Terminate\"}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("SessionStopRes", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"23BD6F140AC33301\"}, \"Body\": {\"SessionStopRes\": {\"ResponseCode\": \"OK\"}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("SignedInfo", XMLDSigNS), "{\"SignedInfo\":{\"CanonicalizationMethod\":{\"Algorithm\":\"http://www.w3.org/TR/canonical-exi/\"},\"SignatureMethod\":{\"Algorithm\":\"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256\"},\"Reference\":[{\"DigestMethod\":{\"Algorithm\":\"http://www.w3.org/2001/04/xmlenc#sha256\"},\"DigestValue\":\"/M+0FWWKts921TfZZw5ApQrujKmbpSdiqcuHHtmfric=\",\"URI\":\"#id1\",\"Transforms\":{\"Transform\":[{\"Algorithm\":\"http://www.w3.org/TR/canonical-exi/\"}]}}]}}");
            iso15118_2_messageMappings.put(new MessageInfo("PaymentDetailsReq", MsgDefNS), "{\"V2G_Message\":{\"Header\":{\"SessionID\":\"2978369F9B6D3A80\"},\"Body\":{\"PaymentDetailsReq\":{\"ContractSignatureCertChain\":{\"SubCertificates\":{\"Certificate\":[\"MIIB6DCCAY6gAwIBAgIBDTAKBggqhkjOPQQDAjBaMSAwHgYDVQQDDBdQS0ktMV9DUlRfTU9fU1VCMV9WQUxJRDEVMBMGA1UECgwMdmVyaXNjbyBHbWJIMQswCQYDVQQGEwJERTESMBAGCgmSJomT8ixkARkWAk1PMB4XDTIxMDkwMjEzMjEzOFoXDTI1MDkwMTEzMjEzOFowWjEgMB4GA1UEAwwXUEtJLTFfQ1JUX01PX1NVQjJfVkFMSUQxFTATBgNVBAoMDHZlcmlzY28gR21iSDELMAkGA1UEBhMCREUxEjAQBgoJkiaJk/IsZAEZFgJNTzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABA9h8psbI/mdtOsqHTmQsh+oMbkRrR/I6YNeAl0sjWvo64RZiHPA81nv/TYgUz1ZktjLU9cIElLFACj+CS4xalqjRTBDMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQDAgHGMB0GA1UdDgQWBBSQiNhe8kxPxU2YZShx5Ui+pXt3jjAKBggqhkjOPQQDAgNIADBFAiAF0QxlfjVuqomAL/rmzzl1T/d3V7bb2vW8U/ITAMwmnwIhAPvxFX+FMCWUDdnZ9vsg5UdcAoo0RD0uLgXgjoRSRkqv\",\"MIIB6DCCAY6gAwIBAgIBDDAKBggqhkjOPQQDAjBaMSAwHgYDVQQDDBdQS0ktMV9DUlRfTU9fUk9PVF9WQUxJRDEVMBMGA1UECgwMdmVyaXNjbyBHbWJIMQswCQYDVQQGEwJERTESMBAGCgmSJomT8ixkARkWAk1PMB4XDTIxMDkwMjEzMjEzOFoXDTI1MDkwMTEzMjEzOFowWjEgMB4GA1UEAwwXUEtJLTFfQ1JUX01PX1NVQjFfVkFMSUQxFTATBgNVBAoMDHZlcmlzY28gR21iSDELMAkGA1UEBhMCREUxEjAQBgoJkiaJk/IsZAEZFgJNTzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABDVarDqUpBKFNnNkssVwvuxnQn3n5mmzKtTQ77ZW8E/yqR6dcWJGfmmOPHYruYZhPFnOGUOej2M6r/0QFhmr55ajRTBDMBIGA1UdEwEB/wQIMAYBAf8CAQEwDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBSo3fgLPv91YCZfWdnipVvlXkP2pDAKBggqhkjOPQQDAgNIADBFAiEAhvm1ML5evLMHizVr04n4h2SakiNFzgGirk9FieQyVVoCIBqA2ZNiEflgdM8KINThkXwONYxJMctgySB6kl/LQ+qL\"]},\"Certificate\":\"MIIByzCCAXKgAwIBAgIBDzAKBggqhkjOPQQDAjBaMSAwHgYDVQQDDBdQS0ktMV9DUlRfTU9fU1VCMl9WQUxJRDEVMBMGA1UECgwMdmVyaXNjbyBHbWJIMQswCQYDVQQGEwJERTESMBAGCgmSJomT8ixkARkWAk1PMB4XDTIxMDkwMjEzMjEzOFoXDTIzMDkwMjEzMjEzOFowRDEXMBUGA1UEAwwOREUxQUJDRDJFRjM1N0ExFTATBgNVBAoMDHZlcmlzY28gR21iSDESMBAGCgmSJomT8ixkARkWAk1PMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEaJJ9IFNgGUzaJxpjcZhOYIal3loOXuKwXly+6FlZkaMPdUclMreEAWHKTzrqXzaolWQW8xBHG17/AyynDIhgPqM/MD0wDAYDVR0TAQH/BAIwADAOBgNVHQ8BAf8EBAMCA+gwHQYDVR0OBBYEFBPjJKg9jlTxyTUagyAmt3ej13R4MAoGCCqGSM49BAMCA0cAMEQCIFdZO1XVMtwk9/RuJUZHuCoazTSyexAyzKoURmRwNrHQAiB10WMXVNm+6Y4XXQuawoYABuyyoOXUuV4qG+3us3IS3A==\"},\"eMAID\":\"DE1ABCD2EF357A\"}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("PaymentDetailsRes", MsgDefNS), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"3D61614E45A0004B\"}, \"Body\": {\"PaymentDetailsRes\": {\"ResponseCode\": \"OK\", \"GenChallenge\": \"6Y6/O21CpGOA64OEudrvSw==\", \"EVSETimeStamp\": 1632752516}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("CertificateInstallationReq", MsgDefNS), "{\"V2G_Message\":{\"Header\":{\"Signature\":{\"SignatureValue\":{\"value\":\"MEYCIQDPbg+inQpolY0nnY22n84n9+dHE6bYNSoOYTvZcsxI0wIhAMOqeBoDXcwOacDAKXdv5vUvZQm51DgtGpVLvNL4pyO1\"},\"SignedInfo\":{\"Reference\":[{\"Transforms\":{\"Transform\":[{\"Algorithm\":\"http://www.w3.org/TR/canonical-exi/\"}]},\"DigestMethod\":{\"Algorithm\":\"http://www.w3.org/2001/04/xmlenc#sha256\"},\"DigestValue\":\"14rVJzskN1olOaOWRREZgabPJ8NFeilm8kaqSBEEgiA=\",\"URI\":\"#id1\"}],\"CanonicalizationMethod\":{\"Algorithm\":\"http://www.w3.org/TR/canonical-exi/\"},\"SignatureMethod\":{\"Algorithm\":\"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256\"}}},\"SessionID\":\"2F82FAE56F4442E2\"},\"Body\":{\"CertificateInstallationReq\":{\"ListOfRootCertificateIDs\":{\"RootCertificateID\":[{\"X509IssuerName\":\"<Name(CN=PKI-1_CRT_V2G_ROOT_VALID,O=verisco GmbH,C=DE,DC=V2G)>\",\"X509SerialNumber\":1}]},\"OEMProvisioningCert\":\"MIIB0TCCAXigAwIBAgIBCTAKBggqhkjOPQQDAjBcMSEwHwYDVQQDDBhQS0ktMV9DUlRfT0VNX1NVQjJfVkFMSUQxFTATBgNVBAoMDHZlcmlzY28gR21iSDELMAkGA1UEBhMCREUxEzARBgoJkiaJk/IsZAEZFgNPRU0wHhcNMjEwOTAyMTMyMTM4WhcNMjExMDAzMTMyMTM4WjBIMRowGAYDVQQDDBFXMDBWRVJJU0NPMDAwMDAwMDEVMBMGA1UECgwMdmVyaXNjbyBHbWJIMRMwEQYKCZImiZPyLGQBGRYDT0VNMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEePb5sm8lLYfueeitKraDIwqVqb526gFTErGN68/SFnQfjlYP8vulZktRg2G1aqt/XHtmThi9vLcV+OaxKRGE0qM/MD0wDAYDVR0TAQH/BAIwADAOBgNVHQ8BAf8EBAMCA4gwHQYDVR0OBBYEFPgm1UQLCJg5tT5MmWGtkyG7Bcd9MAoGCCqGSM49BAMCA0cAMEQCIAL9uxIQOgEOjhMizpkzHEg1ZNQolQ0DWKW54bMzkcd4AiBduIbLFOn5HUkvR5IlI5+41ZV//CfECUoYneLO91yp4Q==\",\"Id\":\"id1\"}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("CertificateInstallationRes", MsgDefNS), "{\"V2G_Message\":{\"Header\":{\"SessionID\":\"3554EEC6F808A383\"},\"Body\":{\"CertificateInstallationRes\":{\"ContractSignatureCertChain\":{\"SubCertificates\":{\"Certificate\":[\"MIIB6DCCAY6gAwIBAgIBDTAKBggqhkjOPQQDAjBaMSAwHgYDVQQDDBdQS0ktMV9DUlRfTU9fU1VCMV9WQUxJRDEVMBMGA1UECgwMdmVyaXNjbyBHbWJIMQswCQYDVQQGEwJERTESMBAGCgmSJomT8ixkARkWAk1PMB4XDTIxMDkwMjEzMjEzOFoXDTI1MDkwMTEzMjEzOFowWjEgMB4GA1UEAwwXUEtJLTFfQ1JUX01PX1NVQjJfVkFMSUQxFTATBgNVBAoMDHZlcmlzY28gR21iSDELMAkGA1UEBhMCREUxEjAQBgoJkiaJk/IsZAEZFgJNTzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABA9h8psbI/mdtOsqHTmQsh+oMbkRrR/I6YNeAl0sjWvo64RZiHPA81nv/TYgUz1ZktjLU9cIElLFACj+CS4xalqjRTBDMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQDAgHGMB0GA1UdDgQWBBSQiNhe8kxPxU2YZShx5Ui+pXt3jjAKBggqhkjOPQQDAgNIADBFAiAF0QxlfjVuqomAL/rmzzl1T/d3V7bb2vW8U/ITAMwmnwIhAPvxFX+FMCWUDdnZ9vsg5UdcAoo0RD0uLgXgjoRSRkqv\",\"MIIB6DCCAY6gAwIBAgIBDDAKBggqhkjOPQQDAjBaMSAwHgYDVQQDDBdQS0ktMV9DUlRfTU9fUk9PVF9WQUxJRDEVMBMGA1UECgwMdmVyaXNjbyBHbWJIMQswCQYDVQQGEwJERTESMBAGCgmSJomT8ixkARkWAk1PMB4XDTIxMDkwMjEzMjEzOFoXDTI1MDkwMTEzMjEzOFowWjEgMB4GA1UEAwwXUEtJLTFfQ1JUX01PX1NVQjFfVkFMSUQxFTATBgNVBAoMDHZlcmlzY28gR21iSDELMAkGA1UEBhMCREUxEjAQBgoJkiaJk/IsZAEZFgJNTzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABDVarDqUpBKFNnNkssVwvuxnQn3n5mmzKtTQ77ZW8E/yqR6dcWJGfmmOPHYruYZhPFnOGUOej2M6r/0QFhmr55ajRTBDMBIGA1UdEwEB/wQIMAYBAf8CAQEwDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBSo3fgLPv91YCZfWdnipVvlXkP2pDAKBggqhkjOPQQDAgNIADBFAiEAhvm1ML5evLMHizVr04n4h2SakiNFzgGirk9FieQyVVoCIBqA2ZNiEflgdM8KINThkXwONYxJMctgySB6kl/LQ+qL\"]},\"Id\":\"id1\",\"Certificate\":\"MIIByzCCAXKgAwIBAgIBDzAKBggqhkjOPQQDAjBaMSAwHgYDVQQDDBdQS0ktMV9DUlRfTU9fU1VCMl9WQUxJRDEVMBMGA1UECgwMdmVyaXNjbyBHbWJIMQswCQYDVQQGEwJERTESMBAGCgmSJomT8ixkARkWAk1PMB4XDTIxMDkwMjEzMjEzOFoXDTIzMDkwMjEzMjEzOFowRDEXMBUGA1UEAwwOREUxQUJDRDJFRjM1N0ExFTATBgNVBAoMDHZlcmlzY28gR21iSDESMBAGCgmSJomT8ixkARkWAk1PMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEaJJ9IFNgGUzaJxpjcZhOYIal3loOXuKwXly+6FlZkaMPdUclMreEAWHKTzrqXzaolWQW8xBHG17/AyynDIhgPqM/MD0wDAYDVR0TAQH/BAIwADAOBgNVHQ8BAf8EBAMCA+gwHQYDVR0OBBYEFBPjJKg9jlTxyTUagyAmt3ej13R4MAoGCCqGSM49BAMCA0cAMEQCIFdZO1XVMtwk9/RuJUZHuCoazTSyexAyzKoURmRwNrHQAiB10WMXVNm+6Y4XXQuawoYABuyyoOXUuV4qG+3us3IS3A==\"},\"ResponseCode\":\"OK\",\"ContractSignatureEncryptedPrivateKey\":{\"Id\":\"id2\",\"value\":\"AA==\"},\"DHpublickey\":{\"Id\":\"id3\",\"value\":\"AA==\"},\"eMAID\":{\"Id\":\"id4\",\"value\":\"DE1ABCD2EF357A\"},\"SAProvisioningCertificateChain\":{\"SubCertificates\":{\"Certificate\":[\"MIIB7zCCAZSgAwIBAgIBFzAKBggqhkjOPQQDAjBdMSIwIAYDVQQDDBlQS0ktMV9DUlRfUFJPVl9TVUIxX1ZBTElEMRUwEwYDVQQKDAx2ZXJpc2NvIEdtYkgxCzAJBgNVBAYTAkRFMRMwEQYKCZImiZPyLGQBGRYDQ1BTMB4XDTIxMDkwMjEzMjEzOVoXDTIzMDkwMjEzMjEzOVowXTEiMCAGA1UEAwwZUEtJLTFfQ1JUX1BST1ZfU1VCMl9WQUxJRDEVMBMGA1UECgwMdmVyaXNjbyBHbWJIMQswCQYDVQQGEwJERTETMBEGCgmSJomT8ixkARkWA0NQUzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABDBjKGihEkDHZtQZXJYXe3XhjtKvHktoK9ulVVljGRYZZPrLUDQQ2lFIm/DKqRIUsrVhlolfu3BGJQUjpUmtk7ujRTBDMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBTjLL8CwMeGQ4nEVnuAc10mDUEJJTAKBggqhkjOPQQDAgNJADBGAiEAl6t2/7D7AB/6kF5tVqK0IDNM6wPsxGFC2U5IxTzngAsCIQClTvD2kXOp7El1TSfG4eVB83D5YimExEIvvONqUKbuMA==\",\"MIIB7TCCAZOgAwIBAgIBFjAKBggqhkjOPQQDAjBcMSEwHwYDVQQDDBhQS0ktMV9DUlRfVjJHX1JPT1RfVkFMSUQxFTATBgNVBAoMDHZlcmlzY28gR21iSDELMAkGA1UEBhMCREUxEzARBgoJkiaJk/IsZAEZFgNWMkcwHhcNMjEwOTAyMTMyMTM5WhcNMjUwOTAxMTMyMTM5WjBdMSIwIAYDVQQDDBlQS0ktMV9DUlRfUFJPVl9TVUIxX1ZBTElEMRUwEwYDVQQKDAx2ZXJpc2NvIEdtYkgxCzAJBgNVBAYTAkRFMRMwEQYKCZImiZPyLGQBGRYDQ1BTMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEuIkmcmiqntz1RGeq9v/nct1vm+7ygfDqO5/YfTrEpwPDbE1Z1X5rmfUvjZ1N0ZXGiy2CtKTGmhd/naQKGvUj4qNFMEMwEgYDVR0TAQH/BAgwBgEB/wIBATAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFFKoBvqCka1q03Wa8y7Uen6EWjuGMAoGCCqGSM49BAMCA0gAMEUCIQDi/X96c6e7HoIJQ/PCzRA9oebrwA0/e00MJ/dOjvpOdwIgbZyOBu8BtwBsv5HTOGNJzJbiUkf8b7Nj85KJjFeHgIw=\"]},\"Certificate\":\"MIIB5zCCAY6gAwIBAgIBGDAKBggqhkjOPQQDAjBdMSIwIAYDVQQDDBlQS0ktMV9DUlRfUFJPVl9TVUIyX1ZBTElEMRUwEwYDVQQKDAx2ZXJpc2NvIEdtYkgxCzAJBgNVBAYTAkRFMRMwEQYKCZImiZPyLGQBGRYDQ1BTMB4XDTIxMDkwMjEzMjE0MFoXDTIxMTAwMzEzMjE0MFowXTEiMCAGA1UEAwwZUEtJLTFfQ1JUX1BST1ZfTEVBRl9WQUxJRDEVMBMGA1UECgwMdmVyaXNjbyBHbWJIMQswCQYDVQQGEwJERTETMBEGCgmSJomT8ixkARkWA0NQUzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABDah/kgaA+vKDNHU3Vp+6cw8tIxkN/72kIknAj/99oMP9iRM8FHGNLaPzq2J0pcDpzmZexzbToaqbkdQ6p4Y/AmjPzA9MAwGA1UdEwEB/wQCMAAwDgYDVR0PAQH/BAQDAgeAMB0GA1UdDgQWBBQp31ArJBS/DX68uwG2lum2Wuj6sTAKBggqhkjOPQQDAgNHADBEAiBsuwGK22QitrfSXTywE+d4v5ABq3nKlV7MzaSJ3qpvzwIge2zPajjyCextKm3TMhs303uUwmfm99D6mS4tt1uR7wI=\"}}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("MeteringReceiptReq", MsgDefNS), "{\"V2G_Message\":{\"Header\":{\"Signature\":{\"SignatureValue\":{\"value\":\"MEUCIQDi6nEn1KpkwuDrQqYN8U0MnuZfguYEEEKCp8cNnHtNqAIgPVMar9Qf1ylBRYrvtToWyDGREbPjGKbGsLmpCs7qfrI=\"},\"SignedInfo\":{\"Reference\":[{\"Transforms\":{\"Transform\":[{\"Algorithm\":\"http://www.w3.org/TR/canonical-exi/\"}]},\"DigestMethod\":{\"Algorithm\":\"http://www.w3.org/2001/04/xmlenc#sha256\"},\"DigestValue\":\"hgBWyaUAlM5Tjrj8Nn8Z4tdC2nP5ctFb/uqkITTnVX0=\",\"URI\":\"#id1\"}],\"CanonicalizationMethod\":{\"Algorithm\":\"http://www.w3.org/TR/canonical-exi/\"},\"SignatureMethod\":{\"Algorithm\":\"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256\"}}},\"SessionID\":\"49B5AEDA5061A7BC\"},\"Body\":{\"MeteringReceiptReq\":{\"MeterInfo\":{\"TMeter\":1635433881,\"MeterReading\":12345,\"MeterID\":\"Switch-Meter-123\"},\"Id\":\"id1\",\"SessionID\":\"49B5AEDA5061A7BC\",\"SAScheduleTupleID\":1}}}}");
            iso15118_2_messageMappings.put(new MessageInfo("ContractSignatureCertChain", MsgDefNS, true), "{\"ContractSignatureCertChain\":{\"SubCertificates\":{\"Certificate\":[\"MIIB6DCCAY6gAwIBAgIBDTAKBggqhkjOPQQDAjBaMSAwHgYDVQQDDBdQS0ktMV9DUlRfTU9fU1VCMV9WQUxJRDEVMBMGA1UECgwMdmVyaXNjbyBHbWJIMQswCQYDVQQGEwJERTESMBAGCgmSJomT8ixkARkWAk1PMB4XDTIxMDkwMjEzMjEzOFoXDTI1MDkwMTEzMjEzOFowWjEgMB4GA1UEAwwXUEtJLTFfQ1JUX01PX1NVQjJfVkFMSUQxFTATBgNVBAoMDHZlcmlzY28gR21iSDELMAkGA1UEBhMCREUxEjAQBgoJkiaJk/IsZAEZFgJNTzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABA9h8psbI/mdtOsqHTmQsh+oMbkRrR/I6YNeAl0sjWvo64RZiHPA81nv/TYgUz1ZktjLU9cIElLFACj+CS4xalqjRTBDMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQDAgHGMB0GA1UdDgQWBBSQiNhe8kxPxU2YZShx5Ui+pXt3jjAKBggqhkjOPQQDAgNIADBFAiAF0QxlfjVuqomAL/rmzzl1T/d3V7bb2vW8U/ITAMwmnwIhAPvxFX+FMCWUDdnZ9vsg5UdcAoo0RD0uLgXgjoRSRkqv\",\"MIIB6DCCAY6gAwIBAgIBDDAKBggqhkjOPQQDAjBaMSAwHgYDVQQDDBdQS0ktMV9DUlRfTU9fUk9PVF9WQUxJRDEVMBMGA1UECgwMdmVyaXNjbyBHbWJIMQswCQYDVQQGEwJERTESMBAGCgmSJomT8ixkARkWAk1PMB4XDTIxMDkwMjEzMjEzOFoXDTI1MDkwMTEzMjEzOFowWjEgMB4GA1UEAwwXUEtJLTFfQ1JUX01PX1NVQjFfVkFMSUQxFTATBgNVBAoMDHZlcmlzY28gR21iSDELMAkGA1UEBhMCREUxEjAQBgoJkiaJk/IsZAEZFgJNTzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABDVarDqUpBKFNnNkssVwvuxnQn3n5mmzKtTQ77ZW8E/yqR6dcWJGfmmOPHYruYZhPFnOGUOej2M6r/0QFhmr55ajRTBDMBIGA1UdEwEB/wQIMAYBAf8CAQEwDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBSo3fgLPv91YCZfWdnipVvlXkP2pDAKBggqhkjOPQQDAgNIADBFAiEAhvm1ML5evLMHizVr04n4h2SakiNFzgGirk9FieQyVVoCIBqA2ZNiEflgdM8KINThkXwONYxJMctgySB6kl/LQ+qL\"]},\"Id\":\"id1\",\"Certificate\":\"MIIByzCCAXKgAwIBAgIBDzAKBggqhkjOPQQDAjBaMSAwHgYDVQQDDBdQS0ktMV9DUlRfTU9fU1VCMl9WQUxJRDEVMBMGA1UECgwMdmVyaXNjbyBHbWJIMQswCQYDVQQGEwJERTESMBAGCgmSJomT8ixkARkWAk1PMB4XDTIxMDkwMjEzMjEzOFoXDTIzMDkwMjEzMjEzOFowRDEXMBUGA1UEAwwOREUxQUJDRDJFRjM1N0ExFTATBgNVBAoMDHZlcmlzY28gR21iSDESMBAGCgmSJomT8ixkARkWAk1PMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEaJJ9IFNgGUzaJxpjcZhOYIal3loOXuKwXly+6FlZkaMPdUclMreEAWHKTzrqXzaolWQW8xBHG17/AyynDIhgPqM/MD0wDAYDVR0TAQH/BAIwADAOBgNVHQ8BAf8EBAMCA+gwHQYDVR0OBBYEFBPjJKg9jlTxyTUagyAmt3ej13R4MAoGCCqGSM49BAMCA0cAMEQCIFdZO1XVMtwk9/RuJUZHuCoazTSyexAyzKoURmRwNrHQAiB10WMXVNm+6Y4XXQuawoYABuyyoOXUuV4qG+3us3IS3A==\"}  }");
            iso15118_2_messageMappings.put(new MessageInfo("ContractSignatureEncryptedPrivateKey", MsgDefNS, true), "{\"ContractSignatureEncryptedPrivateKey\": {\"Id\": \"id2\", \"value\": \"AA==\"}}");
            iso15118_2_messageMappings.put(new MessageInfo("DHpublickey", MsgDefNS, true), "{\"DHpublickey\": {\"Id\": \"id3\", \"value\": \"AA==\"}}");
            iso15118_2_messageMappings.put(new MessageInfo("eMAID", MsgDefNS, true), "{\"eMAID\": {\"Id\": \"id4\", \"value\": \"DE1ABCD2EF357A\"}}");
            iso15118_2_messageMappings.put(new MessageInfo("SalesTariff", MsgDefNS, true), "{\"SalesTariff\": {\"Id\": \"id1\", \"SalesTariffID\": 10, \"NumEPriceLevels\": 2, \"SalesTariffEntry\": [{\"EPriceLevel\": 1, \"RelativeTimeInterval\": {\"start\": 0}}, {\"EPriceLevel\": 2, \"RelativeTimeInterval\": {\"start\": 1801, \"duration\": 1799}}]}}");
        }
        return iso15118_2_messageMappings;
    }

    static Map<MessageInfo, String> getISO15118_2_MessageMapping_FragmentGrammar() {
        if (iso15118_2_messageMappings_fragmentGrammar == null) {
            iso15118_2_messageMappings_fragmentGrammar = Collections.synchronizedMap(new LinkedHashMap());
            iso15118_2_messageMappings_fragmentGrammar.put(new MessageInfo("AuthorizationReq", MsgDefNS, true), "{\"AuthorizationReq\":{\"Id\":\"ID1\",\"GenChallenge\":\"VayS8Hkd0pNuRE1pRx+h2Q==\"}}");
            iso15118_2_messageMappings_fragmentGrammar.put(new MessageInfo("MeteringReceiptReq", MsgDefNS, true), "{\"MeteringReceiptReq\":{\"Id\":\"id1\",\"SessionID\":\"49B5AEDA5061A7BC\",\"SAScheduleTupleID\":1,\"MeterInfo\":{\"MeterID\":\"Switch-Meter-123\",\"MeterReading\":12345,\"TMeter\":1635433881}}}");
            iso15118_2_messageMappings_fragmentGrammar.put(new MessageInfo("CertificateInstallationReq", MsgDefNS, true), "{\"CertificateInstallationReq\": {\"Header\": {\"SessionID\": \"5DC94BF6003C58BA\", \"TimeStamp\": 1636461326, \"Signature\": {\"SignedInfo\": {\"CanonicalizationMethod\": {\"Algorithm\": \"http://www.w3.org/TR/canonical-exi/\"}, \"SignatureMethod\": {\"Algorithm\": \"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256\"}, \"Reference\": [{\"Transforms\": [{\"Transform\": {\"Algorithm\": \"http://www.w3.org/TR/canonical-exi/\"}}], \"DigestMethod\": {\"Algorithm\": \"http://www.w3.org/2001/04/xmlenc#sha256\"}, \"DigestValue\": \"aGYZjLIwFCgpNhml1UH5UpIotSE5FpUDcmN+0cgXg6E=\", \"URI\": \"#id1\"}]}, \"SignatureValue\": {\"value\": \"MEQCIHyunb6CKRr8c+IWgAMhHaaK8YJvAOYd9GoPBTAbsNCSAiBpdyUFagKJTZgPdxwNvPrOQNkC8bbYJX69EL4Sz2aHWA==\"}}}, \"OEMProvisioningCertificateChain\": {\"Id\": \"id1\", \"Certificate\": \"MIIBwDCCAWWgAwIBAgICMEAwCgYIKoZIzj0EAwIwRzESMBAGA1UEAwwJT0VNU3ViQ0EyMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMB4XDTIxMTEwODE3NTY1MVoXDTI1MTEwNzE3NTY1MVowSTEUMBIGA1UEAwwLT0VNUHJvdkNlcnQxDzANBgNVBAoMBlN3aXRjaDELMAkGA1UEBhMCVUsxEzARBgoJkiaJk/IsZAEZFgNPRU0wWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAQh28fTnaQ+OlxojuQZT/pjJaKu4N8CB4Uz8dND0sIlfu3HkNBb4mOk2b3zgA7cub7OAAVlb1x4hO7fJlEu3/pToz8wPTAMBgNVHRMBAf8EAjAAMA4GA1UdDwEB/wQEAwIDiDAdBgNVHQ4EFgQUniuzBygTPlYGcE3UXiyPdBqtkHAwCgYIKoZIzj0EAwIDSQAwRgIhAIkxKc+8WQHqvoYO+4n9LbIc/QJeAogFwqLKS4Pt0t2BAiEAwWjk4oqLA/BVaWgnN/cSlSom/P0YN+Isf4JHvoBzOzo=\", \"SubCertificates\": [{\"Certificate\": \"MIIBwzCCAWmgAwIBAgICMD8wCgYIKoZIzj0EAwIwRzESMBAGA1UEAwwJT0VNU3ViQ0ExMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMB4XDTIxMTEwODE3NTY1MVoXDTI1MTEwNzE3NTY1MVowRzESMBAGA1UEAwwJT0VNU3ViQ0EyMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE/IU2sUXeATj5/HcB5k5L1k2Lg10rvjHPEz3J5VF3GUsvEu40vWpOuirxFxE8j2X1pEN+/WA0J0+YsSXP0KzH4KNFMEMwEgYDVR0TAQH/BAgwBgEB/wIBADAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFCNE2aWcqZ5nrQC8qiNLWNeR1nJpMAoGCCqGSM49BAMCA0gAMEUCIAsEEbMnEjUuZ64Patbzz9B7ouugeavjBdR7jdlqv6DFAiEAjyhqzEGtijXNpCnA/pJcAW4EaR3SmBJ6rVIdYQxCVk8=\"}, {\"Certificate\": \"MIIBwzCCAWmgAwIBAgICMD4wCgYIKoZIzj0EAwIwRzESMBAGA1UEAwwJT0VNUm9vdENBMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMB4XDTIxMTEwODE3NTY1MVoXDTI1MTEwNzE3NTY1MVowRzESMBAGA1UEAwwJT0VNU3ViQ0ExMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEKuwJGkmrog2b+h2p11GV9cM3cZn92QFoyuvkBAxl4iSW90HGKkfVuXVRojkzBWOMPzXoElVMEcEpB7hugleNOKNFMEMwEgYDVR0TAQH/BAgwBgEB/wIBATAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFAX0j4MPNB9jVG5RmXRkS3EeI4V1MAoGCCqGSM49BAMCA0gAMEUCIHqLCS8cjb9DY/HXdlCMvKH2pBK2K74TbSkXUlHoMZMIAiEApcmmAO33E+oJGX1N+sV8plQtKU5sja8VZxlHf8X1o+c=\"}]}, \"ListOfRootCertificateIDs\": [{\"RootCertificateID\": {\"X509IssuerName\": \"<Name(CN=V2GRootCA,O=Switch,C=UK,DC=V2G)>\", \"X509SerialNumber\": 12345}}], \"MaximumContractCertificateChains\": 3}}");
        }
        return iso15118_2_messageMappings_fragmentGrammar;
    }

    static Map<MessageInfo, String> getISO15118_2_MessageMapping_FragmentGrammar_Modded() {
        if (iso15118_2_messageMappings_fragmentGrammar == null) {
            iso15118_2_messageMappings_fragmentGrammar = Collections.synchronizedMap(new LinkedHashMap());
            iso15118_2_messageMappings_fragmentGrammar.put(new MessageInfo("AuthorizationReq", MsgDefNS, true), "{\"AuthorizationReq\":{\"Id\":\"ID1\",\"GenChallenge\":\"VayS8Hkd0pNuRE1pRx+h2Q==\"}}");
            iso15118_2_messageMappings_fragmentGrammar.put(new MessageInfo("MeteringReceiptReq", MsgDefNS, true), "{\"MeteringReceiptReq\":{\"Id\":\"id1\",\"SessionID\":\"49B5AEDA5061A7BC\",\"SAScheduleTupleID\":1,\"MeterInfo\":{\"MeterID\":\"Switch-Meter-123\",\"MeterReading\":12345,\"TMeter\":1635433881}}}");
            iso15118_2_messageMappings_fragmentGrammar.put(new MessageInfo("CertificateInstallationReq", MsgDefNS, true), "{\"CertificateInstallationReq\": {\"Header\": {\"SessionID\": \"5DC94BF6003C58BA\", \"TimeStamp\": 1636461326, \"Signature\": {\"SignedInfo\": {\"CanonicalizationMethod\": {\"Algorithm\": \"http://www.w3.org/TR/canonical-exi/\"}, \"SignatureMethod\": {\"Algorithm\": \"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256\"}, \"Reference\": [{\"Transforms\": [{\"Transform\": {\"Algorithm\": \"http://www.w3.org/TR/canonical-exi/\"}}], \"DigestMethod\": {\"Algorithm\": \"http://www.w3.org/2001/04/xmlenc#sha256\"}, \"DigestValue\": \"aGYZjLIwFCgpNhml1UH5UpIotSE5FpUDcmN+0cgXg6E=\", \"URI\": \"#id1\"}]}, \"SignatureValue\": {\"value\": \"MEQCIHyunb6CKRr8c+IWgAMhHaaK8YJvAOYd9GoPBTAbsNCSAiBpdyUFagKJTZgPdxwNvPrOQNkC8bbYJX69EL4Sz2aHWA==\"}}}, \"OEMProvisioningCertificateChain\": {\"Id\": \"id1\", \"Certificate\": \"MIIBwDCCAWWgAwIBAgICMEAwCgYIKoZIzj0EAwIwRzESMBAGA1UEAwwJT0VNU3ViQ0EyMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMB4XDTIxMTEwODE3NTY1MVoXDTI1MTEwNzE3NTY1MVowSTEUMBIGA1UEAwwLT0VNUHJvdkNlcnQxDzANBgNVBAoMBlN3aXRjaDELMAkGA1UEBhMCVUsxEzARBgoJkiaJk/IsZAEZFgNPRU0wWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAQh28fTnaQ+OlxojuQZT/pjJaKu4N8CB4Uz8dND0sIlfu3HkNBb4mOk2b3zgA7cub7OAAVlb1x4hO7fJlEu3/pToz8wPTAMBgNVHRMBAf8EAjAAMA4GA1UdDwEB/wQEAwIDiDAdBgNVHQ4EFgQUniuzBygTPlYGcE3UXiyPdBqtkHAwCgYIKoZIzj0EAwIDSQAwRgIhAIkxKc+8WQHqvoYO+4n9LbIc/QJeAogFwqLKS4Pt0t2BAiEAwWjk4oqLA/BVaWgnN/cSlSom/P0YN+Isf4JHvoBzOzo=\", \"SubCertificates\": [{\"Certificate\": \"MIIBwzCCAWmgAwIBAgICMD8wCgYIKoZIzj0EAwIwRzESMBAGA1UEAwwJT0VNU3ViQ0ExMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMB4XDTIxMTEwODE3NTY1MVoXDTI1MTEwNzE3NTY1MVowRzESMBAGA1UEAwwJT0VNU3ViQ0EyMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE/IU2sUXeATj5/HcB5k5L1k2Lg10rvjHPEz3J5VF3GUsvEu40vWpOuirxFxE8j2X1pEN+/WA0J0+YsSXP0KzH4KNFMEMwEgYDVR0TAQH/BAgwBgEB/wIBADAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFCNE2aWcqZ5nrQC8qiNLWNeR1nJpMAoGCCqGSM49BAMCA0gAMEUCIAsEEbMnEjUuZ64Patbzz9B7ouugeavjBdR7jdlqv6DFAiEAjyhqzEGtijXNpCnA/pJcAW4EaR3SmBJ6rVIdYQxCVk8=\"}, {\"Certificate\": \"MIIBwzCCAWmgAwIBAgICMD4wCgYIKoZIzj0EAwIwRzESMBAGA1UEAwwJT0VNUm9vdENBMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMB4XDTIxMTEwODE3NTY1MVoXDTI1MTEwNzE3NTY1MVowRzESMBAGA1UEAwwJT0VNU3ViQ0ExMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEKuwJGkmrog2b+h2p11GV9cM3cZn92QFoyuvkBAxl4iSW90HGKkfVuXVRojkzBWOMPzXoElVMEcEpB7hugleNOKNFMEMwEgYDVR0TAQH/BAgwBgEB/wIBATAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFAX0j4MPNB9jVG5RmXRkS3EeI4V1MAoGCCqGSM49BAMCA0gAMEUCIHqLCS8cjb9DY/HXdlCMvKH2pBK2K74TbSkXUlHoMZMIAiEApcmmAO33E+oJGX1N+sV8plQtKU5sja8VZxlHf8X1o+c=\"}]}, \"ListOfRootCertificateIDs\": [{\"RootCertificateID\": {\"X509IssuerName\": \"<Name(CN=V2GRootCA,O=Switch,C=UK,DC=V2G)>\", \"X509SerialNumber\": 12345}}], \"MaximumContractCertificateChains\": 3}}");
        }
        return iso15118_2_messageMappings_fragmentGrammar;
    }

    private static Map<MessageInfo, String> getISO15118_20_MessageMapping_FragmentGrammar_Modded() {
        if (iso15118_20_messageMappings_fragmentGrammar == null) {
            iso15118_20_messageMappings_fragmentGrammar = Collections.synchronizedMap(new LinkedHashMap());
            iso15118_20_messageMappings_fragmentGrammar.put(new MessageInfo("OEMProvisioningCertificateChain", CommonMessagesNS, true), "{\"OEMProvisioningCertificateChain\":{\"SubCertificates\":{\"Certificate\":[\"MIIBwzCCAWmgAwIBAgICMD8wCgYIKoZIzj0EAwIwRzESMBAGA1UEAwwJT0VNU3ViQ0ExMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMB4XDTIxMTEwODE3NTY1MVoXDTI1MTEwNzE3NTY1MVowRzESMBAGA1UEAwwJT0VNU3ViQ0EyMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE/IU2sUXeATj5/HcB5k5L1k2Lg10rvjHPEz3J5VF3GUsvEu40vWpOuirxFxE8j2X1pEN+/WA0J0+YsSXP0KzH4KNFMEMwEgYDVR0TAQH/BAgwBgEB/wIBADAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFCNE2aWcqZ5nrQC8qiNLWNeR1nJpMAoGCCqGSM49BAMCA0gAMEUCIAsEEbMnEjUuZ64Patbzz9B7ouugeavjBdR7jdlqv6DFAiEAjyhqzEGtijXNpCnA/pJcAW4EaR3SmBJ6rVIdYQxCVk8=\",\"MIIBwzCCAWmgAwIBAgICMD4wCgYIKoZIzj0EAwIwRzESMBAGA1UEAwwJT0VNUm9vdENBMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMB4XDTIxMTEwODE3NTY1MVoXDTI1MTEwNzE3NTY1MVowRzESMBAGA1UEAwwJT0VNU3ViQ0ExMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEKuwJGkmrog2b+h2p11GV9cM3cZn92QFoyuvkBAxl4iSW90HGKkfVuXVRojkzBWOMPzXoElVMEcEpB7hugleNOKNFMEMwEgYDVR0TAQH/BAgwBgEB/wIBATAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFAX0j4MPNB9jVG5RmXRkS3EeI4V1MAoGCCqGSM49BAMCA0gAMEUCIHqLCS8cjb9DY/HXdlCMvKH2pBK2K74TbSkXUlHoMZMIAiEApcmmAO33E+oJGX1N+sV8plQtKU5sja8VZxlHf8X1o+c=\"]},\"Id\":\"id1\",\"Certificate\":\"MIIBwDCCAWWgAwIBAgICMEAwCgYIKoZIzj0EAwIwRzESMBAGA1UEAwwJT0VNU3ViQ0EyMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRMwEQYKCZImiZPyLGQBGRYDT0VNMB4XDTIxMTEwODE3NTY1MVoXDTI1MTEwNzE3NTY1MVowSTEUMBIGA1UEAwwLT0VNUHJvdkNlcnQxDzANBgNVBAoMBlN3aXRjaDELMAkGA1UEBhMCVUsxEzARBgoJkiaJk/IsZAEZFgNPRU0wWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAQh28fTnaQ+OlxojuQZT/pjJaKu4N8CB4Uz8dND0sIlfu3HkNBb4mOk2b3zgA7cub7OAAVlb1x4hO7fJlEu3/pToz8wPTAMBgNVHRMBAf8EAjAAMA4GA1UdDwEB/wQEAwIDiDAdBgNVHQ4EFgQUniuzBygTPlYGcE3UXiyPdBqtkHAwCgYIKoZIzj0EAwIDSQAwRgIhAIkxKc+8WQHqvoYO+4n9LbIc/QJeAogFwqLKS4Pt0t2BAiEAwWjk4oqLA/BVaWgnN/cSlSom/P0YN+Isf4JHvoBzOzo=\"}}");
            iso15118_20_messageMappings_fragmentGrammar.put(new MessageInfo("PnC_AReqAuthorizationMode", CommonMessagesNS, true), "{\"PnC_AReqAuthorizationMode\": {\"Id\": \"id1\", \"GenChallenge\": \"+u7JeyrE78u9lgXRCYQc7A==\", \"ContractCertificateChain\": {\"Certificate\": \"MIIBwTCCAWagAwIBAgICMEQwCgYIKoZIzj0EAwIwRTERMA8GA1UEAwwITU9TdWJDQTIxDzANBgNVBAoMBlN3aXRjaDELMAkGA1UEBhMCVUsxEjAQBgoJkiaJk/IsZAEZFgJNTzAeFw0yMTEyMTMxNzUyMzFaFw0yMzEyMTMxNzUyMzFaMEwxGDAWBgNVBAMMD1VLU1dJMTIzNDU2Nzg5QTEPMA0GA1UECgwGU3dpdGNoMQswCQYDVQQGEwJVSzESMBAGCgmSJomT8ixkARkWAk1PMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEprEx34ScKqlhmDnxWpVr2gvGpkeYWYIcNhsB6bzRHv2q2GOAny3ZIKnGA7w6bAoFtUGcdv28zPEHdwDnPLD05KM/MD0wDAYDVR0TAQH/BAIwADAOBgNVHQ8BAf8EBAMCA+gwHQYDVR0OBBYEFPsqauDurRehZO07aEE400vi38Q/MAoGCCqGSM49BAMCA0kAMEYCIQC0GZIDJFPhl1T3+iv45eaqI1yU+VJQzRNXkJIhVvbGcQIhANe5U5DGrdpY/iQGzBaSoNYTaIaAubA2su6FlEh6jXqx\", \"SubCertificates\": {\"Certificate\": [\"MIIBvjCCAWWgAwIBAgICMEMwCgYIKoZIzj0EAwIwRTERMA8GA1UEAwwITU9TdWJDQTExDzANBgNVBAoMBlN3aXRjaDELMAkGA1UEBhMCVUsxEjAQBgoJkiaJk/IsZAEZFgJNTzAeFw0yMTEyMTMxNzUyMzFaFw0yNTEyMTIxNzUyMzFaMEUxETAPBgNVBAMMCE1PU3ViQ0EyMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRIwEAYKCZImiZPyLGQBGRYCTU8wWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAQTxYYRxcZCjuVyPdmdBDOIN4XAIhLAEqU18nytJv9gKqK8qjAY9ZcJVt7luvVhFBqGmKV4q9+67z8teZiSU9aLo0UwQzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB/wQEAwIBxjAdBgNVHQ4EFgQUdIJK+LExa2RWMMgaSogHspahESAwCgYIKoZIzj0EAwIDRwAwRAIgY2ELqUsiMijWn3rsbDzfTYtsRq5iF+m2gxN6axtNLsoCIGnRymAFGPxc09rJ1uCcFywddwfY3Hv3qv0KrbskN0rs\", \"MIIBvjCCAWWgAwIBAgICMEIwCgYIKoZIzj0EAwIwRTERMA8GA1UEAwwITU9Sb290Q0ExDzANBgNVBAoMBlN3aXRjaDELMAkGA1UEBhMCVUsxEjAQBgoJkiaJk/IsZAEZFgJNTzAeFw0yMTEyMTMxNzUyMzFaFw0yNTEyMTIxNzUyMzFaMEUxETAPBgNVBAMMCE1PU3ViQ0ExMQ8wDQYDVQQKDAZTd2l0Y2gxCzAJBgNVBAYTAlVLMRIwEAYKCZImiZPyLGQBGRYCTU8wWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAS3mnLj5pBH5uikDz069wdLVJu3nPQDag3go//W34EfXJxrrAGhom+28ENfJ3OnlpQoRXczWixmV1BP68fpld/eo0UwQzASBgNVHRMBAf8ECDAGAQH/AgEBMA4GA1UdDwEB/wQEAwIBBjAdBgNVHQ4EFgQUHmF60L1Yj4tOnL5EAp68IZuzIB4wCgYIKoZIzj0EAwIDRwAwRAIgaMEAvbdVh/+sgIVcvKOSGxfIVIUycWpnguaOEIQBG+MCIEJPkZLdBJeW7r3rhLv7fvdM16FRHAlh2fxEGgm1f9EP\"]}}}}");
        }
        return iso15118_20_messageMappings_fragmentGrammar;
    }

    static Map<MessageInfo, String> getDINSPEC_70121_MessageMapping() {
        if (dinSpec_70121_messageMappings == null) {
            dinSpec_70121_messageMappings = Collections.synchronizedMap(new LinkedHashMap());
            dinSpec_70121_messageMappings.put(new MessageInfo("SupportedAppProtocolReq", AppProtocolNS), "{\"supportedAppProtocolReq\": {\"AppProtocol\": [{\"ProtocolNamespace\": \"urn:iso:15118:2:2013:MsgDef\", \"VersionNumberMajor\": 2, \"VersionNumberMinor\": 0, \"SchemaID\": 10, \"Priority\": 1}, {\"ProtocolNamespace\": \"urn:iso:std:iso:15118:-20:AC\", \"VersionNumberMajor\": 1, \"VersionNumberMinor\": 0, \"SchemaID\": 20, \"Priority\": 2}]}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("SupportedAppProtocolRes", AppProtocolNS), "{\"supportedAppProtocolRes\": {\"ResponseCode\": \"OK_SuccessfulNegotiation\", \"SchemaID\": 10}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("SessionSetupReq", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"00\"}, \"Body\": {\"SessionSetupReq\": {\"EVCCID\": \"8C859028BFC5\"}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("SessionSetupRes", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"C08CDF36985A7190\"}, \"Body\": {\"SessionSetupRes\": {\"ResponseCode\": \"OK_NewSessionEstablished\", \"EVSEID\": \"00\", \"DateTimeNow\": 1632218029}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("ServiceDiscoveryReq", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"C08CDF36985A7190\"}, \"Body\": {\"ServiceDiscoveryReq\": {}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("SessionDiscoveryRes", DINSpec_70121), "{\"V2G_Message\":{\"Header\":{\"SessionID\":\"9E3EA6105AE723C5\"},\"Body\":{\"ServiceDiscoveryRes\":{\"ResponseCode\":\"OK\",\"ServiceList\":{\"Service\":[{\"ServiceTag\": { \"ServiceCategory\":\"ContractCertificate\",\"ServiceName\":\"Certificate\",\"ServiceID\":2},\"FreeService\":true}]},\"PaymentOptions\":{\"PaymentOption\":[\"ExternalPayment\",\"Contract\"]},\"ChargeService\":{\"EnergyTransferType\":\"AC_single_phase_core\",\"FreeService\":false}}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("ServiceDetailReq", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"A53EF57A8CA57A4C\"}, \"Body\": {\"ServiceDetailReq\": {\"ServiceID\": 2}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("ServiceDetailRes", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"A53EF57A8CA57A4C\"}, \"Body\": {\"ServiceDetailRes\": {\"ResponseCode\": \"OK\", \"ServiceID\": 2, \"ServiceParameterList\": {\"ParameterSet\": [{\"ParameterSetID\": 1, \"Parameter\": [{\"Name\": \"Service\", \"stringValue\": \"Installation\"}]}]}}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("CurrentDemandReq", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"772E089BF54E58BB\"}, \"Body\": {\"CurrentDemandReq\": {\"ChargingComplete\" : false}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("CurrentDemandRes", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"DE47DF7E4C07981D\"}, \"Body\": {\"PowerDeliveryRes\": { \"ResponseCode\": \"OK\", \"AC_EVSEStatus\": {\"PowerSwitchClosed\":false, \"NotificationMaxDelay\": 0, \"EVSENotification\": \"None\", \"RCD\": false}}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("PowerDeliveryReq", DINSpec_70121), "{\"V2G_Message\":{\"Header\":{\"SessionID\":\"363AD40B7302E70B\"},\"Body\":{\"PowerDeliveryReq\":{\"ReadyToChargeState\":false,\"ChargingProfile\":{\"SAScheduleTupleID\":1,\"ProfileEntry\":[{\"ChargingProfileEntryMaxPower\":0,\"ChargingProfileEntryStart\":0},{\"ChargingProfileEntryMaxPower\":0,\"ChargingProfileEntryStart\":3600}]}}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("PowerDeliveryRes", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"DE47DF7E4C07981D\"}, \"Body\": {\"PowerDeliveryRes\": { \"ResponseCode\": \"OK\", \"AC_EVSEStatus\": {\"PowerSwitchClosed\":false, \"NotificationMaxDelay\": 0, \"EVSENotification\": \"None\", \"RCD\": false}}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("ChargingStatusReq", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"602BB3E84737BE58\"}, \"Body\": {\"ChargingStatusReq\": {}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("ChargingStatusRes", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"602BB3E84737BE58\"}, \"Body\": {\"ChargingStatusRes\": {\"ResponseCode\": \"OK\", \"EVSEID\": \"12341234\", \"SAScheduleTupleID\": 1, \"ReceiptRequired\": false, \"AC_EVSEStatus\": {\"PowerSwitchClosed\":false,\"NotificationMaxDelay\": 0, \"EVSENotification\": \"None\", \"RCD\": false}}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("WeldingDetectionReq", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"772E089BF54E58BB\"}, \"Body\": {\"WeldingDetectionReq\": {\"DC_EVStatus\" : {\"EVReady\":false,\"EVErrorCode\" : \"NO_ERROR\",\"EVRESSSOC\":0}}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("WeldingDetectionRes", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"23BD6F140AC33301\"}, \"Body\": {\"WeldingDetectionRes\": {\"ResponseCode\": \"OK\"}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("SessionStopReq", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"772E089BF54E58BB\"}, \"Body\": {\"SessionStopReq\": {}}}}");
            dinSpec_70121_messageMappings.put(new MessageInfo("SessionStopRes", DINSpec_70121), "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"23BD6F140AC33301\"}, \"Body\": {\"SessionStopRes\": {\"ResponseCode\": \"OK\"}}}}");
        }
        return dinSpec_70121_messageMappings;
    }

    private static String print(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("0x%02X, ", b));
            ++n2;
        }
        sb.append("]");
        return sb.toString();
    }
}

