# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetInstanceMaintenanceRebootResult',
    'AwaitableGetInstanceMaintenanceRebootResult',
    'get_instance_maintenance_reboot',
    'get_instance_maintenance_reboot_output',
]

@pulumi.output_type
class GetInstanceMaintenanceRebootResult:
    """
    A collection of values returned by getInstanceMaintenanceReboot.
    """
    def __init__(__self__, id=None, instance_id=None, time_maintenance_reboot_due_max=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if time_maintenance_reboot_due_max and not isinstance(time_maintenance_reboot_due_max, str):
            raise TypeError("Expected argument 'time_maintenance_reboot_due_max' to be a str")
        pulumi.set(__self__, "time_maintenance_reboot_due_max", time_maintenance_reboot_due_max)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="timeMaintenanceRebootDueMax")
    def time_maintenance_reboot_due_max(self) -> str:
        """
        The maximum extension date and time for the maintenance reboot, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). The range for the maintenance extension is between 1 and 14 days from the initial scheduled maintenance date. Example: `2018-05-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_maintenance_reboot_due_max")


class AwaitableGetInstanceMaintenanceRebootResult(GetInstanceMaintenanceRebootResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceMaintenanceRebootResult(
            id=self.id,
            instance_id=self.instance_id,
            time_maintenance_reboot_due_max=self.time_maintenance_reboot_due_max)


def get_instance_maintenance_reboot(instance_id: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceMaintenanceRebootResult:
    """
    This data source provides details about a specific Instance Maintenance Reboot resource in Oracle Cloud Infrastructure Core service.

    Gets the maximum possible date that a maintenance reboot can be extended. For more information, see
    [Infrastructure Maintenance](https://docs.cloud.oracle.com/iaas/Content/Compute/References/infrastructure-maintenance.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_maintenance_reboot = oci.Core.get_instance_maintenance_reboot(instance_id=test_instance["id"])
    ```


    :param str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getInstanceMaintenanceReboot:getInstanceMaintenanceReboot', __args__, opts=opts, typ=GetInstanceMaintenanceRebootResult).value

    return AwaitableGetInstanceMaintenanceRebootResult(
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        time_maintenance_reboot_due_max=pulumi.get(__ret__, 'time_maintenance_reboot_due_max'))
def get_instance_maintenance_reboot_output(instance_id: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceMaintenanceRebootResult]:
    """
    This data source provides details about a specific Instance Maintenance Reboot resource in Oracle Cloud Infrastructure Core service.

    Gets the maximum possible date that a maintenance reboot can be extended. For more information, see
    [Infrastructure Maintenance](https://docs.cloud.oracle.com/iaas/Content/Compute/References/infrastructure-maintenance.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_maintenance_reboot = oci.Core.get_instance_maintenance_reboot(instance_id=test_instance["id"])
    ```


    :param str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getInstanceMaintenanceReboot:getInstanceMaintenanceReboot', __args__, opts=opts, typ=GetInstanceMaintenanceRebootResult)
    return __ret__.apply(lambda __response__: GetInstanceMaintenanceRebootResult(
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        time_maintenance_reboot_due_max=pulumi.get(__response__, 'time_maintenance_reboot_due_max')))
