# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalDbSystemResult',
    'AwaitableGetExternalDbSystemResult',
    'get_external_db_system',
    'get_external_db_system_output',
]

@pulumi.output_type
class GetExternalDbSystemResult:
    """
    A collection of values returned by getExternalDbSystem.
    """
    def __init__(__self__, compartment_id=None, database_management_configs=None, db_system_discovery_id=None, defined_tags=None, discovery_agent_id=None, display_name=None, external_db_system_id=None, freeform_tags=None, home_directory=None, id=None, is_cluster=None, lifecycle_details=None, stack_monitoring_configs=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_management_configs and not isinstance(database_management_configs, list):
            raise TypeError("Expected argument 'database_management_configs' to be a list")
        pulumi.set(__self__, "database_management_configs", database_management_configs)
        if db_system_discovery_id and not isinstance(db_system_discovery_id, str):
            raise TypeError("Expected argument 'db_system_discovery_id' to be a str")
        pulumi.set(__self__, "db_system_discovery_id", db_system_discovery_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if discovery_agent_id and not isinstance(discovery_agent_id, str):
            raise TypeError("Expected argument 'discovery_agent_id' to be a str")
        pulumi.set(__self__, "discovery_agent_id", discovery_agent_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_db_system_id and not isinstance(external_db_system_id, str):
            raise TypeError("Expected argument 'external_db_system_id' to be a str")
        pulumi.set(__self__, "external_db_system_id", external_db_system_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if home_directory and not isinstance(home_directory, str):
            raise TypeError("Expected argument 'home_directory' to be a str")
        pulumi.set(__self__, "home_directory", home_directory)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_cluster and not isinstance(is_cluster, bool):
            raise TypeError("Expected argument 'is_cluster' to be a bool")
        pulumi.set(__self__, "is_cluster", is_cluster)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if stack_monitoring_configs and not isinstance(stack_monitoring_configs, list):
            raise TypeError("Expected argument 'stack_monitoring_configs' to be a list")
        pulumi.set(__self__, "stack_monitoring_configs", stack_monitoring_configs)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseManagementConfigs")
    def database_management_configs(self) -> Sequence['outputs.GetExternalDbSystemDatabaseManagementConfigResult']:
        """
        The details required to enable Database Management for an external DB system.
        """
        return pulumi.get(self, "database_management_configs")

    @property
    @pulumi.getter(name="dbSystemDiscoveryId")
    def db_system_discovery_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system discovery.
        """
        return pulumi.get(self, "db_system_discovery_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="discoveryAgentId")
    def discovery_agent_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management agent used during the discovery of the DB system.
        """
        return pulumi.get(self, "discovery_agent_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalDbSystemId")
    def external_db_system_id(self) -> str:
        return pulumi.get(self, "external_db_system_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="homeDirectory")
    def home_directory(self) -> str:
        """
        The Oracle Grid home directory in case of cluster-based DB system and Oracle home directory in case of single instance-based DB system.
        """
        return pulumi.get(self, "home_directory")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> bool:
        """
        Indicates whether the DB system is a cluster DB system or not.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="stackMonitoringConfigs")
    def stack_monitoring_configs(self) -> Sequence['outputs.GetExternalDbSystemStackMonitoringConfigResult']:
        """
        The configuration details of Stack Monitoring for an external DB system.
        """
        return pulumi.get(self, "stack_monitoring_configs")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the external DB system resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the external DB system was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the external DB system was last updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetExternalDbSystemResult(GetExternalDbSystemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalDbSystemResult(
            compartment_id=self.compartment_id,
            database_management_configs=self.database_management_configs,
            db_system_discovery_id=self.db_system_discovery_id,
            defined_tags=self.defined_tags,
            discovery_agent_id=self.discovery_agent_id,
            display_name=self.display_name,
            external_db_system_id=self.external_db_system_id,
            freeform_tags=self.freeform_tags,
            home_directory=self.home_directory,
            id=self.id,
            is_cluster=self.is_cluster,
            lifecycle_details=self.lifecycle_details,
            stack_monitoring_configs=self.stack_monitoring_configs,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_external_db_system(external_db_system_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalDbSystemResult:
    """
    This data source provides details about a specific External Db System resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the external DB system specified by `externalDbSystemId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_db_system = oci.DatabaseManagement.get_external_db_system(external_db_system_id=test_external_db_system_oci_database_management_external_db_system["id"])
    ```


    :param str external_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system.
    """
    __args__ = dict()
    __args__['externalDbSystemId'] = external_db_system_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalDbSystem:getExternalDbSystem', __args__, opts=opts, typ=GetExternalDbSystemResult).value

    return AwaitableGetExternalDbSystemResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_management_configs=pulumi.get(__ret__, 'database_management_configs'),
        db_system_discovery_id=pulumi.get(__ret__, 'db_system_discovery_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        discovery_agent_id=pulumi.get(__ret__, 'discovery_agent_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_db_system_id=pulumi.get(__ret__, 'external_db_system_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        home_directory=pulumi.get(__ret__, 'home_directory'),
        id=pulumi.get(__ret__, 'id'),
        is_cluster=pulumi.get(__ret__, 'is_cluster'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        stack_monitoring_configs=pulumi.get(__ret__, 'stack_monitoring_configs'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_external_db_system_output(external_db_system_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalDbSystemResult]:
    """
    This data source provides details about a specific External Db System resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the external DB system specified by `externalDbSystemId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_db_system = oci.DatabaseManagement.get_external_db_system(external_db_system_id=test_external_db_system_oci_database_management_external_db_system["id"])
    ```


    :param str external_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system.
    """
    __args__ = dict()
    __args__['externalDbSystemId'] = external_db_system_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getExternalDbSystem:getExternalDbSystem', __args__, opts=opts, typ=GetExternalDbSystemResult)
    return __ret__.apply(lambda __response__: GetExternalDbSystemResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_management_configs=pulumi.get(__response__, 'database_management_configs'),
        db_system_discovery_id=pulumi.get(__response__, 'db_system_discovery_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        discovery_agent_id=pulumi.get(__response__, 'discovery_agent_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        external_db_system_id=pulumi.get(__response__, 'external_db_system_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        home_directory=pulumi.get(__response__, 'home_directory'),
        id=pulumi.get(__response__, 'id'),
        is_cluster=pulumi.get(__response__, 'is_cluster'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        stack_monitoring_configs=pulumi.get(__response__, 'stack_monitoring_configs'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
