# Generated by Django 3.0 on 2019-12-16 14:40

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stripe_id', models.CharField(max_length=255)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('address', models.CharField(blank=True, max_length=255, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('user', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='stripe_customer', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='PaymentMethod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stripe_id', models.CharField(max_length=255)),
                ('brand', models.CharField(max_length=255)),
                ('country', models.CharField(blank=True, max_length=255, null=True)),
                ('funding', models.CharField(choices=[('credit', 'Credit'), ('debit', 'Debit'), ('prepaid', 'Prepaid'), ('unknown', 'Unknown')], default='unknown', max_length=255)),
                ('exp_month', models.PositiveIntegerField(default=0)),
                ('exp_year', models.PositiveIntegerField(default=0)),
                ('last4', models.CharField(max_length=255)),
                ('fingerprint', models.CharField(max_length=255)),
                ('supports_3d_secure', models.BooleanField()),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('customer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='olaii_stripe.Customer')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='stripe_cards', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='PaymentIntent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stripe_id', models.CharField(max_length=255)),
                ('amount', models.PositiveIntegerField(default=0)),
                ('amount_capturable', models.PositiveIntegerField(default=0)),
                ('amount_received', models.PositiveIntegerField(default=0)),
                ('currency', models.CharField(default='eur', max_length=3)),
                ('description', models.TextField(blank=True)),
                ('canceled_at', models.DateTimeField(blank=True, null=True)),
                ('cancellation_reason', models.CharField(blank=True, max_length=255, null=True)),
                ('capture_method', models.CharField(choices=[('automatic', 'Automatic'), ('manual', 'Manual')], default='automatic', max_length=255)),
                ('client_secret', models.CharField(max_length=255)),
                ('setup_future_usage', models.CharField(blank=True, choices=[('on_session', 'On Session'), ('off_session', 'Off Session')], default=None, max_length=255, null=True)),
                ('statement_descriptor', models.CharField(blank=True, max_length=22, null=True)),
                ('statement_descriptor_suffix', models.CharField(blank=True, max_length=22, null=True)),
                ('status', models.CharField(choices=[('requires_payment_method', 'Requires Payment Method'), ('requires_confirmation', 'Requires Confirmation'), ('requires_action', 'Requires Action'), ('processing', 'Processing'), ('requires_capture', 'Requires Capture'), ('canceled', 'Canceled'), ('succeeded', 'Succeeded')], default='requires_payment_method', max_length=255)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('customer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='payment_intents', to='olaii_stripe.Customer')),
                ('payment_method', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='olaii_stripe.PaymentMethod')),
            ],
        ),
    ]
