# CSAF

Common Security Advisory Framework (CSAF) Verification, Validation, and Application Programming Interface (API).

[License: MIT](https://git.sr.ht/~sthagen/csaf/tree/default/item/LICENSE)

Third party dependencies are documented in the folder [third-party](docs/third-party/README.md).

In this project the attempt is made, to provide API and tools to support the CSAF communities from a single repository in the easy to prototype python language.

If, and when this endeavor succeeds, other languages can easily derive form the approach (as long as these offer similar capabilties to keep the effort in check).

**Note**: CSAF predecessor CVRF versions 1.1 and 1.2 are out of scope.

[![version](https://img.shields.io/pypi/v/csaf.svg?style=flat)](https://pypi.python.org/pypi/csaf/)
[![downloads](https://pepy.tech/badge/csaf/month)](https://pepy.tech/project/csaf)
[![wheel](https://img.shields.io/pypi/wheel/csaf.svg?style=flat)](https://pypi.python.org/pypi/csaf/)
[![supported-versions](https://img.shields.io/pypi/pyversions/csaf.svg?style=flat)](https://pypi.python.org/pypi/csaf/)
[![supported-implementations](https://img.shields.io/pypi/implementation/csaf.svg?style=flat)](https://pypi.python.org/pypi/csaf/)

## Documentation

User and developer [documentation of csaf](https://codes.dilettant.life/docs/csaf).

## Bug Tracker

Any feature requests or bug reports shall go to the [todos of csaf](https://todo.sr.ht/~sthagen/csaf).

## Primary Source repository

The main source of `csaf` is on a mountain in central Switzerland.
We use distributed version control (git).
There is no central hub.
Every clone can become a new source for the benefit of all.
The preferred public clones of `csaf` are:

* [on codeberg](https://codeberg.org/sthagen/csaf) - a democratic community-driven, non-profit software development platform operated by Codeberg e.V.
* [at sourcehut](https://git.sr.ht/~sthagen/csaf) - a collection of tools useful for software development.

## Contributions

Please do not submit "pull requests" (I found no way to disable that "feature" on GitHub).
If you like to share small changes under the repositories license please kindly do so by sending a patchset.
You can either send such a patchset per email using [git send-email](https://git-send-email.io) or 
if you are a sourcehut user by selecting "Prepare a patchset" on the summary page of your fork at [sourcehut](https://git.sr.ht/).

## Contributors

In alphabetical order:

* Anthony Harrison
* Jacco Ligthart

## Status

Experimental

**Note**: The default branch is `default`.
